//>>built
require({cache:{"dojox/charting/Chart":function(){define(["../main","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-style","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/sniff","./Element","./SimpleTheme","./Series","./axis2d/common","./plot2d/common","dojox/gfx/shape","dojox/gfx","dojo/has!dojo-bidi?./bidi/Chart","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e,_f,_10,g,_11,_12){var dc=_2.getObject("charting",true,_1),_13={l:10,t:10,r:10,b:10};function _14(_15){return _15.clear();};function _16(_17){return _17.destroy();};function _18(_19){_19.dirty=false;return false;};function _1a(_1b){_1b.dirty=true;return true;};function _1c(_1d){return _1d.name;};var _1e=_4(_a("dojo-bidi")?"dojox.charting.NonBidiChart":"dojox.charting.Chart",null,{constructor:function(_1f,_20){if(!_20){_20={};}this.margins=_20.margins||_13;this._customMargins=!!_20.margins;this.stroke=_20.stroke;this.fill=_20.fill;this.delayInMs=_20.delayInMs||200;this.title=_20.title;this.titleGap=_20.titleGap;this.titlePos=_20.titlePos;this.titleFont=_20.titleFont;this.titleFontColor=_20.titleFontColor;this.titleAlign=_20.titleAlign;this.chartTitle=null;this.htmlLabels=true;if("htmlLabels" in _20){this.htmlLabels=_20.htmlLabels;}this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.node=_6.byId(_1f);var box=_7.getMarginBox(_1f);this.surface=g.createSurface(this.node,box.w||400,box.h||300);if(this.surface.declaredClass.indexOf("vml")==-1){this._nativeClip=true;}},destroy:function(){_3.forEach(this.series,_16);_3.forEach(this.stack,_16);_12.forIn(this.axes,_16);this.surface.destroy();if(this.chartTitle&&this.chartTitle.tagName){_8.destroy(this.chartTitle);}},getCoords:function(){var _21=this.node;var s=_5.getComputedStyle(_21),_22=_7.getMarginBox(_21,s);var abs=_7.position(_21,true);_22.x=abs.x;_22.y=abs.y;return _22;},setTheme:function(_23){this.theme=_23.clone();if(!this._customMargins){this.margins=this.theme.chart.margins||_13;}this.dirty=true;return this;},addAxis:function(_24,_25){var _26,_27=_25&&_25.type||"Default";if(typeof _27=="string"){if(!dc.axis2d||!dc.axis2d[_27]){throw Error("Can't find axis: "+_27+" - Check "+"require() dependencies.");}_26=new dc.axis2d[_27](this,_25);}else{_26=new _27(this,_25);}_26.name=_24;_26.dirty=true;if(_24 in this.axes){this.axes[_24].destroy();}this.axes[_24]=_26;this.dirty=true;return this;},getAxis:function(_28){return this.axes[_28];},removeAxis:function(_29){if(_29 in this.axes){this.axes[_29].destroy();delete this.axes[_29];this.dirty=true;}return this;},addPlot:function(_2a,_2b){var _2c,_2d=_2b&&_2b.type||"Default";if(typeof _2d=="string"){if(!dc.plot2d||!dc.plot2d[_2d]){throw Error("Can't find plot: "+_2d+" - didn't you forget to dojo"+".require() it?");}_2c=new dc.plot2d[_2d](this,_2b);}else{_2c=new _2d(this,_2b);}_2c.name=_2a;_2c.dirty=true;if(_2a in this.plots){this.stack[this.plots[_2a]].destroy();this.stack[this.plots[_2a]]=_2c;}else{this.plots[_2a]=this.stack.length;this.stack.push(_2c);}this.dirty=true;return this;},getPlot:function(_2e){return this.stack[this.plots[_2e]];},removePlot:function(_2f){if(_2f in this.plots){var _30=this.plots[_2f];delete this.plots[_2f];this.stack[_30].destroy();this.stack.splice(_30,1);_12.forIn(this.plots,function(idx,_31,_32){if(idx>_30){_32[_31]=idx-1;}});var ns=_3.filter(this.series,function(run){return run.plot!=_2f;});if(ns.length<this.series.length){_3.forEach(this.series,function(run){if(run.plot==_2f){run.destroy();}});this.runs={};_3.forEach(ns,function(run,_33){this.runs[run.plot]=_33;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return _12.map(this.stack,_1c);},setPlotOrder:function(_34){var _35={},_36=_12.filter(_34,function(_37){if(!(_37 in this.plots)||(_37 in _35)){return false;}_35[_37]=1;return true;},this);if(_36.length<this.stack.length){_12.forEach(this.stack,function(_38){var _39=_38.name;if(!(_39 in _35)){_36.push(_39);}});}var _3a=_12.map(_36,function(_3b){return this.stack[this.plots[_3b]];},this);_12.forEach(_3a,function(_3c,i){this.plots[_3c.name]=i;},this);this.stack=_3a;this.dirty=true;return this;},movePlotToFront:function(_3d){if(_3d in this.plots){var _3e=this.plots[_3d];if(_3e){var _3f=this.getPlotOrder();_3f.splice(_3e,1);_3f.unshift(_3d);return this.setPlotOrder(_3f);}}return this;},movePlotToBack:function(_40){if(_40 in this.plots){var _41=this.plots[_40];if(_41<this.stack.length-1){var _42=this.getPlotOrder();_42.splice(_41,1);_42.push(_40);return this.setPlotOrder(_42);}}return this;},addSeries:function(_43,_44,_45){var run=new _d(this,_44,_45);run.name=_43;if(_43 in this.runs){this.series[this.runs[_43]].destroy();this.series[this.runs[_43]]=run;}else{this.runs[_43]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(_46){return this.series[this.runs[_46]];},removeSeries:function(_47){if(_47 in this.runs){var _48=this.runs[_47];delete this.runs[_47];this.series[_48].destroy();this.series.splice(_48,1);_12.forIn(this.runs,function(idx,_49,_4a){if(idx>_48){_4a[_49]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(_4b,_4c,_4d){if(_4b in this.runs){var run=this.series[this.runs[_4b]];run.update(_4c);if(_4d){this.dirty=true;}else{this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}}return this;},getSeriesOrder:function(_4e){return _12.map(_12.filter(this.series,function(run){return run.plot==_4e;}),_1c);},setSeriesOrder:function(_4f){var _50,_51={},_52=_12.filter(_4f,function(_53){if(!(_53 in this.runs)||(_53 in _51)){return false;}var run=this.series[this.runs[_53]];if(_50){if(run.plot!=_50){return false;}}else{_50=run.plot;}_51[_53]=1;return true;},this);_12.forEach(this.series,function(run){var _54=run.name;if(!(_54 in _51)&&run.plot==_50){_52.push(_54);}});var _55=_12.map(_52,function(_56){return this.series[this.runs[_56]];},this);this.series=_55.concat(_12.filter(this.series,function(run){return run.plot!=_50;}));_12.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(_57){if(_57 in this.runs){var _58=this.runs[_57],_59=this.getSeriesOrder(this.series[_58].plot);if(_57!=_59[0]){_59.splice(_58,1);_59.unshift(_57);return this.setSeriesOrder(_59);}}return this;},moveSeriesToBack:function(_5a){if(_5a in this.runs){var _5b=this.runs[_5a],_5c=this.getSeriesOrder(this.series[_5b].plot);if(_5a!=_5c[_5c.length-1]){_5c.splice(_5b,1);_5c.push(_5a);return this.setSeriesOrder(_5c);}}return this;},resize:function(_5d,_5e){switch(arguments.length){case 1:_7.setMarginBox(this.node,_5d);break;case 2:_7.setMarginBox(this.node,{w:_5d,h:_5e});break;}var box=_7.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;return this.render();}else{return this;}},getGeometry:function(){var ret={};_12.forIn(this.axes,function(_5f){if(_5f.initialized()){ret[_5f.name]={name:_5f.name,vertical:_5f.vertical,scaler:_5f.scaler,ticks:_5f.ticks};}});return ret;},setAxisWindow:function(_60,_61,_62,_63){var _64=this.axes[_60];if(_64){_64.setWindow(_61,_62);_3.forEach(this.stack,function(_65){if(_65.hAxis==_60||_65.vAxis==_60){_65.zoom=_63;}});}return this;},setWindow:function(sx,sy,dx,dy,_66){if(!("plotArea" in this)){this.calculateGeometry();}_12.forIn(this.axes,function(_67){var _68,_69,_6a=_67.getScaler().bounds,s=_6a.span/(_6a.upper-_6a.lower);if(_67.vertical){_68=sy;_69=dy/s/_68;}else{_68=sx;_69=dx/s/_68;}_67.setWindow(_68,_69);});_3.forEach(this.stack,function(_6b){_6b.zoom=_66;});return this;},zoomIn:function(_6c,_6d,_6e){var _6f=this.axes[_6c];if(_6f){var _70,_71,_72=_6f.getScaler().bounds;var _73=Math.min(_6d[0],_6d[1]);var _74=Math.max(_6d[0],_6d[1]);_73=_6d[0]<_72.lower?_72.lower:_73;_74=_6d[1]>_72.upper?_72.upper:_74;_70=(_72.upper-_72.lower)/(_74-_73);_71=_73-_72.lower;this.setAxisWindow(_6c,_70,_71);if(_6e){this.delayedRender();}else{this.render();}}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _75=_3.filter(this.stack,function(_76){return _76.dirty||(_76.hAxis&&this.axes[_76.hAxis].dirty)||(_76.vAxis&&this.axes[_76.vAxis].dirty);},this);_77(_75,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();_3.forEach(this.stack,_14);if(!this.theme){this.setTheme(new _c());}_3.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var _78=new dc.plot2d.Default(this,{});_78.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(_78);}this.stack[this.plots[run.plot]].addSeries(run);},this);_3.forEach(this.stack,function(_79){if(_79.assignAxes){_79.assignAxes(this.axes);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);_12.forIn(this.axes,_14);_77(this.stack,dim);var _7a=this.offsets={l:0,r:0,t:0,b:0};var _7b=this;_12.forIn(this.axes,function(_7c){if(_a("dojo-bidi")){_7b._resetLeftBottom(_7c);}_12.forIn(_7c.getOffsets(),function(o,i){_7a[i]=Math.max(o,_7a[i]);});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";this.titleAlign=this.titleAlign||this.theme&&this.theme.chart&&this.theme.chart.titleAlign||"middle";var _7d=g.normalizedLength(g.splitFontString(this.titleFont).size);_7a[this.titlePos=="top"?"t":"b"]+=(_7d+this.titleGap);}_12.forIn(this.margins,function(o,i){_7a[i]+=o;});this.plotArea={width:dim.width-_7a.l-_7a.r,height:dim.height-_7a.t-_7a.b};_12.forIn(this.axes,_14);_77(this.stack,this.plotArea);return this;},render:function(){if(this._delayedRenderHandle){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;}if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();_12.forEachRev(this.stack,function(_7e){_7e.render(this.dim,this.offsets);},this);_12.forIn(this.axes,function(_7f){_7f.render(this.dim,this.offsets);},this);this._makeClean();return this;},fullRender:function(){this.fullGeometry();var _80=this.offsets,dim=this.dim;var w=Math.max(0,dim.width-_80.l-_80.r),h=Math.max(0,dim.height-_80.t-_80.b);_3.forEach(this.series,_f.purgeGroup);_12.forIn(this.axes,_f.purgeGroup);_3.forEach(this.stack,_f.purgeGroup);var _81=this.surface.children;if(_10.dispose){for(var i=0;i<_81.length;++i){_10.dispose(_81[i]);}}if(this.chartTitle&&this.chartTitle.tagName){_8.destroy(this.chartTitle);}this.surface.clear();this.chartTitle=null;this._renderChartBackground(dim,_80);if(this._nativeClip){this._renderPlotBackground(dim,_80,w,h);}else{this._renderPlotBackground(dim,_80,w,h);}_12.foldr(this.stack,function(z,_82){return _82.render(dim,_80),0;},0);if(!this._nativeClip){this._renderChartBackground(dim,_80);}if(this.title){this._renderTitle(dim,_80);}_12.forIn(this.axes,function(_83){_83.render(dim,_80);});this._makeClean();return this;},_renderTitle:function(dim,_84){var _85=(g.renderer=="canvas")&&this.htmlLabels,_86=_85||!_a("ie")&&!_a("opera")&&this.htmlLabels?"html":"gfx",_87=g.normalizedLength(g.splitFontString(this.titleFont).size),_88=g._base._getTextBox(this.title,{font:this.titleFont});var _89=this.titleAlign;var _8a=_a("dojo-bidi")&&this.isRightToLeft();var _8b=dim.width/2;if(_89==="edge"){_89="left";if(_8a){_8b=dim.width-(_84.r+_88.w);}else{_8b=_84.l;}}else{if(_89!="middle"){if(_8a){_89=_89==="left"?"right":"left";}if(_89==="left"){_8b=this.margins.l;}else{if(_89==="right"){_89="left";_8b=dim.width-(this.margins.l+_88.w);}}}}this.chartTitle=_e.createText[_86](this,this.surface,_8b,this.titlePos=="top"?_87+this.margins.t:dim.height-this.margins.b,_89,this.title,this.titleFont,this.titleFontColor);},_renderChartBackground:function(dim,_8c){var t=this.theme,_8d;var _8e=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);var _8f=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(_8e=="inherit"){var _90=this.node;_8e=new _9(_5.get(_90,"backgroundColor"));while(_8e.a==0&&_90!=document.documentElement){_8e=new _9(_5.get(_90,"backgroundColor"));_90=_90.parentNode;}}if(_8e){if(this._nativeClip){_8e=_b.prototype._shapeFill(_b.prototype._plotFill(_8e,dim),{x:0,y:0,width:dim.width+1,height:dim.height+1});this.surface.createRect({width:dim.width+1,height:dim.height+1}).setFill(_8e);}else{_8e=_b.prototype._plotFill(_8e,dim,_8c);if(_8c.l){_8d={x:0,y:0,width:_8c.l,height:dim.height+1};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.r){_8d={x:dim.width-_8c.r,y:0,width:_8c.r+1,height:dim.height+2};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.t){_8d={x:0,y:0,width:dim.width+1,height:_8c.t};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.b){_8d={x:0,y:dim.height-_8c.b,width:dim.width+1,height:_8c.b+2};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}}}if(_8f){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_8f);}},_renderPlotBackground:function(dim,_91,w,h){var t=this.theme;var _92=t.plotarea&&t.plotarea.fill;var _93=t.plotarea&&t.plotarea.stroke;var _94={x:_91.l-1,y:_91.t-1,width:w+2,height:h+2};if(_92){_92=_b.prototype._shapeFill(_b.prototype._plotFill(_92,dim,_91),_94);this.surface.createRect(_94).setFill(_92);}if(_93){this.surface.createRect({x:_91.l,y:_91.t,width:w+1,height:h+1}).setStroke(_93);}},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(_2.hitch(this,function(){this.render();}),this.delayInMs);}return this;},connectToPlot:function(_95,_96,_97){return _95 in this.plots?this.stack[this.plots[_95]].connect(_96,_97):null;},fireEvent:function(_98,_99,_9a){if(_98 in this.runs){var _9b=this.series[this.runs[_98]].plot;if(_9b in this.plots){var _9c=this.stack[this.plots[_9b]];if(_9c){_9c.fireEvent(_98,_99,_9a);}}}return this;},_makeClean:function(){_3.forEach(this.axes,_18);_3.forEach(this.stack,_18);_3.forEach(this.series,_18);this.dirty=false;},_makeDirty:function(){_3.forEach(this.axes,_1a);_3.forEach(this.stack,_1a);_3.forEach(this.series,_1a);this.dirty=true;},_invalidateDependentPlots:function(_9d,_9e){if(_9d in this.plots){var _9f=this.stack[this.plots[_9d]],_a0,_a1=_9e?"vAxis":"hAxis";if(_9f[_a1]){_a0=this.axes[_9f[_a1]];if(_a0&&_a0.dependOnData()){_a0.dirty=true;_3.forEach(this.stack,function(p){if(p[_a1]&&p[_a1]==_9f[_a1]){p.dirty=true;}});}}else{_9f.dirty=true;}}},setDir:function(dir){return this;},_resetLeftBottom:function(_a2){},formatTruncatedLabel:function(_a3,_a4,_a5){}});function _a6(_a7){return {min:_a7.hmin,max:_a7.hmax};};function _a8(_a9){return {min:_a9.vmin,max:_a9.vmax};};function _aa(_ab,h){_ab.hmin=h.min;_ab.hmax=h.max;};function _ac(_ad,v){_ad.vmin=v.min;_ad.vmax=v.max;};function _ae(_af,_b0){if(_af&&_b0){_af.min=Math.min(_af.min,_b0.min);_af.max=Math.max(_af.max,_b0.max);}return _af||_b0;};function _77(_b1,_b2){var _b3={},_b4={};_3.forEach(_b1,function(_b5){var _b6=_b3[_b5.name]=_b5.getSeriesStats();if(_b5.hAxis){_b4[_b5.hAxis]=_ae(_b4[_b5.hAxis],_a6(_b6));}if(_b5.vAxis){_b4[_b5.vAxis]=_ae(_b4[_b5.vAxis],_a8(_b6));}});_3.forEach(_b1,function(_b7){var _b8=_b3[_b7.name];if(_b7.hAxis){_aa(_b8,_b4[_b7.hAxis]);}if(_b7.vAxis){_ac(_b8,_b4[_b7.vAxis]);}_b7.initializeScalers(_b2,_b8);});};return _a("dojo-bidi")?_4("dojox.charting.Chart",[_1e,_11]):_1e;});},"dojox/main":function(){define(["dojo/_base/kernel"],function(_b9){return _b9.dojox;});},"dojox/charting/Element":function(){define(["dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx","dojox/gfx/shape"],function(arr,_ba,_bb,gfx,_bc){return _bb("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,renderingOptions:null,constructor:function(_bd,_be){this.chart=_bd;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];if(_be&&_be.renderingOptions){this.renderingOptions=_be.renderingOptions;}},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.getGroup().removeShape();var _bf=this.getGroup().children;if(_bc.dispose){for(var i=0;i<_bf.length;++i){_bc.dispose(_bf[i],true);}}if(this.getGroup().rawNode){_ba.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_bc.dispose){_bc.dispose(this.getGroup(),true);}if(this.getGroup()!=this.group){if(this.group.rawNode){_ba.empty(this.group.rawNode);}this.group.clear();if(_bc.dispose){_bc.dispose(this.group,true);}}this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(_c0){_c0.shape.disconnect(_c0.handle);});this._events=[];}return this;},cleanGroup:function(_c1){this.destroyHtmlElements();if(!_c1){_c1=this.chart.surface;}if(this.group){var _c2;var _c3=this.getGroup().children;if(_bc.dispose){for(var i=0;i<_c3.length;++i){_bc.dispose(_c3[i],true);}}if(this.getGroup().rawNode){_c2=this.getGroup().bgNode;_ba.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_c2){this.getGroup().rawNode.appendChild(_c2);}}else{this.group=_c1.createGroup();if(this.renderingOptions&&this.group.rawNode&&this.group.rawNode.namespaceURI=="http://www.w3.org/2000/svg"){for(var key in this.renderingOptions){this.group.rawNode.setAttribute(key,this.renderingOptions[key]);}}}this.dirty=true;return this;},getGroup:function(){return this.group;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_ba.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},overrideShape:function(_c4,_c5){},getTextWidth:function(s,_c6){return gfx._base._getTextBox(s,{font:_c6}).w||0;},getTextWithLimitLength:function(s,_c7,_c8,_c9){if(!s||s.length<=0){return {text:"",truncated:_c9||false};}if(!_c8||_c8<=0){return {text:s,truncated:_c9||false};}var _ca=2,_cb=0.618,_cc=s.substring(0,1)+this.trailingSymbol,_cd=this.getTextWidth(_cc,_c7);if(_c8<=_cd){return {text:_cc,truncated:true};}var _ce=this.getTextWidth(s,_c7);if(_ce<=_c8){return {text:s,truncated:_c9||false};}else{var _cf=0,end=s.length;while(_cf<end){if(end-_cf<=_ca){while(this.getTextWidth(s.substring(0,_cf)+this.trailingSymbol,_c7)>_c8){_cf-=1;}return {text:(s.substring(0,_cf)+this.trailingSymbol),truncated:true};}var _d0=_cf+Math.round((end-_cf)*_cb),_d1=this.getTextWidth(s.substring(0,_d0),_c7);if(_d1<_c8){_cf=_d0;end=end;}else{_cf=_cf;end=_d0;}}}},getTextWithLimitCharCount:function(s,_d2,_d3,_d4){if(!s||s.length<=0){return {text:"",truncated:_d4||false};}if(!_d3||_d3<=0||s.length<=_d3){return {text:s,truncated:_d4||false};}return {text:s.substring(0,_d3)+this.trailingSymbol,truncated:true};},_plotFill:function(_d5,dim,_d6){if(!_d5||!_d5.type||!_d5.space){return _d5;}var _d7=_d5.space,_d8;switch(_d5.type){case "linear":if(_d7==="plot"||_d7==="shapeX"||_d7==="shapeY"){_d5=gfx.makeParameters(gfx.defaultLinearGradient,_d5);_d5.space=_d7;if(_d7==="plot"||_d7==="shapeX"){_d8=dim.height-_d6.t-_d6.b;_d5.y1=_d6.t+_d8*_d5.y1/100;_d5.y2=_d6.t+_d8*_d5.y2/100;}if(_d7==="plot"||_d7==="shapeY"){_d8=dim.width-_d6.l-_d6.r;_d5.x1=_d6.l+_d8*_d5.x1/100;_d5.x2=_d6.l+_d8*_d5.x2/100;}}break;case "radial":if(_d7==="plot"){_d5=gfx.makeParameters(gfx.defaultRadialGradient,_d5);_d5.space=_d7;var _d9=dim.width-_d6.l-_d6.r,_da=dim.height-_d6.t-_d6.b;_d5.cx=_d6.l+_d9*_d5.cx/100;_d5.cy=_d6.t+_da*_d5.cy/100;_d5.r=_d5.r*Math.sqrt(_d9*_d9+_da*_da)/200;}break;case "pattern":if(_d7==="plot"||_d7==="shapeX"||_d7==="shapeY"){_d5=gfx.makeParameters(gfx.defaultPattern,_d5);_d5.space=_d7;if(_d7==="plot"||_d7==="shapeX"){_d8=dim.height-_d6.t-_d6.b;_d5.y=_d6.t+_d8*_d5.y/100;_d5.height=_d8*_d5.height/100;}if(_d7==="plot"||_d7==="shapeY"){_d8=dim.width-_d6.l-_d6.r;_d5.x=_d6.l+_d8*_d5.x/100;_d5.width=_d8*_d5.width/100;}}break;}return _d5;},_shapeFill:function(_db,_dc){if(!_db||!_db.space){return _db;}var _dd=_db.space,_de;switch(_db.type){case "linear":if(_dd==="shape"||_dd==="shapeX"||_dd==="shapeY"){_db=gfx.makeParameters(gfx.defaultLinearGradient,_db);_db.space=_dd;if(_dd==="shape"||_dd==="shapeX"){_de=_dc.width;_db.x1=_dc.x+_de*_db.x1/100;_db.x2=_dc.x+_de*_db.x2/100;}if(_dd==="shape"||_dd==="shapeY"){_de=_dc.height;_db.y1=_dc.y+_de*_db.y1/100;_db.y2=_dc.y+_de*_db.y2/100;}}break;case "radial":if(_dd==="shape"){_db=gfx.makeParameters(gfx.defaultRadialGradient,_db);_db.space=_dd;_db.cx=_dc.x+_dc.width/2;_db.cy=_dc.y+_dc.height/2;_db.r=_db.r*_dc.width/200;}break;case "pattern":if(_dd==="shape"||_dd==="shapeX"||_dd==="shapeY"){_db=gfx.makeParameters(gfx.defaultPattern,_db);_db.space=_dd;if(_dd==="shape"||_dd==="shapeX"){_de=_dc.width;_db.x=_dc.x+_de*_db.x/100;_db.width=_de*_db.width/100;}if(_dd==="shape"||_dd==="shapeY"){_de=_dc.height;_db.y=_dc.y+_de*_db.y/100;_db.height=_de*_db.height/100;}}break;}return _db;},_pseudoRadialFill:function(_df,_e0,_e1,_e2,end){if(!_df||_df.type!=="radial"||_df.space!=="shape"){return _df;}var _e3=_df.space;_df=gfx.makeParameters(gfx.defaultRadialGradient,_df);_df.space=_e3;if(arguments.length<4){_df.cx=_e0.x;_df.cy=_e0.y;_df.r=_df.r*_e1/100;return _df;}var _e4=arguments.length<5?_e2:(end+_e2)/2;return {type:"linear",x1:_e0.x,y1:_e0.y,x2:_e0.x+_df.r*_e1*Math.cos(_e4)/100,y2:_e0.y+_df.r*_e1*Math.sin(_e4)/100,colors:_df.colors};}});});},"dojox/gfx":function(){define(["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(_e5,_e6,_e7){_e6.switchTo(_e7);return _e6;});},"dojox/gfx/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(_e8,_e9,_ea,has,win,arr,dom,_eb,_ec){var g=_e9.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(_ed,_ee){var cls=_ed.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_ee+" ")>=0;};g._addClass=function(_ef,_f0){var cls=_ef.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_f0+" ")<0){_ef.setAttribute("className",cls+(cls?" ":"")+_f0);}};g._removeClass=function(_f1,_f2){var cls=_f1.getAttribute("className");if(cls){_f1.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_f2+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _f3={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p,_f4;if(has("ie")){_f4=win.doc.documentElement.style.fontSize||"";if(!_f4){win.doc.documentElement.style.fontSize="100%";}}var div=_eb.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _f3){div.style.fontSize=p;_f3[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}if(has("ie")){win.doc.documentElement.style.fontSize=_f4;}win.body().removeChild(div);return _f3;};var _f5=null;b._getCachedFontMeasurements=function(_f6){if(_f6||!_f5){_f5=b._getFontMeasurements();}return _f5;};var _f7=null,_f8={};b._getTextBox=function(_f9,_fa,_fb){var m,s,al=arguments.length;var i,box;if(!_f7){_f7=_eb.create("div",{style:{position:"absolute",top:"-10000px",left:"0",visibility:"hidden"}},win.body());}m=_f7;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_fa){for(i in _fa){if(i in _f8){continue;}s[i]=_fa[i];}}if(al>2&&_fb){m.className=_fb;}m.innerHTML=_f9;if(m.getBoundingClientRect){var bcr=m.getBoundingClientRect();box={l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{box=_ec.getMarginBox(m);}m.innerHTML="";return box;};b._computeTextLocation=function(_fc,_fd,_fe,_ff){var loc={},_100=_fc.align;switch(_100){case "end":loc.x=_fc.x-_fd;break;case "middle":loc.x=_fc.x-_fd/2;break;default:loc.x=_fc.x;break;}var c=_ff?0.75:1;loc.y=_fc.y-_fe*c;return loc;};b._computeTextBoundingBox=function(s){if(!g._base._isRendered(s)){return {x:0,y:0,width:0,height:0};}var loc,_101=s.getShape(),font=s.getFont()||g.defaultFont,w=s.getTextWidth(),h=g.normalizedLength(font.size);loc=b._computeTextLocation(_101,w,h,true);return {x:loc.x,y:loc.y,width:w,height:h};};b._isRendered=function(s){var p=s.parent;while(p&&p.getParent){p=p.parent;}return p!==null;};var _102=0;b._getUniqueId=function(){var id;do{id=_e8._scopeName+"xUnique"+(++_102);}while(dom.byId(id));return id;};var _103=has("pointer-events")?"touchAction":has("MSPointer")?"msTouchAction":null;b._fixMsTouchAction=_103?function(_104){_104.rawNode.style[_103]="none";}:function(){};_e9.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _105={};return function(type){var t=_105[type];if(t){return new t();}t=_105[type]=function(){};t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_106){return (_106 instanceof _ea)?_106:new _ea(_106);},normalizeParameters:function(_107,_108){var x;if(_108){var _109={};for(x in _107){if(x in _108&&!(x in _109)){_107[x]=_108[x];}}}return _107;},makeParameters:function(_10a,_10b){var i=null;if(!_10b){return _e9.delegate(_10a);}var _10c={};for(i in _10a){if(!(i in _10c)){_10c[i]=_e9.clone((i in _10b)?_10b[i]:_10a[i]);}}return _10c;},formatNumber:function(x,_10d){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _10e=val.indexOf(".");if(_10e>=0&&val.length-_10e>5){val=x.toFixed(4);}}if(x<0){return val;}return _10d?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _10f=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_10f;case "in":return val*72*_10f;case "pc":return val*12*_10f;case "mm":return val*g.mm_in_pt*_10f;case "cm":return val*g.cm_in_pt*_10f;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-DF-Za-df-z])|([-+]?\d*[.]?\d+(?:[eE][-+]?\d+)?)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_110){var ns=typeof _110=="string"?g[_110]:_110;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});if(typeof _110=="string"){g.renderer=_110;}else{arr.some(["svg","vml","canvas","canvasWithEvents","silverlight"],function(r){return (g.renderer=g[r]&&g[r].Surface===g.Surface?r:null);});}}}});return g;});},"dojox/gfx/renderer":function(){define(["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_111){var _112=null;has.add("vml",function(_113,_114,_115){_115.innerHTML="<v:shape adj=\"1\"/>";var _116=("adj" in _115.firstChild);_115.innerHTML="";return _116;});return {load:function(id,_117,load){if(_112&&id!="force"){load(_112);return;}var _118=_111.forceGfxRenderer,_119=!_118&&(lang.isString(_111.gfxRenderer)?_111.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_11a,_11b;while(!_118&&_119.length){switch(_119.shift()){case "svg":if("SVGAngle" in win.global){_118="svg";}break;case "vml":if(has("vml")){_118="vml";}break;case "silverlight":try{if(has("ie")){_11a=new ActiveXObject("AgControl.AgControl");if(_11a&&_11a.IsVersionSupported("1.0")){_11b=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_11b=true;}}}catch(e){_11b=false;}finally{_11a=null;}if(_11b){_118="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_118="canvas";}break;}}if(_118==="canvas"&&_111.canvasEvents!==false){_118="canvasWithEvents";}if(_111.isDebug){}function _11c(){_117(["dojox/gfx/"+_118],function(_11d){g.renderer=_118;_112=_11d;load(_11d);});};if(_118=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_11c);}else{_11c();}}};});},"dojox/gfx/shape":function(){define(["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/on","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,lang,_11e,_11f,has,on,arr,_120,_121,_122){function _123(a,_124){var len=(a.length-1);while(_124<len){a[_124]=a[++_124];}a.length=len;};var _125=g.shape={};_125.Shape=_11e("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;if(has("gfxRegistry")){var uid=_125.register(this);this.getUID=function(){return uid;};}},destroy:function(){if(has("gfxRegistry")){_125.dispose(this);}if(this.rawNode&&"__gfxObject__" in this.rawNode){this.rawNode.__gfxObject__=null;}this.rawNode=null;},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_122;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(clip){this.clip=clip;},getClip:function(){return this.clip;},setShape:function(_126){this.shape=g.makeParameters(this.shape,_126);this.bbox=null;return this;},setFill:function(fill){if(!fill){this.fillStyle=null;return this;}var f=null;if(typeof (fill)=="object"&&"type" in fill){switch(fill.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,fill);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);break;}}else{f=g.normalizeColor(fill);}this.fillStyle=f;return this;},setStroke:function(_127){if(!_127){this.strokeStyle=null;return this;}if(typeof _127=="string"||lang.isArray(_127)||_127 instanceof _121){_127={color:_127};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_127);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_128){this.matrix=_122.clone(_128?_122.normalize(_128):_122.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_129){return _129?this.setTransform([this.matrix,_129]):this;},applyLeftTransform:function(_12a){return _12a?this.setTransform([_12a,this.matrix]):this;},applyTransform:function(_12b){return _12b?this.setTransform([this.matrix,_12b]):this;},removeShape:function(_12c){if(this.parent){this.parent.remove(this,_12c);}return this;},_setParent:function(_12d,_12e){this.parent=_12d;return this._updateParentMatrix(_12e);},_updateParentMatrix:function(_12f){this.parentMatrix=_12f?_122.clone(_12f):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_122.multiply(p.matrix,m);}p=p.parent;}return m;}});_125._eventsProcessing={on:function(type,_130){return on(this.getEventSource(),type,_125.fixCallback(this,g.fixTarget,_130));},connect:function(name,_131,_132){if(name.substring(0,2)=="on"){name=name.substring(2);}return this.on(name,_132?lang.hitch(_131,_132):_131);},disconnect:function(_133){return _133.remove();}};_125.fixCallback=function(_134,_135,_136,_137){if(!_137){_137=_136;_136=null;}if(lang.isString(_137)){_136=_136||_11f.global;if(!_136[_137]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_137,"\"] is null (scope=\"",_136,"\")"].join(""));}return function(e){return _135(e,_134)?_136[_137].apply(_136,arguments||[]):undefined;};}return !_136?function(e){return _135(e,_134)?_137.apply(_136,arguments):undefined;}:function(e){return _135(e,_134)?_137.apply(_136,arguments||[]):undefined;};};lang.extend(_125.Shape,_125._eventsProcessing);_125.Container={_init:function(){this.children=[];this._batch=0;},openBatch:function(){return this;},closeBatch:function(){return this;},add:function(_138){var _139=_138.getParent();if(_139){_139.remove(_138,true);}this.children.push(_138);return _138._setParent(this,this._getRealMatrix());},remove:function(_13a,_13b){for(var i=0;i<this.children.length;++i){if(this.children[i]==_13a){if(_13b){}else{_13a.parent=null;_13a.parentMatrix=null;}_123(this.children,i);break;}}return this;},clear:function(_13c){var _13d;for(var i=0;i<this.children.length;++i){_13d=this.children[i];_13d.parent=null;_13d.parentMatrix=null;if(_13c){_13d.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _13e=null;arr.forEach(this.children,function(_13f){var bb=_13f.getBoundingBox();if(bb){var ct=_13f.getTransform();if(ct){bb=_122.multiplyRectangle(ct,bb);}if(_13e){_13e.x=Math.min(_13e.x,bb.x);_13e.y=Math.min(_13e.y,bb.y);_13e.endX=Math.max(_13e.endX,bb.x+bb.width);_13e.endY=Math.max(_13e.endY,bb.y+bb.height);}else{_13e={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_13e){_13e.width=_13e.endX-_13e.x;_13e.height=_13e.endY-_13e.y;}return _13e;}return null;},_moveChildToFront:function(_140){for(var i=0;i<this.children.length;++i){if(this.children[i]==_140){_123(this.children,i);this.children.push(_140);break;}}return this;},_moveChildToBack:function(_141){for(var i=0;i<this.children.length;++i){if(this.children[i]==_141){_123(this.children,i);this.children.unshift(_141);break;}}return this;}};_125.Surface=_11e("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_120.destroy);this._nodes=[];arr.forEach(this._events,function(h){if(h){h.remove();}});this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_120.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_142){},whenLoaded:function(_143,_144){var f=lang.hitch(_143,_144);if(this.isLoaded){f(this);}else{on.once(this,"load",function(_145){f(_145);});}}});lang.extend(_125.Surface,_125._eventsProcessing);_125.Rect=_11e("dojox.gfx.shape.Rect",_125.Shape,{constructor:function(_146){this.shape=g.getDefault("Rect");this.rawNode=_146;},getBoundingBox:function(){return this.shape;}});_125.Ellipse=_11e("dojox.gfx.shape.Ellipse",_125.Shape,{constructor:function(_147){this.shape=g.getDefault("Ellipse");this.rawNode=_147;},getBoundingBox:function(){if(!this.bbox){var _148=this.shape;this.bbox={x:_148.cx-_148.rx,y:_148.cy-_148.ry,width:2*_148.rx,height:2*_148.ry};}return this.bbox;}});_125.Circle=_11e("dojox.gfx.shape.Circle",_125.Shape,{constructor:function(_149){this.shape=g.getDefault("Circle");this.rawNode=_149;},getBoundingBox:function(){if(!this.bbox){var _14a=this.shape;this.bbox={x:_14a.cx-_14a.r,y:_14a.cy-_14a.r,width:2*_14a.r,height:2*_14a.r};}return this.bbox;}});_125.Line=_11e("dojox.gfx.shape.Line",_125.Shape,{constructor:function(_14b){this.shape=g.getDefault("Line");this.rawNode=_14b;},getBoundingBox:function(){if(!this.bbox){var _14c=this.shape;this.bbox={x:Math.min(_14c.x1,_14c.x2),y:Math.min(_14c.y1,_14c.y2),width:Math.abs(_14c.x2-_14c.x1),height:Math.abs(_14c.y2-_14c.y1)};}return this.bbox;}});_125.Polyline=_11e("dojox.gfx.shape.Polyline",_125.Shape,{constructor:function(_14d){this.shape=g.getDefault("Polyline");this.rawNode=_14d;},setShape:function(_14e,_14f){if(_14e&&_14e instanceof Array){this.inherited(arguments,[{points:_14e}]);if(_14f&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_14e]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _150=[];for(var i=0;i<l;i+=2){_150.push({x:p[i],y:p[i+1]});}this.shape.points=_150;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x){bbox.l=t.x;}if(bbox.r<t.x){bbox.r=t.x;}if(bbox.t>t.y){bbox.t=t.y;}if(bbox.b<t.y){bbox.b=t.y;}}this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}return this.bbox;}});_125.Image=_11e("dojox.gfx.shape.Image",_125.Shape,{constructor:function(_151){this.shape=g.getDefault("Image");this.rawNode=_151;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_125.Text=_11e(_125.Shape,{constructor:function(_152){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_152;},getFont:function(){return this.fontStyle;},setFont:function(_153){this.fontStyle=typeof _153=="string"?g.splitFontString(_153):g.makeParameters(g.defaultFont,_153);this._setFont();return this;},getBoundingBox:function(){var bbox=null,s=this.getShape();if(s.text){bbox=g._base._computeTextBoundingBox(this);}return bbox;}});_125.Creator={createShape:function(_154){switch(_154.type){case g.defaultPath.type:return this.createPath(_154);case g.defaultRect.type:return this.createRect(_154);case g.defaultCircle.type:return this.createCircle(_154);case g.defaultEllipse.type:return this.createEllipse(_154);case g.defaultLine.type:return this.createLine(_154);case g.defaultPolyline.type:return this.createPolyline(_154);case g.defaultImage.type:return this.createImage(_154);case g.defaultText.type:return this.createText(_154);case g.defaultTextPath.type:return this.createTextPath(_154);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(rect){return this.createObject(g.Rect,rect);},createEllipse:function(_155){return this.createObject(g.Ellipse,_155);},createCircle:function(_156){return this.createObject(g.Circle,_156);},createLine:function(line){return this.createObject(g.Line,line);},createPolyline:function(_157){return this.createObject(g.Polyline,_157);},createImage:function(_158){return this.createObject(g.Image,_158);},createText:function(text){return this.createObject(g.Text,text);},createPath:function(path){return this.createObject(g.Path,path);},createTextPath:function(text){return this.createObject(g.TextPath,{}).setText(text);},createObject:function(_159,_15a){return null;}};return _125;});},"dojox/gfx/matrix":function(){define(["./_base","dojo/_base/lang"],function(g,lang){var m=g.matrix={};var _15b={};m._degToRad=function(_15c){return _15b[_15c]||(_15b[_15c]=(Math.PI*_15c/180));};m._radToDeg=function(_15d){return _15d/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _15e=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_15e,r=m.normalize(arg[i]);_15e=new m.Matrix2D();_15e.xx=l.xx*r.xx+l.xy*r.yx;_15e.xy=l.xx*r.xy+l.xy*r.yy;_15e.yx=l.yx*r.xx+l.yy*r.yx;_15e.yy=l.yx*r.xy+l.yy*r.yy;_15e.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_15e.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}lang.mixin(this,_15e);}}else{lang.mixin(this,arg);}}}};lang.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});lang.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_15f){var c=Math.cos(_15f);var s=Math.sin(_15f);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_160){return m.rotate(m._degToRad(_160));},skewX:function(_161){return new m.Matrix2D({xy:Math.tan(_161)});},skewXg:function(_162){return m.skewX(m._degToRad(_162));},skewY:function(_163){return new m.Matrix2D({yx:Math.tan(_163)});},skewYg:function(_164){return m.skewY(m._degToRad(_164));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_165){return (_165 instanceof m.Matrix2D)?_165:new m.Matrix2D(_165);},isIdentity:function(_166){return _166.xx==1&&_166.xy==0&&_166.yx==0&&_166.yy==1&&_166.dx==0&&_166.dy==0;},clone:function(_167){var obj=new m.Matrix2D();for(var i in _167){if(typeof (_167[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_167[i]){obj[i]=_167[i];}}return obj;},invert:function(_168){var M=m.normalize(_168),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_169,x,y){return {x:_169.xx*x+_169.xy*y+_169.dx,y:_169.yx*x+_169.yy*y+_169.dy};},multiplyPoint:function(_16a,a,b){var M=m.normalize(_16a);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiplyRectangle:function(_16b,rect){var M=m.normalize(_16b);rect=rect||{x:0,y:0,width:0,height:0};if(m.isIdentity(M)){return {x:rect.x,y:rect.y,width:rect.width,height:rect.height};}var p0=m.multiplyPoint(M,rect.x,rect.y),p1=m.multiplyPoint(M,rect.x,rect.y+rect.height),p2=m.multiplyPoint(M,rect.x+rect.width,rect.y),p3=m.multiplyPoint(M,rect.x+rect.width,rect.y+rect.height),minx=Math.min(p0.x,p1.x,p2.x,p3.x),miny=Math.min(p0.y,p1.y,p2.y,p3.y),maxx=Math.max(p0.x,p1.x,p2.x,p3.x),maxy=Math.max(p0.y,p1.y,p2.y,p3.y);return {x:minx,y:miny,width:maxx-minx,height:maxy-miny};},multiply:function(_16c){var M=m.normalize(_16c);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_16d,x,y){return m.multiply(m.translate(x,y),_16d,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_16e,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_16e),a,b);}return m._sandwich(m.rotate(_16e),a.x,a.y);},rotategAt:function(_16f,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_16f),a,b);}return m._sandwich(m.rotateg(_16f),a.x,a.y);},skewXAt:function(_170,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_170),a,b);}return m._sandwich(m.skewX(_170),a.x,a.y);},skewXgAt:function(_171,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_171),a,b);}return m._sandwich(m.skewXg(_171),a.x,a.y);},skewYAt:function(_172,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_172),a,b);}return m._sandwich(m.skewY(_172),a.x,a.y);},skewYgAt:function(_173,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_173),a,b);}return m._sandwich(m.skewYg(_173),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/charting/SimpleTheme":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_174,_175,dlu,dgg){var _176=_174("dojox.charting.SimpleTheme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_177){_177=_177||{};var def=_176.defaultTheme;arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_177[name]);},this);if(_177.seriesThemes&&_177.seriesThemes.length){this.colors=null;this.seriesThemes=_177.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_177.colors||_176.defaultColors).slice(0);}this.markerThemes=null;if(_177.markerThemes&&_177.markerThemes.length){this.markerThemes=_177.markerThemes.slice(0);}this.markers=_177.markers?lang.clone(_177.markers):lang.delegate(_176.defaultMarkers);this.noGradConv=_177.noGradConv;this.noRadialConv=_177.noRadialConv;if(_177.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _178=new this.constructor({chart:this.chart,plotarea:this.plotarea,axis:this.axis,grid:this.grid,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv,pieInnerRadius:this.pieInnerRadius});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_178[name]=this[name];}},this);return _178;},clear:function(){this._current=0;},next:function(_179,_17a,_17b){var _17c=dlu.merge,_17d,_17e;if(this.colors){_17d=lang.delegate(this.series);_17e=lang.delegate(this.marker);var _17f=new _175(this.colors[this._current%this.colors.length]),old;if(_17d.stroke&&_17d.stroke.color){_17d.stroke=lang.delegate(_17d.stroke);old=new _175(_17d.stroke.color);_17d.stroke.color=new _175(_17f);_17d.stroke.color.a=old.a;}else{_17d.stroke={color:_17f};}if(_17e.stroke&&_17e.stroke.color){_17e.stroke=lang.delegate(_17e.stroke);old=new _175(_17e.stroke.color);_17e.stroke.color=new _175(_17f);_17e.stroke.color.a=old.a;}else{_17e.stroke={color:_17f};}if(!_17d.fill||_17d.fill.type){_17d.fill=_17f;}else{old=new _175(_17d.fill);_17d.fill=new _175(_17f);_17d.fill.a=old.a;}if(!_17e.fill||_17e.fill.type){_17e.fill=_17f;}else{old=new _175(_17e.fill);_17e.fill=new _175(_17f);_17e.fill.a=old.a;}}else{_17d=this.seriesThemes?_17c(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_17e=this.markerThemes?_17c(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_17d;}var _180=_17e&&_17e.symbol||this._markers[this._current%this._markers.length];var _181={series:_17d,marker:_17e,symbol:_180};++this._current;if(_17a){_181=this.addMixin(_181,_179,_17a);}if(_17b){_181=this.post(_181,_179);}return _181;},skip:function(){++this._current;},addMixin:function(_182,_183,_184,_185){if(lang.isArray(_184)){arr.forEach(_184,function(m){_182=this.addMixin(_182,_183,m);},this);}else{var t={};if("color" in _184){if(_183=="line"||_183=="area"){lang.setObject("series.stroke.color",_184.color,t);lang.setObject("marker.stroke.color",_184.color,t);}else{lang.setObject("series.fill",_184.color,t);}}arr.forEach(["stroke","outline","shadow","fill","filter","font","fontColor","labelWiring"],function(name){var _186="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_186 in _184;if(name in _184){lang.setObject("series."+name,_184[name],t);if(!b){lang.setObject("marker."+name,_184[name],t);}}if(b){lang.setObject("marker."+name,_184[_186],t);}});if("marker" in _184){t.symbol=_184.marker;t.symbol=_184.marker;}_182=dlu.merge(_182,t);}if(_185){_182=this.post(_182,_183);}return _182;},post:function(_187,_188){var fill=_187.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_188=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_188=="slice"||_188=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_187,{series:{fill:t}});}}return _187;},getTick:function(name,_189){var tick=this.axis.tick,_18a=name+"Tick",_18b=dlu.merge;if(tick){if(this.axis[_18a]){tick=_18b(tick,this.axis[_18a]);}}else{tick=this.axis[_18a];}if(_189){if(tick){if(_189[_18a]){tick=_18b(tick,_189[_18a]);}}else{tick=_189[_18a];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_18c){this.markers[name]=_18c;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_176,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333",titleAlign:"middle"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",labelGap:4},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1},title:{gap:15,font:"normal normal normal 11pt Tahoma",fontColor:"#333",orientation:"axis"}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,lineFill:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}}});return _176;});},"dojox/lang/utils":function(){define(["..","dojo/_base/lang"],function(_18d,lang){var du=lang.getObject("lang.utils",true,_18d);var _18e={},opts=Object.prototype.toString;var _18f=function(o){if(o){switch(opts.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return lang.delegate(o);}}return o;};lang.mixin(du,{coerceType:function(_190,_191){switch(typeof _190){case "number":return Number(eval("("+_191+")"));case "string":return String(_191);case "boolean":return Boolean(eval("("+_191+")"));}return eval("("+_191+")");},updateWithObject:function(_192,_193,conv){if(!_193){return _192;}for(var x in _192){if(x in _193&&!(x in _18e)){var t=_192[x];if(t&&typeof t=="object"){du.updateWithObject(t,_193[x],conv);}else{_192[x]=conv?du.coerceType(t,_193[x]):_18f(_193[x]);}}}return _192;},updateWithPattern:function(_194,_195,_196,conv){if(!_195||!_196){return _194;}for(var x in _196){if(x in _195&&!(x in _18e)){_194[x]=conv?du.coerceType(_196[x],_195[x]):_18f(_195[x]);}}return _194;},merge:function(_197,_198){if(_198){var _199=opts.call(_197),_19a=opts.call(_198),t,i,l,m;switch(_19a){case "[object Array]":if(_19a==_199){t=new Array(Math.max(_197.length,_198.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_197[i],_198[i]);}return t;}return _198.slice(0);case "[object Object]":if(_19a==_199&&_197){t=lang.delegate(_197);for(i in _198){if(i in _197){l=_197[i];m=_198[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=lang.clone(_198[i]);}}return t;}return lang.clone(_198);}}return _198;}});return du;});},"dojox/gfx/gradutils":function(){define(["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_19b){var _19c=g.gradutils={};function _19d(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _19b.blendColors(new _19b(prev.color),new _19b(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_19c.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _19e=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_19f=m.rotate(-_19e),_1a0=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_1a0,pt),pf1=m.multiplyPoint(_1a0,fill.x1,fill.y1),pf2=m.multiplyPoint(_1a0,fill.x2,fill.y2),_1a1=m.multiplyPoint(_19f,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_19f,p.x-pf1.x,p.y-pf1.y).x/_1a1;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _19d(o,fill.colors);}return new _19b(fill||[0,0,0,0]);};_19c.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _19c;});},"dojox/charting/Series":function(){define(["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_1a2,_1a3){return _1a2("dojox.charting.Series",_1a3,{constructor:function(_1a4,data,_1a5){lang.mixin(this,_1a5);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dojox/charting/axis2d/common":function(){define(["dojo/_base/lang","dojo/_base/window","dojo/dom-geometry","dojox/gfx","dojo/has"],function(lang,win,_1a6,g,has){var _1a7=lang.getObject("dojox.charting.axis2d.common",true);var _1a8=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _1a9=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _1a6.getMarginBox(n).w;}};return lang.mixin(_1a7,{createText:{gfx:function(_1aa,_1ab,x,y,_1ac,text,font,_1ad){return _1ab.createText({x:x,y:y,text:text,align:_1ac}).setFont(font).setFill(_1ad);},html:function(_1ae,_1af,x,y,_1b0,text,font,_1b1,_1b2){var p=win.doc.createElement("div"),s=p.style,_1b3;if(_1ae.getTextDir){p.dir=_1ae.getTextDir(text);}_1a8(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_1b1;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_1b2){_1b3=_1a9(p);}if(p.dir=="rtl"){x+=_1b2?_1b2:_1b3;}win.body().removeChild(p);s.position="relative";if(_1b2){s.width=_1b2+"px";switch(_1b0){case "middle":s.textAlign="center";s.left=(x-_1b2/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_1b2)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_1b0){case "middle":s.left=Math.floor(x-_1b3/2)+"px";break;case "end":s.left=Math.floor(x-_1b3)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_1a8(w);w.width="0px";w.height="0px";wrap.appendChild(p);_1ae.node.insertBefore(wrap,_1ae.node.firstChild);if(has("dojo-bidi")){_1ae.htmlElementsRegistry.push([wrap,x,y,_1b0,text,font,_1b1]);}return wrap;}}});});},"dojox/charting/plot2d/common":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,_1b4,g,df,sc){var _1b5=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_1b5,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_1b6){if(!_1b6){return _1b6;}if(typeof _1b6=="string"||_1b6 instanceof _1b4){_1b6={color:_1b6};}return g.makeParameters(g.defaultStroke,_1b6);},augmentColor:function(_1b7,_1b8){var t=new _1b4(_1b7),c=new _1b4(_1b8);c.a=t.a;return c;},augmentStroke:function(_1b9,_1ba){var s=_1b5.makeStroke(_1b9);if(s){s.color=_1b5.augmentColor(s.color,_1ba);}return s;},augmentFill:function(fill,_1bb){var fc,c=new _1b4(_1bb);if(typeof fill=="string"||fill instanceof _1b4){return _1b5.augmentColor(fill,_1bb);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_1bc,_1bd){var _1be=lang.delegate(_1b5.defaultStats);for(var i=0;i<_1bc.length;++i){var run=_1bc[i];for(var j=0;j<run.data.length;j++){if(!_1bd(run.data[j])){if(typeof run.data[j]=="number"){var _1bf=_1be.vmin,_1c0=_1be.vmax;arr.forEach(run.data,function(val,i){if(!_1bd(val)){var x=i+1,y=val;if(isNaN(y)){y=0;}_1be.hmin=Math.min(_1be.hmin,x);_1be.hmax=Math.max(_1be.hmax,x);_1be.vmin=Math.min(_1be.vmin,y);_1be.vmax=Math.max(_1be.vmax,y);}});if("ymin" in run){_1be.vmin=Math.min(_1bf,run.ymin);}if("ymax" in run){_1be.vmax=Math.max(_1c0,run.ymax);}}else{var _1c1=_1be.hmin,_1c2=_1be.hmax,_1bf=_1be.vmin,_1c0=_1be.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(!_1bd(val)){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_1be.hmin=Math.min(_1be.hmin,x);_1be.hmax=Math.max(_1be.hmax,x);_1be.vmin=Math.min(_1be.vmin,y);_1be.vmax=Math.max(_1be.vmax,y);}});}if("xmin" in run){_1be.hmin=Math.min(_1c1,run.xmin);}if("xmax" in run){_1be.hmax=Math.max(_1c2,run.xmax);}if("ymin" in run){_1be.vmin=Math.min(_1bf,run.ymin);}if("ymax" in run){_1be.vmax=Math.max(_1c0,run.ymax);}}break;}}}return _1be;},calculateBarSize:function(_1c3,opt,_1c4){if(!_1c4){_1c4=1;}var gap=opt.gap,size=(_1c3-2*gap)/_1c4;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_1c3-size*_1c4)/2;return {size:size,gap:gap};},collectStackedStats:function(_1c5){var _1c6=lang.clone(_1b5.defaultStats);if(_1c5.length){_1c6.hmin=Math.min(_1c6.hmin,1);_1c6.hmax=df.foldl(_1c5,"seed, run -> Math.max(seed, run.data.length)",_1c6.hmax);for(var i=0;i<_1c6.hmax;++i){var v=_1c5[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}_1c6.vmin=Math.min(_1c6.vmin,v);for(var j=1;j<_1c5.length;++j){var t=_1c5[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}_1c6.vmax=Math.max(_1c6.vmax,v);}}return _1c6;},curve:function(a,_1c7){var _1c8=a.slice(0);if(_1c7=="x"){_1c8[_1c8.length]=_1c8[0];}var p=arr.map(_1c8,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_1c7)){var dx=item.x-_1c8[i-1].x,dy=_1c8[i-1].y;return "C"+(item.x-(_1c7-1)*(dx/_1c7))+","+dy+" "+(item.x-(dx/_1c7))+","+item.y+" "+item.x+","+item.y;}else{if(_1c7=="X"||_1c7=="x"||_1c7=="S"){var p0,p1=_1c8[i-1],p2=_1c8[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_1c7=="x"){p0=_1c8[_1c8.length-2];}else{p0=p1;}f=1/3;}else{p0=_1c8[i-2];}if(i==(_1c8.length-1)){if(_1c7=="x"){p3=_1c8[1];}else{p3=p2;}f=1/3;}else{p3=_1c8[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _1c9=p0p2*f;var _1ca=p1p3*f;if(_1c9>p1p2/2&&_1ca>p1p2/2){_1c9=p1p2/2;_1ca=p1p2/2;}else{if(_1c9>p1p2/2){_1c9=p1p2/2;_1ca=p1p2/2*p1p3/p0p2;}else{if(_1ca>p1p2/2){_1ca=p1p2/2;_1c9=p1p2/2*p0p2/p1p3;}}}if(_1c7=="S"){if(p0==p1){_1c9=0;}if(p2==p3){_1ca=0;}}bz1x=p1.x+_1c9*(p2.x-p0.x)/p0p2;bz1y=p1.y+_1c9*(p2.y-p0.y)/p0p2;bz2x=p2.x-_1ca*(p3.x-p1.x)/p1p3;bz2y=p2.y-_1ca*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_1cb,_1cc,_1cd){return sc.doIfLoaded("dojo/number",function(_1ce){return (_1cc?_1ce.format(_1cb,{places:_1cd}):_1ce.format(_1cb))||"";},function(){return _1cc?_1cb.toFixed(_1cd):_1cb.toString();});},purgeGroup:function(item){return item.purgeGroup();}});});},"dojox/lang/functional":function(){define(["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dojox/lang/functional/lambda":function(){define(["../..","dojo/_base/lang","dojo/_base/array"],function(_1cf,lang,arr){var df=lang.getObject("lang.functional",true,_1cf);var _1d0={};var _1d1="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _1d2=function(s){var args=[],_1d3=_1d1.call(s,/\s*->\s*/m);if(_1d3.length>1){while(_1d3.length){s=_1d3.pop();args=_1d3.pop().split(/\s*,\s*|\s+/m);if(_1d3.length){_1d3.push("(function("+args.join(", ")+"){ return ("+s+"); })");}}}else{if(s.match(/\b_\b/)){args=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){args.push("$1");s="$1"+s;}if(r){args.push("$2");s=s+"$2";}}else{var vars=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(vars,function(v){if(!t.hasOwnProperty(v)){args.push(v);t[v]=1;}});}}}return {args:args,body:s};};var _1d4=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};lang.mixin(df,{rawLambda:function(s){return _1d2(s);},buildLambda:function(s){var l=_1d2(s);return "function("+l.args.join(",")+"){return ("+l.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _1d4(s);}if(_1d0.hasOwnProperty(s)){return _1d0[s];}var l=_1d2(s);return _1d0[s]=new Function(l.args,"return ("+l.body+");");},clearLambdaCache:function(){_1d0={};}});return df;});},"dojox/lang/functional/array":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","./lambda"],function(_1d5,lang,arr,df){var _1d6={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _1d6)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _1d6)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _1d6)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _1d6)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _1d6)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dojox/lang/functional/object":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_1d7,lang,df){var _1d8={};lang.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _1d8)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _1d8)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _1d8)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);for(var i in obj){if(!(i in _1d8)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _1d8)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});return df;});},"dojox/charting/scaler/common":function(){define(["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _1d9=lang.getObject("dojox.charting.scaler.common",true);var _1da={};return lang.mixin(_1d9,{doIfLoaded:function(_1db,_1dc,_1dd){if(_1da[_1db]===undefined){try{_1da[_1db]=require(_1db);}catch(e){_1da[_1db]=null;}}if(_1da[_1db]){return _1dc(_1da[_1db]);}else{return _1dd();}},getNumericLabel:function(_1de,_1df,_1e0){var def="";_1d9.doIfLoaded("dojo/number",function(_1e1){def=(_1e0.fixed?_1e1.format(_1de,{places:_1df<0?-_1df:0}):_1e1.format(_1de))||"";},function(){def=_1e0.fixed?_1de.toFixed(_1df<0?-_1df:0):_1de.toString();});if(_1e0.labelFunc){var r=_1e0.labelFunc(def,_1de,_1df);if(r){return r;}}if(_1e0.labels){var l=_1e0.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_1de){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}}return def;}});});},"dojox/lang/functional/fold":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/kernel","./lambda"],function(lang,arr,_1e2,df){var _1e3={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _1e3)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _1e4=true;for(i in a){if(!(i in _1e3)){if(_1e4){z=a[i];_1e4=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||_1e2.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"dojox/lang/functional/reversed":function(){define(["dojo/_base/lang","dojo/_base/kernel","./lambda"],function(lang,_1e5,df){lang.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dojox/charting/plot2d/Pie":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-geometry","dojo/_base/Color","./Base","./_PlotEvents","./common","dojox/gfx","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/utils","dojo/has"],function(lang,arr,_1e6,_1e7,_1e8,Base,_1e9,dc,g,m,df,du,has){var _1ea=0.2;return _1e6("dojox.charting.plot2d.Pie",[Base,_1e9],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0,innerRadius:0,minWidth:0,zeroDataMessage:""},optionalParams:{radius:0,omitLabels:false,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",labelWiring:{}},constructor:function(_1eb,_1ec){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_1ec);du.updateWithPattern(this.opt,_1ec,this.optionalParams);this.axes=[];this.run=null;this.dyn=[];this.runFilter=[];if(_1ec&&_1ec.hasOwnProperty("innerRadius")){this._plotSetInnerRadius=true;}},clear:function(){this.inherited(arguments);this.dyn=[];this.run=null;return this;},setAxis:function(axis){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_1ed){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this._plotSetInnerRadius&&t&&t.pieInnerRadius){this.opt.innerRadius=t.pieInnerRadius;}var rx=(dim.width-_1ed.l-_1ed.r)/2,ry=(dim.height-_1ed.t-_1ed.b)/2,r=Math.min(rx,ry),_1ee="font" in this.opt?this.opt.font:t.axis.tick.titleFont||"",size=_1ee?g.normalizedLength(g.splitFontString(_1ee).size):0,_1ef=this.opt.hasOwnProperty("fontColor")?this.opt.fontColor:t.axis.tick.fontColor,_1f0=m._degToRad(this.opt.startAngle),_1f1=_1f0,_1f2,_1f3,_1f4,_1f5,_1f6,run=this.run.data,_1f7=this.events();var _1f8=lang.hitch(this,function(){var ct=t.clone();var _1f9=df.map(run,function(v){var _1fa=[this.opt,this.run];if(v!==null&&typeof v!="number"){_1fa.push(v);}if(this.opt.styleFunc){_1fa.push(this.opt.styleFunc(v));}return ct.next("slice",_1fa,true);},this);if("radius" in this.opt){r=this.opt.radius<r?this.opt.radius:r;}var _1fb={cx:_1ed.l+rx,cy:_1ed.t+ry,r:r};var _1fc=new _1e8(_1ef);if(this.opt.innerRadius){_1fc.a=0.1;}var ring=this._createRing(s,_1fb).setStroke(_1fc);if(this.opt.innerRadius){ring.setFill(_1fc);}if(this.opt.zeroDataMessage){this.renderLabel(s,_1fb.cx,_1fb.cy+size/3,this.opt.zeroDataMessage,{series:{font:_1ee,fontColor:_1ef}},null,"middle");}this.dyn=[];arr.forEach(run,function(item,i){this.dyn.push({fill:this._plotFill(_1f9[i].series.fill,dim,_1ed),stroke:_1f9[i].series.stroke});},this);});if(!this.run&&!this.run.data.ength){_1f8();return this;}if(typeof run[0]=="number"){_1f2=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_1f2,"<= 0")){_1f8();return this;}_1f3=df.map(_1f2,"/this",df.foldl(_1f2,"+",0));if(this.opt.labels){_1f4=arr.map(_1f3,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}else{_1f2=df.map(run,"x ? Math.max(x.y, 0) : 0");if(!_1f2.length||df.every(_1f2,"<= 0")){_1f8();return this;}_1f3=df.map(_1f2,"/this",df.foldl(_1f2,"+",0));if(this.opt.labels){_1f4=arr.map(_1f3,function(x,i){if(x<0){return "";}var v=run[i];return v.hasOwnProperty("text")?v.text:this._getLabel(x*100)+"%";},this);}}var _1fd=df.map(run,function(v){var _1fe=[this.opt,this.run];if(v!==null&&typeof v!="number"){_1fe.push(v);}if(this.opt.styleFunc){_1fe.push(this.opt.styleFunc(v));}return t.next("slice",_1fe,true);},this);if(this.opt.labels){_1f5=df.foldl1(df.map(_1f4,function(_1ff,i){var font=_1fd[i].series.font;return g._base._getTextBox(_1ff,{font:font}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_1f5,ry-size)+this.opt.labelOffset;}}if(this.opt.hasOwnProperty("radius")){r=this.opt.radius<r*0.9?this.opt.radius:r*0.9;}if(!this.opt.radius&&this.opt.labels&&this.opt.labelStyle=="columns"){r=r/2;if(rx>ry&&rx>r*2){r*=rx/(r*2);}if(r>=ry*0.8){r=ry*0.8;}}else{if(r>=ry*0.9){r=ry*0.9;}}_1f6=r-this.opt.labelOffset;var _200={cx:_1ed.l+rx,cy:_1ed.t+ry,r:r};this.dyn=[];var _201=new Array(_1f3.length);var _202=[],_203=_1f1;var _204=this.opt.minWidth;arr.forEach(_1f3,function(_205,i){if(_205===0){_202[i]={step:0,end:_203,start:_203,weak:false};return;}var end=_203+_205*2*Math.PI;if(i===_1f3.length-1){end=_1f0+2*Math.PI;}var step=end-_203,dist=step*r;_202[i]={step:step,start:_203,end:end,weak:dist<_204};_203=end;});if(_204>0){var _206=0,_207=_204/r,_208=0,i;for(i=_202.length-1;i>=0;i--){if(_202[i].weak){++_206;_208+=_202[i].step;_202[i].step=_207;}}var _209=_206*_207;if(_209>Math.PI){_207=Math.PI/_206;for(i=0;i<_202.length;++i){if(_202[i].weak){_202[i].step=_207;}}_209=Math.PI;}if(_206>0){_207=1-(_209-_208)/2/Math.PI;for(i=0;i<_202.length;++i){if(!_202[i].weak){_202[i].step=_207*_202[i].step;}}}for(i=0;i<_202.length;++i){_202[i].start=i?_202[i].end:_203;_202[i].end=_202[i].start+_202[i].step;}for(i=_202.length-1;i>=0;--i){if(_202[i].step!==0){_202[i].end=_203+2*Math.PI;break;}}}_203=_1f1;var o,_20a;arr.some(_1f3,function(_20b,i){var _20c;var v=run[i],_20d=_1fd[i];if(_20b>=1){_20a=this._plotFill(_20d.series.fill,dim,_1ed);_20a=this._shapeFill(_20a,{x:_200.cx-_200.r,y:_200.cy-_200.r,width:2*_200.r,height:2*_200.r});_20a=this._pseudoRadialFill(_20a,{x:_200.cx,y:_200.cy},_200.r);_20c=this._createRing(s,_200).setFill(_20a).setStroke(_20d.series.stroke);this.dyn.push({fill:_20a,stroke:_20d.series.stroke});if(_1f7){o={element:"slice",index:i,run:this.run,shape:_20c,x:i,y:typeof v=="number"?v:v.y,cx:_200.cx,cy:_200.cy,cr:r};this._connectEvents(o);_201[i]=o;}var k;for(k=i+1;k<_1f3.length;k++){_20d=_1fd[k];this.dyn.push({fill:_20d.series.fill,stroke:_20d.series.stroke});}return true;}if(_202[i].step===0){this.dyn.push({fill:_20d.series.fill,stroke:_20d.series.stroke});return false;}var step=_202[i].step,x1=_200.cx+r*Math.cos(_203),y1=_200.cy+r*Math.sin(_203),x2=_200.cx+r*Math.cos(_203+step),y2=_200.cy+r*Math.sin(_203+step);var _20e=m._degToRad(this.opt.fanSize),_20f;if(_20d.series.fill&&_20d.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&step>_20e){var _210=s.createGroup(),_211=Math.ceil(step/_20e),_212=step/_211;_20a=this._shapeFill(_20d.series.fill,{x:_200.cx-_200.r,y:_200.cy-_200.r,width:2*_200.r,height:2*_200.r});var j,_213,beta,_214,_215,_216,_217;for(j=0;j<_211;++j){_213=_203+(j-_1ea)*_212;beta=_203+(j+1+_1ea)*_212;_214=j==0?x1:_200.cx+r*Math.cos(_213);_215=j==0?y1:_200.cy+r*Math.sin(_213);_216=j==_211-1?x2:_200.cx+r*Math.cos(beta);_217=j==_211-1?y2:_200.cy+r*Math.sin(beta);this._createSlice(_210,_200,r,_214,_215,_216,_217,_213,_212).setFill(this._pseudoRadialFill(_20a,{x:_200.cx,y:_200.cy},r,_203+(j+0.5)*_212,_203+(j+0.5)*_212));}_20f=_20d.series.stroke;this._createSlice(_210,_200,r,x1,y1,x2,y2,_203,step).setStroke(_20f);_20c=_210;}else{_20f=_20d.series.stroke;_20c=this._createSlice(s,_200,r,x1,y1,x2,y2,_203,step).setStroke(_20f);_20a=_20d.series.fill;if(_20a&&_20a.type==="radial"){_20a=this._shapeFill(_20a,{x:_200.cx-_200.r,y:_200.cy-_200.r,width:2*_200.r,height:2*_200.r});if(this.opt.radGrad==="linear"){_20a=this._pseudoRadialFill(_20a,{x:_200.cx,y:_200.cy},r,_203,_203+step);}}else{if(_20a&&_20a.type==="linear"){var bbox=lang.clone(_20c.getBoundingBox());if(g.renderer==="svg"){var pos={w:0,h:0};try{pos=_1e7.position(_20c.rawNode);}catch(ignore){}if(pos.h>bbox.height){bbox.height=pos.h;}if(pos.w>bbox.width){bbox.width=pos.w;}}_20a=this._plotFill(_20a,dim,_1ed);_20a=this._shapeFill(_20a,bbox);}}_20c.setFill(_20a);}this.dyn.push({fill:_20a,stroke:_20d.series.stroke});if(_1f7){o={element:"slice",index:i,run:this.run,shape:_20c,x:i,y:typeof v=="number"?v:v.y,cx:_200.cx,cy:_200.cy,cr:r};this._connectEvents(o);_201[i]=o;}_203=_203+step;return false;},this);if(this.opt.labels){var _218=has("dojo-bidi")&&this.chart.isRightToLeft();if(this.opt.labelStyle=="default"){_1f1=_1f0;_203=_1f1;arr.some(_1f3,function(_219,i){if(_219<=0&&!this.opt.minWidth){return false;}var _21a=_1fd[i];if(_219>=1){this.renderLabel(s,_200.cx,_200.cy+size/2,_1f4[i],_21a,this.opt.labelOffset>0);return true;}var end=_1f1+_219*2*Math.PI;if(i+1==_1f3.length){end=_1f0+2*Math.PI;}if(this.opt.omitLabels&&end-_1f1<0.001){return false;}var _21b=_203+(_202[i].step/2),x=_200.cx+_1f6*Math.cos(_21b),y=_200.cy+_1f6*Math.sin(_21b)+size/2;this.renderLabel(s,_218?dim.width-x:x,y,_1f4[i],_21a,this.opt.labelOffset>0);_203+=_202[i].step;_1f1=end;return false;},this);}else{if(this.opt.labelStyle=="columns"){var _21c=this.opt.omitLabels;_1f1=_1f0;_203=_1f1;var _21d=[],_21e=0,k;for(k=_1f3.length-1;k>=0;--k){if(_1f3[k]){++_21e;}}arr.forEach(_1f3,function(_21f,i){var end=_1f1+_21f*2*Math.PI;if(i+1==_1f3.length){end=_1f0+2*Math.PI;}if(this.minWidth!==0||end-_1f1>=0.001){var _220=_203+(_202[i].step/2);if(_21e===1&&!this.opt.minWidth){_220=(_1f1+end)/2;}_21d.push({angle:_220,left:Math.cos(_220)<0,theme:_1fd[i],index:i,omit:_21c?end-_1f1<0.001:false});}_1f1=end;_203+=_202[i].step;},this);var _221=g._base._getTextBox("a",{font:_1ee,whiteSpace:"nowrap"}).h;this._getProperLabelRadius(_21d,_221,_200.r*1.1);var _222=_200.cx-_200.r*2,_223=_200.cx+_200.r*2;arr.forEach(_21d,function(_224){if(_224.omit){return;}var _225=_1fd[_224.index],_226=0;if(_225&&_225.axis&&_225.axis.tick&&_225.axis.tick.labelGap){_226=_225.axis.tick.labelGap;}var _227=g._base._getTextBox(_1f4[_224.index],{font:_225.series.font,whiteSpace:"nowrap",paddingLeft:_226+"px"}).w,x=_200.cx+_224.labelR*Math.cos(_224.angle),y=_200.cy+_224.labelR*Math.sin(_224.angle),_228=(_224.left)?(_222+_227):(_223-_227),_229=(_224.left)?_222:_228+_226,_22a=_200.r,_22b=s.createPath().moveTo(_200.cx+_22a*Math.cos(_224.angle),_200.cy+_22a*Math.sin(_224.angle));if(Math.abs(_224.labelR*Math.cos(_224.angle))<_200.r*2-_227){_22b.lineTo(x,y);}_22b.lineTo(_228,y).setStroke(_224.theme.series.labelWiring);_22b.moveToBack();var mid=_221/3+y;var elem=this.renderLabel(s,_229,mid||0,_1f4[_224.index],_225,false,"left");if(_1f7&&!this.opt.htmlLabels){var _22c=g._base._getTextBox(_1f4[_224.index],{font:_224.theme.series.font}).w||0,_22d=g.normalizedLength(g.splitFontString(_224.theme.series.font).size);o={element:"labels",index:_224.index,run:this.run,shape:elem,x:_229,y:y,label:_1f4[_224.index]};var shp=elem.getShape(),lt=_1e7.position(this.chart.node,true),_22e=lang.mixin({type:"rect"},{x:shp.x,y:shp.y-2*_22d});_22e.x+=lt.x;_22e.y+=lt.y;_22e.x=Math.round(_22e.x);_22e.y=Math.round(_22e.y);_22e.width=Math.ceil(_22c);_22e.height=Math.ceil(_22d);o.aroundRect=_22e;this._connectEvents(o);_201[_1f3.length+_224.index]=o;}},this);}}}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_201[esi++];});if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_1ed);}return this;},_getProperLabelRadius:function(_22f,_230,_231){if(_22f.length==1){_22f[0].labelR=_231;return;}var _232={},_233={},_234=2,_235=2,i;var _236;for(i=0;i<_22f.length;++i){_236=Math.abs(Math.sin(_22f[i].angle));if(_22f[i].left){if(_234>_236){_234=_236;_232=_22f[i];}}else{if(_235>_236){_235=_236;_233=_22f[i];}}}_232.labelR=_233.labelR=_231;this._caculateLabelR(_232,_22f,_230);this._caculateLabelR(_233,_22f,_230);},_caculateLabelR:function(_237,_238,_239){var i,j,k,_23a=_238.length,_23b=_237.labelR,_23c,step=_238[_237.index].left?-_239:_239;for(k=0,i=_237.index,j=(i+1)%_23a;k<_23a&&_238[i].left===_238[j].left;++k){_23c=(Math.sin(_238[i].angle)*_23b+step)/Math.sin(_238[j].angle);_23b=Math.max(_237.labelR,_23c);_238[j].labelR=_23b;i=(i+1)%_23a;j=(j+1)%_23a;}if(k>=_23a){_238[0].labelR=_237.labelR;}for(k=0,i=_237.index,j=(i||_23a)-1;k<_23a&&_238[i].left===_238[j].left;++k){_23c=(Math.sin(_238[i].angle)*_23b-step)/Math.sin(_238[j].angle);_23b=Math.max(_237.labelR,_23c);_238[j].labelR=_23b;i=(i||_23a)-1;j=(j||_23a)-1;}},_createRing:function(_23d,_23e){var r=this.opt.innerRadius;if(r>0){r=_23e.r*(r/100);}else{if(r<0){r=-r;}}if(r){return _23d.createPath({}).setAbsoluteMode(true).moveTo(_23e.cx,_23e.cy-_23e.r).arcTo(_23e.r,_23e.r,0,false,true,_23e.cx+_23e.r,_23e.cy).arcTo(_23e.r,_23e.r,0,true,true,_23e.cx,_23e.cy-_23e.r).closePath().moveTo(_23e.cx,_23e.cy-r).arcTo(r,r,0,false,true,_23e.cx+r,_23e.cy).arcTo(r,r,0,true,true,_23e.cx,_23e.cy-r).closePath();}return _23d.createCircle(_23e);},_createSlice:function(_23f,_240,R,x1,y1,x2,y2,_241,_242){var r=this.opt.innerRadius;if(r>0){r=_240.r*(r/100);}else{if(r<0){r=-r;}}if(r){var _243=_240.cx+r*Math.cos(_241),_244=_240.cy+r*Math.sin(_241),_245=_240.cx+r*Math.cos(_241+_242),_246=_240.cy+r*Math.sin(_241+_242);return _23f.createPath({}).setAbsoluteMode(true).moveTo(_243,_244).lineTo(x1,y1).arcTo(R,R,0,_242>Math.PI,true,x2,y2).lineTo(_245,_246).arcTo(r,r,0,_242>Math.PI,false,_243,_244).closePath();}return _23f.createPath({}).setAbsoluteMode(true).moveTo(_240.cx,_240.cy).lineTo(x1,y1).arcTo(R,R,0,_242>Math.PI,true,x2,y2).lineTo(_240.cx,_240.cy).closePath();}});});},"dojox/charting/plot2d/Base":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojox/gfx","../Element","./common","../axis2d/common","dojo/has"],function(_247,arr,lang,gfx,_248,_249,ac,has){var Base=_247("dojox.charting.plot2d.Base",_248,{constructor:function(_24a,_24b){if(_24b&&_24b.tooltipFunc){this.tooltipFunc=_24b.tooltipFunc;}},clear:function(){this.series=[];this.dirty=true;return this;},setAxis:function(axis){return this;},assignAxes:function(axes){arr.forEach(this.axes,function(axis){if(this[axis]){this.setAxis(axes[this[axis]]);}},this);},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _249.collectSimpleStats(this.series,lang.hitch(this,"isNullValue"));},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},initializeScalers:function(){return this;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},render:function(dim,_24c){return this;},renderLabel:function(_24d,x,y,_24e,_24f,_250,_251){var elem=ac.createText[this.opt.htmlLabels&&gfx.renderer!="vml"?"html":"gfx"](this.chart,_24d,x,y,_251?_251:"middle",_24e,_24f.series.font,_24f.series.fontColor);if(_250){if(this.opt.htmlLabels&&gfx.renderer!="vml"){elem.style.pointerEvents="none";}else{if(elem.rawNode){elem.rawNode.style.pointerEvents="none";}}}if(this.opt.htmlLabels&&gfx.renderer!="vml"){this.htmlElements.push(elem);}return elem;},getRequiredColors:function(){return this.series.length;},_getLabel:function(_252){return _249.getLabel(_252,this.opt.fixed,this.opt.precision);}});if(has("dojo-bidi")){Base.extend({_checkOrientation:function(_253,dim,_254){this.chart.applyMirroring(this.group,dim,_254);}});}return Base;});},"dojox/charting/plot2d/_PlotEvents":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(lang,arr,_255,hub){return _255("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=lang.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";arr.forEach(this.chart.stack,function(plot){if(plot!==this&&plot.plotEvent){t.plot=plot;plot.plotEvent(t);}},this);},connect:function(_256,_257){this.dirty=true;return hub.connect(this,"plotEvent",_256,_257);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){arr.forEach(this._shapeEvents,function(item){item.shape.disconnect(item.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_258){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_258,this,function(e){o.type=_258;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_259){var a=this._eventSeries[_259];if(a){arr.forEach(a,this._connectEvents,this);}},fireEvent:function(_25a,_25b,_25c,_25d){var s=this._eventSeries[_25a];if(s&&s.length&&_25c<s.length){var o=s[_25c];o.type=_25b;o.event=_25d||null;this.raiseEvent(o);o.event=null;}}});});},"dojox/charting/action2d/Tooltip":function(){define(["dijit/Tooltip","dojo/_base/lang","dojo/_base/declare","dojo/_base/window","dojo/_base/connect","dojo/dom-style","./PlotAction","dojox/gfx/matrix","dojo/has","dojo/has!dojo-bidi?../bidi/action2d/Tooltip","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(_25e,lang,_25f,win,hub,_260,_261,m,has,_262,df){var _263=function(o,plot){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(plot.tooltipFunc){return plot.tooltipFunc(o);}else{return o.y;}};var pi4=Math.PI/4,pi2=Math.PI/2;var _264=_25f(has("dojo-bidi")?"dojox.charting.action2d.NonBidiTooltip":"dojox.charting.action2d.Tooltip",_261,{defaultParams:{text:_263,mouseOver:true,defaultPosition:["after-centered","before-centered"]},optionalParams:{},constructor:function(_265,plot,_266){this.text=_266&&_266.text?_266.text:_263;this.mouseOver=_266&&_266.mouseOver!=undefined?_266.mouseOver:true;this.defaultPosition=_266&&_266.defaultPosition!=undefined?_266.defaultPosition:["after-centered","before-centered"];this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){_25e.hide(this.aroundRect);this.aroundRect=null;if(o.type==="onplotreset"){delete this.angles;}return;}if(!o.shape||(this.mouseOver&&o.type!=="onmouseover")||(!this.mouseOver&&o.type!=="onclick")){return;}var _267={type:"rect"},_268=this.defaultPosition;switch(o.element){case "marker":_267.x=o.cx;_267.y=o.cy;_267.w=_267.h=1;break;case "circle":_267.x=o.cx-o.cr;_267.y=o.cy-o.cr;_267.w=_267.h=2*o.cr;break;case "spider_circle":_267.x=o.cx;_267.y=o.cy;_267.w=_267.h=1;break;case "spider_plot":return;case "column":_268=["above-centered","below-centered"];case "bar":_267=lang.clone(o.shape.getShape());_267.w=_267.width;_267.h=_267.height;break;case "candlestick":_267.x=o.x;_267.y=o.y;_267.w=o.width;_267.h=o.height;break;default:if(!this.angles){var _269=typeof o.run.data[0]=="number"?df.map(o.run.data,"x ? Math.max(x, 0) : 0"):df.map(o.run.data,"x ? Math.max(x.y, 0) : 0");this.angles=df.map(df.scanl(_269,"+",0),"* 2 * Math.PI / this",df.foldl(_269,"+",0));}var _26a=m._degToRad(o.plot.opt.startAngle),_26b=(this.angles[o.index]+this.angles[o.index+1])/2+_26a;_267.x=o.cx+o.cr*Math.cos(_26b);_267.y=o.cy+o.cr*Math.sin(_26b);_267.w=_267.h=1;if(_26a&&(_26b<0||_26b>2*Math.PI)){_26b=Math.abs(2*Math.PI-Math.abs(_26b));}if(_26b<pi4){}else{if(_26b<pi2+pi4){_268=["below-centered","above-centered"];}else{if(_26b<Math.PI+pi4){_268=["before-centered","after-centered"];}else{if(_26b<2*Math.PI-pi4){_268=["above-centered","below-centered"];}}}}break;}if(has("dojo-bidi")){this._recheckPosition(o,_267,_268);}var lt=this.chart.getCoords();_267.x+=lt.x;_267.y+=lt.y;_267.x=Math.round(_267.x);_267.y=Math.round(_267.y);_267.w=Math.ceil(_267.w);_267.h=Math.ceil(_267.h);this.aroundRect=_267;var _26c=this.text(o,this.plot);if(_26c){_25e.show(this._format(_26c),this.aroundRect,_268);}if(!this.mouseOver){this._handle=hub.connect(win.doc,"onclick",this,"onClick");}},onClick:function(){this.process({type:"onmouseout"});},_recheckPosition:function(obj,rect,_26d){},_format:function(_26e){return _26e;}});return has("dojo-bidi")?_25f("dojox.charting.action2d.Tooltip",[_264,_262]):_264;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_26f,_270,fx,dom,_271,_272,_273,lang,_274,on,has,_275,_276,_277,_278,_279,_27a,_27b){var _27c=_270("dijit._MasterTooltip",[_277,_278],{duration:_275.defaultDuration,templateString:_27a,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _279(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_27d,_27e,_27f,rtl,_280,_281,_282){if(this.aroundNode&&this.aroundNode===_27e&&this.containerNode.innerHTML==_27d){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_27d;if(_280){this.set("textDir",_280);}this.containerNode.align=rtl?"right":"left";var pos=_276.around(this.domNode,_27e,_27f&&_27f.length?_27f:_283.defaultPosition,!rtl,lang.hitch(this,"orient"));var _284=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_284.y+((_284.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_284.x+((_284.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_273.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_27e;this.onMouseEnter=_281||noop;this.onMouseLeave=_282||noop;},orient:function(node,_285,_286,_287,_288){this.connectorNode.style.top="";var _289=_287.h,_28a=_287.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_285+"-"+_286];this.domNode.style.width="auto";var size=_272.position(this.domNode);if(has("ie")||has("trident")){size.w+=2;}var _28b=Math.min((Math.max(_28a,1)),size.w);_272.setMarginBox(this.domNode,{w:_28b});if(_286.charAt(0)=="B"&&_285.charAt(0)=="B"){var bb=_272.position(node);var _28c=this.connectorNode.offsetHeight;if(bb.h>_289){var _28d=_289-((_288.h+_28c)>>1);this.connectorNode.style.top=_28d+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_288.h/2-_28c/2,0),bb.h-_28c)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_28a);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_28e){if(this._onDeck&&this._onDeck[1]==_28e){this._onDeck=null;}else{if(this.aroundNode===_28e){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}this.onMouseEnter=this.onMouseLeave=noop;},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_27c.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_26f.forEach(node.children,function(_28f){this._setAutoTextDir(_28f);},this);},_setTextDirAttr:function(_290){this._set("textDir",_290);if(_290=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_27b.showTooltip=function(_291,_292,_293,rtl,_294,_295,_296){if(_293){_293=_26f.map(_293,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_283._masterTT){_27b._masterTT=_283._masterTT=new _27c();}return _283._masterTT.show(_291,_292,_293,rtl,_294,_295,_296);};_27b.hideTooltip=function(_297){return _283._masterTT&&_283._masterTT.hide(_297);};var _298="DORMANT",_299="SHOW TIMER",_29a="SHOWING",_29b="HIDE TIMER";function noop(){};var _283=_270("dijit.Tooltip",_277,{label:"",showDelay:400,hideDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_29c){_26f.forEach(this._connections||[],function(_29d){_26f.forEach(_29d,function(_29e){_29e.remove();});},this);this._connectIds=_26f.filter(lang.isArrayLike(_29c)?_29c:(_29c?[_29c]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_26f.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_29f=this.selector,_2a0=_29f?function(_2a1){return on.selector(_29f,_2a1);}:function(_2a2){return _2a2;},self=this;return [on(node,_2a0(_274.enter),function(){self._onHover(this);}),on(node,_2a0("focusin"),function(){self._onHover(this);}),on(node,_2a0(_274.leave),lang.hitch(self,"_onUnHover")),on(node,_2a0("focusout"),lang.hitch(self,"set","state",_298))];},this);this._set("connectId",_29c);},addTarget:function(node){var id=node.id||node;if(_26f.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_26f.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_271.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_26f.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},state:_298,_setStateAttr:function(val){if(this.state==val||(val==_299&&this.state==_29a)||(val==_29b&&this.state==_298)){return;}if(this._hideTimer){this._hideTimer.remove();delete this._hideTimer;}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}switch(val){case _298:if(this._connectNode){_283.hide(this._connectNode);delete this._connectNode;this.onHide();}break;case _299:if(this.state!=_29a){this._showTimer=this.defer(function(){this.set("state",_29a);},this.showDelay);}break;case _29a:var _2a3=this.getContent(this._connectNode);if(!_2a3){this.set("state",_298);return;}_283.show(_2a3,this._connectNode,this.position,!this.isLeftToRight(),this.textDir,lang.hitch(this,"set","state",_29a),lang.hitch(this,"set","state",_29b));this.onShow(this._connectNode,this.position);break;case _29b:this._hideTimer=this.defer(function(){this.set("state",_298);},this.hideDelay);break;}this._set("state",val);},_onHover:function(_2a4){if(this._connectNode&&_2a4!=this._connectNode){this.set("state",_298);}this._connectNode=_2a4;this.set("state",_299);},_onUnHover:function(_2a5){this.set("state",_29b);},open:function(_2a6){this.set("state",_298);this._connectNode=_2a6;this.set("state",_29a);},close:function(){this.set("state",_298);},onShow:function(){},onHide:function(){},destroy:function(){this.set("state",_298);_26f.forEach(this._connections||[],function(_2a7){_26f.forEach(_2a7,function(_2a8){_2a8.remove();});},this);this.inherited(arguments);}});_283._MasterTooltip=_27c;_283.show=_27b.showTooltip;_283.hide=_27b.hideTooltip;_283.defaultPosition=["after-centered","before-centered"];return _283;});},"dijit/_base/manager":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_2a9,_2aa,lang,_2ab,_2ac){var _2ad={};_2a9.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_2ad[name]=_2ab[name];});lang.mixin(_2ad,{defaultDuration:_2aa["defaultDuration"]||200});lang.mixin(_2ac,_2ad);return _2ac;});},"dijit/registry":function(){define(["dojo/_base/array","dojo/_base/window","./main"],function(_2ae,win,_2af){var _2b0={},hash={};var _2b1={length:0,add:function(_2b2){if(hash[_2b2.id]){throw new Error("Tried to register widget with id=="+_2b2.id+" but that id is already registered");}hash[_2b2.id]=_2b2;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_2b3){var id;do{id=_2b3+"_"+(_2b3 in _2b0?++_2b0[_2b3]:_2b0[_2b3]=0);}while(hash[id]);return _2af._scopeName=="dijit"?id:_2af._scopeName+"_"+id;},findWidgets:function(root,_2b4){var _2b5=[];function _2b6(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _2b7=node.getAttribute("widgetId");if(_2b7){var _2b8=hash[_2b7];if(_2b8){_2b5.push(_2b8);}}else{if(node!==_2b4){_2b6(node);}}}}};_2b6(root);return _2b5;},_destroyAll:function(){_2af._curFocus=null;_2af._prevFocus=null;_2af._activeStack=[];_2ae.forEach(_2b1.findWidgets(win.body()),function(_2b9){if(!_2b9._destroyed){if(_2b9.destroyRecursive){_2b9.destroyRecursive();}else{if(_2b9.destroy){_2b9.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.nodeType==1&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};_2af.registry=_2b1;return _2b1;});},"dijit/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dijit/place":function(){define(["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","./Viewport","./main"],function(_2ba,_2bb,_2bc,_2bd,win,_2be,_2bf){function _2c0(node,_2c1,_2c2,_2c3){var view=_2be.getEffectiveBox(node.ownerDocument);if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body(node.ownerDocument).appendChild(node);}var best=null;_2ba.some(_2c1,function(_2c4){var _2c5=_2c4.corner;var pos=_2c4.pos;var _2c6=0;var _2c7={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_2c5.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_2c5.charAt(0)]};var s=node.style;s.left=s.right="auto";if(_2c2){var res=_2c2(node,_2c4.aroundCorner,_2c5,_2c7,_2c3);_2c6=typeof res=="undefined"?0:res;}var _2c8=node.style;var _2c9=_2c8.display;var _2ca=_2c8.visibility;if(_2c8.display=="none"){_2c8.visibility="hidden";_2c8.display="";}var bb=_2bb.position(node);_2c8.display=_2c9;_2c8.visibility=_2ca;var _2cb={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_2c5.charAt(1)],_2cc={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_2c5.charAt(0)],_2cd=Math.max(view.l,_2cb),_2ce=Math.max(view.t,_2cc),endX=Math.min(view.l+view.w,_2cb+bb.w),endY=Math.min(view.t+view.h,_2cc+bb.h),_2cf=endX-_2cd,_2d0=endY-_2ce;_2c6+=(bb.w-_2cf)+(bb.h-_2d0);if(best==null||_2c6<best.overflow){best={corner:_2c5,aroundCorner:_2c4.aroundCorner,x:_2cd,y:_2ce,w:_2cf,h:_2d0,overflow:_2c6,spaceAvailable:_2c7};}return !_2c6;});if(best.overflow&&_2c2){_2c2(node,best.aroundCorner,best.corner,best.spaceAvailable,_2c3);}var top=best.y,side=best.x,body=win.body(node.ownerDocument);if(/relative|absolute/.test(_2bc.get(body,"position"))){top-=_2bc.get(body,"marginTop");side-=_2bc.get(body,"marginLeft");}var s=node.style;s.top=top+"px";s.left=side+"px";s.right="auto";return best;};var _2d1={"TL":"BR","TR":"BL","BL":"TR","BR":"TL"};var _2d2={at:function(node,pos,_2d3,_2d4,_2d5){var _2d6=_2ba.map(_2d3,function(_2d7){var c={corner:_2d7,aroundCorner:_2d1[_2d7],pos:{x:pos.x,y:pos.y}};if(_2d4){c.pos.x+=_2d7.charAt(1)=="L"?_2d4.x:-_2d4.x;c.pos.y+=_2d7.charAt(0)=="T"?_2d4.y:-_2d4.y;}return c;});return _2c0(node,_2d6,_2d5);},around:function(node,_2d8,_2d9,_2da,_2db){var _2dc;if(typeof _2d8=="string"||"offsetWidth" in _2d8||"ownerSVGElement" in _2d8){_2dc=_2bb.position(_2d8,true);if(/^(above|below)/.test(_2d9[0])){var _2dd=_2bb.getBorderExtents(_2d8),_2de=_2d8.firstChild?_2bb.getBorderExtents(_2d8.firstChild):{t:0,l:0,b:0,r:0},_2df=_2bb.getBorderExtents(node),_2e0=node.firstChild?_2bb.getBorderExtents(node.firstChild):{t:0,l:0,b:0,r:0};_2dc.y+=Math.min(_2dd.t+_2de.t,_2df.t+_2e0.t);_2dc.h-=Math.min(_2dd.t+_2de.t,_2df.t+_2e0.t)+Math.min(_2dd.b+_2de.b,_2df.b+_2e0.b);}}else{_2dc=_2d8;}if(_2d8.parentNode){var _2e1=_2bc.getComputedStyle(_2d8).position=="absolute";var _2e2=_2d8.parentNode;while(_2e2&&_2e2.nodeType==1&&_2e2.nodeName!="BODY"){var _2e3=_2bb.position(_2e2,true),pcs=_2bc.getComputedStyle(_2e2);if(/relative|absolute/.test(pcs.position)){_2e1=false;}if(!_2e1&&/hidden|auto|scroll/.test(pcs.overflow)){var _2e4=Math.min(_2dc.y+_2dc.h,_2e3.y+_2e3.h);var _2e5=Math.min(_2dc.x+_2dc.w,_2e3.x+_2e3.w);_2dc.x=Math.max(_2dc.x,_2e3.x);_2dc.y=Math.max(_2dc.y,_2e3.y);_2dc.h=_2e4-_2dc.y;_2dc.w=_2e5-_2dc.x;}if(pcs.position=="absolute"){_2e1=true;}_2e2=_2e2.parentNode;}}var x=_2dc.x,y=_2dc.y,_2e6="w" in _2dc?_2dc.w:(_2dc.w=_2dc.width),_2e7="h" in _2dc?_2dc.h:(_2bd.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_2dc.height+", width:"+_2e6+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_2dc.height+", w:"+_2e6+" }","","2.0"),_2dc.h=_2dc.height);var _2e8=[];function push(_2e9,_2ea){_2e8.push({aroundCorner:_2e9,corner:_2ea,pos:{x:{"L":x,"R":x+_2e6,"M":x+(_2e6>>1)}[_2e9.charAt(1)],y:{"T":y,"B":y+_2e7,"M":y+(_2e7>>1)}[_2e9.charAt(0)]}});};_2ba.forEach(_2d9,function(pos){var ltr=_2da;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":push(ltr?"TL":"TR",ltr?"TR":"TL");push(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _2eb=_2c0(node,_2e8,_2db,{w:_2e6,h:_2e7});_2eb.aroundNodePos=_2dc;return _2eb;}};return _2bf.place=_2d2;});},"dijit/Viewport":function(){define(["dojo/Evented","dojo/on","dojo/domReady","dojo/sniff","dojo/window"],function(_2ec,on,_2ed,has,_2ee){var _2ef=new _2ec();var _2f0;_2ed(function(){var _2f1=_2ee.getBox();_2ef._rlh=on(window,"resize",function(){var _2f2=_2ee.getBox();if(_2f1.h==_2f2.h&&_2f1.w==_2f2.w){return;}_2f1=_2f2;_2ef.emit("resize");});if(has("ie")==8){var _2f3=screen.deviceXDPI;setInterval(function(){if(screen.deviceXDPI!=_2f3){_2f3=screen.deviceXDPI;_2ef.emit("resize");}},500);}if(has("ios")){on(document,"focusin",function(evt){_2f0=evt.target;});on(document,"focusout",function(evt){_2f0=null;});}});_2ef.getEffectiveBox=function(doc){var box=_2ee.getBox(doc);var tag=_2f0&&_2f0.tagName&&_2f0.tagName.toLowerCase();if(has("ios")&&_2f0&&!_2f0.readOnly&&(tag=="textarea"||(tag=="input"&&/^(color|email|number|password|search|tel|text|url)$/.test(_2f0.type)))){box.h*=(orientation==0||orientation==180?0.66:0.4);var rect=_2f0.getBoundingClientRect();box.h=Math.max(box.h,rect.top+rect.height);}return box;};return _2ef;});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(lang,has,_2f4,dom,geom,_2f5,_2f6){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var body=_2f4.body(doc),_2f7=_2f6.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},body,"last"),div=_2f6.create("div",{style:{overflow:"hidden",direction:"ltr"}},_2f7,"last"),ret=geom.position(div).x!=0;_2f7.removeChild(div);body.removeChild(_2f7);return ret;});has.add("position-fixed-support",function(win,doc){var body=_2f4.body(doc),_2f8=_2f6.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},body,"last"),_2f9=_2f6.create("span",{style:{position:"fixed",left:"0",top:"0"}},_2f8,"last"),ret=geom.position(_2f9).x!=geom.position(_2f8).x;_2f8.removeChild(_2f9);body.removeChild(_2f8);return ret;});var _2fa={getBox:function(doc){doc=doc||_2f4.doc;var _2fb=(doc.compatMode=="BackCompat")?_2f4.body(doc):doc.documentElement,_2fc=geom.docScroll(doc),w,h;if(has("touch")){var _2fd=_2fa.get(doc);w=_2fd.innerWidth||_2fb.clientWidth;h=_2fd.innerHeight||_2fb.clientHeight;}else{w=_2fb.clientWidth;h=_2fb.clientHeight;}return {l:_2fc.x,t:_2fc.y,w:w,h:h};},get:function(doc){if(has("ie")&&_2fa!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_2f4.doc,body=_2f4.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie")||has("trident"),isWK=has("webkit");if(node==body||node==html){return;}if(!(has("mozilla")||isIE||isWK||has("opera")||has("trident")||has("edge"))&&("scrollIntoView" in node)){node.scrollIntoView(false);return;}var _2fe=doc.compatMode=="BackCompat",_2ff=Math.min(body.clientWidth||html.clientWidth,html.clientWidth||body.clientWidth),_300=Math.min(body.clientHeight||html.clientHeight,html.clientHeight||body.clientHeight),_301=(isWK||_2fe)?body:html,_302=pos||geom.position(node),el=node.parentNode,_303=function(el){return (isIE<=6||(isIE==7&&_2fe))?false:(has("position-fixed-support")&&(_2f5.get(el,"position").toLowerCase()=="fixed"));},self=this,_304=function(el,x,y){if(el.tagName=="BODY"||el.tagName=="HTML"){self.get(el.ownerDocument).scrollBy(x,y);}else{x&&(el.scrollLeft+=x);y&&(el.scrollTop+=y);}};if(_303(node)){return;}while(el){if(el==body){el=_301;}var _305=geom.position(el),_306=_303(el),rtl=_2f5.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_301){_305.w=_2ff;_305.h=_300;if(_301==html&&(isIE||has("trident"))&&rtl){_305.x+=_301.offsetWidth-_305.w;}_305.x=0;_305.y=0;}else{var pb=geom.getPadBorderExtents(el);_305.w-=pb.w;_305.h-=pb.h;_305.x+=pb.l;_305.y+=pb.t;var _307=el.clientWidth,_308=_305.w-_307;if(_307>0&&_308>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_305.x+=_308;}_305.w=_307;}_307=el.clientHeight;_308=_305.h-_307;if(_307>0&&_308>0){_305.h=_307;}}if(_306){if(_305.y<0){_305.h+=_305.y;_305.y=0;}if(_305.x<0){_305.w+=_305.x;_305.x=0;}if(_305.y+_305.h>_300){_305.h=_300-_305.y;}if(_305.x+_305.w>_2ff){_305.w=_2ff-_305.x;}}var l=_302.x-_305.x,t=_302.y-_305.y,r=l+_302.w-_305.w,bot=t+_302.h-_305.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_301||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_2fe)||has("trident")>=5)){s=-s;}old=el.scrollLeft;_304(el,s,0);s=el.scrollLeft-old;_302.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_301||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;_304(el,0,s);s=el.scrollTop-old;_302.y-=s;}el=(el!=_301)&&!_306&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_2fa);return _2fa;});},"dijit/_Widget":function(){define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_309,_30a,_30b,_30c,has,_30d,lang,_30e,_30f,_310,_311,_312,_313){function _314(){};function _315(_316){return function(obj,_317,_318,_319){if(obj&&typeof _317=="string"&&obj[_317]==_314){return obj.on(_317.substring(2).toLowerCase(),lang.hitch(_318,_319));}return _316.apply(_30b,arguments);};};_309.around(_30b,"connect",_315);if(_30d.connect){_309.around(_30d,"connect",_315);}var _31a=_30c("dijit._Widget",[_311,_312,_313],{onClick:_314,onDblClick:_314,onKeyDown:_314,onKeyPress:_314,onKeyUp:_314,onMouseDown:_314,onMouseMove:_314,onMouseOut:_314,onMouseOver:_314,onMouseLeave:_314,onMouseEnter:_314,onMouseUp:_314,constructor:function(_31b){this._toConnect={};for(var name in _31b){if(this[name]===_314){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_31b[name];delete _31b[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_314){return _30b.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_31c){_30d.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_31c);},attr:function(name,_31d){var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_30d.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_30e("[widgetId]",this.containerNode).map(_310.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_30f(0,function(){var _31e=["dijit/_base"];require(_31e);});}return _31a;});},"dijit/_WidgetBase":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","dojo/has!dojo-bidi?./_BidiMixin","./registry"],function(_31f,_320,_321,_322,_323,_324,dom,_325,_326,_327,_328,_329,has,_32a,lang,on,_32b,_32c,_32d,win,_32e,_32f,_330){has.add("dijit-legacy-requires",!_32a.isAsync);has.add("dojo-bidi",false);if(has("dijit-legacy-requires")){_32b(0,function(){var _331=["dijit/_base/manager"];_31f(_331);});}var _332={};function _333(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _334(attr){return function(val){_325[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};function _335(a,b){return a===b||(a!==a&&b!==b);};var _336=_324("dijit._WidgetBase",[_32c,_32e],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_334("lang"),dir:"",_setDirAttr:_334("dir"),"class":"",_setClassAttr:{node:"domNode",type:"class"},_setTypeAttr:null,style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_322.blankGif||_31f.toUrl("dojo/resources/blank.gif"),textDir:"",_introspect:function(){var ctor=this.constructor;if(!ctor._setterAttrs){var _337=ctor.prototype,_338=ctor._setterAttrs=[],_339=(ctor._onMap={});for(var name in _337.attributeMap){_338.push(name);}for(name in _337){if(/^on/.test(name)){_339[name.substring(2).toLowerCase()]=name;}if(/^_set[A-Z](.*)Attr$/.test(name)){name=name.charAt(4).toLowerCase()+name.substr(5,name.length-9);if(!_337.attributeMap||!(name in _337.attributeMap)){_338.push(name);}}}}},postscript:function(_33a,_33b){this.create(_33a,_33b);},create:function(_33c,_33d){this._introspect();this.srcNodeRef=dom.byId(_33d);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&this.srcNodeRef.id&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_33c){this.params=_33c;lang.mixin(this,_33c);}this.postMixInProperties();if(!this.id){this.id=_330.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:document);this.ownerDocumentBody=win.body(this.ownerDocument);_330.add(this);this.buildRendering();var _33e;if(this.domNode){this._applyAttributes();var _33f=this.srcNodeRef;if(_33f&&_33f.parentNode&&this.domNode!==_33f){_33f.parentNode.replaceChild(this.domNode,_33f);_33e=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_33e){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var _340={};for(var key in this.params||{}){_340[key]=this._get(key);}_320.forEach(this.constructor._setterAttrs,function(key){if(!(key in _340)){var val=this._get(key);if(val){this.set(key,val);}}},this);for(key in _340){this.set(key,_340[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _341=this.baseClass.split(" ");if(!this.isLeftToRight()){_341=_341.concat(_320.map(_341,function(name){return name+"Rtl";}));}_326.add(this.domNode,_341);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_320.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_342){this._beingDestroyed=true;this.destroyDescendants(_342);this.destroy(_342);},destroy:function(_343){this._beingDestroyed=true;this.uninitialize();function _344(w){if(w.destroyRecursive){w.destroyRecursive(_343);}else{if(w.destroy){w.destroy(_343);}}};_320.forEach(this._connects,lang.hitch(this,"disconnect"));_320.forEach(this._supportingWidgets,_344);if(this.domNode){_320.forEach(_330.findWidgets(this.domNode,this.containerNode),_344);}this.destroyRendering(_343);_330.remove(this.id);this._destroyed=true;},destroyRendering:function(_345){if(this.bgIframe){this.bgIframe.destroy(_345);delete this.bgIframe;}if(this.domNode){if(_345){_325.remove(this.domNode,"widgetId");}else{_327.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_345){_327.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_346){_320.forEach(this.getChildren(),function(_347){if(_347.destroyRecursive){_347.destroyRecursive(_346);}});},uninitialize:function(){return false;},_setStyleAttr:function(_348){var _349=this.domNode;if(lang.isObject(_348)){_329.set(_349,_348);}else{if(_349.style.cssText){_349.style.cssText+="; "+_348;}else{_349.style.cssText=_348;}}this._set("style",_348);},_attrToDom:function(attr,_34a,_34b){_34b=arguments.length>=3?_34b:this.attributeMap[attr];_320.forEach(lang.isArray(_34b)?_34b:[_34b],function(_34c){var _34d=this[_34c.node||_34c||"domNode"];var type=_34c.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_34a)){_34a=lang.hitch(this,_34a);}var _34e=_34c.attribute?_34c.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_34d.tagName){_325.set(_34d,_34e,_34a);}else{_34d.set(_34e,_34a);}break;case "innerText":_34d.innerHTML="";_34d.appendChild(this.ownerDocument.createTextNode(_34a));break;case "textContent":_34d.textContent=_34a;break;case "innerHTML":_34d.innerHTML=_34a;break;case "class":_326.replace(_34d,_34a,this[attr]);break;case "toggleClass":_326.toggle(_34d,_34c.className||attr,_34a);break;}},this);},get:function(name){var _34f=this._getAttrNames(name);return this[_34f.g]?this[_34f.g]():this._get(name);},set:function(name,_350){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _351=this._getAttrNames(name),_352=this[_351.s];if(lang.isFunction(_352)){var _353=_352.apply(this,Array.prototype.slice.call(arguments,1));}else{var _354=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_354]&&this[_354].tagName,_355=tag&&(_332[tag]||(_332[tag]=_333(this[_354]))),map=name in this.attributeMap?this.attributeMap[name]:_351.s in this?this[_351.s]:((_355&&_351.l in _355&&typeof _350!="function")||/^aria-|^data-|^role$/.test(name))?_354:null;if(map!=null){this._attrToDom(name,_350,map);}this._set(name,_350);}return _353||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_356){var _357=this[name];this[name]=_356;if(this._created&&!_335(_357,_356)){if(this._watchCallbacks){this._watchCallbacks(name,_357,_356);}this.emit("attrmodified-"+name,{detail:{prevValue:_357,newValue:_356}});}},_get:function(name){return this[name];},emit:function(type,_358,_359){_358=_358||{};if(_358.bubbles===undefined){_358.bubbles=true;}if(_358.cancelable===undefined){_358.cancelable=true;}if(!_358.detail){_358.detail={};}_358.detail.widget=this;var ret,_35a=this["on"+type];if(_35a){ret=_35a.apply(this,_359?_359:[_358]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_358);}return ret;},on:function(type,func){var _35b=this._onMap(type);if(_35b){return _321.after(this,_35b,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_330.findWidgets(this.containerNode):[];},getParent:function(){return _330.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_35c,_35d){return this.own(_323.connect(obj,_35c,this,_35d))[0];},disconnect:function(_35e){_35e.remove();},subscribe:function(t,_35f){return this.own(_32d.subscribe(t,lang.hitch(this,_35f)))[0];},unsubscribe:function(_360){_360.remove();},isLeftToRight:function(){return this.dir?(this.dir.toLowerCase()=="ltr"):_328.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_329.get(this.domNode,"display")!="none");},placeAt:function(_361,_362){var _363=!_361.tagName&&_330.byId(_361);if(_363&&_363.addChild&&(!_362||typeof _362==="number")){_363.addChild(this,_362);}else{var ref=_363&&("domNode" in _363)?(_363.containerNode&&!/after|before|replace/.test(_362||"")?_363.containerNode:_363.domNode):dom.byId(_361,this.ownerDocument);_327.place(this.domNode,ref,_362);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},defer:function(fcn,_364){var _365=setTimeout(lang.hitch(this,function(){if(!_365){return;}_365=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_364||0);return {remove:function(){if(_365){clearTimeout(_365);_365=null;}return null;}};}});if(has("dojo-bidi")){_336.extend(_32f);}return _336;});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_366,lang,_367,when){return _366("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_368){if(_368){this.set(_368);}},_get:function(name,_369){return typeof this[_369.g]==="function"?this[_369.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_36a){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _36b=this._getAttrNames(name),_36c=this._get(name,_36b),_36d=this[_36b.s],_36e;if(typeof _36d==="function"){_36e=_36d.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_36a;}if(this._watchCallbacks){var self=this;when(_36e,function(){self._watchCallbacks(name,_36c,_36a);});}return this;},_changeAttrValue:function(name,_36f){var _370=this.get(name);this[name]=_36f;if(this._watchCallbacks){this._watchCallbacks(name,_370,_36f);}return this;},watch:function(name,_371){var _372=this._watchCallbacks;if(!_372){var self=this;_372=this._watchCallbacks=function(name,_373,_374,_375){var _376=function(_377){if(_377){_377=_377.slice();for(var i=0,l=_377.length;i<l;i++){_377[i].call(self,name,_373,_374);}}};_376(_372["_"+name]);if(!_375){_376(_372["*"]);}};}if(!_371&&typeof name==="function"){_371=name;name="*";}else{name="_"+name;}var _378=_372[name];if(typeof _378!=="object"){_378=_372[name]=[];}_378.push(_371);var _379={};_379.unwatch=_379.remove=function(){var _37a=_367.indexOf(_378,_371);if(_37a>-1){_378.splice(_37a,1);}};return _379;}});});},"dijit/Destroyable":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_37b,_37c,_37d){return _37d("dijit.Destroyable",null,{destroy:function(_37e){this._destroyed=true;},own:function(){var _37f=["destroyRecursive","destroy","remove"];_37b.forEach(arguments,function(_380){var _381;var odh=_37c.before(this,"destroy",function(_382){_380[_381](_382);});var hdhs=[];function _383(){odh.remove();_37b.forEach(hdhs,function(hdh){hdh.remove();});};if(_380.then){_381="cancel";_380.then(_383,_383);}else{_37b.forEach(_37f,function(_384){if(typeof _380[_384]==="function"){if(!_381){_381=_384;}hdhs.push(_37c.after(_380,_384,_383,true));}});}},this);return arguments;}});});},"dijit/_OnDijitClickMixin":function(){define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","./a11yclick"],function(on,_385,keys,_386,has,_387){var ret=_386("dijit._OnDijitClickMixin",null,{connect:function(obj,_388,_389){return this.inherited(arguments,[obj,_388=="ondijitclick"?_387:_388,_389]);}});ret.a11yclick=_387;return ret;});},"dijit/a11yclick":function(){define(["dojo/keys","dojo/mouse","dojo/on","dojo/touch"],function(keys,_38a,on,_38b){function _38c(e){if((e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!/input|button|textarea/i.test(e.target.nodeName)){for(var node=e.target;node;node=node.parentNode){if(node.dojoClick){return true;}}}};var _38d;on(document,"keydown",function(e){if(_38c(e)){_38d=e.target;e.preventDefault();}else{_38d=null;}});on(document,"keyup",function(e){if(_38c(e)&&e.target==_38d){_38d=null;on.emit(e.target,"click",{cancelable:true,bubbles:true,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,metaKey:e.metaKey,altKey:e.altKey,_origType:e.type});}});var _38e=function(node,_38f){node.dojoClick=true;return on(node,"click",_38f);};_38e.click=_38e;_38e.press=function(node,_390){var _391=on(node,_38b.press,function(evt){if(evt.type=="mousedown"&&!_38a.isLeft(evt)){return;}_390(evt);}),_392=on(node,"keydown",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_390(evt);}});return {remove:function(){_391.remove();_392.remove();}};};_38e.release=function(node,_393){var _394=on(node,_38b.release,function(evt){if(evt.type=="mouseup"&&!_38a.isLeft(evt)){return;}_393(evt);}),_395=on(node,"keyup",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_393(evt);}});return {remove:function(){_394.remove();_395.remove();}};};_38e.move=_38b.move;return _38e;});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./dom-class","./_base/lang","./on","./has","./mouse","./domReady","./_base/window"],function(dojo,_396,dom,_397,lang,on,has,_398,_399,win){var ios4=has("ios")<5;var _39a=has("pointer-events")||has("MSPointer"),_39b=(function(){var _39c={};for(var type in {down:1,move:1,up:1,cancel:1,over:1,out:1}){_39c[type]=has("MSPointer")?"MSPointer"+type.charAt(0).toUpperCase()+type.slice(1):"pointer"+type;}return _39c;})();var _39d=has("touch-events");var _39e,_39f,_3a0=false,_3a1,_3a2,_3a3,_3a4,_3a5,_3a6;var _3a7;function _3a8(_3a9,_3aa,_3ab){if(_39a&&_3ab){return function(node,_3ac){return on(node,_3ab,_3ac);};}else{if(_39d){return function(node,_3ad){var _3ae=on(node,_3aa,function(evt){_3ad.call(this,evt);_3a7=(new Date()).getTime();}),_3af=on(node,_3a9,function(evt){if(!_3a7||(new Date()).getTime()>_3a7+1000){_3ad.call(this,evt);}});return {remove:function(){_3ae.remove();_3af.remove();}};};}else{return function(node,_3b0){return on(node,_3a9,_3b0);};}}};function _3b1(node){do{if(node.dojoClick!==undefined){return node;}}while(node=node.parentNode);};function _3b2(e,_3b3,_3b4){if(_398.isRight(e)){return;}var _3b5=_3b1(e.target);_39f=!e.target.disabled&&_3b5&&_3b5.dojoClick;if(_39f){_3a0=(_39f=="useTarget");_3a1=(_3a0?_3b5:e.target);if(_3a0){e.preventDefault();}_3a2=e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX;_3a3=e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY;_3a4=(typeof _39f=="object"?_39f.x:(typeof _39f=="number"?_39f:0))||4;_3a5=(typeof _39f=="object"?_39f.y:(typeof _39f=="number"?_39f:0))||4;if(!_39e){_39e=true;var _3b6=function _3b6(e){if(_3a0){_39f=dom.isDescendant(win.doc.elementFromPoint((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX),(e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)),_3a1);}else{_39f=_39f&&(e.changedTouches?e.changedTouches[0].target:e.target)==_3a1&&Math.abs((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX)-_3a2)<=_3a4&&Math.abs((e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)-_3a3)<=_3a5;}};win.doc.addEventListener(_3b3,function(e){if(_398.isRight(e)){return;}_3b6(e);if(_3a0){e.preventDefault();}},true);win.doc.addEventListener(_3b4,function(e){if(_398.isRight(e)){return;}_3b6(e);if(_39f){_3a6=(new Date()).getTime();var _3b7=(_3a0?_3a1:e.target);if(_3b7.tagName==="LABEL"){_3b7=dom.byId(_3b7.getAttribute("for"))||_3b7;}var src=(e.changedTouches)?e.changedTouches[0]:e;var _3b8=function _3b8(type){var evt=document.createEvent("MouseEvents");evt._dojo_click=true;evt.initMouseEvent(type,true,true,e.view,e.detail,src.screenX,src.screenY,src.clientX,src.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,0,null);return evt;};var _3b9=_3b8("mousedown");var _3ba=_3b8("mouseup");var _3bb=_3b8("click");setTimeout(function(){on.emit(_3b7,"mousedown",_3b9);on.emit(_3b7,"mouseup",_3ba);on.emit(_3b7,"click",_3bb);_3a6=(new Date()).getTime();},0);}},true);var _3bc=function _3bc(type){win.doc.addEventListener(type,function(e){var _3bd=e.target;if(_39f&&!e._dojo_click&&(new Date()).getTime()<=_3a6+1000&&!(_3bd.tagName=="INPUT"&&_397.contains(_3bd,"dijitOffScreen"))){e.stopPropagation();e.stopImmediatePropagation&&e.stopImmediatePropagation();if(type=="click"&&(_3bd.tagName!="INPUT"||(_3bd.type=="radio"&&(_397.contains(_3bd,"dijitCheckBoxInput")||_397.contains(_3bd,"mblRadioButton")))||(_3bd.type=="checkbox"&&(_397.contains(_3bd,"dijitCheckBoxInput")||_397.contains(_3bd,"mblCheckBox"))))&&_3bd.tagName!="TEXTAREA"&&_3bd.tagName!="AUDIO"&&_3bd.tagName!="VIDEO"){e.preventDefault();}}},true);};_3bc("click");_3bc("mousedown");_3bc("mouseup");}}};var _3be;if(has("touch")){if(_39a){_399(function(){win.doc.addEventListener(_39b.down,function(evt){_3b2(evt,_39b.move,_39b.up);},true);});}else{_399(function(){_3be=win.body();win.doc.addEventListener("touchstart",function(evt){_3a7=(new Date()).getTime();var _3bf=_3be;_3be=evt.target;on.emit(_3bf,"dojotouchout",{relatedTarget:_3be,bubbles:true});on.emit(_3be,"dojotouchover",{relatedTarget:_3bf,bubbles:true});_3b2(evt,"touchmove","touchend");},true);function _3c0(evt){var _3c1=lang.delegate(evt,{bubbles:true});if(has("ios")>=6){_3c1.touches=evt.touches;_3c1.altKey=evt.altKey;_3c1.changedTouches=evt.changedTouches;_3c1.ctrlKey=evt.ctrlKey;_3c1.metaKey=evt.metaKey;_3c1.shiftKey=evt.shiftKey;_3c1.targetTouches=evt.targetTouches;}return _3c1;};on(win.doc,"touchmove",function(evt){_3a7=(new Date()).getTime();var _3c2=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_3c2){if(_3be!==_3c2){on.emit(_3be,"dojotouchout",{relatedTarget:_3c2,bubbles:true});on.emit(_3c2,"dojotouchover",{relatedTarget:_3be,bubbles:true});_3be=_3c2;}if(!on.emit(_3c2,"dojotouchmove",_3c0(evt))){evt.preventDefault();}}});on(win.doc,"touchend",function(evt){_3a7=(new Date()).getTime();var node=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset))||win.body();on.emit(node,"dojotouchend",_3c0(evt));});});}}var _3c3={press:_3a8("mousedown","touchstart",_39b.down),move:_3a8("mousemove","dojotouchmove",_39b.move),release:_3a8("mouseup","dojotouchend",_39b.up),cancel:_3a8(_398.leave,"touchcancel",_39a?_39b.cancel:null),over:_3a8("mouseover","dojotouchover",_39b.over),out:_3a8("mouseout","dojotouchout",_39b.out),enter:_398._eventHandler(_3a8("mouseover","dojotouchover",_39b.over)),leave:_398._eventHandler(_3a8("mouseout","dojotouchout",_39b.out))};1&&(dojo.touch=_3c3);return _3c3;});},"dijit/_FocusMixin":function(){define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_3c4,_3c5,_3c6,lang){lang.extend(_3c5,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _3c6("dijit._FocusMixin",null,{_focusManager:_3c4});});},"dijit/focus":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/domReady","dojo/sniff","dojo/Stateful","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_3c7,_3c8,dom,_3c9,_3ca,_3cb,_3cc,lang,on,_3cd,has,_3ce,win,_3cf,a11y,_3d0,_3d1){var _3d2;var _3d3;var _3d4=_3c8([_3ce,_3cc],{curNode:null,activeStack:[],constructor:function(){var _3d5=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_3c7.before(_3cb,"empty",_3d5);_3c7.before(_3cb,"destroy",_3d5);},registerIframe:function(_3d6){return this.registerWin(_3d6.contentWindow,_3d6);},registerWin:function(_3d7,_3d8){var _3d9=this,body=_3d7.document&&_3d7.document.body;if(body){var _3da=has("pointer-events")?"pointerdown":has("MSPointer")?"MSPointerDown":has("touch-events")?"mousedown, touchstart":"mousedown";var mdh=on(_3d7.document,_3da,function(evt){if(evt&&evt.target&&evt.target.parentNode==null){return;}_3d9._onTouchNode(_3d8||evt.target,"mouse");});var fih=on(body,"focusin",function(evt){if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isFocusable(evt.target)){_3d9._onFocusNode(_3d8||evt.target);}else{_3d9._onTouchNode(_3d8||evt.target);}});var foh=on(body,"focusout",function(evt){_3d9._onBlurNode(_3d8||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;body=null;}};}},_onBlurNode:function(node){var now=(new Date()).getTime();if(now<_3d2+100){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}if(now<_3d3+100){return;}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){_3d3=(new Date()).getTime();if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}if(_3ca.contains(node,"dijitPopup")){node=node.firstChild;}var _3db=[];try{while(node){var _3dc=_3c9.get(node,"dijitPopupParent");if(_3dc){node=_3d0.byId(_3dc).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_3cf.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_3dd=id&&_3d0.byId(id);if(_3dd&&!(by=="mouse"&&_3dd.get("disabled"))){_3db.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_3db,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}_3d2=(new Date()).getTime();if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_3de,by){var _3df=this.activeStack,_3e0=_3df.length-1,_3e1=_3de.length-1;if(_3de[_3e1]==_3df[_3e0]){return;}this.set("activeStack",_3de);var _3e2,i;for(i=_3e0;i>=0&&_3df[i]!=_3de[i];i--){_3e2=_3d0.byId(_3df[i]);if(_3e2){_3e2._hasBeenBlurred=true;_3e2.set("focused",false);if(_3e2._focusManager==this){_3e2._onBlur(by);}this.emit("widget-blur",_3e2,by);}}for(i++;i<=_3e1;i++){_3e2=_3d0.byId(_3de[i]);if(_3e2){_3e2.set("focused",true);if(_3e2._focusManager==this){_3e2._onFocus(by);}this.emit("widget-focus",_3e2,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _3e3=new _3d4();_3cd(function(){var _3e4=_3e3.registerWin(_3cf.get(document));if(has("ie")){on(window,"unload",function(){if(_3e4){_3e4.remove();_3e4=null;}});}});_3d1.focus=function(node){_3e3.focus(node);};for(var attr in _3e3){if(!/^_/.test(attr)){_3d1.focus[attr]=typeof _3e3[attr]=="function"?lang.hitch(_3e3,attr):_3e3[attr];}}_3e3.watch(function(attr,_3e5,_3e6){_3d1.focus[attr]=_3e6;});return _3e3;});},"dijit/a11y":function(){define(["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_3e7,dom,_3e8,_3e9,lang,has,_3ea){var _3eb;var a11y={_isElementShown:function(elem){var s=_3e9.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_3e8.get(elem,"type")!="hidden");},hasDefaultTabStop:function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _3e8.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _3ec=elem.contentDocument;if("designMode" in _3ec&&_3ec.designMode=="on"){return true;}body=_3ec.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}},effectiveTabIndex:function(elem){if(_3e8.get(elem,"disabled")){return _3eb;}else{if(_3e8.has(elem,"tabIndex")){return +_3e8.get(elem,"tabIndex");}else{return a11y.hasDefaultTabStop(elem)?0:_3eb;}}},isTabNavigable:function(elem){return a11y.effectiveTabIndex(elem)>=0;},isFocusable:function(elem){return a11y.effectiveTabIndex(elem)>=-1;},_getTabNavigable:function(root){var _3ed,last,_3ee,_3ef,_3f0,_3f1,_3f2={};function _3f3(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _3f4=a11y._isElementShown,_3f5=a11y.effectiveTabIndex;var _3f6=function(_3f7){for(var _3f8=_3f7.firstChild;_3f8;_3f8=_3f8.nextSibling){if(_3f8.nodeType!=1||(has("ie")<=9&&_3f8.scopeName!=="HTML")||!_3f4(_3f8)){continue;}var _3f9=_3f5(_3f8);if(_3f9>=0){if(_3f9==0){if(!_3ed){_3ed=_3f8;}last=_3f8;}else{if(_3f9>0){if(!_3ee||_3f9<_3ef){_3ef=_3f9;_3ee=_3f8;}if(!_3f0||_3f9>=_3f1){_3f1=_3f9;_3f0=_3f8;}}}var rn=_3f3(_3f8);if(_3e8.get(_3f8,"checked")&&rn){_3f2[rn]=_3f8;}}if(_3f8.nodeName.toUpperCase()!="SELECT"){_3f6(_3f8);}}};if(_3f4(root)){_3f6(root);}function rs(node){return _3f2[_3f3(node)]||node;};return {first:rs(_3ed),last:rs(last),lowest:rs(_3ee),highest:rs(_3f0)};},getFirstInTabbingOrder:function(root,doc){var _3fa=a11y._getTabNavigable(dom.byId(root,doc));return _3fa.lowest?_3fa.lowest:_3fa.first;},getLastInTabbingOrder:function(root,doc){var _3fb=a11y._getTabNavigable(dom.byId(root,doc));return _3fb.last?_3fb.last:_3fb.highest;}};1&&lang.mixin(_3ea,a11y);return a11y;});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./domReady","./sniff","./_base/window"],function(_3fc,lang,_3fd,has,_3fe){var html=_3fe.doc.documentElement,ie=has("ie"),_3ff=has("trident"),_400=has("opera"),maj=Math.floor,ff=has("ff"),_401=_3fc.boxModel.replace(/-/,""),_402={"dj_quirks":has("quirks"),"dj_opera":_400,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_edge":has("edge"),"dj_gecko":has("mozilla"),"dj_ios":has("ios"),"dj_android":has("android")};if(ie){_402["dj_ie"]=true;_402["dj_ie"+maj(ie)]=true;_402["dj_iequirks"]=has("quirks");}if(_3ff){_402["dj_trident"]=true;_402["dj_trident"+maj(_3ff)]=true;}if(ff){_402["dj_ff"+maj(ff)]=true;}_402["dj_"+_401]=true;var _403="";for(var clz in _402){if(_402[clz]){_403+=clz+" ";}}html.className=lang.trim(html.className+" "+_403);_3fd(function(){if(!_3fc.isBodyLtr()){var _404="dj_rtl dijitRtl "+_403.replace(/ /g,"-rtl ");html.className=lang.trim(html.className+" "+_404+"dj_rtl dijitRtl "+_403.replace(/ /g,"-rtl "));}});return has;});},"dijit/hccss":function(){define(["dojo/dom-class","dojo/hccss","dojo/domReady","dojo/_base/window"],function(_405,has,_406,win){_406(function(){if(has("highcontrast")){_405.add(win.body(),"dijit_a11y");}});return has;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./domReady","./_base/window"],function(_407,_408,_409,_40a,has,_40b,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");try{div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url(\""+(_408.blankGif||_407.toUrl("./resources/blank.gif"))+"\");";win.body().appendChild(div);var cs=_40a.getComputedStyle(div),_40c=cs.backgroundImage;return cs.borderTopColor==cs.borderRightColor||(_40c&&(_40c=="none"||_40c=="url(invalid-url:)"));}catch(e){console.warn("hccss: exception detecting high-contrast mode, document is likely hidden: "+e.toString());return false;}finally{if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}}});_40b(function(){if(has("highcontrast")){_409.add(win.body(),"dj_a11y");}});return has;});},"dijit/_TemplatedMixin":function(){define(["dojo/cache","dojo/_base/declare","dojo/dom-construct","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_AttachMixin"],function(_40d,_40e,_40f,lang,on,has,_410,_411){var _412=_40e("dijit._TemplatedMixin",_411,{templateString:null,templatePath:null,_skipNodeCache:false,searchContainerNode:true,_stringRepl:function(tmpl){var _413=this.declaredClass,_414=this;return _410.substitute(tmpl,this,function(_415,key){if(key.charAt(0)=="!"){_415=lang.getObject(key.substr(1),false,_414);}if(typeof _415=="undefined"){throw new Error(_413+" template:"+key);}if(_415==null){return "";}return key.charAt(0)=="!"?_415:this._escapeValue(""+_415);},this);},_escapeValue:function(val){return val.replace(/["'<>&]/g,function(val){return {"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;"}[val];});},buildRendering:function(){if(!this._rendered){if(!this.templateString){this.templateString=_40d(this.templatePath,{sanitize:true});}var _416=_412.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_416)){node=_40f.toDom(this._stringRepl(_416),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_416);}}else{node=_416.cloneNode(true);}this.domNode=node;}this.inherited(arguments);if(!this._rendered){this._fillContent(this.srcNodeRef);}this._rendered=true;},_fillContent:function(_417){var dest=this.containerNode;if(_417&&dest){while(_417.hasChildNodes()){dest.appendChild(_417.firstChild);}}}});_412._templateCache={};_412.getCachedTemplate=function(_418,_419,doc){var _41a=_412._templateCache;var key=_418;var _41b=_41a[key];if(_41b){try{if(!_41b.ownerDocument||_41b.ownerDocument==(doc||document)){return _41b;}}catch(e){}_40f.destroy(_41b);}_418=_410.trim(_418);if(_419||_418.match(/\$\{([^\}]+)\}/g)){return (_41a[key]=_418);}else{var node=_40f.toDom(_418,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_418);}return (_41a[key]=node);}};if(has("ie")){on(window,"unload",function(){var _41c=_412._templateCache;for(var key in _41c){var _41d=_41c[key];if(typeof _41d=="object"){_40f.destroy(_41d);}delete _41c[key];}});}return _412;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dojo/text":function(){define(["./_base/kernel","require","./has","./request"],function(dojo,_41e,has,_41f){var _420;if(1){_420=function(url,sync,load){_41f(url,{sync:!!sync,headers:{"X-Requested-With":null}}).then(load);};}else{if(_41e.getText){_420=_41e.getText;}else{console.error("dojo/text plugin failed to load because loader does not support getText");}}var _421={},_422=function(text){if(text){text=text.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");var _423=text.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_423){text=_423[1];}}else{text="";}return text;},_424={},_425={};dojo.cache=function(_426,url,_427){var key;if(typeof _426=="string"){if(/\//.test(_426)){key=_426;_427=url;}else{key=_41e.toUrl(_426.replace(/\./g,"/")+(url?("/"+url):""));}}else{key=_426+"";_427=url;}var val=(_427!=undefined&&typeof _427!="string")?_427.value:_427,_428=_427&&_427.sanitize;if(typeof val=="string"){_421[key]=val;return _428?_422(val):val;}else{if(val===null){delete _421[key];return null;}else{if(!(key in _421)){_420(key,true,function(text){_421[key]=text;});}return _428?_422(_421[key]):_421[key];}}};return {dynamic:true,normalize:function(id,_429){var _42a=id.split("!"),url=_42a[0];return (/^\./.test(url)?_429(url):url)+(_42a[1]?"!"+_42a[1]:"");},load:function(id,_42b,load){var _42c=id.split("!"),_42d=_42c.length>1,_42e=_42c[0],url=_42b.toUrl(_42c[0]),_42f="url:"+url,text=_424,_430=function(text){load(_42d?_422(text):text);};if(_42e in _421){text=_421[_42e];}else{if(_42b.cache&&_42f in _42b.cache){text=_42b.cache[_42f];}else{if(url in _421){text=_421[url];}}}if(text===_424){if(_425[url]){_425[url].push(_430);}else{var _431=_425[url]=[_430];_420(url,!_42b.async,function(text){_421[_42e]=_421[url]=text;for(var i=0;i<_431.length;){_431[i++](text);}delete _425[url];});}}else{_430(text);}}};});},"dojo/request":function(){define(["./request/default!"],function(_432){return _432;});},"dojo/request/default":function(){define(["exports","require","../has"],function(_433,_434,has){var _435=has("config-requestProvider"),_436;if(1||has("host-webworker")){_436="./xhr";}else{if(0){_436="./node";}}if(!_435){_435=_436;}_433.getPlatformDefaultId=function(){return _436;};_433.load=function(id,_437,_438,_439){_434([id=="platform"?_436:_435],function(_43a){_438(_43a);});};});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_43b,lang){var _43c=/[&<>'"\/]/g;var _43d={"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;","/":"&#x2F;"};var _43e={};lang.setObject("dojo.string",_43e);_43e.escape=function(str){if(!str){return "";}return str.replace(_43c,function(c){return _43d[c];});};_43e.codePointAt=String.prototype.codePointAt?function(str,_43f){return String.prototype.codePointAt.call(str,_43f);}:function(str,_440){if(str==null){throw new TypeError("codePointAt called on null or undefined");}var size;var _441;var _442;var _443;str=String(str);size=str.length;_443=_440?Number(_440):0;if(_443!=_443){_443=0;}if(_443<0||_443>=size){return undefined;}_441=str.charCodeAt(_443);if(_441>=55296&&_441<=56319&&size>_443+1){_442=str.charCodeAt(_443+1);if(_442>=56320&&_442<=57343){return (_441-55296)*1024+_442-56320+65536;}}return _441;};_43e.fromCodePoint=String.fromCodePoint||function(){var _444=[];var _445=0;var _446="";var _447;var _448;for(_448=0,len=arguments.length;_448!==len;++_448){_447=+arguments[_448];if(!(_447<1114111&&(_447>>>0)===_447)){throw RangeError("Invalid code point: "+_447);}if(_447<=65535){_445=_444.push(_447);}else{_447-=65536;_445=_444.push((_447>>10)+55296,(_447%1024)+56320);}if(_445>=16383){_446+=String.fromCharCode.apply(null,_444);_444.length=0;}}return _446+String.fromCharCode.apply(null,_444);};_43e.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_43e.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_43e.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_43e.substitute=function(_449,map,_44a,_44b){_44b=_44b||_43b.global;_44a=_44a?lang.hitch(_44b,_44a):function(v){return v;};return _449.replace(/\$\{([^\s\:\}]*)(?:\:([^\s\:\}]+))?\}/g,function(_44c,key,_44d){if(key==""){return "$";}var _44e=lang.getObject(key,false,map);if(_44d){_44e=lang.getObject(_44d,false,_44b).call(_44b,_44e,key);}var _44f=_44a(_44e,key);if(typeof _44f==="undefined"){throw new Error("string.substitute could not find key \""+key+"\" in template");}return _44f.toString();});};_43e.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _43e;});},"dijit/_AttachMixin":function(){define(["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","./_WidgetBase"],function(_450,_451,_452,_453,lang,_454,on,_455,_456){var _457=lang.delegate(_455,{"mouseenter":_454.enter,"mouseleave":_454.leave,"keypress":_452._keypress});var _458;var _459=_453("dijit._AttachMixin",null,{constructor:function(){this._attachPoints=[];this._attachEvents=[];},buildRendering:function(){this.inherited(arguments);this._attachTemplateNodes(this.domNode);this._beforeFillContent();},_beforeFillContent:function(){},_attachTemplateNodes:function(_45a){var node=_45a;while(true){if(node.nodeType==1&&(this._processTemplateNode(node,function(n,p){return n.getAttribute(p);},this._attach)||this.searchContainerNode)&&node.firstChild){node=node.firstChild;}else{if(node==_45a){return;}while(!node.nextSibling){node=node.parentNode;if(node==_45a){return;}}node=node.nextSibling;}}},_processTemplateNode:function(_45b,_45c,_45d){var ret=true;var _45e=this.attachScope||this,_45f=_45c(_45b,"dojoAttachPoint")||_45c(_45b,"data-dojo-attach-point");if(_45f){var _460,_461=_45f.split(/\s*,\s*/);while((_460=_461.shift())){if(lang.isArray(_45e[_460])){_45e[_460].push(_45b);}else{_45e[_460]=_45b;}ret=(_460!="containerNode");this._attachPoints.push(_460);}}var _462=_45c(_45b,"dojoAttachEvent")||_45c(_45b,"data-dojo-attach-event");if(_462){var _463,_464=_462.split(/\s*,\s*/);var trim=lang.trim;while((_463=_464.shift())){if(_463){var _465=null;if(_463.indexOf(":")!=-1){var _466=_463.split(":");_463=trim(_466[0]);_465=trim(_466[1]);}else{_463=trim(_463);}if(!_465){_465=_463;}this._attachEvents.push(_45d(_45b,_463,lang.hitch(_45e,_465)));}}}return ret;},_attach:function(node,type,func){type=type.replace(/^on/,"").toLowerCase();if(type=="dijitclick"){type=_458||(_458=_450("./a11yclick"));}else{type=_457[type]||type;}return on(node,type,func);},_detachTemplateNodes:function(){var _467=this.attachScope||this;_451.forEach(this._attachPoints,function(_468){delete _467[_468];});this._attachPoints=[];_451.forEach(this._attachEvents,function(_469){_469.remove();});this._attachEvents=[];},destroyRendering:function(){this._detachTemplateNodes();this.inherited(arguments);}});lang.extend(_456,{dojoAttachEvent:"",dojoAttachPoint:""});return _459;});},"dijit/BackgroundIframe":function(){define(["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff"],function(_46a,_46b,_46c,_46d,_46e,lang,on,has){has.add("config-bgIframe",(has("ie")||has("trident"))&&!/IEMobile\/10\.0/.test(navigator.userAgent));var _46f=new function(){var _470=[];this.pop=function(){var _471;if(_470.length){_471=_470.pop();_471.style.display="";}else{if(has("ie")<9){var burl=_46c["dojoBlankHtmlUrl"]||_46a.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_471=document.createElement(html);}else{_471=_46d.create("iframe");_471.src="javascript:\"\"";_471.className="dijitBackgroundIframe";_471.setAttribute("role","presentation");_46e.set(_471,"opacity",0.1);}_471.tabIndex=-1;}return _471;};this.push=function(_472){_472.style.display="none";_470.push(_472);};}();_46b.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("config-bgIframe")){var _473=(this.iframe=_46f.pop());node.appendChild(_473);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,"resize",node));}else{_46e.set(_473,{width:"100%",height:"100%"});}}};lang.extend(_46b.BackgroundIframe,{resize:function(node){if(this.iframe){_46e.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){this.iframe.parentNode.removeChild(this.iframe);_46f.push(this.iframe);delete this.iframe;}}});return _46b.BackgroundIframe;});},"dojox/charting/action2d/PlotAction":function(){define(["dojo/_base/connect","dojo/_base/declare","./Base","dojo/fx/easing","dojox/lang/functional"],function(hub,_474,Base,dfe,df){var _475=400,_476=dfe.backOut;return _474("dojox.charting.action2d.PlotAction",Base,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_477,plot,_478){this.anim={};if(!_478){_478={};}this.duration=_478.duration?_478.duration:_475;this.easing=_478.easing?_478.easing:_476;},connect:function(){this.handle=this.chart.connectToPlot(this.plot.name,this,"process");},disconnect:function(){if(this.handle){hub.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.inherited(arguments);df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});});},"dojox/charting/action2d/Base":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/Evented"],function(lang,_479,_47a){return _479("dojox.charting.action2d.Base",_47a,{constructor:function(_47b,plot){this.chart=_47b;this.plot=plot?(lang.isString(plot)?this.chart.getPlot(plot):plot):this.chart.getPlot("default");},connect:function(){},disconnect:function(){},destroy:function(){this.disconnect();}});});},"dojo/fx/easing":function(){define(["../_base/lang"],function(lang){var _47c={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-_47c.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return _47c.bounceIn(n*2)/2;}return (_47c.bounceOut(n*2-1)/2)+0.5;}};lang.setObject("dojo.fx.easing",_47c);return _47c;});},"dojox/lang/functional/scan":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_47d,lang,df){var _47e={};lang.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_47d.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _47e)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_47d.global;f=df.lambda(f);var t,n,z,_47f=true;if(lang.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(i in a){if(!(i in _47e)){if(_47f){t=[z=a[i]];_47f=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_47d.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_47d.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});});},"dojox/charting/themes/Tom":function(){define(["../Theme","dojox/gfx/gradutils","./common"],function(_480,_481,_482){var g=_480.generateGradient,_483={type:"linear",space:"shape",x1:0,y1:0,x2:0,y2:100};_482.Tom=new _480({chart:{fill:"#181818",stroke:{color:"#181818"},pageStyle:{backgroundColor:"#181818",backgroundImage:"none",color:"#eaf2cb"}},plotarea:{fill:"#181818"},axis:{stroke:{color:"#a0a68b",width:1},tick:{color:"#888c76",position:"center",font:"normal normal normal 7pt Helvetica, Arial, sans-serif",fontColor:"#888c76"}},series:{stroke:{width:2.5,color:"#eaf2cb"},outline:null,font:"normal normal normal 8pt Helvetica, Arial, sans-serif",fontColor:"#eaf2cb"},marker:{stroke:{width:1.25,color:"#eaf2cb"},outline:{width:1.25,color:"#eaf2cb"},font:"normal normal normal 8pt Helvetica, Arial, sans-serif",fontColor:"#eaf2cb"},seriesThemes:[{fill:g(_483,"#bf9e0a","#ecc20c")},{fill:g(_483,"#73b086","#95e5af")},{fill:g(_483,"#c7212d","#ed2835")},{fill:g(_483,"#87ab41","#b6e557")},{fill:g(_483,"#b86c25","#d37d2a")}],markerThemes:[{fill:"#bf9e0a",stroke:{color:"#ecc20c"}},{fill:"#73b086",stroke:{color:"#95e5af"}},{fill:"#c7212d",stroke:{color:"#ed2835"}},{fill:"#87ab41",stroke:{color:"#b6e557"}},{fill:"#b86c25",stroke:{color:"#d37d2a"}}]});_482.Tom.next=function(_484,_485,_486){var _487=_484=="line";if(_487||_484=="area"){var s=this.seriesThemes[this._current%this.seriesThemes.length];s.fill.space="plot";if(_487){s.stroke={width:4,color:s.fill.colors[0].color};}var _488=_480.prototype.next.apply(this,arguments);delete s.outline;delete s.stroke;s.fill.space="shape";return _488;}return _480.prototype.next.apply(this,arguments);};_482.Tom.post=function(_489,_48a){_489=_480.prototype.post.apply(this,arguments);if((_48a=="slice"||_48a=="circle")&&_489.series.fill&&_489.series.fill.type=="radial"){_489.series.fill=_481.reverse(_489.series.fill);}return _489;};return _482.Tom;});},"dojox/charting/Theme":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","./SimpleTheme","dojox/color/_base","dojox/color/Palette","dojox/gfx/gradutils"],function(lang,_48b,_48c,_48d,_48e,_48f){var _490=_48b("dojox.charting.Theme",_48d,{});lang.mixin(_490,{defineColors:function(_491){_491=_491||{};var l,c=[],n=_491.num||5;if(_491.colors){l=_491.colors.length;for(var i=0;i<n;i++){c.push(_491.colors[i%l]);}return c;}if(_491.hue){var s=_491.saturation||100,st=_491.low||30,end=_491.high||90;l=(end+st)/2;return _48f.generate(_48e.fromHsv(_491.hue,s,l),"monochromatic").colors;}if(_491.generator){return _48e.Palette.generate(_491.base,_491.generator).colors;}return c;},generateGradient:function(_492,_493,_494){var fill=lang.delegate(_492);fill.colors=[{offset:0,color:_493},{offset:1,color:_494}];return fill;},generateHslColor:function(_495,_496){_495=new _48c(_495);var hsl=_495.toHsl(),_497=_48e.fromHsl(hsl.h,hsl.s,_496);_497.a=_495.a;return _497;},generateHslGradient:function(_498,_499,_49a,_49b){_498=new _48c(_498);var hsl=_498.toHsl(),_49c=_48e.fromHsl(hsl.h,hsl.s,_49a),_49d=_48e.fromHsl(hsl.h,hsl.s,_49b);_49c.a=_49d.a=_498.a;return _490.generateGradient(_499,_49c,_49d);}});_490.defaultMarkers=_48d.defaultMarkers;_490.defaultColors=_48d.defaultColors;_490.defaultTheme=_48d.defaultTheme;return _490;});},"dojox/color/_base":function(){define(["../main","dojo/_base/lang","dojo/_base/Color","dojo/colors"],function(_49e,lang,_49f,_4a0){var cx=lang.getObject("color",true,_49e);cx.Color=_49f;cx.blend=_49f.blendColors;cx.fromRgb=_49f.fromRgb;cx.fromHex=_49f.fromHex;cx.fromArray=_49f.fromArray;cx.fromString=_49f.fromString;cx.greyscale=_4a0.makeGrey;lang.mixin(cx,{fromCmy:function(cyan,_4a1,_4a2){if(lang.isArray(cyan)){_4a1=cyan[1],_4a2=cyan[2],cyan=cyan[0];}else{if(lang.isObject(cyan)){_4a1=cyan.m,_4a2=cyan.y,cyan=cyan.c;}}cyan/=100,_4a1/=100,_4a2/=100;var r=1-cyan,g=1-_4a1,b=1-_4a2;return new _49f({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_4a3,_4a4,_4a5){if(lang.isArray(cyan)){_4a3=cyan[1],_4a4=cyan[2],_4a5=cyan[3],cyan=cyan[0];}else{if(lang.isObject(cyan)){_4a3=cyan.m,_4a4=cyan.y,_4a5=cyan.b,cyan=cyan.c;}}cyan/=100,_4a3/=100,_4a4/=100,_4a5/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_4a5)+_4a5);g=1-Math.min(1,_4a3*(1-_4a5)+_4a5);b=1-Math.min(1,_4a4*(1-_4a5)+_4a5);return new _49f({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_4a6,_4a7){if(lang.isArray(hue)){_4a6=hue[1],_4a7=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_4a6=hue.s,_4a7=hue.l,hue=hue.h;}}_4a6/=100;_4a7/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_4a6*Math.min(r,1)+(1-_4a6);g=2*_4a6*Math.min(g,1)+(1-_4a6);b=2*_4a6*Math.min(b,1)+(1-_4a6);if(_4a7<0.5){r*=_4a7,g*=_4a7,b*=_4a7;}else{r=(1-_4a7)*r+2*_4a7-1;g=(1-_4a7)*g+2*_4a7-1;b=(1-_4a7)*b+2*_4a7-1;}return new _49f({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});cx.fromHsv=function(hue,_4a8,_4a9){if(lang.isArray(hue)){_4a8=hue[1],_4a9=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_4a8=hue.s,_4a9=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_4a8/=100;_4a9/=100;var r,g,b;if(_4a8==0){r=_4a9,b=_4a9,g=_4a9;}else{var _4aa=hue/60,i=Math.floor(_4aa),f=_4aa-i;var p=_4a9*(1-_4a8);var q=_4a9*(1-(_4a8*f));var t=_4a9*(1-(_4a8*(1-f)));switch(i){case 0:r=_4a9,g=t,b=p;break;case 1:r=q,g=_4a9,b=p;break;case 2:r=p,g=_4a9,b=t;break;case 3:r=p,g=q,b=_4a9;break;case 4:r=t,g=p,b=_4a9;break;case 5:r=_4a9,g=p,b=q;break;}}return new _49f({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});};lang.extend(_49f,{toCmy:function(){var cyan=1-(this.r/255),_4ab=1-(this.g/255),_4ac=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_4ab*100),y:Math.round(_4ac*100)};},toCmyk:function(){var cyan,_4ad,_4ae,_4af;var r=this.r/255,g=this.g/255,b=this.b/255;_4af=Math.min(1-r,1-g,1-b);cyan=(1-r-_4af)/(1-_4af);_4ad=(1-g-_4af)/(1-_4af);_4ae=(1-b-_4af)/(1-_4af);return {c:Math.round(cyan*100),m:Math.round(_4ad*100),y:Math.round(_4ae*100),b:Math.round(_4af*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _4b0=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_4b0/((l<0.5)?(2*l):(2-2*l));}if(_4b0>0){if(max==r&&max!=g){h+=(g-b)/_4b0;}if(max==g&&max!=b){h+=(2+(b-r)/_4b0);}if(max==b&&max!=r){h+=(4+(r-g)/_4b0);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _4b1=max-min;var h=null,s=(max==0)?0:(_4b1/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_4b1;}else{if(g==max){h=120+60*(b-r)/_4b1;}else{h=240+60*(r-g)/_4b1;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});return cx;});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_4b2,_4b3){var _4b4={};lang.setObject("dojo.colors",_4b4);var _4b5=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_4b2.fromRgb=function(_4b6,obj){var m=_4b6.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_4b3.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _4b2.fromArray(a,obj);}return _4b2.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_4b5(m1,m2,H+1/3)*256,_4b5(m1,m2,H)*256,_4b5(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _4b2.fromArray(a,obj);}}return null;};var _4b7=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_4b2.prototype.sanitize=function(){var t=this;t.r=Math.round(_4b7(t.r,0,255));t.g=Math.round(_4b7(t.g,0,255));t.b=Math.round(_4b7(t.b,0,255));t.a=_4b7(t.a,0,1);return this;};_4b4.makeGrey=_4b2.makeGrey=function(g,a){return _4b2.fromArray([g,g,g,a]);};lang.mixin(_4b2.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _4b2;});},"dojox/color/Palette":function(){define(["dojo/_base/lang","dojo/_base/array","./_base"],function(lang,arr,dxc){dxc.Palette=function(base){this.colors=[];if(base instanceof dxc.Palette){this.colors=base.colors.slice(0);}else{if(base instanceof dxc.Color){this.colors=[null,null,base,null,null];}else{if(lang.isArray(base)){this.colors=arr.map(base.slice(0),function(item){if(lang.isString(item)){return new dxc.Color(item);}return item;});}else{if(lang.isString(base)){this.colors=[null,null,new dxc.Color(base),null,null];}}}}};function _4b8(p,_4b9,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var r=(_4b9=="dr")?item.r+val:item.r,g=(_4b9=="dg")?item.g+val:item.g,b=(_4b9=="db")?item.b+val:item.b,a=(_4b9=="da")?item.a+val:item.a;ret.colors.push(new dxc.Color({r:Math.min(255,Math.max(0,r)),g:Math.min(255,Math.max(0,g)),b:Math.min(255,Math.max(0,b)),a:Math.min(1,Math.max(0,a))}));});return ret;};function tCMY(p,_4ba,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmy(),c=(_4ba=="dc")?o.c+val:o.c,m=(_4ba=="dm")?o.m+val:o.m,y=(_4ba=="dy")?o.y+val:o.y;ret.colors.push(dxc.fromCmy(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y))));});return ret;};function _4bb(p,_4bc,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmyk(),c=(_4bc=="dc")?o.c+val:o.c,m=(_4bc=="dm")?o.m+val:o.m,y=(_4bc=="dy")?o.y+val:o.y,k=(_4bc=="dk")?o.b+val:o.b;ret.colors.push(dxc.fromCmyk(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y)),Math.min(100,Math.max(0,k))));});return ret;};function tHSL(p,_4bd,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsl(),h=(_4bd=="dh")?o.h+val:o.h,s=(_4bd=="ds")?o.s+val:o.s,l=(_4bd=="dl")?o.l+val:o.l;ret.colors.push(dxc.fromHsl(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,l))));});return ret;};function tHSV(p,_4be,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsv(),h=(_4be=="dh")?o.h+val:o.h,s=(_4be=="ds")?o.s+val:o.s,v=(_4be=="dv")?o.v+val:o.v;ret.colors.push(dxc.fromHsv(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,v))));});return ret;};function _4bf(val,low,high){return high-((high-val)*((high-low)/high));};lang.extend(dxc.Palette,{transform:function(_4c0){var fn=_4b8;if(_4c0.use){var use=_4c0.use.toLowerCase();if(use.indexOf("hs")==0){if(use.charAt(2)=="l"){fn=tHSL;}else{fn=tHSV;}}else{if(use.indexOf("cmy")==0){if(use.charAt(3)=="k"){fn=_4bb;}else{fn=tCMY;}}}}else{if("dc" in _4c0||"dm" in _4c0||"dy" in _4c0){if("dk" in _4c0){fn=_4bb;}else{fn=tCMY;}}else{if("dh" in _4c0||"ds" in _4c0){if("dv" in _4c0){fn=tHSV;}else{fn=tHSL;}}}}var _4c1=this;for(var p in _4c0){if(p=="use"){continue;}_4c1=fn(_4c1,p,_4c0[p]);}return _4c1;},clone:function(){return new dxc.Palette(this);}});lang.mixin(dxc.Palette,{generators:{analogous:function(args){var high=args.high||60,low=args.low||18,base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h=[(hsv.h+low+360)%360,(hsv.h+Math.round(low/2)+360)%360,hsv.h,(hsv.h-Math.round(high/2)+360)%360,(hsv.h-high+360)%360];var s1=Math.max(10,(hsv.s<=95)?hsv.s+5:(100-(hsv.s-95))),s2=(hsv.s>1)?hsv.s-1:21-hsv.s,v1=(hsv.v>=92)?hsv.v-9:Math.max(hsv.v+9,20),v2=(hsv.v<=90)?Math.max(hsv.v+5,20):(95+Math.ceil((hsv.v-90)/2)),s=[s1,s2,hsv.s,s1,s1],v=[v1,v2,hsv.v,v1,v2];return new dxc.Palette(arr.map(h,function(hue,i){return dxc.fromHsv(hue,s[i],v[i]);}));},monochromatic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s1=(hsv.s-30>9)?hsv.s-30:hsv.s+30,s2=hsv.s,v1=_4bf(hsv.v,20,100),v2=(hsv.v-20>20)?hsv.v-20:hsv.v+60,v3=(hsv.v-50>20)?hsv.v-50:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v3),base,dxc.fromHsv(hsv.h,s1,v3),dxc.fromHsv(hsv.h,s2,v2)]);},triadic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=(hsv.h+57+360)%360,h2=(hsv.h-157+360)%360,s1=(hsv.s>20)?hsv.s-10:hsv.s+10,s2=(hsv.s>90)?hsv.s-10:hsv.s+10,s3=(hsv.s>95)?hsv.s-5:hsv.s+5,v1=(hsv.v-20>20)?hsv.v-20:hsv.v+20,v2=(hsv.v-30>20)?hsv.v-30:hsv.v+30,v3=(hsv.v-30>70)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,hsv.v),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h2,s2,v1),dxc.fromHsv(h2,s3,v3)]);},complementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,s1=Math.max(hsv.s-10,0),s2=_4bf(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h1,s3,v2),dxc.fromHsv(h1,hsv.s,hsv.v)]);},splitComplementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,_4c2=args.da||30,hsv=base.toHsv();var _4c3=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,h1=(_4c3-_4c2+360)%360,h2=(_4c3+_4c2)%360,s1=Math.max(hsv.s-10,0),s2=_4bf(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v2),dxc.fromHsv(h2,hsv.s,hsv.v)]);},compound:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+18<360)?(hsv.h*2)+18:Math.floor(hsv.h/2)-18,h2=((hsv.h*2)+120<360)?(hsv.h*2)+120:Math.floor(hsv.h/2)-120,h3=((hsv.h*2)+99<360)?(hsv.h*2)+99:Math.floor(hsv.h/2)-99,s1=(hsv.s-40>10)?hsv.s-40:hsv.s+40,s2=(hsv.s-10>80)?hsv.s-10:hsv.s+10,s3=(hsv.s-25>10)?hsv.s-25:hsv.s+25,v1=(hsv.v-40>10)?hsv.v-40:hsv.v+40,v2=(hsv.v-20>80)?hsv.v-20:hsv.v+20,v3=Math.max(hsv.v,20);return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v3),dxc.fromHsv(h3,s2,v2)]);},shades:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s=(hsv.s==100&&hsv.v==0)?0:hsv.s,v1=(hsv.v-50>20)?hsv.v-50:hsv.v+30,v2=(hsv.v-25>=20)?hsv.v-25:hsv.v+55,v3=(hsv.v-75>=20)?hsv.v-75:hsv.v+5,v4=Math.max(hsv.v-10,20);return new dxc.Palette([new dxc.fromHsv(hsv.h,s,v1),new dxc.fromHsv(hsv.h,s,v2),base,new dxc.fromHsv(hsv.h,s,v3),new dxc.fromHsv(hsv.h,s,v4)]);}},generate:function(base,type){if(lang.isFunction(type)){return type({base:base});}else{if(dxc.Palette.generators[type]){return dxc.Palette.generators[type]({base:base});}}throw new Error("dojox.color.Palette.generate: the specified generator ('"+type+"') does not exist.");}});return dxc.Palette;});},"dojox/charting/themes/common":function(){define(["dojo/_base/lang"],function(lang){return lang.getObject("dojox.charting.themes",true);});},"dojox/charting/widget/Legend":function(){define(["dojo/_base/declare","dijit/_WidgetBase","dojox/gfx","dojo/_base/array","dojo/has","dojo/has!dojo-bidi?../bidi/widget/Legend","dojox/lang/functional","dojo/dom","dojo/dom-construct","dojo/dom-class","dijit/registry"],function(_4c4,_4c5,gfx,arr,has,_4c6,df,dom,_4c7,_4c8,_4c9){var _4ca=_4c4(has("dojo-bidi")?"dojox.charting.widget.NonBidiLegend":"dojox.charting.widget.Legend",_4c5,{chartRef:"",horizontal:true,swatchSize:18,legendBody:null,postCreate:function(){if(!this.chart&&this.chartRef){this.chart=_4c9.byId(this.chartRef)||_4c9.byNode(dom.byId(this.chartRef));if(!this.chart){}}this.chart=this.chart.chart||this.chart;this.refresh();},buildRendering:function(){this.domNode=_4c7.create("table",{role:"group","aria-label":"chart legend","class":"dojoxLegendNode"});this.legendBody=_4c7.create("tbody",null,this.domNode);this.inherited(arguments);},destroy:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_4cb){_4cb.destroy();});}this.inherited(arguments);},refresh:function(){if(this._surfaces){arr.forEach(this._surfaces,function(_4cc){_4cc.destroy();});}this._surfaces=[];while(this.legendBody.lastChild){_4c7.destroy(this.legendBody.lastChild);}if(this.horizontal){_4c8.add(this.domNode,"dojoxLegendHorizontal");this._tr=_4c7.create("tr",null,this.legendBody);this._inrow=0;}var s=this.series||this.chart.series;if(s.length==0){return;}if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var _4cd=df.map(t.run.data,"Math.max(x, 0)");var _4ce=df.map(_4cd,"/this",df.foldl(_4cd,"+",0));arr.forEach(_4ce,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{arr.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{arr.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,_4cf){var _4d0=_4c7.create("td"),icon=_4c7.create("div",null,_4d0),text=_4c7.create("label",null,_4d0),div=_4c7.create("div",{style:{"width":this.swatchSize+"px","height":this.swatchSize+"px","float":"left"}},icon);_4c8.add(icon,"dojoxLegendIcon dijitInline");_4c8.add(text,"dojoxLegendText");if(this._tr){this._tr.appendChild(_4d0);if(++this._inrow===this.horizontal){this._tr=_4c7.create("tr",null,this.legendBody);this._inrow=0;}}else{var tr=_4c7.create("tr",null,this.legendBody);tr.appendChild(_4d0);}this._makeIcon(div,dyn);text.innerHTML=String(_4cf);if(has("dojo-bidi")){text.dir=this.getTextDir(_4cf,text.dir);}},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var _4d1=gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(_4d1);if(dyn.fill){_4d1.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else{if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){_4d1.createLine(line).setStroke(dyn.stroke);}if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};_4d1.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.markerFill).setStroke(dyn.markerStroke);}}else{_4d1.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");_4d1.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");_4d1.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}}});return has("dojo-bidi")?_4c4("dojox.charting.widget.Legend",[_4ca,_4c6]):_4ca;});},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\" data-dojo-attach-event=\"mouseenter:onMouseEnter,mouseleave:onMouseLeave\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n"}});require(["dojox/charting/Chart","dojox/charting/plot2d/Pie","dojox/charting/action2d/Tooltip","dojox/charting/themes/Tom","dojox/charting/widget/Legend","dojo/ready"],function(_4d2,Pie,_4d3,Tom,_4d4,_4d5){var _4d6=null;var _4d7=null;_4d5(function(){_4d6=new _4d2("pieChart");_4d6.setTheme(Tom).addPlot("default",{type:"Pie",font:"normal normal 10pt Tahoma",fontColor:"#ccc",labelWiring:"#ccc",radius:100,labelStyle:"columns",htmlLabels:true,startAngle:-10}).addSeries("Series A",[{y:12.1,text:"China",tooltip:"1,210 million"},{y:9.52,text:"India",tooltip:"952 million"},{y:2.66,text:"USA",tooltip:"266 million"},{y:2.06,text:"Indonisia",tooltip:"206 million"},{y:1.63,text:"Brazil",tooltip:"163 million"},{y:1.48,text:"Russian",tooltip:"148 million"},{y:1.29,text:"Pakistan",tooltip:"129 million"},{y:1.25,text:"Japan",tooltip:"125 million"},{y:1.23,text:"Bangladesh",tooltip:"123 million"},{y:1.04,text:"Nigeria",tooltip:"104 million"},{y:0.96,text:"Mexico",tooltip:"96 million"},{y:0.84,text:"Germany",tooltip:"84 million"},{y:0.74,text:"Phillippines",tooltip:"74 million"},{y:0.74,text:"Viet Nam",tooltip:"74 million"},{y:0.66,text:"Iran",tooltip:"66 million"},{y:0.64,text:"Egypt",tooltip:"64 million"}]);var _4d8=new _4d3(_4d6,"default");_4d6.render();_4d7=new _4d4({chart:_4d6,horizontal:false},"legend");});});