//>>built
require({cache:{"dojox/charting/Chart":function(){define(["../main","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-style","dojo/dom","dojo/dom-geometry","dojo/dom-construct","dojo/_base/Color","dojo/sniff","./Element","./SimpleTheme","./Series","./axis2d/common","./plot2d/common","dojox/gfx/shape","dojox/gfx","dojo/has!dojo-bidi?./bidi/Chart","dojox/lang/functional","dojox/lang/functional/fold","dojox/lang/functional/reversed"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e,_f,_10,g,_11,_12){var dc=_2.getObject("charting",true,_1),_13={l:10,t:10,r:10,b:10};function _14(_15){return _15.clear();};function _16(_17){return _17.destroy();};function _18(_19){_19.dirty=false;return false;};function _1a(_1b){_1b.dirty=true;return true;};function _1c(_1d){return _1d.name;};var _1e=_4(_a("dojo-bidi")?"dojox.charting.NonBidiChart":"dojox.charting.Chart",null,{constructor:function(_1f,_20){if(!_20){_20={};}this.margins=_20.margins||_13;this._customMargins=!!_20.margins;this.stroke=_20.stroke;this.fill=_20.fill;this.delayInMs=_20.delayInMs||200;this.title=_20.title;this.titleGap=_20.titleGap;this.titlePos=_20.titlePos;this.titleFont=_20.titleFont;this.titleFontColor=_20.titleFontColor;this.titleAlign=_20.titleAlign;this.chartTitle=null;this.htmlLabels=true;if("htmlLabels" in _20){this.htmlLabels=_20.htmlLabels;}this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.node=_6.byId(_1f);var box=_7.getMarginBox(_1f);this.surface=g.createSurface(this.node,box.w||400,box.h||300);if(this.surface.declaredClass.indexOf("vml")==-1){this._nativeClip=true;}},destroy:function(){_3.forEach(this.series,_16);_3.forEach(this.stack,_16);_12.forIn(this.axes,_16);this.surface.destroy();if(this.chartTitle&&this.chartTitle.tagName){_8.destroy(this.chartTitle);}},getCoords:function(){var _21=this.node;var s=_5.getComputedStyle(_21),_22=_7.getMarginBox(_21,s);var abs=_7.position(_21,true);_22.x=abs.x;_22.y=abs.y;return _22;},setTheme:function(_23){this.theme=_23.clone();if(!this._customMargins){this.margins=this.theme.chart.margins||_13;}this.dirty=true;return this;},addAxis:function(_24,_25){var _26,_27=_25&&_25.type||"Default";if(typeof _27=="string"){if(!dc.axis2d||!dc.axis2d[_27]){throw Error("Can't find axis: "+_27+" - Check "+"require() dependencies.");}_26=new dc.axis2d[_27](this,_25);}else{_26=new _27(this,_25);}_26.name=_24;_26.dirty=true;if(_24 in this.axes){this.axes[_24].destroy();}this.axes[_24]=_26;this.dirty=true;return this;},getAxis:function(_28){return this.axes[_28];},removeAxis:function(_29){if(_29 in this.axes){this.axes[_29].destroy();delete this.axes[_29];this.dirty=true;}return this;},addPlot:function(_2a,_2b){var _2c,_2d=_2b&&_2b.type||"Default";if(typeof _2d=="string"){if(!dc.plot2d||!dc.plot2d[_2d]){throw Error("Can't find plot: "+_2d+" - didn't you forget to dojo"+".require() it?");}_2c=new dc.plot2d[_2d](this,_2b);}else{_2c=new _2d(this,_2b);}_2c.name=_2a;_2c.dirty=true;if(_2a in this.plots){this.stack[this.plots[_2a]].destroy();this.stack[this.plots[_2a]]=_2c;}else{this.plots[_2a]=this.stack.length;this.stack.push(_2c);}this.dirty=true;return this;},getPlot:function(_2e){return this.stack[this.plots[_2e]];},removePlot:function(_2f){if(_2f in this.plots){var _30=this.plots[_2f];delete this.plots[_2f];this.stack[_30].destroy();this.stack.splice(_30,1);_12.forIn(this.plots,function(idx,_31,_32){if(idx>_30){_32[_31]=idx-1;}});var ns=_3.filter(this.series,function(run){return run.plot!=_2f;});if(ns.length<this.series.length){_3.forEach(this.series,function(run){if(run.plot==_2f){run.destroy();}});this.runs={};_3.forEach(ns,function(run,_33){this.runs[run.plot]=_33;},this);this.series=ns;}this.dirty=true;}return this;},getPlotOrder:function(){return _12.map(this.stack,_1c);},setPlotOrder:function(_34){var _35={},_36=_12.filter(_34,function(_37){if(!(_37 in this.plots)||(_37 in _35)){return false;}_35[_37]=1;return true;},this);if(_36.length<this.stack.length){_12.forEach(this.stack,function(_38){var _39=_38.name;if(!(_39 in _35)){_36.push(_39);}});}var _3a=_12.map(_36,function(_3b){return this.stack[this.plots[_3b]];},this);_12.forEach(_3a,function(_3c,i){this.plots[_3c.name]=i;},this);this.stack=_3a;this.dirty=true;return this;},movePlotToFront:function(_3d){if(_3d in this.plots){var _3e=this.plots[_3d];if(_3e){var _3f=this.getPlotOrder();_3f.splice(_3e,1);_3f.unshift(_3d);return this.setPlotOrder(_3f);}}return this;},movePlotToBack:function(_40){if(_40 in this.plots){var _41=this.plots[_40];if(_41<this.stack.length-1){var _42=this.getPlotOrder();_42.splice(_41,1);_42.push(_40);return this.setPlotOrder(_42);}}return this;},addSeries:function(_43,_44,_45){var run=new _d(this,_44,_45);run.name=_43;if(_43 in this.runs){this.series[this.runs[_43]].destroy();this.series[this.runs[_43]]=run;}else{this.runs[_43]=this.series.length;this.series.push(run);}this.dirty=true;if(!("ymin" in run)&&"min" in run){run.ymin=run.min;}if(!("ymax" in run)&&"max" in run){run.ymax=run.max;}return this;},getSeries:function(_46){return this.series[this.runs[_46]];},removeSeries:function(_47){if(_47 in this.runs){var _48=this.runs[_47];delete this.runs[_47];this.series[_48].destroy();this.series.splice(_48,1);_12.forIn(this.runs,function(idx,_49,_4a){if(idx>_48){_4a[_49]=idx-1;}});this.dirty=true;}return this;},updateSeries:function(_4b,_4c,_4d){if(_4b in this.runs){var run=this.series[this.runs[_4b]];run.update(_4c);if(_4d){this.dirty=true;}else{this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}}return this;},getSeriesOrder:function(_4e){return _12.map(_12.filter(this.series,function(run){return run.plot==_4e;}),_1c);},setSeriesOrder:function(_4f){var _50,_51={},_52=_12.filter(_4f,function(_53){if(!(_53 in this.runs)||(_53 in _51)){return false;}var run=this.series[this.runs[_53]];if(_50){if(run.plot!=_50){return false;}}else{_50=run.plot;}_51[_53]=1;return true;},this);_12.forEach(this.series,function(run){var _54=run.name;if(!(_54 in _51)&&run.plot==_50){_52.push(_54);}});var _55=_12.map(_52,function(_56){return this.series[this.runs[_56]];},this);this.series=_55.concat(_12.filter(this.series,function(run){return run.plot!=_50;}));_12.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(_57){if(_57 in this.runs){var _58=this.runs[_57],_59=this.getSeriesOrder(this.series[_58].plot);if(_57!=_59[0]){_59.splice(_58,1);_59.unshift(_57);return this.setSeriesOrder(_59);}}return this;},moveSeriesToBack:function(_5a){if(_5a in this.runs){var _5b=this.runs[_5a],_5c=this.getSeriesOrder(this.series[_5b].plot);if(_5a!=_5c[_5c.length-1]){_5c.splice(_5b,1);_5c.push(_5a);return this.setSeriesOrder(_5c);}}return this;},resize:function(_5d,_5e){switch(arguments.length){case 1:_7.setMarginBox(this.node,_5d);break;case 2:_7.setMarginBox(this.node,{w:_5d,h:_5e});break;}var box=_7.getMarginBox(this.node);var d=this.surface.getDimensions();if(d.width!=box.w||d.height!=box.h){this.surface.setDimensions(box.w,box.h);this.dirty=true;return this.render();}else{return this;}},getGeometry:function(){var ret={};_12.forIn(this.axes,function(_5f){if(_5f.initialized()){ret[_5f.name]={name:_5f.name,vertical:_5f.vertical,scaler:_5f.scaler,ticks:_5f.ticks};}});return ret;},setAxisWindow:function(_60,_61,_62,_63){var _64=this.axes[_60];if(_64){_64.setWindow(_61,_62);_3.forEach(this.stack,function(_65){if(_65.hAxis==_60||_65.vAxis==_60){_65.zoom=_63;}});}return this;},setWindow:function(sx,sy,dx,dy,_66){if(!("plotArea" in this)){this.calculateGeometry();}_12.forIn(this.axes,function(_67){var _68,_69,_6a=_67.getScaler().bounds,s=_6a.span/(_6a.upper-_6a.lower);if(_67.vertical){_68=sy;_69=dy/s/_68;}else{_68=sx;_69=dx/s/_68;}_67.setWindow(_68,_69);});_3.forEach(this.stack,function(_6b){_6b.zoom=_66;});return this;},zoomIn:function(_6c,_6d,_6e){var _6f=this.axes[_6c];if(_6f){var _70,_71,_72=_6f.getScaler().bounds;var _73=Math.min(_6d[0],_6d[1]);var _74=Math.max(_6d[0],_6d[1]);_73=_6d[0]<_72.lower?_72.lower:_73;_74=_6d[1]>_72.upper?_72.upper:_74;_70=(_72.upper-_72.lower)/(_74-_73);_71=_73-_72.lower;this.setAxisWindow(_6c,_70,_71);if(_6e){this.delayedRender();}else{this.render();}}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}var _75=_3.filter(this.stack,function(_76){return _76.dirty||(_76.hAxis&&this.axes[_76.hAxis].dirty)||(_76.vAxis&&this.axes[_76.vAxis].dirty);},this);_77(_75,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();_3.forEach(this.stack,_14);if(!this.theme){this.setTheme(new _c());}_3.forEach(this.series,function(run){if(!(run.plot in this.plots)){if(!dc.plot2d||!dc.plot2d.Default){throw Error("Can't find plot: Default - didn't you forget to dojo"+".require() it?");}var _78=new dc.plot2d.Default(this,{});_78.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(_78);}this.stack[this.plots[run.plot]].addSeries(run);},this);_3.forEach(this.stack,function(_79){if(_79.assignAxes){_79.assignAxes(this.axes);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=g.normalizedLength(dim.width);dim.height=g.normalizedLength(dim.height);_12.forIn(this.axes,_14);_77(this.stack,dim);var _7a=this.offsets={l:0,r:0,t:0,b:0};var _7b=this;_12.forIn(this.axes,function(_7c){if(_a("dojo-bidi")){_7b._resetLeftBottom(_7c);}_12.forIn(_7c.getOffsets(),function(o,i){_7a[i]=Math.max(o,_7a[i]);});});if(this.title){this.titleGap=(this.titleGap==0)?0:this.titleGap||this.theme.chart.titleGap||20;this.titlePos=this.titlePos||this.theme.chart.titlePos||"top";this.titleFont=this.titleFont||this.theme.chart.titleFont;this.titleFontColor=this.titleFontColor||this.theme.chart.titleFontColor||"black";this.titleAlign=this.titleAlign||this.theme&&this.theme.chart&&this.theme.chart.titleAlign||"middle";var _7d=g.normalizedLength(g.splitFontString(this.titleFont).size);_7a[this.titlePos=="top"?"t":"b"]+=(_7d+this.titleGap);}_12.forIn(this.margins,function(o,i){_7a[i]+=o;});this.plotArea={width:dim.width-_7a.l-_7a.r,height:dim.height-_7a.t-_7a.b};_12.forIn(this.axes,_14);_77(this.stack,this.plotArea);return this;},render:function(){if(this._delayedRenderHandle){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;}if(this.theme){this.theme.clear();}if(this.dirty){return this.fullRender();}this.calculateGeometry();_12.forEachRev(this.stack,function(_7e){_7e.render(this.dim,this.offsets);},this);_12.forIn(this.axes,function(_7f){_7f.render(this.dim,this.offsets);},this);this._makeClean();return this;},fullRender:function(){this.fullGeometry();var _80=this.offsets,dim=this.dim;var w=Math.max(0,dim.width-_80.l-_80.r),h=Math.max(0,dim.height-_80.t-_80.b);_3.forEach(this.series,_f.purgeGroup);_12.forIn(this.axes,_f.purgeGroup);_3.forEach(this.stack,_f.purgeGroup);var _81=this.surface.children;if(_10.dispose){for(var i=0;i<_81.length;++i){_10.dispose(_81[i]);}}if(this.chartTitle&&this.chartTitle.tagName){_8.destroy(this.chartTitle);}this.surface.clear();this.chartTitle=null;this._renderChartBackground(dim,_80);if(this._nativeClip){this._renderPlotBackground(dim,_80,w,h);}else{this._renderPlotBackground(dim,_80,w,h);}_12.foldr(this.stack,function(z,_82){return _82.render(dim,_80),0;},0);if(!this._nativeClip){this._renderChartBackground(dim,_80);}if(this.title){this._renderTitle(dim,_80);}_12.forIn(this.axes,function(_83){_83.render(dim,_80);});this._makeClean();return this;},_renderTitle:function(dim,_84){var _85=(g.renderer=="canvas")&&this.htmlLabels,_86=_85||!_a("ie")&&!_a("opera")&&this.htmlLabels?"html":"gfx",_87=g.normalizedLength(g.splitFontString(this.titleFont).size),_88=g._base._getTextBox(this.title,{font:this.titleFont});var _89=this.titleAlign;var _8a=_a("dojo-bidi")&&this.isRightToLeft();var _8b=dim.width/2;if(_89==="edge"){_89="left";if(_8a){_8b=dim.width-(_84.r+_88.w);}else{_8b=_84.l;}}else{if(_89!="middle"){if(_8a){_89=_89==="left"?"right":"left";}if(_89==="left"){_8b=this.margins.l;}else{if(_89==="right"){_89="left";_8b=dim.width-(this.margins.l+_88.w);}}}}this.chartTitle=_e.createText[_86](this,this.surface,_8b,this.titlePos=="top"?_87+this.margins.t:dim.height-this.margins.b,_89,this.title,this.titleFont,this.titleFontColor);},_renderChartBackground:function(dim,_8c){var t=this.theme,_8d;var _8e=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);var _8f=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(_8e=="inherit"){var _90=this.node;_8e=new _9(_5.get(_90,"backgroundColor"));while(_8e.a==0&&_90!=document.documentElement){_8e=new _9(_5.get(_90,"backgroundColor"));_90=_90.parentNode;}}if(_8e){if(this._nativeClip){_8e=_b.prototype._shapeFill(_b.prototype._plotFill(_8e,dim),{x:0,y:0,width:dim.width+1,height:dim.height+1});this.surface.createRect({width:dim.width+1,height:dim.height+1}).setFill(_8e);}else{_8e=_b.prototype._plotFill(_8e,dim,_8c);if(_8c.l){_8d={x:0,y:0,width:_8c.l,height:dim.height+1};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.r){_8d={x:dim.width-_8c.r,y:0,width:_8c.r+1,height:dim.height+2};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.t){_8d={x:0,y:0,width:dim.width+1,height:_8c.t};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}if(_8c.b){_8d={x:0,y:dim.height-_8c.b,width:dim.width+1,height:_8c.b+2};this.surface.createRect(_8d).setFill(_b.prototype._shapeFill(_8e,_8d));}}}if(_8f){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(_8f);}},_renderPlotBackground:function(dim,_91,w,h){var t=this.theme;var _92=t.plotarea&&t.plotarea.fill;var _93=t.plotarea&&t.plotarea.stroke;var _94={x:_91.l-1,y:_91.t-1,width:w+2,height:h+2};if(_92){_92=_b.prototype._shapeFill(_b.prototype._plotFill(_92,dim,_91),_94);this.surface.createRect(_94).setFill(_92);}if(_93){this.surface.createRect({x:_91.l,y:_91.t,width:w+1,height:h+1}).setStroke(_93);}},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(_2.hitch(this,function(){this.render();}),this.delayInMs);}return this;},connectToPlot:function(_95,_96,_97){return _95 in this.plots?this.stack[this.plots[_95]].connect(_96,_97):null;},fireEvent:function(_98,_99,_9a){if(_98 in this.runs){var _9b=this.series[this.runs[_98]].plot;if(_9b in this.plots){var _9c=this.stack[this.plots[_9b]];if(_9c){_9c.fireEvent(_98,_99,_9a);}}}return this;},_makeClean:function(){_3.forEach(this.axes,_18);_3.forEach(this.stack,_18);_3.forEach(this.series,_18);this.dirty=false;},_makeDirty:function(){_3.forEach(this.axes,_1a);_3.forEach(this.stack,_1a);_3.forEach(this.series,_1a);this.dirty=true;},_invalidateDependentPlots:function(_9d,_9e){if(_9d in this.plots){var _9f=this.stack[this.plots[_9d]],_a0,_a1=_9e?"vAxis":"hAxis";if(_9f[_a1]){_a0=this.axes[_9f[_a1]];if(_a0&&_a0.dependOnData()){_a0.dirty=true;_3.forEach(this.stack,function(p){if(p[_a1]&&p[_a1]==_9f[_a1]){p.dirty=true;}});}}else{_9f.dirty=true;}}},setDir:function(dir){return this;},_resetLeftBottom:function(_a2){},formatTruncatedLabel:function(_a3,_a4,_a5){}});function _a6(_a7){return {min:_a7.hmin,max:_a7.hmax};};function _a8(_a9){return {min:_a9.vmin,max:_a9.vmax};};function _aa(_ab,h){_ab.hmin=h.min;_ab.hmax=h.max;};function _ac(_ad,v){_ad.vmin=v.min;_ad.vmax=v.max;};function _ae(_af,_b0){if(_af&&_b0){_af.min=Math.min(_af.min,_b0.min);_af.max=Math.max(_af.max,_b0.max);}return _af||_b0;};function _77(_b1,_b2){var _b3={},_b4={};_3.forEach(_b1,function(_b5){var _b6=_b3[_b5.name]=_b5.getSeriesStats();if(_b5.hAxis){_b4[_b5.hAxis]=_ae(_b4[_b5.hAxis],_a6(_b6));}if(_b5.vAxis){_b4[_b5.vAxis]=_ae(_b4[_b5.vAxis],_a8(_b6));}});_3.forEach(_b1,function(_b7){var _b8=_b3[_b7.name];if(_b7.hAxis){_aa(_b8,_b4[_b7.hAxis]);}if(_b7.vAxis){_ac(_b8,_b4[_b7.vAxis]);}_b7.initializeScalers(_b2,_b8);});};return _a("dojo-bidi")?_4("dojox.charting.Chart",[_1e,_11]):_1e;});},"dojox/main":function(){define(["dojo/_base/kernel"],function(_b9){return _b9.dojox;});},"dojox/charting/Element":function(){define(["dojo/_base/array","dojo/dom-construct","dojo/_base/declare","dojox/gfx","dojox/gfx/shape"],function(arr,_ba,_bb,gfx,_bc){return _bb("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,renderingOptions:null,constructor:function(_bd,_be){this.chart=_bd;this.group=null;this.htmlElements=[];this.dirty=true;this.trailingSymbol="...";this._events=[];if(_be&&_be.renderingOptions){this.renderingOptions=_be.renderingOptions;}},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.getGroup().removeShape();var _bf=this.getGroup().children;if(_bc.dispose){for(var i=0;i<_bf.length;++i){_bc.dispose(_bf[i],true);}}if(this.getGroup().rawNode){_ba.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_bc.dispose){_bc.dispose(this.getGroup(),true);}if(this.getGroup()!=this.group){if(this.group.rawNode){_ba.empty(this.group.rawNode);}this.group.clear();if(_bc.dispose){_bc.dispose(this.group,true);}}this.group=null;}this.dirty=true;if(this._events.length){arr.forEach(this._events,function(_c0){_c0.shape.disconnect(_c0.handle);});this._events=[];}return this;},cleanGroup:function(_c1){this.destroyHtmlElements();if(!_c1){_c1=this.chart.surface;}if(this.group){var _c2;var _c3=this.getGroup().children;if(_bc.dispose){for(var i=0;i<_c3.length;++i){_bc.dispose(_c3[i],true);}}if(this.getGroup().rawNode){_c2=this.getGroup().bgNode;_ba.empty(this.getGroup().rawNode);}this.getGroup().clear();if(_c2){this.getGroup().rawNode.appendChild(_c2);}}else{this.group=_c1.createGroup();if(this.renderingOptions&&this.group.rawNode&&this.group.rawNode.namespaceURI=="http://www.w3.org/2000/svg"){for(var key in this.renderingOptions){this.group.rawNode.setAttribute(key,this.renderingOptions[key]);}}}this.dirty=true;return this;},getGroup:function(){return this.group;},destroyHtmlElements:function(){if(this.htmlElements.length){arr.forEach(this.htmlElements,_ba.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},overrideShape:function(_c4,_c5){},getTextWidth:function(s,_c6){return gfx._base._getTextBox(s,{font:_c6}).w||0;},getTextWithLimitLength:function(s,_c7,_c8,_c9){if(!s||s.length<=0){return {text:"",truncated:_c9||false};}if(!_c8||_c8<=0){return {text:s,truncated:_c9||false};}var _ca=2,_cb=0.618,_cc=s.substring(0,1)+this.trailingSymbol,_cd=this.getTextWidth(_cc,_c7);if(_c8<=_cd){return {text:_cc,truncated:true};}var _ce=this.getTextWidth(s,_c7);if(_ce<=_c8){return {text:s,truncated:_c9||false};}else{var _cf=0,end=s.length;while(_cf<end){if(end-_cf<=_ca){while(this.getTextWidth(s.substring(0,_cf)+this.trailingSymbol,_c7)>_c8){_cf-=1;}return {text:(s.substring(0,_cf)+this.trailingSymbol),truncated:true};}var _d0=_cf+Math.round((end-_cf)*_cb),_d1=this.getTextWidth(s.substring(0,_d0),_c7);if(_d1<_c8){_cf=_d0;end=end;}else{_cf=_cf;end=_d0;}}}},getTextWithLimitCharCount:function(s,_d2,_d3,_d4){if(!s||s.length<=0){return {text:"",truncated:_d4||false};}if(!_d3||_d3<=0||s.length<=_d3){return {text:s,truncated:_d4||false};}return {text:s.substring(0,_d3)+this.trailingSymbol,truncated:true};},_plotFill:function(_d5,dim,_d6){if(!_d5||!_d5.type||!_d5.space){return _d5;}var _d7=_d5.space,_d8;switch(_d5.type){case "linear":if(_d7==="plot"||_d7==="shapeX"||_d7==="shapeY"){_d5=gfx.makeParameters(gfx.defaultLinearGradient,_d5);_d5.space=_d7;if(_d7==="plot"||_d7==="shapeX"){_d8=dim.height-_d6.t-_d6.b;_d5.y1=_d6.t+_d8*_d5.y1/100;_d5.y2=_d6.t+_d8*_d5.y2/100;}if(_d7==="plot"||_d7==="shapeY"){_d8=dim.width-_d6.l-_d6.r;_d5.x1=_d6.l+_d8*_d5.x1/100;_d5.x2=_d6.l+_d8*_d5.x2/100;}}break;case "radial":if(_d7==="plot"){_d5=gfx.makeParameters(gfx.defaultRadialGradient,_d5);_d5.space=_d7;var _d9=dim.width-_d6.l-_d6.r,_da=dim.height-_d6.t-_d6.b;_d5.cx=_d6.l+_d9*_d5.cx/100;_d5.cy=_d6.t+_da*_d5.cy/100;_d5.r=_d5.r*Math.sqrt(_d9*_d9+_da*_da)/200;}break;case "pattern":if(_d7==="plot"||_d7==="shapeX"||_d7==="shapeY"){_d5=gfx.makeParameters(gfx.defaultPattern,_d5);_d5.space=_d7;if(_d7==="plot"||_d7==="shapeX"){_d8=dim.height-_d6.t-_d6.b;_d5.y=_d6.t+_d8*_d5.y/100;_d5.height=_d8*_d5.height/100;}if(_d7==="plot"||_d7==="shapeY"){_d8=dim.width-_d6.l-_d6.r;_d5.x=_d6.l+_d8*_d5.x/100;_d5.width=_d8*_d5.width/100;}}break;}return _d5;},_shapeFill:function(_db,_dc){if(!_db||!_db.space){return _db;}var _dd=_db.space,_de;switch(_db.type){case "linear":if(_dd==="shape"||_dd==="shapeX"||_dd==="shapeY"){_db=gfx.makeParameters(gfx.defaultLinearGradient,_db);_db.space=_dd;if(_dd==="shape"||_dd==="shapeX"){_de=_dc.width;_db.x1=_dc.x+_de*_db.x1/100;_db.x2=_dc.x+_de*_db.x2/100;}if(_dd==="shape"||_dd==="shapeY"){_de=_dc.height;_db.y1=_dc.y+_de*_db.y1/100;_db.y2=_dc.y+_de*_db.y2/100;}}break;case "radial":if(_dd==="shape"){_db=gfx.makeParameters(gfx.defaultRadialGradient,_db);_db.space=_dd;_db.cx=_dc.x+_dc.width/2;_db.cy=_dc.y+_dc.height/2;_db.r=_db.r*_dc.width/200;}break;case "pattern":if(_dd==="shape"||_dd==="shapeX"||_dd==="shapeY"){_db=gfx.makeParameters(gfx.defaultPattern,_db);_db.space=_dd;if(_dd==="shape"||_dd==="shapeX"){_de=_dc.width;_db.x=_dc.x+_de*_db.x/100;_db.width=_de*_db.width/100;}if(_dd==="shape"||_dd==="shapeY"){_de=_dc.height;_db.y=_dc.y+_de*_db.y/100;_db.height=_de*_db.height/100;}}break;}return _db;},_pseudoRadialFill:function(_df,_e0,_e1,_e2,end){if(!_df||_df.type!=="radial"||_df.space!=="shape"){return _df;}var _e3=_df.space;_df=gfx.makeParameters(gfx.defaultRadialGradient,_df);_df.space=_e3;if(arguments.length<4){_df.cx=_e0.x;_df.cy=_e0.y;_df.r=_df.r*_e1/100;return _df;}var _e4=arguments.length<5?_e2:(end+_e2)/2;return {type:"linear",x1:_e0.x,y1:_e0.y,x2:_e0.x+_df.r*_e1*Math.cos(_e4)/100,y2:_e0.y+_df.r*_e1*Math.sin(_e4)/100,colors:_df.colors};}});});},"dojox/gfx":function(){define(["dojo/_base/lang","./gfx/_base","./gfx/renderer!"],function(_e5,_e6,_e7){_e6.switchTo(_e7);return _e6;});},"dojox/gfx/_base":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/Color","dojo/_base/sniff","dojo/_base/window","dojo/_base/array","dojo/dom","dojo/dom-construct","dojo/dom-geometry"],function(_e8,_e9,_ea,has,win,arr,dom,_eb,_ec){var g=_e9.getObject("dojox.gfx",true),b=g._base={};g._hasClass=function(_ed,_ee){var cls=_ed.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+_ee+" ")>=0;};g._addClass=function(_ef,_f0){var cls=_ef.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+_f0+" ")<0){_ef.setAttribute("className",cls+(cls?" ":"")+_f0);}};g._removeClass=function(_f1,_f2){var cls=_f1.getAttribute("className");if(cls){_f1.setAttribute("className",cls.replace(new RegExp("(^|\\s+)"+_f2+"(\\s+|$)"),"$1$2"));}};b._getFontMeasurements=function(){var _f3={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var p,_f4;if(has("ie")){_f4=win.doc.documentElement.style.fontSize||"";if(!_f4){win.doc.documentElement.style.fontSize="100%";}}var div=_eb.create("div",{style:{position:"absolute",left:"0",top:"-100px",width:"30px",height:"1000em",borderWidth:"0",margin:"0",padding:"0",outline:"none",lineHeight:"1",overflow:"hidden"}},win.body());for(p in _f3){div.style.fontSize=p;_f3[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}if(has("ie")){win.doc.documentElement.style.fontSize=_f4;}win.body().removeChild(div);return _f3;};var _f5=null;b._getCachedFontMeasurements=function(_f6){if(_f6||!_f5){_f5=b._getFontMeasurements();}return _f5;};var _f7=null,_f8={};b._getTextBox=function(_f9,_fa,_fb){var m,s,al=arguments.length;var i,box;if(!_f7){_f7=_eb.create("div",{style:{position:"absolute",top:"-10000px",left:"0",visibility:"hidden"}},win.body());}m=_f7;m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&_fa){for(i in _fa){if(i in _f8){continue;}s[i]=_fa[i];}}if(al>2&&_fb){m.className=_fb;}m.innerHTML=_f9;if(m.getBoundingClientRect){var bcr=m.getBoundingClientRect();box={l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{box=_ec.getMarginBox(m);}m.innerHTML="";return box;};b._computeTextLocation=function(_fc,_fd,_fe,_ff){var loc={},_100=_fc.align;switch(_100){case "end":loc.x=_fc.x-_fd;break;case "middle":loc.x=_fc.x-_fd/2;break;default:loc.x=_fc.x;break;}var c=_ff?0.75:1;loc.y=_fc.y-_fe*c;return loc;};b._computeTextBoundingBox=function(s){if(!g._base._isRendered(s)){return {x:0,y:0,width:0,height:0};}var loc,_101=s.getShape(),font=s.getFont()||g.defaultFont,w=s.getTextWidth(),h=g.normalizedLength(font.size);loc=b._computeTextLocation(_101,w,h,true);return {x:loc.x,y:loc.y,width:w,height:h};};b._isRendered=function(s){var p=s.parent;while(p&&p.getParent){p=p.parent;}return p!==null;};var _102=0;b._getUniqueId=function(){var id;do{id=_e8._scopeName+"xUnique"+(++_102);}while(dom.byId(id));return id;};var _103=has("pointer-events")?"touchAction":has("MSPointer")?"msTouchAction":null;b._fixMsTouchAction=_103?function(_104){_104.rawNode.style[_103]="none";}:function(){};_e9.mixin(g,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var _105={};return function(type){var t=_105[type];if(t){return new t();}t=_105[type]=function(){};t.prototype=g["default"+type];return new t();};})(),normalizeColor:function(_106){return (_106 instanceof _ea)?_106:new _ea(_106);},normalizeParameters:function(_107,_108){var x;if(_108){var _109={};for(x in _107){if(x in _108&&!(x in _109)){_107[x]=_108[x];}}}return _107;},makeParameters:function(_10a,_10b){var i=null;if(!_10b){return _e9.delegate(_10a);}var _10c={};for(i in _10a){if(!(i in _10c)){_10c[i]=_e9.clone((i in _10b)?_10b[i]:_10a[i]);}}return _10c;},formatNumber:function(x,_10d){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var _10e=val.indexOf(".");if(_10e>=0&&val.length-_10e>5){val=x.toFixed(4);}}if(x<0){return val;}return _10d?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=g.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else{if(t[4].charAt(0)=="/"){j=5;}}}if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return g._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*g.px_in_pt();},px2pt:function(len){return len/g.px_in_pt();},normalizedLength:function(len){if(len.length===0){return 0;}if(len.length>2){var _10f=g.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case "px":return val;case "pt":return val*_10f;case "in":return val*72*_10f;case "pc":return val*12*_10f;case "mm":return val*g.mm_in_pt*_10f;case "cm":return val*g.cm_in_pt*_10f;}}return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-DF-Za-df-z])|([-+]?\d*[.]?\d+(?:[eE][-+]?\d+)?)/g,equalSources:function(a,b){return a&&b&&a===b;},switchTo:function(_110){var ns=typeof _110=="string"?g[_110]:_110;if(ns){arr.forEach(["Group","Rect","Ellipse","Circle","Line","Polyline","Image","Text","Path","TextPath","Surface","createSurface","fixTarget"],function(name){g[name]=ns[name];});if(typeof _110=="string"){g.renderer=_110;}else{arr.some(["svg","vml","canvas","canvasWithEvents","silverlight"],function(r){return (g.renderer=g[r]&&g[r].Surface===g.Surface?r:null);});}}}});return g;});},"dojox/gfx/renderer":function(){define(["./_base","dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/_base/config"],function(g,lang,has,win,_111){var _112=null;has.add("vml",function(_113,_114,_115){_115.innerHTML="<v:shape adj=\"1\"/>";var _116=("adj" in _115.firstChild);_115.innerHTML="";return _116;});return {load:function(id,_117,load){if(_112&&id!="force"){load(_112);return;}var _118=_111.forceGfxRenderer,_119=!_118&&(lang.isString(_111.gfxRenderer)?_111.gfxRenderer:"svg,vml,canvas,silverlight").split(","),_11a,_11b;while(!_118&&_119.length){switch(_119.shift()){case "svg":if("SVGAngle" in win.global){_118="svg";}break;case "vml":if(has("vml")){_118="vml";}break;case "silverlight":try{if(has("ie")){_11a=new ActiveXObject("AgControl.AgControl");if(_11a&&_11a.IsVersionSupported("1.0")){_11b=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){_11b=true;}}}catch(e){_11b=false;}finally{_11a=null;}if(_11b){_118="silverlight";}break;case "canvas":if(win.global.CanvasRenderingContext2D){_118="canvas";}break;}}if(_118==="canvas"&&_111.canvasEvents!==false){_118="canvasWithEvents";}if(_111.isDebug){}function _11c(){_117(["dojox/gfx/"+_118],function(_11d){g.renderer=_118;_112=_11d;load(_11d);});};if(_118=="svg"&&typeof window.svgweb!="undefined"){window.svgweb.addOnLoad(_11c);}else{_11c();}}};});},"dojox/gfx/shape":function(){define(["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/on","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,lang,_11e,_11f,has,on,arr,_120,_121,_122){function _123(a,_124){var len=(a.length-1);while(_124<len){a[_124]=a[++_124];}a.length=len;};var _125=g.shape={};_125.Shape=_11e("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;if(has("gfxRegistry")){var uid=_125.register(this);this.getUID=function(){return uid;};}},destroy:function(){if(has("gfxRegistry")){_125.dispose(this);}if(this.rawNode&&"__gfxObject__" in this.rawNode){this.rawNode.__gfxObject__=null;}this.rawNode=null;},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_122;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(clip){this.clip=clip;},getClip:function(){return this.clip;},setShape:function(_126){this.shape=g.makeParameters(this.shape,_126);this.bbox=null;return this;},setFill:function(fill){if(!fill){this.fillStyle=null;return this;}var f=null;if(typeof (fill)=="object"&&"type" in fill){switch(fill.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,fill);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,fill);break;case "pattern":f=g.makeParameters(g.defaultPattern,fill);break;}}else{f=g.normalizeColor(fill);}this.fillStyle=f;return this;},setStroke:function(_127){if(!_127){this.strokeStyle=null;return this;}if(typeof _127=="string"||lang.isArray(_127)||_127 instanceof _121){_127={color:_127};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_127);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_128){this.matrix=_122.clone(_128?_122.normalize(_128):_122.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_129){return _129?this.setTransform([this.matrix,_129]):this;},applyLeftTransform:function(_12a){return _12a?this.setTransform([_12a,this.matrix]):this;},applyTransform:function(_12b){return _12b?this.setTransform([this.matrix,_12b]):this;},removeShape:function(_12c){if(this.parent){this.parent.remove(this,_12c);}return this;},_setParent:function(_12d,_12e){this.parent=_12d;return this._updateParentMatrix(_12e);},_updateParentMatrix:function(_12f){this.parentMatrix=_12f?_122.clone(_12f):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_122.multiply(p.matrix,m);}p=p.parent;}return m;}});_125._eventsProcessing={on:function(type,_130){return on(this.getEventSource(),type,_125.fixCallback(this,g.fixTarget,_130));},connect:function(name,_131,_132){if(name.substring(0,2)=="on"){name=name.substring(2);}return this.on(name,_132?lang.hitch(_131,_132):_131);},disconnect:function(_133){return _133.remove();}};_125.fixCallback=function(_134,_135,_136,_137){if(!_137){_137=_136;_136=null;}if(lang.isString(_137)){_136=_136||_11f.global;if(!_136[_137]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_137,"\"] is null (scope=\"",_136,"\")"].join(""));}return function(e){return _135(e,_134)?_136[_137].apply(_136,arguments||[]):undefined;};}return !_136?function(e){return _135(e,_134)?_137.apply(_136,arguments):undefined;}:function(e){return _135(e,_134)?_137.apply(_136,arguments||[]):undefined;};};lang.extend(_125.Shape,_125._eventsProcessing);_125.Container={_init:function(){this.children=[];this._batch=0;},openBatch:function(){return this;},closeBatch:function(){return this;},add:function(_138){var _139=_138.getParent();if(_139){_139.remove(_138,true);}this.children.push(_138);return _138._setParent(this,this._getRealMatrix());},remove:function(_13a,_13b){for(var i=0;i<this.children.length;++i){if(this.children[i]==_13a){if(_13b){}else{_13a.parent=null;_13a.parentMatrix=null;}_123(this.children,i);break;}}return this;},clear:function(_13c){var _13d;for(var i=0;i<this.children.length;++i){_13d=this.children[i];_13d.parent=null;_13d.parentMatrix=null;if(_13c){_13d.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _13e=null;arr.forEach(this.children,function(_13f){var bb=_13f.getBoundingBox();if(bb){var ct=_13f.getTransform();if(ct){bb=_122.multiplyRectangle(ct,bb);}if(_13e){_13e.x=Math.min(_13e.x,bb.x);_13e.y=Math.min(_13e.y,bb.y);_13e.endX=Math.max(_13e.endX,bb.x+bb.width);_13e.endY=Math.max(_13e.endY,bb.y+bb.height);}else{_13e={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_13e){_13e.width=_13e.endX-_13e.x;_13e.height=_13e.endY-_13e.y;}return _13e;}return null;},_moveChildToFront:function(_140){for(var i=0;i<this.children.length;++i){if(this.children[i]==_140){_123(this.children,i);this.children.push(_140);break;}}return this;},_moveChildToBack:function(_141){for(var i=0;i<this.children.length;++i){if(this.children[i]==_141){_123(this.children,i);this.children.unshift(_141);break;}}return this;}};_125.Surface=_11e("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_120.destroy);this._nodes=[];arr.forEach(this._events,function(h){if(h){h.remove();}});this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_120.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_142){},whenLoaded:function(_143,_144){var f=lang.hitch(_143,_144);if(this.isLoaded){f(this);}else{on.once(this,"load",function(_145){f(_145);});}}});lang.extend(_125.Surface,_125._eventsProcessing);_125.Rect=_11e("dojox.gfx.shape.Rect",_125.Shape,{constructor:function(_146){this.shape=g.getDefault("Rect");this.rawNode=_146;},getBoundingBox:function(){return this.shape;}});_125.Ellipse=_11e("dojox.gfx.shape.Ellipse",_125.Shape,{constructor:function(_147){this.shape=g.getDefault("Ellipse");this.rawNode=_147;},getBoundingBox:function(){if(!this.bbox){var _148=this.shape;this.bbox={x:_148.cx-_148.rx,y:_148.cy-_148.ry,width:2*_148.rx,height:2*_148.ry};}return this.bbox;}});_125.Circle=_11e("dojox.gfx.shape.Circle",_125.Shape,{constructor:function(_149){this.shape=g.getDefault("Circle");this.rawNode=_149;},getBoundingBox:function(){if(!this.bbox){var _14a=this.shape;this.bbox={x:_14a.cx-_14a.r,y:_14a.cy-_14a.r,width:2*_14a.r,height:2*_14a.r};}return this.bbox;}});_125.Line=_11e("dojox.gfx.shape.Line",_125.Shape,{constructor:function(_14b){this.shape=g.getDefault("Line");this.rawNode=_14b;},getBoundingBox:function(){if(!this.bbox){var _14c=this.shape;this.bbox={x:Math.min(_14c.x1,_14c.x2),y:Math.min(_14c.y1,_14c.y2),width:Math.abs(_14c.x2-_14c.x1),height:Math.abs(_14c.y2-_14c.y1)};}return this.bbox;}});_125.Polyline=_11e("dojox.gfx.shape.Polyline",_125.Shape,{constructor:function(_14d){this.shape=g.getDefault("Polyline");this.rawNode=_14d;},setShape:function(_14e,_14f){if(_14e&&_14e instanceof Array){this.inherited(arguments,[{points:_14e}]);if(_14f&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_14e]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _150=[];for(var i=0;i<l;i+=2){_150.push({x:p[i],y:p[i+1]});}this.shape.points=_150;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x){bbox.l=t.x;}if(bbox.r<t.x){bbox.r=t.x;}if(bbox.t>t.y){bbox.t=t.y;}if(bbox.b<t.y){bbox.b=t.y;}}this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}return this.bbox;}});_125.Image=_11e("dojox.gfx.shape.Image",_125.Shape,{constructor:function(_151){this.shape=g.getDefault("Image");this.rawNode=_151;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_125.Text=_11e(_125.Shape,{constructor:function(_152){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_152;},getFont:function(){return this.fontStyle;},setFont:function(_153){this.fontStyle=typeof _153=="string"?g.splitFontString(_153):g.makeParameters(g.defaultFont,_153);this._setFont();return this;},getBoundingBox:function(){var bbox=null,s=this.getShape();if(s.text){bbox=g._base._computeTextBoundingBox(this);}return bbox;}});_125.Creator={createShape:function(_154){switch(_154.type){case g.defaultPath.type:return this.createPath(_154);case g.defaultRect.type:return this.createRect(_154);case g.defaultCircle.type:return this.createCircle(_154);case g.defaultEllipse.type:return this.createEllipse(_154);case g.defaultLine.type:return this.createLine(_154);case g.defaultPolyline.type:return this.createPolyline(_154);case g.defaultImage.type:return this.createImage(_154);case g.defaultText.type:return this.createText(_154);case g.defaultTextPath.type:return this.createTextPath(_154);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(rect){return this.createObject(g.Rect,rect);},createEllipse:function(_155){return this.createObject(g.Ellipse,_155);},createCircle:function(_156){return this.createObject(g.Circle,_156);},createLine:function(line){return this.createObject(g.Line,line);},createPolyline:function(_157){return this.createObject(g.Polyline,_157);},createImage:function(_158){return this.createObject(g.Image,_158);},createText:function(text){return this.createObject(g.Text,text);},createPath:function(path){return this.createObject(g.Path,path);},createTextPath:function(text){return this.createObject(g.TextPath,{}).setText(text);},createObject:function(_159,_15a){return null;}};return _125;});},"dojox/gfx/matrix":function(){define(["./_base","dojo/_base/lang"],function(g,lang){var m=g.matrix={};var _15b={};m._degToRad=function(_15c){return _15b[_15c]||(_15b[_15c]=(Math.PI*_15c/180));};m._radToDeg=function(_15d){return _15d/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else{if(arg instanceof Array){if(arg.length>0){var _15e=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=_15e,r=m.normalize(arg[i]);_15e=new m.Matrix2D();_15e.xx=l.xx*r.xx+l.xy*r.yx;_15e.xy=l.xx*r.xy+l.xy*r.yy;_15e.yx=l.yx*r.xx+l.yy*r.yx;_15e.yy=l.yx*r.xy+l.yy*r.yy;_15e.dx=l.xx*r.dx+l.xy*r.dy+l.dx;_15e.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}lang.mixin(this,_15e);}}else{lang.mixin(this,arg);}}}};lang.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});lang.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(_15f){var c=Math.cos(_15f);var s=Math.sin(_15f);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(_160){return m.rotate(m._degToRad(_160));},skewX:function(_161){return new m.Matrix2D({xy:Math.tan(_161)});},skewXg:function(_162){return m.skewX(m._degToRad(_162));},skewY:function(_163){return new m.Matrix2D({yx:Math.tan(_163)});},skewYg:function(_164){return m.skewY(m._degToRad(_164));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(_165){return (_165 instanceof m.Matrix2D)?_165:new m.Matrix2D(_165);},isIdentity:function(_166){return _166.xx==1&&_166.xy==0&&_166.yx==0&&_166.yy==1&&_166.dx==0&&_166.dy==0;},clone:function(_167){var obj=new m.Matrix2D();for(var i in _167){if(typeof (_167[i])=="number"&&typeof (obj[i])=="number"&&obj[i]!=_167[i]){obj[i]=_167[i];}}return obj;},invert:function(_168){var M=m.normalize(_168),D=M.xx*M.yy-M.xy*M.yx;M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(_169,x,y){return {x:_169.xx*x+_169.xy*y+_169.dx,y:_169.yx*x+_169.yy*y+_169.dy};},multiplyPoint:function(_16a,a,b){var M=m.normalize(_16a);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}return m._multiplyPoint(M,a.x,a.y);},multiplyRectangle:function(_16b,rect){var M=m.normalize(_16b);rect=rect||{x:0,y:0,width:0,height:0};if(m.isIdentity(M)){return {x:rect.x,y:rect.y,width:rect.width,height:rect.height};}var p0=m.multiplyPoint(M,rect.x,rect.y),p1=m.multiplyPoint(M,rect.x,rect.y+rect.height),p2=m.multiplyPoint(M,rect.x+rect.width,rect.y),p3=m.multiplyPoint(M,rect.x+rect.width,rect.y+rect.height),minx=Math.min(p0.x,p1.x,p2.x,p3.x),miny=Math.min(p0.y,p1.y,p2.y,p3.y),maxx=Math.max(p0.x,p1.x,p2.x,p3.x),maxy=Math.max(p0.y,p1.y,p2.y,p3.y);return {x:minx,y:miny,width:maxx-minx,height:maxy-miny};},multiply:function(_16c){var M=m.normalize(_16c);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}return M;},_sandwich:function(_16d,x,y){return m.multiply(m.translate(x,y),_16d,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}return m._sandwich(m.scale(a,b),c.x,c.y);}return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(_16e,a,b){if(arguments.length>2){return m._sandwich(m.rotate(_16e),a,b);}return m._sandwich(m.rotate(_16e),a.x,a.y);},rotategAt:function(_16f,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(_16f),a,b);}return m._sandwich(m.rotateg(_16f),a.x,a.y);},skewXAt:function(_170,a,b){if(arguments.length>2){return m._sandwich(m.skewX(_170),a,b);}return m._sandwich(m.skewX(_170),a.x,a.y);},skewXgAt:function(_171,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(_171),a,b);}return m._sandwich(m.skewXg(_171),a.x,a.y);},skewYAt:function(_172,a,b){if(arguments.length>2){return m._sandwich(m.skewY(_172),a,b);}return m._sandwich(m.skewY(_172),a.x,a.y);},skewYgAt:function(_173,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(_173),a,b);}return m._sandwich(m.skewYg(_173),a.x,a.y);}});g.Matrix2D=m.Matrix2D;return m;});},"dojox/charting/SimpleTheme":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/Color","dojox/lang/utils","dojox/gfx/gradutils"],function(lang,arr,_174,_175,dlu,dgg){var _176=_174("dojox.charting.SimpleTheme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(_177){_177=_177||{};var def=_176.defaultTheme;arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){this[name]=lang.delegate(def[name],_177[name]);},this);if(_177.seriesThemes&&_177.seriesThemes.length){this.colors=null;this.seriesThemes=_177.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(_177.colors||_176.defaultColors).slice(0);}this.markerThemes=null;if(_177.markerThemes&&_177.markerThemes.length){this.markerThemes=_177.markerThemes.slice(0);}this.markers=_177.markers?lang.clone(_177.markers):lang.delegate(_176.defaultMarkers);this.noGradConv=_177.noGradConv;this.noRadialConv=_177.noRadialConv;if(_177.reverseFills){this.reverseFills();}this._current=0;this._buildMarkerArray();},clone:function(){var _178=new this.constructor({chart:this.chart,plotarea:this.plotarea,axis:this.axis,grid:this.grid,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,indicator:this.indicator,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv,pieInnerRadius:this.pieInnerRadius});arr.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){_178[name]=this[name];}},this);return _178;},clear:function(){this._current=0;},next:function(_179,_17a,_17b){var _17c=dlu.merge,_17d,_17e;if(this.colors){_17d=lang.delegate(this.series);_17e=lang.delegate(this.marker);var _17f=new _175(this.colors[this._current%this.colors.length]),old;if(_17d.stroke&&_17d.stroke.color){_17d.stroke=lang.delegate(_17d.stroke);old=new _175(_17d.stroke.color);_17d.stroke.color=new _175(_17f);_17d.stroke.color.a=old.a;}else{_17d.stroke={color:_17f};}if(_17e.stroke&&_17e.stroke.color){_17e.stroke=lang.delegate(_17e.stroke);old=new _175(_17e.stroke.color);_17e.stroke.color=new _175(_17f);_17e.stroke.color.a=old.a;}else{_17e.stroke={color:_17f};}if(!_17d.fill||_17d.fill.type){_17d.fill=_17f;}else{old=new _175(_17d.fill);_17d.fill=new _175(_17f);_17d.fill.a=old.a;}if(!_17e.fill||_17e.fill.type){_17e.fill=_17f;}else{old=new _175(_17e.fill);_17e.fill=new _175(_17f);_17e.fill.a=old.a;}}else{_17d=this.seriesThemes?_17c(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;_17e=this.markerThemes?_17c(this.marker,this.markerThemes[this._current%this.markerThemes.length]):_17d;}var _180=_17e&&_17e.symbol||this._markers[this._current%this._markers.length];var _181={series:_17d,marker:_17e,symbol:_180};++this._current;if(_17a){_181=this.addMixin(_181,_179,_17a);}if(_17b){_181=this.post(_181,_179);}return _181;},skip:function(){++this._current;},addMixin:function(_182,_183,_184,_185){if(lang.isArray(_184)){arr.forEach(_184,function(m){_182=this.addMixin(_182,_183,m);},this);}else{var t={};if("color" in _184){if(_183=="line"||_183=="area"){lang.setObject("series.stroke.color",_184.color,t);lang.setObject("marker.stroke.color",_184.color,t);}else{lang.setObject("series.fill",_184.color,t);}}arr.forEach(["stroke","outline","shadow","fill","filter","font","fontColor","labelWiring"],function(name){var _186="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=_186 in _184;if(name in _184){lang.setObject("series."+name,_184[name],t);if(!b){lang.setObject("marker."+name,_184[name],t);}}if(b){lang.setObject("marker."+name,_184[_186],t);}});if("marker" in _184){t.symbol=_184.marker;t.symbol=_184.marker;}_182=dlu.merge(_182,t);}if(_185){_182=this.post(_182,_183);}return _182;},post:function(_187,_188){var fill=_187.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(_188=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else{if(!this.noRadialConv&&fill.space=="shape"&&(_188=="slice"||_188=="circle")){t={type:"radial",cx:0,cy:0,r:100};}}if(t){return dlu.merge(_187,{series:{fill:t}});}}return _187;},getTick:function(name,_189){var tick=this.axis.tick,_18a=name+"Tick",_18b=dlu.merge;if(tick){if(this.axis[_18a]){tick=_18b(tick,this.axis[_18a]);}}else{tick=this.axis[_18a];}if(_189){if(tick){if(_189[_18a]){tick=_18b(tick,_189[_18a]);}}else{tick=_189[_18a];}}return tick;},inspectObjects:function(f){arr.forEach(["chart","plotarea","axis","grid","series","marker","indicator"],function(name){f(this[name]);},this);if(this.seriesThemes){arr.forEach(this.seriesThemes,f);}if(this.markerThemes){arr.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dgg.reverse(o.fill);}});},addMarker:function(name,_18c){this.markers[name]=_18c;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});lang.mixin(_176,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null,titleGap:20,titlePos:"top",titleFont:"normal normal bold 14pt Tahoma",titleFontColor:"#333",titleAlign:"middle"},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333",labelGap:4},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1},title:{gap:15,font:"normal normal normal 11pt Tahoma",fontColor:"#333",orientation:"axis"}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000",labelWiring:{width:1,color:"#ccc"}},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},indicator:{lineStroke:{width:1.5,color:"#333"},lineOutline:{width:0.1,color:"#ccc"},lineShadow:null,lineFill:null,stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",radius:3,font:"normal normal normal 10pt Tahoma",fontColor:"#000",markerFill:"#ccc",markerSymbol:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",markerStroke:{width:1.5,color:"#333"},markerOutline:{width:0.1,color:"#ccc"},markerShadow:null}}});return _176;});},"dojox/lang/utils":function(){define(["..","dojo/_base/lang"],function(_18d,lang){var du=lang.getObject("lang.utils",true,_18d);var _18e={},opts=Object.prototype.toString;var _18f=function(o){if(o){switch(opts.call(o)){case "[object Array]":return o.slice(0);case "[object Object]":return lang.delegate(o);}}return o;};lang.mixin(du,{coerceType:function(_190,_191){switch(typeof _190){case "number":return Number(eval("("+_191+")"));case "string":return String(_191);case "boolean":return Boolean(eval("("+_191+")"));}return eval("("+_191+")");},updateWithObject:function(_192,_193,conv){if(!_193){return _192;}for(var x in _192){if(x in _193&&!(x in _18e)){var t=_192[x];if(t&&typeof t=="object"){du.updateWithObject(t,_193[x],conv);}else{_192[x]=conv?du.coerceType(t,_193[x]):_18f(_193[x]);}}}return _192;},updateWithPattern:function(_194,_195,_196,conv){if(!_195||!_196){return _194;}for(var x in _196){if(x in _195&&!(x in _18e)){_194[x]=conv?du.coerceType(_196[x],_195[x]):_18f(_195[x]);}}return _194;},merge:function(_197,_198){if(_198){var _199=opts.call(_197),_19a=opts.call(_198),t,i,l,m;switch(_19a){case "[object Array]":if(_19a==_199){t=new Array(Math.max(_197.length,_198.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(_197[i],_198[i]);}return t;}return _198.slice(0);case "[object Object]":if(_19a==_199&&_197){t=lang.delegate(_197);for(i in _198){if(i in _197){l=_197[i];m=_198[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=lang.clone(_198[i]);}}return t;}return lang.clone(_198);}}return _198;}});return du;});},"dojox/gfx/gradutils":function(){define(["./_base","dojo/_base/lang","./matrix","dojo/_base/Color"],function(g,lang,m,_19b){var _19c=g.gradutils={};function _19d(o,c){if(o<=0){return c[0].color;}var len=c.length;if(o>=1){return c[len-1].color;}for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return _19b.blendColors(new _19b(prev.color),new _19b(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}return stop.color;}}return c[len-1].color;};_19c.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case "linear":var _19e=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),_19f=m.rotate(-_19e),_1a0=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(_1a0,pt),pf1=m.multiplyPoint(_1a0,fill.x1,fill.y1),pf2=m.multiplyPoint(_1a0,fill.x2,fill.y2),_1a1=m.multiplyPoint(_19f,pf2.x-pf1.x,pf2.y-pf1.y).x;o=m.multiplyPoint(_19f,p.x-pf1.x,p.y-pf1.y).x/_1a1;break;case "radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy;o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}return _19d(o,fill.colors);}return new _19b(fill||[0,0,0,0]);};_19c.reverse=function(fill){if(fill){switch(fill.type){case "linear":case "radial":fill=lang.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}n.sort(function(a,b){return a.offset-b.offset;});}break;}}return fill;};return _19c;});},"dojox/charting/Series":function(){define(["dojo/_base/lang","dojo/_base/declare","./Element"],function(lang,_1a2,_1a3){return _1a2("dojox.charting.Series",_1a3,{constructor:function(_1a4,data,_1a5){lang.mixin(this,_1a5);if(typeof this.plot!="string"){this.plot="default";}this.update(data);},clear:function(){this.dyn={};},update:function(data){if(lang.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}this.dirty=true;this.clear();}});});},"dojox/charting/axis2d/common":function(){define(["dojo/_base/lang","dojo/_base/window","dojo/dom-geometry","dojox/gfx","dojo/has"],function(lang,win,_1a6,g,has){var _1a7=lang.getObject("dojox.charting.axis2d.common",true);var _1a8=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var _1a9=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return _1a6.getMarginBox(n).w;}};return lang.mixin(_1a7,{createText:{gfx:function(_1aa,_1ab,x,y,_1ac,text,font,_1ad){return _1ab.createText({x:x,y:y,text:text,align:_1ac}).setFont(font).setFill(_1ad);},html:function(_1ae,_1af,x,y,_1b0,text,font,_1b1,_1b2){var p=win.doc.createElement("div"),s=p.style,_1b3;if(_1ae.getTextDir){p.dir=_1ae.getTextDir(text);}_1a8(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=_1b1;s.position="absolute";s.left="-10000px";win.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!_1b2){_1b3=_1a9(p);}if(p.dir=="rtl"){x+=_1b2?_1b2:_1b3;}win.body().removeChild(p);s.position="relative";if(_1b2){s.width=_1b2+"px";switch(_1b0){case "middle":s.textAlign="center";s.left=(x-_1b2/2)+"px";break;case "end":s.textAlign="right";s.left=(x-_1b2)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(_1b0){case "middle":s.left=Math.floor(x-_1b3/2)+"px";break;case "end":s.left=Math.floor(x-_1b3)+"px";break;default:s.left=Math.floor(x)+"px";break;}}s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=win.doc.createElement("div"),w=wrap.style;_1a8(w);w.width="0px";w.height="0px";wrap.appendChild(p);_1ae.node.insertBefore(wrap,_1ae.node.firstChild);if(has("dojo-bidi")){_1ae.htmlElementsRegistry.push([wrap,x,y,_1b0,text,font,_1b1]);}return wrap;}}});});},"dojox/charting/plot2d/common":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojox/gfx","dojox/lang/functional","../scaler/common"],function(lang,arr,_1b4,g,df,sc){var _1b5=lang.getObject("dojox.charting.plot2d.common",true);return lang.mixin(_1b5,{doIfLoaded:sc.doIfLoaded,makeStroke:function(_1b6){if(!_1b6){return _1b6;}if(typeof _1b6=="string"||_1b6 instanceof _1b4){_1b6={color:_1b6};}return g.makeParameters(g.defaultStroke,_1b6);},augmentColor:function(_1b7,_1b8){var t=new _1b4(_1b7),c=new _1b4(_1b8);c.a=t.a;return c;},augmentStroke:function(_1b9,_1ba){var s=_1b5.makeStroke(_1b9);if(s){s.color=_1b5.augmentColor(s.color,_1ba);}return s;},augmentFill:function(fill,_1bb){var fc,c=new _1b4(_1bb);if(typeof fill=="string"||fill instanceof _1b4){return _1b5.augmentColor(fill,_1bb);}return fill;},defaultStats:{vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY,hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(_1bc,_1bd){var _1be=lang.delegate(_1b5.defaultStats);for(var i=0;i<_1bc.length;++i){var run=_1bc[i];for(var j=0;j<run.data.length;j++){if(!_1bd(run.data[j])){if(typeof run.data[j]=="number"){var _1bf=_1be.vmin,_1c0=_1be.vmax;arr.forEach(run.data,function(val,i){if(!_1bd(val)){var x=i+1,y=val;if(isNaN(y)){y=0;}_1be.hmin=Math.min(_1be.hmin,x);_1be.hmax=Math.max(_1be.hmax,x);_1be.vmin=Math.min(_1be.vmin,y);_1be.vmax=Math.max(_1be.vmax,y);}});if("ymin" in run){_1be.vmin=Math.min(_1bf,run.ymin);}if("ymax" in run){_1be.vmax=Math.max(_1c0,run.ymax);}}else{var _1c1=_1be.hmin,_1c2=_1be.hmax,_1bf=_1be.vmin,_1c0=_1be.vmax;if(!("xmin" in run)||!("xmax" in run)||!("ymin" in run)||!("ymax" in run)){arr.forEach(run.data,function(val,i){if(!_1bd(val)){var x="x" in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}if(isNaN(y)){y=0;}_1be.hmin=Math.min(_1be.hmin,x);_1be.hmax=Math.max(_1be.hmax,x);_1be.vmin=Math.min(_1be.vmin,y);_1be.vmax=Math.max(_1be.vmax,y);}});}if("xmin" in run){_1be.hmin=Math.min(_1c1,run.xmin);}if("xmax" in run){_1be.hmax=Math.max(_1c2,run.xmax);}if("ymin" in run){_1be.vmin=Math.min(_1bf,run.ymin);}if("ymax" in run){_1be.vmax=Math.max(_1c0,run.ymax);}}break;}}}return _1be;},calculateBarSize:function(_1c3,opt,_1c4){if(!_1c4){_1c4=1;}var gap=opt.gap,size=(_1c3-2*gap)/_1c4;if("minBarSize" in opt){size=Math.max(size,opt.minBarSize);}if("maxBarSize" in opt){size=Math.min(size,opt.maxBarSize);}size=Math.max(size,1);gap=(_1c3-size*_1c4)/2;return {size:size,gap:gap};},collectStackedStats:function(_1c5){var _1c6=lang.clone(_1b5.defaultStats);if(_1c5.length){_1c6.hmin=Math.min(_1c6.hmin,1);_1c6.hmax=df.foldl(_1c5,"seed, run -> Math.max(seed, run.data.length)",_1c6.hmax);for(var i=0;i<_1c6.hmax;++i){var v=_1c5[0].data[i];v=v&&(typeof v=="number"?v:v.y);if(isNaN(v)){v=0;}_1c6.vmin=Math.min(_1c6.vmin,v);for(var j=1;j<_1c5.length;++j){var t=_1c5[j].data[i];t=t&&(typeof t=="number"?t:t.y);if(isNaN(t)){t=0;}v+=t;}_1c6.vmax=Math.max(_1c6.vmax,v);}}return _1c6;},curve:function(a,_1c7){var _1c8=a.slice(0);if(_1c7=="x"){_1c8[_1c8.length]=_1c8[0];}var p=arr.map(_1c8,function(item,i){if(i==0){return "M"+item.x+","+item.y;}if(!isNaN(_1c7)){var dx=item.x-_1c8[i-1].x,dy=_1c8[i-1].y;return "C"+(item.x-(_1c7-1)*(dx/_1c7))+","+dy+" "+(item.x-(dx/_1c7))+","+item.y+" "+item.x+","+item.y;}else{if(_1c7=="X"||_1c7=="x"||_1c7=="S"){var p0,p1=_1c8[i-1],p2=_1c8[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(_1c7=="x"){p0=_1c8[_1c8.length-2];}else{p0=p1;}f=1/3;}else{p0=_1c8[i-2];}if(i==(_1c8.length-1)){if(_1c7=="x"){p3=_1c8[1];}else{p3=p2;}f=1/3;}else{p3=_1c8[i+1];}var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var _1c9=p0p2*f;var _1ca=p1p3*f;if(_1c9>p1p2/2&&_1ca>p1p2/2){_1c9=p1p2/2;_1ca=p1p2/2;}else{if(_1c9>p1p2/2){_1c9=p1p2/2;_1ca=p1p2/2*p1p3/p0p2;}else{if(_1ca>p1p2/2){_1ca=p1p2/2;_1c9=p1p2/2*p0p2/p1p3;}}}if(_1c7=="S"){if(p0==p1){_1c9=0;}if(p2==p3){_1ca=0;}}bz1x=p1.x+_1c9*(p2.x-p0.x)/p0p2;bz1y=p1.y+_1c9*(p2.y-p0.y)/p0p2;bz2x=p2.x-_1ca*(p3.x-p1.x)/p1p3;bz2y=p2.y-_1ca*(p3.y-p1.y)/p1p3;}}return "C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");},getLabel:function(_1cb,_1cc,_1cd){return sc.doIfLoaded("dojo/number",function(_1ce){return (_1cc?_1ce.format(_1cb,{places:_1cd}):_1ce.format(_1cb))||"";},function(){return _1cc?_1cb.toFixed(_1cd):_1cb.toString();});},purgeGroup:function(item){return item.purgeGroup();}});});},"dojox/lang/functional":function(){define(["./functional/lambda","./functional/array","./functional/object"],function(df){return df;});},"dojox/lang/functional/lambda":function(){define(["../..","dojo/_base/lang","dojo/_base/array"],function(_1cf,lang,arr){var df=lang.getObject("lang.functional",true,_1cf);var _1d0={};var _1d1="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}return r;};var _1d2=function(s){var args=[],_1d3=_1d1.call(s,/\s*->\s*/m);if(_1d3.length>1){while(_1d3.length){s=_1d3.pop();args=_1d3.pop().split(/\s*,\s*|\s+/m);if(_1d3.length){_1d3.push("(function("+args.join(", ")+"){ return ("+s+"); })");}}}else{if(s.match(/\b_\b/)){args=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){args.push("$1");s="$1"+s;}if(r){args.push("$2");s=s+"$2";}}else{var vars=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};arr.forEach(vars,function(v){if(!t.hasOwnProperty(v)){args.push(v);t[v]=1;}});}}}return {args:args,body:s};};var _1d4=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}return x;}:function(x){return x;};};lang.mixin(df,{rawLambda:function(s){return _1d2(s);},buildLambda:function(s){var l=_1d2(s);return "function("+l.args.join(",")+"){return ("+l.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}if(s instanceof Array){return _1d4(s);}if(_1d0.hasOwnProperty(s)){return _1d0[s];}var l=_1d2(s);return _1d0[s]=new Function(l.args,"return ("+l.body+");");},clearLambdaCache:function(){_1d0={};}});return df;});},"dojox/lang/functional/array":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/array","./lambda"],function(_1d5,lang,arr,df){var _1d6={};lang.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var t=[],v,i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in _1d6)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}}return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a)){}}else{for(i in a){if(!(i in _1d6)){f.call(o,a[i],i,a);}}}}return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a))){}}else{t=[];for(i in a){if(!(i in _1d6)){t.push(f.call(o,a[i],i,a));}}}}return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in _1d6)){if(!f.call(o,a[i],i,a)){return false;}}}}}return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1d5.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in _1d6)){if(f.call(o,a[i],i,a)){return true;}}}}}return false;}});return df;});},"dojox/lang/functional/object":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_1d7,lang,df){var _1d8={};lang.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in _1d8)){t.push(i);}}return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in _1d8)){t.push(obj[i]);}}return t;},filterIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in _1d8)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}return t;},forIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);for(var i in obj){if(!(i in _1d8)){f.call(o,obj[i],i,obj);}}return o;},mapIn:function(obj,f,o){o=o||_1d7.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in _1d8)){t[i]=f.call(o,obj[i],i,obj);}}return t;}});return df;});},"dojox/charting/scaler/common":function(){define(["dojo/_base/lang"],function(lang){var eq=function(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};var _1d9=lang.getObject("dojox.charting.scaler.common",true);var _1da={};return lang.mixin(_1d9,{doIfLoaded:function(_1db,_1dc,_1dd){if(_1da[_1db]===undefined){try{_1da[_1db]=require(_1db);}catch(e){_1da[_1db]=null;}}if(_1da[_1db]){return _1dc(_1da[_1db]);}else{return _1dd();}},getNumericLabel:function(_1de,_1df,_1e0){var def="";_1d9.doIfLoaded("dojo/number",function(_1e1){def=(_1e0.fixed?_1e1.format(_1de,{places:_1df<0?-_1df:0}):_1e1.format(_1de))||"";},function(){def=_1e0.fixed?_1de.toFixed(_1df<0?-_1df:0):_1de.toString();});if(_1e0.labelFunc){var r=_1e0.labelFunc(def,_1de,_1df);if(r){return r;}}if(_1e0.labels){var l=_1e0.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<_1de){lo=mid+1;}else{hi=mid;}}if(lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}lo+=2;if(lo<l.length&&eq(l[lo].value,_1de)){return l[lo].text;}}return def;}});});},"dojox/lang/functional/fold":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/kernel","./lambda"],function(lang,arr,_1e2,df){var _1e3={};lang.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var i,n;if(lang.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}else{for(i in a){if(!(i in _1e3)){z=f.call(o,z,a[i],i,a);}}}}return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var z,i,n;if(lang.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a)){}}}else{var _1e4=true;for(i in a){if(!(i in _1e3)){if(_1e4){z=a[i];_1e4=false;}else{z=f.call(o,z,a[i],i,a);}}}}}return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e2.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a)){}return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||_1e2.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z)){}return t;}});});},"dojox/lang/functional/reversed":function(){define(["dojo/_base/lang","dojo/_base/kernel","./lambda"],function(lang,_1e5,df){lang.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i){}},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i){}return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_1e5.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}return false;}});return df;});},"dojo/store/Memory":function(){define(["../_base/declare","./util/QueryResults","./util/SimpleQueryEngine"],function(_1e6,_1e7,_1e8){var base=null;return _1e6("dojo.store.Memory",base,{constructor:function(_1e9){for(var i in _1e9){this[i]=_1e9[i];}this.setData(this.data||[]);},data:null,idProperty:"id",index:null,queryEngine:_1e8,get:function(id){return this.data[this.index[id]];},getIdentity:function(_1ea){return _1ea[this.idProperty];},put:function(_1eb,_1ec){var data=this.data;var _1ed=this.index;var _1ee=this.idProperty;var id=_1eb[_1ee]=(_1ec&&"id" in _1ec)?_1ec.id:_1ee in _1eb?_1eb[_1ee]:Math.random();var _1ef=data.length;var _1f0;var _1f1;var _1f2=id in _1ed?"update":"add";if(_1f2==="update"){if(_1ec&&_1ec.overwrite===false){throw new Error("Object already exists");}else{_1f1=_1ed[id];_1ef=_1f1;}}if(_1ec&&"before" in _1ec){if(_1ec.before==null){_1f0=data.length;if(_1f2==="update"){--_1f0;}}else{_1f0=_1ed[this.getIdentity(_1ec.before)];if(_1f1<_1f0){--_1f0;}}}else{_1f0=_1ef;}if(_1f0===_1f1){data[_1f0]=_1eb;}else{if(_1f1!==undefined){data.splice(_1f1,1);}data.splice(_1f0,0,_1eb);this._rebuildIndex(_1f1===undefined?_1f0:Math.min(_1f1,_1f0));}return id;},add:function(_1f3,_1f4){(_1f4=_1f4||{}).overwrite=false;return this.put(_1f3,_1f4);},remove:function(id){var _1f5=this.index;var data=this.data;if(id in _1f5){data.splice(_1f5[id],1);this.index={};this._rebuildIndex();return true;}},query:function(_1f6,_1f7){return _1e7(this.queryEngine(_1f6,_1f7)(this.data));},setData:function(data){if(data.items){this.idProperty=data.identifier||this.idProperty;data=this.data=data.items;}else{this.data=data;}this.index={};this._rebuildIndex();},_rebuildIndex:function(_1f8){var data=this.data;var _1f9=data.length;var i;_1f8=_1f8||0;for(i=_1f8;i<_1f9;i++){this.index[data[i][this.idProperty]]=i;}}});});},"dojo/store/util/QueryResults":function(){define(["../../_base/array","../../_base/lang","../../when"],function(_1fa,lang,when){var _1fb=function(_1fc){if(!_1fc){return _1fc;}var _1fd=!!_1fc.then;if(_1fd){_1fc=lang.delegate(_1fc);}function _1fe(_1ff){_1fc[_1ff]=function(){var args=arguments;var _200=when(_1fc,function(_201){Array.prototype.unshift.call(args,_201);return _1fb(_1fa[_1ff].apply(_1fa,args));});if(_1ff!=="forEach"||_1fd){return _200;}};};_1fe("forEach");_1fe("filter");_1fe("map");if(_1fc.total==null){_1fc.total=when(_1fc,function(_202){return _202.length;});}return _1fc;};lang.setObject("dojo.store.util.QueryResults",_1fb);return _1fb;});},"dojo/store/util/SimpleQueryEngine":function(){define(["../../_base/array"],function(_203){return function(_204,_205){switch(typeof _204){default:throw new Error("Can not query with a "+typeof _204);case "object":case "undefined":var _206=_204;_204=function(_207){for(var key in _206){var _208=_206[key];if(_208&&_208.test){if(!_208.test(_207[key],_207)){return false;}}else{if(_208!=_207[key]){return false;}}}return true;};break;case "string":if(!this[_204]){throw new Error("No filter function "+_204+" was found in store");}_204=this[_204];case "function":}function _209(_20a){var _20b=_203.filter(_20a,_204);var _20c=_205&&_205.sort;if(_20c){_20b.sort(typeof _20c=="function"?_20c:function(a,b){for(var sort,i=0;sort=_20c[i];i++){var _20d=a[sort.attribute];var _20e=b[sort.attribute];_20d=_20d!=null?_20d.valueOf():_20d;_20e=_20e!=null?_20e.valueOf():_20e;if(_20d!=_20e){return !!sort.descending==(_20d==null||_20d>_20e)?-1:1;}}return 0;});}if(_205&&(_205.start||_205.count)){var _20f=_20b.length;_20b=_20b.slice(_205.start||0,(_205.start||0)+(_205.count||Infinity));_20b.total=_20f;}return _20b;};_209.matches=_204;return _209;};});},"dojox/charting/StoreSeries":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/Deferred"],function(arr,_210,_211){return _210("dojox.charting.StoreSeries",null,{constructor:function(_212,_213,_214){this.store=_212;this.kwArgs=_213;if(_214){if(typeof _214=="function"){this.value=_214;}else{if(typeof _214=="object"){this.value=function(_215){var o={};for(var key in _214){o[key]=_215[_214[key]];}return o;};}else{this.value=function(_216){return _216[_214];};}}}else{this.value=function(_217){return _217.value;};}this.data=[];this._initialRendering=true;this.fetch();},destroy:function(){if(this.observeHandle){this.observeHandle.remove();}},setSeriesObject:function(_218){this.series=_218;},fetch:function(_219,_21a){var self=this;if(this.observeHandle){this.observeHandle.remove();}var _21b=this.store.query(_219||this.kwArgs.query,_21a||this.kwArgs);_211.when(_21b,function(_21c){self.objects=_21c;_21d();});if(_21b.observe){this.observeHandle=_21b.observe(_21d,true);}function _21d(){self.data=arr.map(self.objects,function(_21e){return self.value(_21e,self.store);});self._pushDataChanges();};},_pushDataChanges:function(){if(this.series){this.series.chart.updateSeries(this.series.name,this,this._initialRendering);this._initialRendering=false;this.series.chart.delayedRender();}}});});},"dojox/charting/Theme":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","./SimpleTheme","dojox/color/_base","dojox/color/Palette","dojox/gfx/gradutils"],function(lang,_21f,_220,_221,_222,_223){var _224=_21f("dojox.charting.Theme",_221,{});lang.mixin(_224,{defineColors:function(_225){_225=_225||{};var l,c=[],n=_225.num||5;if(_225.colors){l=_225.colors.length;for(var i=0;i<n;i++){c.push(_225.colors[i%l]);}return c;}if(_225.hue){var s=_225.saturation||100,st=_225.low||30,end=_225.high||90;l=(end+st)/2;return _223.generate(_222.fromHsv(_225.hue,s,l),"monochromatic").colors;}if(_225.generator){return _222.Palette.generate(_225.base,_225.generator).colors;}return c;},generateGradient:function(_226,_227,_228){var fill=lang.delegate(_226);fill.colors=[{offset:0,color:_227},{offset:1,color:_228}];return fill;},generateHslColor:function(_229,_22a){_229=new _220(_229);var hsl=_229.toHsl(),_22b=_222.fromHsl(hsl.h,hsl.s,_22a);_22b.a=_229.a;return _22b;},generateHslGradient:function(_22c,_22d,_22e,_22f){_22c=new _220(_22c);var hsl=_22c.toHsl(),_230=_222.fromHsl(hsl.h,hsl.s,_22e),_231=_222.fromHsl(hsl.h,hsl.s,_22f);_230.a=_231.a=_22c.a;return _224.generateGradient(_22d,_230,_231);}});_224.defaultMarkers=_221.defaultMarkers;_224.defaultColors=_221.defaultColors;_224.defaultTheme=_221.defaultTheme;return _224;});},"dojox/color/_base":function(){define(["../main","dojo/_base/lang","dojo/_base/Color","dojo/colors"],function(_232,lang,_233,_234){var cx=lang.getObject("color",true,_232);cx.Color=_233;cx.blend=_233.blendColors;cx.fromRgb=_233.fromRgb;cx.fromHex=_233.fromHex;cx.fromArray=_233.fromArray;cx.fromString=_233.fromString;cx.greyscale=_234.makeGrey;lang.mixin(cx,{fromCmy:function(cyan,_235,_236){if(lang.isArray(cyan)){_235=cyan[1],_236=cyan[2],cyan=cyan[0];}else{if(lang.isObject(cyan)){_235=cyan.m,_236=cyan.y,cyan=cyan.c;}}cyan/=100,_235/=100,_236/=100;var r=1-cyan,g=1-_235,b=1-_236;return new _233({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,_237,_238,_239){if(lang.isArray(cyan)){_237=cyan[1],_238=cyan[2],_239=cyan[3],cyan=cyan[0];}else{if(lang.isObject(cyan)){_237=cyan.m,_238=cyan.y,_239=cyan.b,cyan=cyan.c;}}cyan/=100,_237/=100,_238/=100,_239/=100;var r,g,b;r=1-Math.min(1,cyan*(1-_239)+_239);g=1-Math.min(1,_237*(1-_239)+_239);b=1-Math.min(1,_238*(1-_239)+_239);return new _233({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,_23a,_23b){if(lang.isArray(hue)){_23a=hue[1],_23b=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_23a=hue.s,_23b=hue.l,hue=hue.h;}}_23a/=100;_23b/=100;while(hue<0){hue+=360;}while(hue>=360){hue-=360;}var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else{if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}}r=2*_23a*Math.min(r,1)+(1-_23a);g=2*_23a*Math.min(g,1)+(1-_23a);b=2*_23a*Math.min(b,1)+(1-_23a);if(_23b<0.5){r*=_23b,g*=_23b,b*=_23b;}else{r=(1-_23b)*r+2*_23b-1;g=(1-_23b)*g+2*_23b-1;b=(1-_23b)*b+2*_23b-1;}return new _233({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});cx.fromHsv=function(hue,_23c,_23d){if(lang.isArray(hue)){_23c=hue[1],_23d=hue[2],hue=hue[0];}else{if(lang.isObject(hue)){_23c=hue.s,_23d=hue.v,hue=hue.h;}}if(hue==360){hue=0;}_23c/=100;_23d/=100;var r,g,b;if(_23c==0){r=_23d,b=_23d,g=_23d;}else{var _23e=hue/60,i=Math.floor(_23e),f=_23e-i;var p=_23d*(1-_23c);var q=_23d*(1-(_23c*f));var t=_23d*(1-(_23c*(1-f)));switch(i){case 0:r=_23d,g=t,b=p;break;case 1:r=q,g=_23d,b=p;break;case 2:r=p,g=_23d,b=t;break;case 3:r=p,g=q,b=_23d;break;case 4:r=t,g=p,b=_23d;break;case 5:r=_23d,g=p,b=q;break;}}return new _233({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});};lang.extend(_233,{toCmy:function(){var cyan=1-(this.r/255),_23f=1-(this.g/255),_240=1-(this.b/255);return {c:Math.round(cyan*100),m:Math.round(_23f*100),y:Math.round(_240*100)};},toCmyk:function(){var cyan,_241,_242,_243;var r=this.r/255,g=this.g/255,b=this.b/255;_243=Math.min(1-r,1-g,1-b);cyan=(1-r-_243)/(1-_243);_241=(1-g-_243)/(1-_243);_242=(1-b-_243)/(1-_243);return {c:Math.round(cyan*100),m:Math.round(_241*100),y:Math.round(_242*100),b:Math.round(_243*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _244=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=_244/((l<0.5)?(2*l):(2-2*l));}if(_244>0){if(max==r&&max!=g){h+=(g-b)/_244;}if(max==g&&max!=b){h+=(2+(b-r)/_244);}if(max==b&&max!=r){h+=(4+(r-g)/_244);}h*=60;}return {h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var _245=max-min;var h=null,s=(max==0)?0:(_245/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/_245;}else{if(g==max){h=120+60*(b-r)/_245;}else{h=240+60*(r-g)/_245;}}if(h<0){h+=360;}}return {h:h,s:Math.round(s*100),v:Math.round(max*100)};}});return cx;});},"dojo/colors":function(){define(["./_base/kernel","./_base/lang","./_base/Color","./_base/array"],function(dojo,lang,_246,_247){var _248={};lang.setObject("dojo.colors",_248);var _249=function(m1,m2,h){if(h<0){++h;}if(h>1){--h;}var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}if(2*h<1){return m2;}if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}return m1;};dojo.colorFromRgb=_246.fromRgb=function(_24a,obj){var m=_24a.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=_247.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}return _246.fromArray(a,obj);}return _246.fromArray(c,obj);}if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[_249(m1,m2,H+1/3)*256,_249(m1,m2,H)*256,_249(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}return _246.fromArray(a,obj);}}return null;};var _24b=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};_246.prototype.sanitize=function(){var t=this;t.r=Math.round(_24b(t.r,0,255));t.g=Math.round(_24b(t.g,0,255));t.b=Math.round(_24b(t.b,0,255));t.a=_24b(t.a,0,1);return this;};_248.makeGrey=_246.makeGrey=function(g,a){return _246.fromArray([g,g,g,a]);};lang.mixin(_246.named,{"aliceblue":[240,248,255],"antiquewhite":[250,235,215],"aquamarine":[127,255,212],"azure":[240,255,255],"beige":[245,245,220],"bisque":[255,228,196],"blanchedalmond":[255,235,205],"blueviolet":[138,43,226],"brown":[165,42,42],"burlywood":[222,184,135],"cadetblue":[95,158,160],"chartreuse":[127,255,0],"chocolate":[210,105,30],"coral":[255,127,80],"cornflowerblue":[100,149,237],"cornsilk":[255,248,220],"crimson":[220,20,60],"cyan":[0,255,255],"darkblue":[0,0,139],"darkcyan":[0,139,139],"darkgoldenrod":[184,134,11],"darkgray":[169,169,169],"darkgreen":[0,100,0],"darkgrey":[169,169,169],"darkkhaki":[189,183,107],"darkmagenta":[139,0,139],"darkolivegreen":[85,107,47],"darkorange":[255,140,0],"darkorchid":[153,50,204],"darkred":[139,0,0],"darksalmon":[233,150,122],"darkseagreen":[143,188,143],"darkslateblue":[72,61,139],"darkslategray":[47,79,79],"darkslategrey":[47,79,79],"darkturquoise":[0,206,209],"darkviolet":[148,0,211],"deeppink":[255,20,147],"deepskyblue":[0,191,255],"dimgray":[105,105,105],"dimgrey":[105,105,105],"dodgerblue":[30,144,255],"firebrick":[178,34,34],"floralwhite":[255,250,240],"forestgreen":[34,139,34],"gainsboro":[220,220,220],"ghostwhite":[248,248,255],"gold":[255,215,0],"goldenrod":[218,165,32],"greenyellow":[173,255,47],"grey":[128,128,128],"honeydew":[240,255,240],"hotpink":[255,105,180],"indianred":[205,92,92],"indigo":[75,0,130],"ivory":[255,255,240],"khaki":[240,230,140],"lavender":[230,230,250],"lavenderblush":[255,240,245],"lawngreen":[124,252,0],"lemonchiffon":[255,250,205],"lightblue":[173,216,230],"lightcoral":[240,128,128],"lightcyan":[224,255,255],"lightgoldenrodyellow":[250,250,210],"lightgray":[211,211,211],"lightgreen":[144,238,144],"lightgrey":[211,211,211],"lightpink":[255,182,193],"lightsalmon":[255,160,122],"lightseagreen":[32,178,170],"lightskyblue":[135,206,250],"lightslategray":[119,136,153],"lightslategrey":[119,136,153],"lightsteelblue":[176,196,222],"lightyellow":[255,255,224],"limegreen":[50,205,50],"linen":[250,240,230],"magenta":[255,0,255],"mediumaquamarine":[102,205,170],"mediumblue":[0,0,205],"mediumorchid":[186,85,211],"mediumpurple":[147,112,219],"mediumseagreen":[60,179,113],"mediumslateblue":[123,104,238],"mediumspringgreen":[0,250,154],"mediumturquoise":[72,209,204],"mediumvioletred":[199,21,133],"midnightblue":[25,25,112],"mintcream":[245,255,250],"mistyrose":[255,228,225],"moccasin":[255,228,181],"navajowhite":[255,222,173],"oldlace":[253,245,230],"olivedrab":[107,142,35],"orange":[255,165,0],"orangered":[255,69,0],"orchid":[218,112,214],"palegoldenrod":[238,232,170],"palegreen":[152,251,152],"paleturquoise":[175,238,238],"palevioletred":[219,112,147],"papayawhip":[255,239,213],"peachpuff":[255,218,185],"peru":[205,133,63],"pink":[255,192,203],"plum":[221,160,221],"powderblue":[176,224,230],"rosybrown":[188,143,143],"royalblue":[65,105,225],"saddlebrown":[139,69,19],"salmon":[250,128,114],"sandybrown":[244,164,96],"seagreen":[46,139,87],"seashell":[255,245,238],"sienna":[160,82,45],"skyblue":[135,206,235],"slateblue":[106,90,205],"slategray":[112,128,144],"slategrey":[112,128,144],"snow":[255,250,250],"springgreen":[0,255,127],"steelblue":[70,130,180],"tan":[210,180,140],"thistle":[216,191,216],"tomato":[255,99,71],"turquoise":[64,224,208],"violet":[238,130,238],"wheat":[245,222,179],"whitesmoke":[245,245,245],"yellowgreen":[154,205,50]});return _246;});},"dojox/color/Palette":function(){define(["dojo/_base/lang","dojo/_base/array","./_base"],function(lang,arr,dxc){dxc.Palette=function(base){this.colors=[];if(base instanceof dxc.Palette){this.colors=base.colors.slice(0);}else{if(base instanceof dxc.Color){this.colors=[null,null,base,null,null];}else{if(lang.isArray(base)){this.colors=arr.map(base.slice(0),function(item){if(lang.isString(item)){return new dxc.Color(item);}return item;});}else{if(lang.isString(base)){this.colors=[null,null,new dxc.Color(base),null,null];}}}}};function _24c(p,_24d,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var r=(_24d=="dr")?item.r+val:item.r,g=(_24d=="dg")?item.g+val:item.g,b=(_24d=="db")?item.b+val:item.b,a=(_24d=="da")?item.a+val:item.a;ret.colors.push(new dxc.Color({r:Math.min(255,Math.max(0,r)),g:Math.min(255,Math.max(0,g)),b:Math.min(255,Math.max(0,b)),a:Math.min(1,Math.max(0,a))}));});return ret;};function tCMY(p,_24e,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmy(),c=(_24e=="dc")?o.c+val:o.c,m=(_24e=="dm")?o.m+val:o.m,y=(_24e=="dy")?o.y+val:o.y;ret.colors.push(dxc.fromCmy(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y))));});return ret;};function _24f(p,_250,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toCmyk(),c=(_250=="dc")?o.c+val:o.c,m=(_250=="dm")?o.m+val:o.m,y=(_250=="dy")?o.y+val:o.y,k=(_250=="dk")?o.b+val:o.b;ret.colors.push(dxc.fromCmyk(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y)),Math.min(100,Math.max(0,k))));});return ret;};function tHSL(p,_251,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsl(),h=(_251=="dh")?o.h+val:o.h,s=(_251=="ds")?o.s+val:o.s,l=(_251=="dl")?o.l+val:o.l;ret.colors.push(dxc.fromHsl(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,l))));});return ret;};function tHSV(p,_252,val){var ret=new dxc.Palette();ret.colors=[];arr.forEach(p.colors,function(item){var o=item.toHsv(),h=(_252=="dh")?o.h+val:o.h,s=(_252=="ds")?o.s+val:o.s,v=(_252=="dv")?o.v+val:o.v;ret.colors.push(dxc.fromHsv(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,v))));});return ret;};function _253(val,low,high){return high-((high-val)*((high-low)/high));};lang.extend(dxc.Palette,{transform:function(_254){var fn=_24c;if(_254.use){var use=_254.use.toLowerCase();if(use.indexOf("hs")==0){if(use.charAt(2)=="l"){fn=tHSL;}else{fn=tHSV;}}else{if(use.indexOf("cmy")==0){if(use.charAt(3)=="k"){fn=_24f;}else{fn=tCMY;}}}}else{if("dc" in _254||"dm" in _254||"dy" in _254){if("dk" in _254){fn=_24f;}else{fn=tCMY;}}else{if("dh" in _254||"ds" in _254){if("dv" in _254){fn=tHSV;}else{fn=tHSL;}}}}var _255=this;for(var p in _254){if(p=="use"){continue;}_255=fn(_255,p,_254[p]);}return _255;},clone:function(){return new dxc.Palette(this);}});lang.mixin(dxc.Palette,{generators:{analogous:function(args){var high=args.high||60,low=args.low||18,base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h=[(hsv.h+low+360)%360,(hsv.h+Math.round(low/2)+360)%360,hsv.h,(hsv.h-Math.round(high/2)+360)%360,(hsv.h-high+360)%360];var s1=Math.max(10,(hsv.s<=95)?hsv.s+5:(100-(hsv.s-95))),s2=(hsv.s>1)?hsv.s-1:21-hsv.s,v1=(hsv.v>=92)?hsv.v-9:Math.max(hsv.v+9,20),v2=(hsv.v<=90)?Math.max(hsv.v+5,20):(95+Math.ceil((hsv.v-90)/2)),s=[s1,s2,hsv.s,s1,s1],v=[v1,v2,hsv.v,v1,v2];return new dxc.Palette(arr.map(h,function(hue,i){return dxc.fromHsv(hue,s[i],v[i]);}));},monochromatic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s1=(hsv.s-30>9)?hsv.s-30:hsv.s+30,s2=hsv.s,v1=_253(hsv.v,20,100),v2=(hsv.v-20>20)?hsv.v-20:hsv.v+60,v3=(hsv.v-50>20)?hsv.v-50:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v3),base,dxc.fromHsv(hsv.h,s1,v3),dxc.fromHsv(hsv.h,s2,v2)]);},triadic:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=(hsv.h+57+360)%360,h2=(hsv.h-157+360)%360,s1=(hsv.s>20)?hsv.s-10:hsv.s+10,s2=(hsv.s>90)?hsv.s-10:hsv.s+10,s3=(hsv.s>95)?hsv.s-5:hsv.s+5,v1=(hsv.v-20>20)?hsv.v-20:hsv.v+20,v2=(hsv.v-30>20)?hsv.v-30:hsv.v+30,v3=(hsv.v-30>70)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,hsv.v),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h2,s2,v1),dxc.fromHsv(h2,s3,v3)]);},complementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,s1=Math.max(hsv.s-10,0),s2=_253(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(hsv.h,s1,v1),dxc.fromHsv(hsv.h,s2,v2),base,dxc.fromHsv(h1,s3,v2),dxc.fromHsv(h1,hsv.s,hsv.v)]);},splitComplementary:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,_256=args.da||30,hsv=base.toHsv();var _257=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,h1=(_257-_256+360)%360,h2=(_257+_256)%360,s1=Math.max(hsv.s-10,0),s2=_253(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v2),dxc.fromHsv(h2,hsv.s,hsv.v)]);},compound:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+18<360)?(hsv.h*2)+18:Math.floor(hsv.h/2)-18,h2=((hsv.h*2)+120<360)?(hsv.h*2)+120:Math.floor(hsv.h/2)-120,h3=((hsv.h*2)+99<360)?(hsv.h*2)+99:Math.floor(hsv.h/2)-99,s1=(hsv.s-40>10)?hsv.s-40:hsv.s+40,s2=(hsv.s-10>80)?hsv.s-10:hsv.s+10,s3=(hsv.s-25>10)?hsv.s-25:hsv.s+25,v1=(hsv.v-40>10)?hsv.v-40:hsv.v+40,v2=(hsv.v-20>80)?hsv.v-20:hsv.v+20,v3=Math.max(hsv.v,20);return new dxc.Palette([dxc.fromHsv(h1,s1,v1),dxc.fromHsv(h1,s2,v2),base,dxc.fromHsv(h2,s3,v3),dxc.fromHsv(h3,s2,v2)]);},shades:function(args){var base=lang.isString(args.base)?new dxc.Color(args.base):args.base,hsv=base.toHsv();var s=(hsv.s==100&&hsv.v==0)?0:hsv.s,v1=(hsv.v-50>20)?hsv.v-50:hsv.v+30,v2=(hsv.v-25>=20)?hsv.v-25:hsv.v+55,v3=(hsv.v-75>=20)?hsv.v-75:hsv.v+5,v4=Math.max(hsv.v-10,20);return new dxc.Palette([new dxc.fromHsv(hsv.h,s,v1),new dxc.fromHsv(hsv.h,s,v2),base,new dxc.fromHsv(hsv.h,s,v3),new dxc.fromHsv(hsv.h,s,v4)]);}},generate:function(base,type){if(lang.isFunction(type)){return type({base:base});}else{if(dxc.Palette.generators[type]){return dxc.Palette.generators[type]({base:base});}}throw new Error("dojox.color.Palette.generate: the specified generator ('"+type+"') does not exist.");}});return dxc.Palette;});},"dojox/charting/action2d/PlotAction":function(){define(["dojo/_base/connect","dojo/_base/declare","./Base","dojo/fx/easing","dojox/lang/functional"],function(hub,_258,Base,dfe,df){var _259=400,_25a=dfe.backOut;return _258("dojox.charting.action2d.PlotAction",Base,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(_25b,plot,_25c){this.anim={};if(!_25c){_25c={};}this.duration=_25c.duration?_25c.duration:_259;this.easing=_25c.easing?_25c.easing:_25a;},connect:function(){this.handle=this.chart.connectToPlot(this.plot.name,this,"process");},disconnect:function(){if(this.handle){hub.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.inherited(arguments);df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});});},"dojox/charting/action2d/Base":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/Evented"],function(lang,_25d,_25e){return _25d("dojox.charting.action2d.Base",_25e,{constructor:function(_25f,plot){this.chart=_25f;this.plot=plot?(lang.isString(plot)?this.chart.getPlot(plot):plot):this.chart.getPlot("default");},connect:function(){},disconnect:function(){},destroy:function(){this.disconnect();}});});},"dojo/fx/easing":function(){define(["../_base/lang"],function(lang){var _260={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}return -1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}n-=2;return (Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return -1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}n-=2;return -1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;}n-=2;return (Math.pow(n,5)+2)/2;},sineIn:function(n){return -1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return -1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return (n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return (n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}if(n==1){return 1;}n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}--n;return (-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return -1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return -1/2*(Math.sqrt(1-Math.pow(n,2))-1);}n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return (Math.pow(n,2)*((s+1)*n-s))/2;}n-=2;return (Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;n=n-1;return -1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}var p=0.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0){return 0;}n=n*2;if(n==2){return 1;}var p=0.3*1.5;var s=p/4;if(n<1){n-=1;return -0.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}n-=1;return 0.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return (1-_260.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else{if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+0.75;}else{if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+0.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+0.984375;}}}return l;},bounceInOut:function(n){if(n<0.5){return _260.bounceIn(n*2)/2;}return (_260.bounceOut(n*2-1)/2)+0.5;}};lang.setObject("dojo.fx.easing",_260);return _260;});},"dojox/charting/axis2d/Default":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/sniff","dojo/_base/declare","dojo/_base/connect","dojo/dom-geometry","./Invisible","../scaler/linear","./common","dojox/gfx","dojox/lang/utils","dojox/lang/functional","dojo/has!dojo-bidi?../bidi/axis2d/Default"],function(lang,arr,has,_261,_262,_263,_264,lin,_265,g,du,df,_266){var _267=45;var _268=_261(has("dojo-bidi")?"dojox.charting.axis2d.NonBidiDefault":"dojox.charting.axis2d.Default",_264,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true,enableCache:false,dropLabels:true,labelSizeChange:false,position:"leftOrBottom"},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,maxLabelCharCount:0,trailingSymbol:null,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:"",title:"",titleGap:0,titleFont:"",titleFontColor:"",titleOrientation:""},constructor:function(_269,_26a){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_26a);du.updateWithPattern(this.opt,_26a,this.optionalParams);if(this.opt.enableCache){this._textFreePool=[];this._lineFreePool=[];this._textUsePool=[];this._lineUsePool=[];}this._invalidMaxLabelSize=true;if(!(_26a&&("position" in _26a))){this.opt.position=this.opt.leftBottom?"leftOrBottom":"rightOrTop";}this.renderingOptions={"shape-rendering":"crispEdges"};},setWindow:function(_26b,_26c){if(_26b!=this.scale){this._invalidMaxLabelSize=true;}return this.inherited(arguments);},_groupLabelWidth:function(_26d,font,_26e){if(!_26d.length){return 0;}if(_26d.length>50){_26d.length=50;}if(lang.isObject(_26d[0])){_26d=df.map(_26d,function(_26f){return _26f.text;});}if(_26e){_26d=df.map(_26d,function(_270){return lang.trim(_270).length==0?"":_270.substring(0,_26e)+this.trailingSymbol;},this);}var s=_26d.join("<br>");return g._base._getTextBox(s,{font:font}).w||0;},_getMaxLabelSize:function(min,max,span,_271,font,size){if(this._maxLabelSize==null&&arguments.length==6){var o=this.opt;this.scaler.minMinorStep=this._prevMinMinorStep=0;var ob=lang.clone(o);delete ob.to;delete ob.from;var sb=lin.buildScaler(min,max,span,ob,o.to-o.from);sb.minMinorStep=0;this._majorStart=sb.major.start;var tb=lin.buildTicks(sb,o);if(size&&tb){var _272=0,_273=0;var _274=function(tick){if(tick.label){this.push(tick.label);}};var _275=[];if(this.opt.majorLabels){arr.forEach(tb.major,_274,_275);_272=this._groupLabelWidth(_275,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_272=Math.min(ob.maxLabelSize,_272);}}_275=[];if(this.opt.dropLabels&&this.opt.minorLabels){arr.forEach(tb.minor,_274,_275);_273=this._groupLabelWidth(_275,font,ob.maxLabelCharCount);if(ob.maxLabelSize){_273=Math.min(ob.maxLabelSize,_273);}}this._maxLabelSize={majLabelW:_272,minLabelW:_273,majLabelH:size,minLabelH:size};}else{this._maxLabelSize=null;}}return this._maxLabelSize;},calculate:function(min,max,span){this.inherited(arguments);this.scaler.minMinorStep=this._prevMinMinorStep;if((this._invalidMaxLabelSize||span!=this._oldSpan)&&(min!=Infinity&&max!=-Infinity)){this._invalidMaxLabelSize=false;if(this.opt.labelSizeChange){this._maxLabelSize=null;}this._oldSpan=span;var o=this.opt;var ta=this.chart.theme.axis,_276=o.rotation%360,_277=this.chart.theme.axis.tick.labelGap,font=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),size=font?g.normalizedLength(g.splitFontString(font).size):0,_278=this._getMaxLabelSize(min,max,span,_276,font,size);if(typeof _277!="number"){_277=4;}if(_278&&o.dropLabels){var cosr=Math.abs(Math.cos(_276*Math.PI/180)),sinr=Math.abs(Math.sin(_276*Math.PI/180));var _279,_27a;if(_276<0){_276+=360;}switch(_276){case 0:case 180:if(this.vertical){_279=_27a=size;}else{_279=_278.majLabelW;_27a=_278.minLabelW;}break;case 90:case 270:if(this.vertical){_279=_278.majLabelW;_27a=_278.minLabelW;}else{_279=_27a=size;}break;default:_279=this.vertical?Math.min(_278.majLabelW,size/cosr):Math.min(_278.majLabelW,size/sinr);var gap1=Math.sqrt(_278.minLabelW*_278.minLabelW+size*size),gap2=this.vertical?size*cosr+_278.minLabelW*sinr:_278.minLabelW*cosr+size*sinr;_27a=Math.min(gap1,gap2);break;}this.scaler.minMinorStep=this._prevMinMinorStep=Math.max(_279,_27a)+_277;var _27b=this.scaler.minMinorStep<=this.scaler.minor.tick*this.scaler.bounds.scale;if(!_27b){this._skipInterval=Math.floor((_279+_277)/(this.scaler.major.tick*this.scaler.bounds.scale));}else{this._skipInterval=0;}}else{this._skipInterval=0;}}this.ticks=lin.buildTicks(this.scaler,this.opt);return this;},getOffsets:function(){var s=this.scaler,_27c={l:0,r:0,t:0,b:0};if(!s){return _27c;}var o=this.opt,ta=this.chart.theme.axis,_27d=this.chart.theme.axis.tick.labelGap,_27e=o.titleFont||(ta.title&&ta.title.font),_27f=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap),_280=this.chart.theme.getTick("major",o),_281=this.chart.theme.getTick("minor",o),_282=_27e?g.normalizedLength(g.splitFontString(_27e).size):0,_283=o.rotation%360,_284=o.position,_285=_284!=="rightOrTop",cosr=Math.abs(Math.cos(_283*Math.PI/180)),sinr=Math.abs(Math.sin(_283*Math.PI/180));this.trailingSymbol=(o.trailingSymbol===undefined||o.trailingSymbol===null)?this.trailingSymbol:o.trailingSymbol;if(typeof _27d!="number"){_27d=4;}if(_283<0){_283+=360;}var _286=this._getMaxLabelSize();if(_286){var side;var _287=Math.ceil(Math.max(_286.majLabelW,_286.minLabelW))+1,size=Math.ceil(Math.max(_286.majLabelH,_286.minLabelH))+1;if(this.vertical){side=_285?"l":"r";switch(_283){case 0:case 180:_27c[side]=_284==="center"?0:_287;_27c.t=_27c.b=size/2;break;case 90:case 270:_27c[side]=size;_27c.t=_27c.b=_287/2;break;default:if(_283<=_267||(180<_283&&_283<=(180+_267))){_27c[side]=size*sinr/2+_287*cosr;_27c[_285?"t":"b"]=size*cosr/2+_287*sinr;_27c[_285?"b":"t"]=size*cosr/2;}else{if(_283>(360-_267)||(180>_283&&_283>(180-_267))){_27c[side]=size*sinr/2+_287*cosr;_27c[_285?"b":"t"]=size*cosr/2+_287*sinr;_27c[_285?"t":"b"]=size*cosr/2;}else{if(_283<90||(180<_283&&_283<270)){_27c[side]=size*sinr+_287*cosr;_27c[_285?"t":"b"]=size*cosr+_287*sinr;}else{_27c[side]=size*sinr+_287*cosr;_27c[_285?"b":"t"]=size*cosr+_287*sinr;}}}break;}if(_284==="center"){_27c[side]=0;}else{_27c[side]+=_27d+Math.max(_280.length>0?_280.length:0,_281.length>0?_281.length:0)+(o.title?(_282+_27f):0);}}else{side=_285?"b":"t";switch(_283){case 0:case 180:_27c[side]=_284==="center"?0:size;_27c.l=_27c.r=_287/2;break;case 90:case 270:_27c[side]=_287;_27c.l=_27c.r=size/2;break;default:if((90-_267)<=_283&&_283<=90||(270-_267)<=_283&&_283<=270){_27c[side]=size*cosr/2+_287*sinr;_27c[_285?"r":"l"]=size*sinr/2+_287*cosr;_27c[_285?"l":"r"]=size*sinr/2;}else{if(90<=_283&&_283<=(90+_267)||270<=_283&&_283<=(270+_267)){_27c[side]=size*cosr/2+_287*sinr;_27c[_285?"l":"r"]=size*sinr/2+_287*cosr;_27c[_285?"r":"l"]=size*sinr/2;}else{if(_283<_267||(180<_283&&_283<(180+_267))){_27c[side]=size*cosr+_287*sinr;_27c[_285?"r":"l"]=size*sinr+_287*cosr;}else{_27c[side]=size*cosr+_287*sinr;_27c[_285?"l":"r"]=size*sinr+_287*cosr;}}}break;}if(_284==="center"){_27c[side]=0;}else{_27c[side]+=_27d+Math.max(_280.length>0?_280.length:0,_281.length>0?_281.length:0)+(o.title?(_282+_27f):0);}}}return _27c;},cleanGroup:function(_288){if(this.opt.enableCache&&this.group){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._textFreePool=this._textFreePool.concat(this._textUsePool);this._textUsePool=[];}this.inherited(arguments);},createText:function(_289,_28a,x,y,_28b,_28c,font,_28d,_28e){if(!this.opt.enableCache||_289=="html"){return _265.createText[_289](this.chart,_28a,x,y,_28b,_28c,font,_28d,_28e);}var text;if(this._textFreePool.length>0){text=this._textFreePool.pop();text.setShape({x:x,y:y,text:_28c,align:_28b});_28a.add(text);}else{text=_265.createText[_289](this.chart,_28a,x,y,_28b,_28c,font,_28d);}this._textUsePool.push(text);return text;},createLine:function(_28f,_290){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_290);_28f.add(line);}else{line=_28f.createLine(_290);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},render:function(dim,_291){var _292=this._isRtl();if(!this.dirty||!this.scaler){return this;}var o=this.opt,ta=this.chart.theme.axis,_293=o.position,_294=_293!=="rightOrTop",_295=o.rotation%360,_296,stop,_297,_298=0,_299,_29a,_29b,_29c,_29d,_29e,_29f=this.chart.theme.axis.tick.labelGap,_2a0=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),_2a1=o.titleFont||(ta.title&&ta.title.font),_2a2=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",_2a3=o.titleFontColor||(ta.title&&ta.title.fontColor)||"black",_2a4=(o.titleGap==0)?0:o.titleGap||(ta.title&&ta.title.gap)||15,_2a5=o.titleOrientation||(ta.title&&ta.title.orientation)||"axis",_2a6=this.chart.theme.getTick("major",o),_2a7=this.chart.theme.getTick("minor",o),_2a8=this.chart.theme.getTick("micro",o),_2a9="stroke" in o?o.stroke:ta.stroke,size=_2a0?g.normalizedLength(g.splitFontString(_2a0).size):0,cosr=Math.abs(Math.cos(_295*Math.PI/180)),sinr=Math.abs(Math.sin(_295*Math.PI/180)),_2aa=_2a1?g.normalizedLength(g.splitFontString(_2a1).size):0;if(typeof _29f!="number"){_29f=4;}if(_295<0){_295+=360;}var _2ab=this._getMaxLabelSize();_2ab=_2ab&&_2ab.majLabelW;if(this.vertical){_296={y:dim.height-_291.b};stop={y:_291.t};_297={y:(dim.height-_291.b+_291.t)/2};_299=size*sinr+(_2ab||0)*cosr+_29f+Math.max(_2a6.length>0?_2a6.length:0,_2a7.length>0?_2a7.length:0)+_2aa+_2a4;_29a={x:0,y:-1};_29d={x:0,y:0};_29b={x:1,y:0};_29c={x:_29f,y:0};switch(_295){case 0:_29e="end";_29d.y=size*0.4;break;case 90:_29e="middle";_29d.x=-size;break;case 180:_29e="start";_29d.y=-size*0.4;break;case 270:_29e="middle";break;default:if(_295<_267){_29e="end";_29d.y=size*0.4;}else{if(_295<90){_29e="end";_29d.y=size*0.4;}else{if(_295<(180-_267)){_29e="start";}else{if(_295<(180+_267)){_29e="start";_29d.y=-size*0.4;}else{if(_295<270){_29e="start";_29d.x=_294?0:size*0.4;}else{if(_295<(360-_267)){_29e="end";_29d.x=_294?0:size*0.4;}else{_29e="end";_29d.y=size*0.4;}}}}}}}if(_294){_296.x=stop.x=_293==="center"?dim.width/2:_291.l;_298=(_2a5&&_2a5=="away")?90:270;_297.x=_291.l-_299+(_298==270?_2aa:0);_29b.x=-1;_29c.x=-_29c.x;}else{_296.x=stop.x=dim.width-_291.r;_298=(_2a5&&_2a5=="axis")?90:270;_297.x=dim.width-_291.r+_299-(_298==270?0:_2aa);switch(_29e){case "start":_29e="end";break;case "end":_29e="start";break;case "middle":_29d.x+=size;break;}}}else{_296={x:_291.l};stop={x:dim.width-_291.r};_297={x:(dim.width-_291.r+_291.l)/2};_299=size*cosr+(_2ab||0)*sinr+_29f+Math.max(_2a6.length>0?_2a6.length:0,_2a7.length>0?_2a7.length:0)+_2aa+_2a4;_29a={x:_292?-1:1,y:0};_29d={x:0,y:0};_29b={x:0,y:1};_29c={x:0,y:_29f};switch(_295){case 0:_29e="middle";_29d.y=size;break;case 90:_29e="start";_29d.x=-size*0.4;break;case 180:_29e="middle";break;case 270:_29e="end";_29d.x=size*0.4;break;default:if(_295<(90-_267)){_29e="start";_29d.y=_294?size:0;}else{if(_295<(90+_267)){_29e="start";_29d.x=-size*0.4;}else{if(_295<180){_29e="start";_29d.y=_294?0:-size;}else{if(_295<(270-_267)){_29e="end";_29d.y=_294?0:-size;}else{if(_295<(270+_267)){_29e="end";_29d.y=_294?size*0.4:0;}else{_29e="end";_29d.y=_294?size:0;}}}}}}if(_294){_296.y=stop.y=_293==="center"?dim.height/2:dim.height-_291.b;_298=(_2a5&&_2a5=="axis")?180:0;_297.y=dim.height-_291.b+_299-(_298?_2aa:0);}else{_296.y=stop.y=_291.t;_298=(_2a5&&_2a5=="away")?180:0;_297.y=_291.t-_299+(_298?0:_2aa);_29b.y=-1;_29c.y=-_29c.y;switch(_29e){case "start":_29e="end";break;case "end":_29e="start";break;case "middle":_29d.y-=size;break;}}}this.cleanGroup();var s=this.group,c=this.scaler,t=this.ticks,f=lin.getTransformerFromModel(this.scaler),_2ac=(!o.title||!_298)&&!_295&&this.opt.htmlLabels&&!has("ie")&&!has("opera")?"html":"gfx",dx=_29b.x*_2a6.length,dy=_29b.y*_2a6.length,skip=this._skipInterval;s.createLine({x1:_296.x,y1:_296.y,x2:stop.x,y2:stop.y}).setStroke(_2a9);if(o.title){var _2ad=_265.createText[_2ac](this.chart,s,_297.x,_297.y,"middle",o.title,_2a1,_2a3);if(_2ac=="html"){this.htmlElements.push(_2ad);}else{_2ad.setTransform(g.matrix.rotategAt(_298,_297.x,_297.y));}}if(t==null){this.dirty=false;return this;}var rel=(t.major.length>0)?(t.major[0].value-this._majorStart)/c.major.tick:0;var _2ae=this.opt.majorLabels;arr.forEach(t.major,function(tick,i){var _2af=f(tick.value),elem,x=(_292?stop.x:_296.x)+_29a.x*_2af,y=_296.y+_29a.y*_2af;i+=rel;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_2a6);if(tick.label&&(!skip||(i-(1+skip))%(1+skip)==0)){var _2b0=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_2a0,o.maxLabelCharCount):{text:tick.label,truncated:false};_2b0=o.maxLabelSize?this.getTextWithLimitLength(_2b0.text,_2a0,o.maxLabelSize,_2b0.truncated):_2b0;elem=this.createText(_2ac,s,x+(_2a6.length>0?dx:0)+_29c.x+(_295?0:_29d.x),y+(_2a6.length>0?dy:0)+_29c.y+(_295?0:_29d.y),_29e,_2b0.text,_2a0,_2a2);if(_2b0.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_2ac);}_2b0.truncated&&this.labelTooltip(elem,this.chart,tick.label,_2b0.text,_2a0,_2ac);if(_2ac=="html"){this.htmlElements.push(elem);}else{if(_295){elem.setTransform([{dx:_29d.x,dy:_29d.y},g.matrix.rotategAt(_295,x+(_2a6.length>0?dx:0)+_29c.x,y+(_2a6.length>0?dy:0)+_29c.y)]);}}}},this);dx=_29b.x*_2a7.length;dy=_29b.y*_2a7.length;_2ae=this.opt.minorLabels&&c.minMinorStep<=c.minor.tick*c.bounds.scale;arr.forEach(t.minor,function(tick){var _2b1=f(tick.value),elem,x=(_292?stop.x:_296.x)+_29a.x*_2b1,y=_296.y+_29a.y*_2b1;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_2a7);if(_2ae&&tick.label){var _2b2=o.maxLabelCharCount?this.getTextWithLimitCharCount(tick.label,_2a0,o.maxLabelCharCount):{text:tick.label,truncated:false};_2b2=o.maxLabelSize?this.getTextWithLimitLength(_2b2.text,_2a0,o.maxLabelSize,_2b2.truncated):_2b2;elem=this.createText(_2ac,s,x+(_2a7.length>0?dx:0)+_29c.x+(_295?0:_29d.x),y+(_2a7.length>0?dy:0)+_29c.y+(_295?0:_29d.y),_29e,_2b2.text,_2a0,_2a2);if(_2b2.truncated){this.chart.formatTruncatedLabel(elem,tick.label,_2ac);}_2b2.truncated&&this.labelTooltip(elem,this.chart,tick.label,_2b2.text,_2a0,_2ac);if(_2ac=="html"){this.htmlElements.push(elem);}else{if(_295){elem.setTransform([{dx:_29d.x,dy:_29d.y},g.matrix.rotategAt(_295,x+(_2a7.length>0?dx:0)+_29c.x,y+(_2a7.length>0?dy:0)+_29c.y)]);}}}},this);dx=_29b.x*_2a8.length;dy=_29b.y*_2a8.length;arr.forEach(t.micro,function(tick){var _2b3=f(tick.value),x=_296.x+_29a.x*_2b3,y=_296.y+_29a.y*_2b3;this.createLine(s,{x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(_2a8);},this);this.dirty=false;return this;},labelTooltip:function(elem,_2b4,_2b5,_2b6,font,_2b7){var _2b8=["dijit/Tooltip"];var _2b9={type:"rect"},_2ba=["above","below"],_2bb=g._base._getTextBox(_2b6,{font:font}).w||0,_2bc=font?g.normalizedLength(g.splitFontString(font).size):0;if(_2b7=="html"){lang.mixin(_2b9,_263.position(elem.firstChild,true));_2b9.width=Math.ceil(_2bb);_2b9.height=Math.ceil(_2bc);this._events.push({shape:dojo,handle:_262.connect(elem.firstChild,"onmouseover",this,function(e){require(_2b8,function(_2bd){_2bd.show(_2b5,_2b9,_2ba);});})});this._events.push({shape:dojo,handle:_262.connect(elem.firstChild,"onmouseout",this,function(e){require(_2b8,function(_2be){_2be.hide(_2b9);});})});}else{var shp=elem.getShape(),lt=_2b4.getCoords();_2b9=lang.mixin(_2b9,{x:shp.x-_2bb/2,y:shp.y});_2b9.x+=lt.x;_2b9.y+=lt.y;_2b9.x=Math.round(_2b9.x);_2b9.y=Math.round(_2b9.y);_2b9.width=Math.ceil(_2bb);_2b9.height=Math.ceil(_2bc);this._events.push({shape:elem,handle:elem.connect("onmouseenter",this,function(e){require(_2b8,function(_2bf){_2bf.show(_2b5,_2b9,_2ba);});})});this._events.push({shape:elem,handle:elem.connect("onmouseleave",this,function(e){require(_2b8,function(_2c0){_2c0.hide(_2b9);});})});}},_isRtl:function(){return false;}});return has("dojo-bidi")?_261("dojox.charting.axis2d.Default",[_268,_266]):_268;});},"dojox/charting/axis2d/Invisible":function(){define(["dojo/_base/lang","dojo/_base/declare","./Base","../scaler/linear","dojox/lang/utils"],function(lang,_2c1,Base,lin,du){return _2c1("dojox.charting.axis2d.Invisible",Base,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1},constructor:function(_2c2,_2c3){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_2c3);du.updateWithPattern(this.opt,_2c3,this.optionalParams);},dependOnData:function(){return !("min" in this.opt)||!("max" in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return "scaler" in this&&!(this.dirty&&this.dependOnData());},setWindow:function(_2c4,_2c5){this.scale=_2c4;this.offset=_2c5;return this.clear();},getWindowScale:function(){return "scale" in this?this.scale:1;},getWindowOffset:function(){return "offset" in this?this.offset:0;},calculate:function(min,max,span,_2c6){if(this.initialized()){return this;}var o=this.opt;this.labels=o.labels;this.scaler=(_2c6||lin).buildScaler(min,max,span,o);var tsb=this.scaler.bounds;if("scale" in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else{if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}}this.offset=o.from-tsb.lower;}this.scaler=(_2c6||lin).buildScaler(min,max,span,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});});},"dojox/charting/axis2d/Base":function(){define(["dojo/_base/declare","../Element"],function(_2c7,_2c8){return _2c7("dojox.charting.axis2d.Base",_2c8,{constructor:function(_2c9,_2ca){this.vertical=_2ca&&_2ca.vertical;this.opt={};this.opt.min=_2ca&&_2ca.min;this.opt.max=_2ca&&_2ca.max;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return {l:0,r:0,t:0,b:0};},render:function(dim,_2cb){this.dirty=false;return this;},isNullValue:function(_2cc){return false;},naturalBaseline:0});});},"dojox/charting/scaler/linear":function(){define(["dojo/_base/lang","./common"],function(lang,_2cd){var _2ce=lang.getObject("dojox.charting.scaler.linear",true);var _2cf=3,_2d0=_2cd.getNumericLabel;function _2d1(val,text){val=val.toLowerCase();for(var i=text.length-1;i>=0;--i){if(val===text[i]){return true;}}return false;};var _2d2=function(min,max,_2d3,_2d4,_2d5,_2d6,span){_2d3=lang.delegate(_2d3);if(!_2d4){if(_2d3.fixUpper=="major"){_2d3.fixUpper="minor";}if(_2d3.fixLower=="major"){_2d3.fixLower="minor";}}if(!_2d5){if(_2d3.fixUpper=="minor"){_2d3.fixUpper="micro";}if(_2d3.fixLower=="minor"){_2d3.fixLower="micro";}}if(!_2d6){if(_2d3.fixUpper=="micro"){_2d3.fixUpper="none";}if(_2d3.fixLower=="micro"){_2d3.fixLower="none";}}var _2d7=_2d1(_2d3.fixLower,["major"])?Math.floor(_2d3.min/_2d4)*_2d4:_2d1(_2d3.fixLower,["minor"])?Math.floor(_2d3.min/_2d5)*_2d5:_2d1(_2d3.fixLower,["micro"])?Math.floor(_2d3.min/_2d6)*_2d6:_2d3.min,_2d8=_2d1(_2d3.fixUpper,["major"])?Math.ceil(_2d3.max/_2d4)*_2d4:_2d1(_2d3.fixUpper,["minor"])?Math.ceil(_2d3.max/_2d5)*_2d5:_2d1(_2d3.fixUpper,["micro"])?Math.ceil(_2d3.max/_2d6)*_2d6:_2d3.max;if(_2d3.useMin){min=_2d7;}if(_2d3.useMax){max=_2d8;}var _2d9=(!_2d4||_2d3.useMin&&_2d1(_2d3.fixLower,["major"]))?min:Math.ceil(min/_2d4)*_2d4,_2da=(!_2d5||_2d3.useMin&&_2d1(_2d3.fixLower,["major","minor"]))?min:Math.ceil(min/_2d5)*_2d5,_2db=(!_2d6||_2d3.useMin&&_2d1(_2d3.fixLower,["major","minor","micro"]))?min:Math.ceil(min/_2d6)*_2d6,_2dc=!_2d4?0:(_2d3.useMax&&_2d1(_2d3.fixUpper,["major"])?Math.round((max-_2d9)/_2d4):Math.floor((max-_2d9)/_2d4))+1,_2dd=!_2d5?0:(_2d3.useMax&&_2d1(_2d3.fixUpper,["major","minor"])?Math.round((max-_2da)/_2d5):Math.floor((max-_2da)/_2d5))+1,_2de=!_2d6?0:(_2d3.useMax&&_2d1(_2d3.fixUpper,["major","minor","micro"])?Math.round((max-_2db)/_2d6):Math.floor((max-_2db)/_2d6))+1,_2df=_2d5?Math.round(_2d4/_2d5):0,_2e0=_2d6?Math.round(_2d5/_2d6):0,_2e1=_2d4?Math.floor(Math.log(_2d4)/Math.LN10):0,_2e2=_2d5?Math.floor(Math.log(_2d5)/Math.LN10):0,_2e3=span/(max-min);if(!isFinite(_2e3)){_2e3=1;}return {bounds:{lower:_2d7,upper:_2d8,from:min,to:max,scale:_2e3,span:span},major:{tick:_2d4,start:_2d9,count:_2dc,prec:_2e1},minor:{tick:_2d5,start:_2da,count:_2dd,prec:_2e2},micro:{tick:_2d6,start:_2db,count:_2de,prec:0},minorPerMajor:_2df,microPerMinor:_2e0,scaler:_2ce};};return lang.mixin(_2ce,{buildScaler:function(min,max,span,_2e4,_2e5,_2e6){var h={fixUpper:"none",fixLower:"none",natural:false};if(_2e4){if("fixUpper" in _2e4){h.fixUpper=String(_2e4.fixUpper);}if("fixLower" in _2e4){h.fixLower=String(_2e4.fixLower);}if("natural" in _2e4){h.natural=Boolean(_2e4.natural);}}_2e6=!_2e6||_2e6<_2cf?_2cf:_2e6;if("min" in _2e4){min=_2e4.min;}if("max" in _2e4){max=_2e4.max;}if(_2e4.includeZero){if(min>0){min=0;}if(max<0){max=0;}}h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from" in _2e4){min=_2e4.from;h.useMin=false;}if("to" in _2e4){max=_2e4.to;h.useMax=false;}if(max<=min){return _2d2(min,max,h,0,0,0,span);}if(!_2e5){_2e5=max-min;}var mag=Math.floor(Math.log(_2e5)/Math.LN10),_2e7=_2e4&&("majorTickStep" in _2e4)?_2e4.majorTickStep:Math.pow(10,mag),_2e8=0,_2e9=0,_2ea;if(_2e4&&("minorTickStep" in _2e4)){_2e8=_2e4.minorTickStep;}else{do{_2e8=_2e7/10;if(!h.natural||_2e8>0.9){_2ea=_2d2(min,max,h,_2e7,_2e8,0,span);if(_2ea.bounds.scale*_2ea.minor.tick>_2e6){break;}}_2e8=_2e7/5;if(!h.natural||_2e8>0.9){_2ea=_2d2(min,max,h,_2e7,_2e8,0,span);if(_2ea.bounds.scale*_2ea.minor.tick>_2e6){break;}}_2e8=_2e7/2;if(!h.natural||_2e8>0.9){_2ea=_2d2(min,max,h,_2e7,_2e8,0,span);if(_2ea.bounds.scale*_2ea.minor.tick>_2e6){break;}}return _2d2(min,max,h,_2e7,0,0,span);}while(false);}if(_2e4&&("microTickStep" in _2e4)){_2e9=_2e4.microTickStep;_2ea=_2d2(min,max,h,_2e7,_2e8,_2e9,span);}else{do{_2e9=_2e8/10;if(!h.natural||_2e9>0.9){_2ea=_2d2(min,max,h,_2e7,_2e8,_2e9,span);if(_2ea.bounds.scale*_2ea.micro.tick>_2cf){break;}}_2e9=_2e8/5;if(!h.natural||_2e9>0.9){_2ea=_2d2(min,max,h,_2e7,_2e8,_2e9,span);if(_2ea.bounds.scale*_2ea.micro.tick>_2cf){break;}}_2e9=_2e8/2;if(!h.natural||_2e9>0.9){_2ea=_2d2(min,max,h,_2e7,_2e8,_2e9,span);if(_2ea.bounds.scale*_2ea.micro.tick>_2cf){break;}}_2e9=0;}while(false);}return _2e9?_2ea:_2d2(min,max,h,_2e7,_2e8,0,span);},buildTicks:function(_2eb,_2ec){var step,next,tick,_2ed=_2eb.major.start,_2ee=_2eb.minor.start,_2ef=_2eb.micro.start;if(_2ec.microTicks&&_2eb.micro.tick){step=_2eb.micro.tick,next=_2ef;}else{if(_2ec.minorTicks&&_2eb.minor.tick){step=_2eb.minor.tick,next=_2ee;}else{if(_2eb.major.tick){step=_2eb.major.tick,next=_2ed;}else{return null;}}}var _2f0=1/_2eb.bounds.scale;if(_2eb.bounds.to<=_2eb.bounds.from||isNaN(_2f0)||!isFinite(_2f0)||step<=0||isNaN(step)||!isFinite(step)){return null;}var _2f1=[],_2f2=[],_2f3=[];while(next<=_2eb.bounds.to+_2f0){if(Math.abs(_2ed-next)<step/2){tick={value:_2ed};if(_2ec.majorLabels){tick.label=_2d0(_2ed,_2eb.major.prec,_2ec);}_2f1.push(tick);_2ed+=_2eb.major.tick;_2ee+=_2eb.minor.tick;_2ef+=_2eb.micro.tick;}else{if(Math.abs(_2ee-next)<step/2){if(_2ec.minorTicks){tick={value:_2ee};if(_2ec.minorLabels&&(_2eb.minMinorStep<=_2eb.minor.tick*_2eb.bounds.scale)){tick.label=_2d0(_2ee,_2eb.minor.prec,_2ec);}_2f2.push(tick);}_2ee+=_2eb.minor.tick;_2ef+=_2eb.micro.tick;}else{if(_2ec.microTicks){_2f3.push({value:_2ef});}_2ef+=_2eb.micro.tick;}}next+=step;}return {major:_2f1,minor:_2f2,micro:_2f3};},getTransformerFromModel:function(_2f4){var _2f5=_2f4.bounds.from,_2f6=_2f4.bounds.scale;return function(x){return (x-_2f5)*_2f6;};},getTransformerFromPlot:function(_2f7){var _2f8=_2f7.bounds.from,_2f9=_2f7.bounds.scale;return function(x){return x/_2f9+_2f8;};}});});},"dojox/charting/plot2d/Columns":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/utils","dojox/gfx/fx"],function(lang,arr,_2fa,has,_2fb,_2fc,dc,df,du,fx){var _2fd=function(){return false;};return _2fa("dojox.charting.plot2d.Columns",[_2fb,_2fc],{defaultParams:{gap:0,animate:null,enableCache:false},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:""},constructor:function(_2fe,_2ff){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_2ff);du.updateWithPattern(this.opt,_2ff,this.optionalParams);this.animate=this.opt.animate;this.renderingOptions={"shape-rendering":"crispEdges"};},getSeriesStats:function(){var _300=dc.collectSimpleStats(this.series,lang.hitch(this,"isNullValue"));_300.hmin-=0.5;_300.hmax+=0.5;return _300;},createRect:function(run,_301,_302){var rect;if(this.opt.enableCache&&run._rectFreePool.length>0){rect=run._rectFreePool.pop();rect.setShape(_302);_301.add(rect);}else{rect=_301.createRect(_302);}if(this.opt.enableCache){run._rectUsePool.push(rect);}return rect;},render:function(dim,_303){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_303);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,dc.purgeGroup);this._eventSeries={};this.cleanGroup();s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_304=Math.max(this._vScaler.bounds.lower,this._vAxis?this._vAxis.naturalBaseline:0),_305=vt(_304),_306=this.events(),bar=this.getBarProperties();var z=0;var _307=this.extractValues(this._hScaler);_307=this.rearrangeValues(_307,vt,_305);for(var i=0;i<this.series.length;i++){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._rectFreePool=(run._rectFreePool?run._rectFreePool:[]).concat(run._rectUsePool?run._rectUsePool:[]);run._rectUsePool=[];}var _308=t.next("column",[this.opt,run]),_309=new Array(run.data.length);if(run.hidden){run.dyn.fill=_308.series.fill;continue;}s=run.group;var _30a=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var min=_30a?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0;var max=_30a?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length;for(var j=min;j<max;++j){var _30b=run.data[j];if(!this.isNullValue(_30b)){var val=this.getValue(_30b,j,i,_30a),vv=vt(val.y),h=_307[i][j],_30c,_30d;if(this.opt.styleFunc||typeof _30b!="number"){var _30e=typeof _30b!="number"?[_30b]:[];if(this.opt.styleFunc){_30e.push(this.opt.styleFunc(_30b));}_30c=t.addMixin(_308,"column",_30e,true);}else{_30c=t.post(_308,"column");}if(bar.width>=1){var rect={x:_303.l+ht(val.x+0.5)+bar.gap+bar.thickness*z,y:dim.height-_303.b-_305-Math.max(h,0),width:bar.width,height:Math.abs(h)};if(_30c.series.shadow){var _30f=lang.clone(rect);_30f.x+=_30c.series.shadow.dx;_30f.y+=_30c.series.shadow.dy;_30d=this.createRect(run,s,_30f).setFill(_30c.series.shadow.color).setStroke(_30c.series.shadow);if(this.animate){this._animateColumn(_30d,dim.height-_303.b+_305,h);}}var _310=this._plotFill(_30c.series.fill,dim,_303);_310=this._shapeFill(_310,rect);var _311=this.createRect(run,s,rect).setFill(_310).setStroke(_30c.series.stroke);this.overrideShape(_311,{index:j,value:val});if(_311.setFilter&&_30c.series.filter){_311.setFilter(_30c.series.filter);}run.dyn.fill=_311.getFill();run.dyn.stroke=_311.getStroke();if(_306){var o={element:"column",index:j,run:run,shape:_311,shadow:_30d,cx:val.x+0.5,cy:val.y,x:_30a?j:run.data[j].x,y:_30a?run.data[j]:run.data[j].y};this._connectEvents(o);_309[j]=o;}if(!isNaN(val.py)&&val.py>_304){rect.height=h-vt(val.py);}this.createLabel(s,_30b,rect,_30c);if(this.animate){this._animateColumn(_311,dim.height-_303.b-_305,h);}}}}this._eventSeries[run.name]=_309;run.dirty=false;z++;}this.dirty=false;if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_303);}return this;},getValue:function(_312,j,_313,_314){var y,x;if(_314){if(typeof _312=="number"){y=_312;}else{y=_312.y;}x=j;}else{y=_312.y;x=_312.x-1;}return {x:x,y:y};},extractValues:function(_315){var _316=[];for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}var _317=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));}),min=_317?Math.max(0,Math.floor(_315.bounds.from-1)):0,max=_317?Math.min(run.data.length,Math.ceil(_315.bounds.to)):run.data.length,_318=_316[i]=[];_318.min=min;_318.max=max;for(var j=min;j<max;++j){var _319=run.data[j];_318[j]=this.isNullValue(_319)?0:(typeof _319=="number"?_319:_319.y);}}return _316;},rearrangeValues:function(_31a,_31b,_31c){for(var i=0,n=_31a.length;i<n;++i){var _31d=_31a[i];if(_31d){for(var j=_31d.min,k=_31d.max;j<k;++j){var _31e=_31d[j];_31d[j]=this.isNullValue(_31e)?0:_31b(_31e)-_31c;}}}return _31a;},isNullValue:function(_31f){if(_31f===null||typeof _31f=="undefined"){return true;}var h=this._hAxis?this._hAxis.isNullValue:_2fd,v=this._vAxis?this._vAxis.isNullValue:_2fd;if(typeof _31f=="number"){return v(0.5)||h(_31f);}return v(isNaN(_31f.x)?0.5:_31f.x+0.5)||_31f.y===null||h(_31f.y);},getBarProperties:function(){var f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);return {gap:f.gap,width:f.size,thickness:0};},_animateColumn:function(_320,_321,_322){if(_322===0){_322=1;}fx.animateTransform(lang.delegate({shape:_320,duration:1200,transform:[{name:"translate",start:[0,_321-(_321/_322)],end:[0,0]},{name:"scale",start:[1,1/_322],end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/plot2d/CartesianBase":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/has","./Base","../scaler/primitive","dojox/gfx","dojox/gfx/fx","dojox/lang/utils"],function(lang,_323,hub,has,Base,_324,gfx,fx,du){var _325=function(){return false;};return _323("dojox.charting.plot2d.CartesianBase",Base,{baseParams:{hAxis:"x",vAxis:"y",labels:false,labelOffset:10,fixed:true,precision:1,labelStyle:"inside",htmlLabels:true,omitLabels:true,labelFunc:null},constructor:function(_326,_327){this.axes=["hAxis","vAxis"];this.zoom=null;this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};this.hAxis=(_327&&_327.hAxis)||"x";this.vAxis=(_327&&_327.vAxis)||"y";this.series=[];this.opt=lang.clone(this.baseParams);du.updateWithObject(this.opt,_327);},clear:function(){this.inherited(arguments);this._hAxis=null;this._vAxis=null;return this;},cleanGroup:function(_328,_329){this.inherited(arguments);if(!_329&&this.chart._nativeClip){var _32a=this.chart.offsets,dim=this.chart.dim;var w=Math.max(0,dim.width-_32a.l-_32a.r),h=Math.max(0,dim.height-_32a.t-_32a.b);this.group.setClip({x:_32a.l,y:_32a.t,width:w,height:h});if(!this._clippedGroup){this._clippedGroup=this.group.createGroup();}}},purgeGroup:function(){this.inherited(arguments);this._clippedGroup=null;},getGroup:function(){return this._clippedGroup||this.group;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}return this;},toPage:function(_32b){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromModel(sh),tv=sv.scaler.getTransformerFromModel(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_32c){var r={};r.x=th(_32c[ah.name])+c.x+o.l;r.y=c.y+dim.height-o.b-tv(_32c[av.name]);return r;};return _32b?t(_32b):t;},toData:function(_32d){var ah=this._hAxis,av=this._vAxis,sh=ah.getScaler(),sv=av.getScaler(),th=sh.scaler.getTransformerFromPlot(sh),tv=sv.scaler.getTransformerFromPlot(sv),c=this.chart.getCoords(),o=this.chart.offsets,dim=this.chart.dim;var t=function(_32e){var r={};r[ah.name]=th(_32e.x-c.x-o.l);r[av.name]=tv(c.y+dim.height-_32e.y-o.b);return r;};return _32d?t(_32d):t;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},createLabel:function(_32f,_330,bbox,_331){if(this.opt.labels){var x,y,_332=this.opt.labelFunc?this.opt.labelFunc.apply(this,[_330,this.opt.fixed,this.opt.precision]):this._getLabel(isNaN(_330.y)?_330:_330.y);if(this.opt.labelStyle=="inside"){var lbox=gfx._base._getTextBox(_332,{font:_331.series.font});x=bbox.x+bbox.width/2;y=bbox.y+bbox.height/2+lbox.h/4;if(lbox.w>bbox.width||lbox.h>bbox.height){return;}}else{x=bbox.x+bbox.width/2;y=bbox.y-this.opt.labelOffset;}this.renderLabel(_32f,x,y,_332,_331,this.opt.labelStyle=="inside");}},performZoom:function(dim,_333){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,_334=dim.height-_333.b,_335=this._hScaler.bounds,_336=(_335.from-_335.lower)*_335.scale,_337=this._vScaler.bounds,_338=(_337.from-_337.lower)*_337.scale,_339=vs/this.lastWindow.vscale,_33a=hs/this.lastWindow.hscale,_33b=(this.lastWindow.xoffset-_336)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),_33c=(_338-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),_33d=this.getGroup(),anim=fx.animateTransform(lang.delegate({shape:_33d,duration:1200,transform:[{name:"translate",start:[0,0],end:[_333.l*(1-_33a),_334*(1-_339)]},{name:"scale",start:[1,1],end:[_33a,_339]},{name:"original"},{name:"translate",start:[0,0],end:[_33b,_33c]}]},this.zoom));lang.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:_336,yoffset:_338});this.zoomQueue.push(anim);hub.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}return this;},initializeScalers:function(dim,_33e){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(_33e.hmin,_33e.hmax,dim.width);}this._hScaler=this._hAxis.getScaler();}else{this._hScaler=_324.buildScaler(_33e.hmin,_33e.hmax,dim.width);}if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(_33e.vmin,_33e.vmax,dim.height);}this._vScaler=this._vAxis.getScaler();}else{this._vScaler=_324.buildScaler(_33e.vmin,_33e.vmax,dim.height);}return this;},isNullValue:function(_33f){if(_33f===null||typeof _33f=="undefined"){return true;}var h=this._hAxis?this._hAxis.isNullValue:_325,v=this._vAxis?this._vAxis.isNullValue:_325;if(typeof _33f=="number"){return h(1)||v(_33f);}return h(isNaN(_33f.x)?1:_33f.x)||_33f.y===null||v(_33f.y);}});});},"dojox/charting/plot2d/Base":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojox/gfx","../Element","./common","../axis2d/common","dojo/has"],function(_340,arr,lang,gfx,_341,_342,ac,has){var Base=_340("dojox.charting.plot2d.Base",_341,{constructor:function(_343,_344){if(_344&&_344.tooltipFunc){this.tooltipFunc=_344.tooltipFunc;}},clear:function(){this.series=[];this.dirty=true;return this;},setAxis:function(axis){return this;},assignAxes:function(axes){arr.forEach(this.axes,function(axis){if(this[axis]){this.setAxis(axes[this[axis]]);}},this);},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return _342.collectSimpleStats(this.series,lang.hitch(this,"isNullValue"));},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},initializeScalers:function(){return this;},isDataDirty:function(){return arr.some(this.series,function(item){return item.dirty;});},render:function(dim,_345){return this;},renderLabel:function(_346,x,y,_347,_348,_349,_34a){var elem=ac.createText[this.opt.htmlLabels&&gfx.renderer!="vml"?"html":"gfx"](this.chart,_346,x,y,_34a?_34a:"middle",_347,_348.series.font,_348.series.fontColor);if(_349){if(this.opt.htmlLabels&&gfx.renderer!="vml"){elem.style.pointerEvents="none";}else{if(elem.rawNode){elem.rawNode.style.pointerEvents="none";}}}if(this.opt.htmlLabels&&gfx.renderer!="vml"){this.htmlElements.push(elem);}return elem;},getRequiredColors:function(){return this.series.length;},_getLabel:function(_34b){return _342.getLabel(_34b,this.opt.fixed,this.opt.precision);}});if(has("dojo-bidi")){Base.extend({_checkOrientation:function(_34c,dim,_34d){this.chart.applyMirroring(this.group,dim,_34d);}});}return Base;});},"dojox/charting/scaler/primitive":function(){define(["dojo/_base/lang"],function(lang){var _34e=lang.getObject("dojox.charting.scaler.primitive",true);return lang.mixin(_34e,{buildScaler:function(min,max,span,_34f){if(min==max){min-=0.5;max+=0.5;}return {bounds:{lower:min,upper:max,from:min,to:max,scale:span/(max-min),span:span},scaler:_34e};},buildTicks:function(_350,_351){return {major:[],minor:[],micro:[]};},getTransformerFromModel:function(_352){var _353=_352.bounds.from,_354=_352.bounds.scale;return function(x){return (x-_353)*_354;};},getTransformerFromPlot:function(_355){var _356=_355.bounds.from,_357=_355.bounds.scale;return function(x){return x/_357+_356;};}});});},"dojox/gfx/fx":function(){define(["dojo/_base/lang","./_base","./matrix","dojo/_base/Color","dojo/_base/array","dojo/_base/fx","dojo/_base/connect","dojo/sniff"],function(lang,g,m,_358,arr,fx,Hub,has){var fxg=g.fx={};function _359(_35a,end){this.start=_35a,this.end=end;};_359.prototype.getValue=function(r){return (this.end-this.start)*r+this.start;};function _35b(_35c,end,_35d){this.start=_35c,this.end=end;this.units=_35d;};_35b.prototype.getValue=function(r){return (this.end-this.start)*r+this.start+this.units;};function _35e(_35f,end){this.start=_35f,this.end=end;this.temp=new _358();};_35e.prototype.getValue=function(r){return _358.blendColors(this.start,this.end,r,this.temp);};function _360(_361){this.values=_361;this.length=_361.length;};_360.prototype.getValue=function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];};function _362(_363,def){this.values=_363;this.def=def?def:{};};_362.prototype.getValue=function(r){var ret=lang.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}return ret;};function _364(_365,_366){this.stack=_365;this.original=_366;};_364.prototype.getValue=function(r){var ret=[];arr.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}if(t.name=="original"&&this.original){ret.push(this.original);return;}if(t.name=="matrix"){if((t.start instanceof m.Matrix2D)&&(t.end instanceof m.Matrix2D)){var _367=new m.Matrix2D();for(var p in t.start){_367[p]=(t.end[p]-t.start[p])*r+t.start[p];}ret.push(_367);}return;}if(!(t.name in m)){return;}var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}var val=arr.map(t.start,function(v,i){return (t.end[i]-v)*r+v;}),_368=f.apply(m,val);if(_368 instanceof m.Matrix2D){ret.push(_368);}},this);return ret;};var _369=new _358(0,0,0,0);function _36a(prop,obj,name,def){if(prop.values){return new _360(prop.values);}var _36b,_36c,end;if(prop.start){_36c=g.normalizeColor(prop.start);}else{_36c=_36b=obj?(name?obj[name]:obj):def;}if(prop.end){end=g.normalizeColor(prop.end);}else{if(!_36b){_36b=obj?(name?obj[name]:obj):def;}end=_36b;}return new _35e(_36c,end);};function _36d(prop,obj,name,def){if(prop.values){return new _360(prop.values);}var _36e,_36f,end;if(prop.start){_36f=prop.start;}else{_36f=_36e=obj?obj[name]:def;}if(prop.end){end=prop.end;}else{if(typeof _36e!="number"){_36e=obj?obj[name]:def;}end=_36e;}return new _359(_36f,end);};fxg.animateStroke=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_370=args.shape,_371;Hub.connect(anim,"beforeBegin",anim,function(){_371=_370.getStroke();var prop=args.color,_372={},_373,_374,end;if(prop){_372.color=_36a(prop,_371,"color",_369);}prop=args.style;if(prop&&prop.values){_372.style=new _360(prop.values);}prop=args.width;if(prop){_372.width=_36d(prop,_371,"width",1);}prop=args.cap;if(prop&&prop.values){_372.cap=new _360(prop.values);}prop=args.join;if(prop){if(prop.values){_372.join=new _360(prop.values);}else{_374=prop.start?prop.start:(_371&&_371.join||0);end=prop.end?prop.end:(_371&&_371.join||0);if(typeof _374=="number"&&typeof end=="number"){_372.join=new _359(_374,end);}}}this.curve=new _362(_372,_371);});Hub.connect(anim,"onAnimate",_370,"setStroke");return anim;};fxg.animateFill=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_375=args.shape,fill;Hub.connect(anim,"beforeBegin",anim,function(){fill=_375.getFill();var prop=args.color,_376={};if(prop){this.curve=_36a(prop,fill,"",_369);}});Hub.connect(anim,"onAnimate",_375,"setFill");return anim;};fxg.animateFont=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_377=args.shape,font;Hub.connect(anim,"beforeBegin",anim,function(){font=_377.getFont();var prop=args.style,_378={},_379,_37a,end;if(prop&&prop.values){_378.style=new _360(prop.values);}prop=args.variant;if(prop&&prop.values){_378.variant=new _360(prop.values);}prop=args.weight;if(prop&&prop.values){_378.weight=new _360(prop.values);}prop=args.family;if(prop&&prop.values){_378.family=new _360(prop.values);}prop=args.size;if(prop&&prop.units){_37a=parseFloat(prop.start?prop.start:(_377.font&&_377.font.size||"0"));end=parseFloat(prop.end?prop.end:(_377.font&&_377.font.size||"0"));_378.size=new _35b(_37a,end,prop.units);}this.curve=new _362(_378,font);});Hub.connect(anim,"onAnimate",_377,"setFont");return anim;};fxg.animateTransform=function(args){if(!args.easing){args.easing=fx._defaultEasing;}var anim=new fx.Animation(args),_37b=args.shape,_37c;Hub.connect(anim,"beforeBegin",anim,function(){_37c=_37b.getTransform();this.curve=new _364(args.transform,_37c);});Hub.connect(anim,"onAnimate",_37b,"setTransform");if(g.renderer==="svg"&&(has("ie")>=9||has("ff"))){var _37d=[Hub.connect(anim,"onBegin",anim,function(){var _37e=_37b.getParent();while(_37e&&_37e.getParent){_37e=_37e.getParent();}if(_37e){_37b.__svgContainer=_37e.rawNode.parentNode;_37b.__svgRoot=_37e.rawNode;if(_37b.__svgRoot&&_37b.__svgRoot.getAttribute){_37b.__svgWidth=parseInt(_37b.__svgRoot.getAttribute("width"),10);if(isNaN(_37b.__svgWidth)){delete _37b.__svgWidth;}}}}),Hub.connect(anim,"onAnimate",anim,function(){try{if(_37b.__svgContainer){var ov=_37b.__svgContainer.style.visibility;_37b.__svgContainer.style.visibility="visible";var _37f=_37b.__svgContainer.offsetHeight;_37b.__svgContainer.style.visibility=ov;var _380=_37b.__svgWidth;if(!isNaN(_380)){try{_37b.__svgRoot.setAttribute("width",_380-0.000005);_37b.__svgRoot.setAttribute("width",_380);}catch(ignore){}}}}catch(e){}}),Hub.connect(anim,"onEnd",anim,function(){arr.forEach(_37d,Hub.disconnect);if(_37b.__svgContainer){var sn=_37b.__svgContainer;if(sn.getAttribute("__gotVis")==null){sn.setAttribute("__gotVis",true);var ov=_37b.__svgContainer.style.visibility;var root=_37b.__svgRoot;var _381=_37b.__svgWidth;sn.style.visibility="visible";setTimeout(function(){try{sn.style.visibility=ov;sn.removeAttribute("__gotVis");sn=null;try{if(!isNaN(_381)){root.setAttribute("width",_381-0.000005);root.setAttribute("width",_381);}}catch(ignore){}}catch(e){}},100);}}delete _37b.__svgContainer;delete _37b.__svgRoot;delete _37b.__svgWidth;})];}return anim;};return fxg;});},"dojox/charting/plot2d/_PlotEvents":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect"],function(lang,arr,_382,hub){return _382("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=lang.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";arr.forEach(this.chart.stack,function(plot){if(plot!==this&&plot.plotEvent){t.plot=plot;plot.plotEvent(t);}},this);},connect:function(_383,_384){this.dirty=true;return hub.connect(this,"plotEvent",_383,_384);},events:function(){return !!this.plotEvent.after;},resetEvents:function(){if(this._shapeEvents.length){arr.forEach(this._shapeEvents,function(item){item.shape.disconnect(item.handle);});this._shapeEvents=[];}this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,_385){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(_385,this,function(e){o.type=_385;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){if(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");}},_reconnectEvents:function(_386){var a=this._eventSeries[_386];if(a){arr.forEach(a,this._connectEvents,this);}},fireEvent:function(_387,_388,_389,_38a){var s=this._eventSeries[_387];if(s&&s.length&&_389<s.length){var o=s[_389];o.type=_388;o.event=_38a||null;this.raiseEvent(o);o.event=null;}}});});},"dojox/charting/plot2d/Lines":function(){define(["dojo/_base/declare","./Default"],function(_38b,_38c){return _38b("dojox.charting.plot2d.Lines",_38c,{constructor:function(){this.opt.lines=true;}});});},"dojox/charting/plot2d/Default":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/has","./CartesianBase","./_PlotEvents","./common","dojox/lang/functional","dojox/lang/utils","dojox/gfx/fx"],function(lang,_38d,arr,has,_38e,_38f,dc,df,du,fx){var _390=1200;return _38d("dojox.charting.plot2d.Default",[_38e,_38f],{defaultParams:{lines:true,areas:false,markers:false,tension:"",animate:false,enableCache:false,interpolate:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",marker:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:"",zeroLine:0},constructor:function(_391,_392){this.opt=lang.clone(lang.mixin(this.opt,this.defaultParams));du.updateWithObject(this.opt,_392);du.updateWithPattern(this.opt,_392,this.optionalParams);this.animate=this.opt.animate;},createPath:function(run,_393,_394){var path;if(this.opt.enableCache&&run._pathFreePool.length>0){path=run._pathFreePool.pop();path.setShape(_394);_393.add(path);}else{path=_393.createPath(_394);}if(this.opt.enableCache){run._pathUsePool.push(path);}return path;},buildSegments:function(i,_395){var run=this.series[i],min=_395?Math.max(0,Math.floor(this._hScaler.bounds.from-1)):0,max=_395?Math.min(run.data.length,Math.ceil(this._hScaler.bounds.to)):run.data.length,rseg=null,_396=[];for(var j=min;j<max;j++){if(!this.isNullValue(run.data[j])){if(!rseg){rseg=[];_396.push({index:j,rseg:rseg});}rseg.push((_395&&run.data[j].hasOwnProperty("y"))?run.data[j].y:run.data[j]);}else{if(!this.opt.interpolate||_395){rseg=null;}}}return _396;},render:function(dim,_397){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,_397);}this.resetEvents();this.dirty=this.isDirty();var s;if(this.dirty){arr.forEach(this.series,dc.purgeGroup);this._eventSeries={};this.cleanGroup();this.getGroup().setTransform(null);s=this.getGroup();df.forEachRev(this.series,function(item){item.cleanGroup(s);});}var t=this.chart.theme,_398,_399,_39a=this.events();for(var i=0;i<this.series.length;i++){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}run.cleanGroup();if(this.opt.enableCache){run._pathFreePool=(run._pathFreePool?run._pathFreePool:[]).concat(run._pathUsePool?run._pathUsePool:[]);run._pathUsePool=[];}if(!run.data.length){run.dirty=false;t.skip();continue;}var _39b=t.next(this.opt.areas?"area":"line",[this.opt,run],true),_39c,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),_39d=this._eventSeries[run.name]=new Array(run.data.length);s=run.group;if(run.hidden){if(this.opt.lines){run.dyn.stroke=_39b.series.stroke;}if(run.markers||(run.markers===undefined&&this.opt.markers)){run.dyn.markerFill=_39b.marker.fill;run.dyn.markerStroke=_39b.marker.stroke;run.dyn.marker=_39b.symbol;}if(this.opt.areas){run.dyn.fill=_39b.series.fill;}continue;}var _39e=arr.some(run.data,function(item){return typeof item=="number"||(item&&!item.hasOwnProperty("x"));});var _39f=this.buildSegments(i,_39e);for(var seg=0;seg<_39f.length;seg++){var _3a0=_39f[seg];if(_39e){_39c=arr.map(_3a0.rseg,function(v,i){return {x:ht(i+_3a0.index+1)+_397.l,y:dim.height-_397.b-vt(v),data:v};},this);}else{_39c=arr.map(_3a0.rseg,function(v){return {x:ht(v.x)+_397.l,y:dim.height-_397.b-vt(v.y),data:v};},this);}if(_39e&&this.opt.interpolate){while(seg<_39f.length){seg++;_3a0=_39f[seg];if(_3a0){_39c=_39c.concat(arr.map(_3a0.rseg,function(v,i){return {x:ht(i+_3a0.index+1)+_397.l,y:dim.height-_397.b-vt(v),data:v};},this));}}}var _3a1=this.opt.tension?dc.curve(_39c,this.opt.tension):"";if(this.opt.areas&&_39c.length>1){var fill=this._plotFill(_39b.series.fill,dim,_397),_3a2=lang.clone(_39c),_3a3=dim.height-_397.b;if(!isNaN(this.opt.zeroLine)){_3a3=Math.max(_397.t,Math.min(dim.height-_397.b-vt(this.opt.zeroLine),_3a3));}if(this.opt.tension){var _3a4="L"+_3a2[_3a2.length-1].x+","+_3a3+" L"+_3a2[0].x+","+_3a3+" L"+_3a2[0].x+","+_3a2[0].y;run.dyn.fill=s.createPath(_3a1+" "+_3a4).setFill(fill).getFill();}else{_3a2.push({x:_39c[_39c.length-1].x,y:_3a3});_3a2.push({x:_39c[0].x,y:_3a3});_3a2.push(_39c[0]);run.dyn.fill=s.createPolyline(_3a2).setFill(fill).getFill();}}if(this.opt.lines||this.opt.markers){_398=_39b.series.stroke;if(_39b.series.outline){_399=run.dyn.outline=dc.makeStroke(_39b.series.outline);_399.width=2*_399.width+(_398&&_398.width||0);}}if(this.opt.markers){run.dyn.marker=_39b.symbol;}var _3a5=null,_3a6=null,_3a7=null;if(_398&&_39b.series.shadow&&_39c.length>1){var _3a8=_39b.series.shadow,_3a9=arr.map(_39c,function(c){return {x:c.x+_3a8.dx,y:c.y+_3a8.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(_3a9,this.opt.tension)).setStroke(_3a8).getStroke();}else{run.dyn.shadow=s.createPolyline(_3a9).setStroke(_3a8).getStroke();}}if(this.opt.markers&&_39b.marker.shadow){_3a8=_39b.marker.shadow;_3a7=arr.map(_3a9,function(c){return this.createPath(run,s,"M"+c.x+" "+c.y+" "+_39b.symbol).setStroke(_3a8).setFill(_3a8.color);},this);}}if(this.opt.lines&&_39c.length>1){var _3aa;if(_399){if(this.opt.tension){run.dyn.outline=s.createPath(_3a1).setStroke(_399).getStroke();}else{run.dyn.outline=s.createPolyline(_39c).setStroke(_399).getStroke();}}if(this.opt.tension){run.dyn.stroke=(_3aa=s.createPath(_3a1)).setStroke(_398).getStroke();}else{run.dyn.stroke=(_3aa=s.createPolyline(_39c)).setStroke(_398).getStroke();}if(_3aa.setFilter&&_39b.series.filter){_3aa.setFilter(_39b.series.filter);}}var _3ab=null;if(this.opt.markers){var _3ac=_39b;_3a5=new Array(_39c.length);_3a6=new Array(_39c.length);_399=null;if(_3ac.marker.outline){_399=dc.makeStroke(_3ac.marker.outline);_399.width=2*_399.width+(_3ac.marker.stroke?_3ac.marker.stroke.width:0);}arr.forEach(_39c,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _3ad=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_3ad.push(this.opt.styleFunc(c.data));}_3ac=t.addMixin(_39b,"marker",_3ad,true);}else{_3ac=t.post(_39b,"marker");}var path="M"+c.x+" "+c.y+" "+_3ac.symbol;if(_399){_3a6[i]=this.createPath(run,s,path).setStroke(_399);}_3a5[i]=this.createPath(run,s,path).setStroke(_3ac.marker.stroke).setFill(_3ac.marker.fill);},this);run.dyn.markerFill=_3ac.marker.fill;run.dyn.markerStroke=_3ac.marker.stroke;if(!_3ab&&this.opt.labels){_3ab=_3a5[0].getBoundingBox();}if(_39a){arr.forEach(_3a5,function(s,i){var o={element:"marker",index:i+_3a0.index,run:run,shape:s,outline:_3a6[i]||null,shadow:_3a7&&_3a7[i]||null,cx:_39c[i].x,cy:_39c[i].y};if(_39e){o.x=i+_3a0.index+1;o.y=run.data[i+_3a0.index];}else{o.x=_3a0.rseg[i].x;o.y=run.data[i+_3a0.index].y;}this._connectEvents(o);_39d[i+_3a0.index]=o;},this);}else{delete this._eventSeries[run.name];}}if(this.opt.labels){var _3ae=_3ab?_3ab.width:2;var _3af=_3ab?_3ab.height:2;arr.forEach(_39c,function(c,i){if(this.opt.styleFunc||typeof c.data!="number"){var _3b0=typeof c.data!="number"?[c.data]:[];if(this.opt.styleFunc){_3b0.push(this.opt.styleFunc(c.data));}_3ac=t.addMixin(_39b,"marker",_3b0,true);}else{_3ac=t.post(_39b,"marker");}this.createLabel(s,_3a0.rseg[i],{x:c.x-_3ae/2,y:c.y-_3af/2,width:_3ae,height:_3af},_3ac);},this);}}run.dirty=false;}if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_397);}if(this.animate){var _3b1=this.getGroup();fx.animateTransform(lang.delegate({shape:_3b1,duration:_390,transform:[{name:"translate",start:[0,dim.height-_397.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}this.dirty=false;return this;}});});},"dojox/charting/plot2d/Pie":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/dom-geometry","dojo/_base/Color","./Base","./_PlotEvents","./common","dojox/gfx","dojox/gfx/matrix","dojox/lang/functional","dojox/lang/utils","dojo/has"],function(lang,arr,_3b2,_3b3,_3b4,Base,_3b5,dc,g,m,df,du,has){var _3b6=0.2;return _3b2("dojox.charting.plot2d.Pie",[Base,_3b5],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0,innerRadius:0,minWidth:0,zeroDataMessage:""},optionalParams:{radius:0,omitLabels:false,stroke:{},outline:{},shadow:{},fill:{},filter:{},styleFunc:null,font:"",fontColor:"",labelWiring:{}},constructor:function(_3b7,_3b8){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_3b8);du.updateWithPattern(this.opt,_3b8,this.optionalParams);this.axes=[];this.run=null;this.dyn=[];this.runFilter=[];if(_3b8&&_3b8.hasOwnProperty("innerRadius")){this._plotSetInnerRadius=true;}},clear:function(){this.inherited(arguments);this.dyn=[];this.run=null;return this;},setAxis:function(axis){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,_3b9){if(!this.dirty){return this;}this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this._plotSetInnerRadius&&t&&t.pieInnerRadius){this.opt.innerRadius=t.pieInnerRadius;}var rx=(dim.width-_3b9.l-_3b9.r)/2,ry=(dim.height-_3b9.t-_3b9.b)/2,r=Math.min(rx,ry),_3ba="font" in this.opt?this.opt.font:t.axis.tick.titleFont||"",size=_3ba?g.normalizedLength(g.splitFontString(_3ba).size):0,_3bb=this.opt.hasOwnProperty("fontColor")?this.opt.fontColor:t.axis.tick.fontColor,_3bc=m._degToRad(this.opt.startAngle),_3bd=_3bc,_3be,_3bf,_3c0,_3c1,_3c2,run=this.run.data,_3c3=this.events();var _3c4=lang.hitch(this,function(){var ct=t.clone();var _3c5=df.map(run,function(v){var _3c6=[this.opt,this.run];if(v!==null&&typeof v!="number"){_3c6.push(v);}if(this.opt.styleFunc){_3c6.push(this.opt.styleFunc(v));}return ct.next("slice",_3c6,true);},this);if("radius" in this.opt){r=this.opt.radius<r?this.opt.radius:r;}var _3c7={cx:_3b9.l+rx,cy:_3b9.t+ry,r:r};var _3c8=new _3b4(_3bb);if(this.opt.innerRadius){_3c8.a=0.1;}var ring=this._createRing(s,_3c7).setStroke(_3c8);if(this.opt.innerRadius){ring.setFill(_3c8);}if(this.opt.zeroDataMessage){this.renderLabel(s,_3c7.cx,_3c7.cy+size/3,this.opt.zeroDataMessage,{series:{font:_3ba,fontColor:_3bb}},null,"middle");}this.dyn=[];arr.forEach(run,function(item,i){this.dyn.push({fill:this._plotFill(_3c5[i].series.fill,dim,_3b9),stroke:_3c5[i].series.stroke});},this);});if(!this.run&&!this.run.data.ength){_3c4();return this;}if(typeof run[0]=="number"){_3be=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(_3be,"<= 0")){_3c4();return this;}_3bf=df.map(_3be,"/this",df.foldl(_3be,"+",0));if(this.opt.labels){_3c0=arr.map(_3bf,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}else{_3be=df.map(run,"x ? Math.max(x.y, 0) : 0");if(!_3be.length||df.every(_3be,"<= 0")){_3c4();return this;}_3bf=df.map(_3be,"/this",df.foldl(_3be,"+",0));if(this.opt.labels){_3c0=arr.map(_3bf,function(x,i){if(x<0){return "";}var v=run[i];return v.hasOwnProperty("text")?v.text:this._getLabel(x*100)+"%";},this);}}var _3c9=df.map(run,function(v){var _3ca=[this.opt,this.run];if(v!==null&&typeof v!="number"){_3ca.push(v);}if(this.opt.styleFunc){_3ca.push(this.opt.styleFunc(v));}return t.next("slice",_3ca,true);},this);if(this.opt.labels){_3c1=df.foldl1(df.map(_3c0,function(_3cb,i){var font=_3c9[i].series.font;return g._base._getTextBox(_3cb,{font:font}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*_3c1,ry-size)+this.opt.labelOffset;}}if(this.opt.hasOwnProperty("radius")){r=this.opt.radius<r*0.9?this.opt.radius:r*0.9;}if(!this.opt.radius&&this.opt.labels&&this.opt.labelStyle=="columns"){r=r/2;if(rx>ry&&rx>r*2){r*=rx/(r*2);}if(r>=ry*0.8){r=ry*0.8;}}else{if(r>=ry*0.9){r=ry*0.9;}}_3c2=r-this.opt.labelOffset;var _3cc={cx:_3b9.l+rx,cy:_3b9.t+ry,r:r};this.dyn=[];var _3cd=new Array(_3bf.length);var _3ce=[],_3cf=_3bd;var _3d0=this.opt.minWidth;arr.forEach(_3bf,function(_3d1,i){if(_3d1===0){_3ce[i]={step:0,end:_3cf,start:_3cf,weak:false};return;}var end=_3cf+_3d1*2*Math.PI;if(i===_3bf.length-1){end=_3bc+2*Math.PI;}var step=end-_3cf,dist=step*r;_3ce[i]={step:step,start:_3cf,end:end,weak:dist<_3d0};_3cf=end;});if(_3d0>0){var _3d2=0,_3d3=_3d0/r,_3d4=0,i;for(i=_3ce.length-1;i>=0;i--){if(_3ce[i].weak){++_3d2;_3d4+=_3ce[i].step;_3ce[i].step=_3d3;}}var _3d5=_3d2*_3d3;if(_3d5>Math.PI){_3d3=Math.PI/_3d2;for(i=0;i<_3ce.length;++i){if(_3ce[i].weak){_3ce[i].step=_3d3;}}_3d5=Math.PI;}if(_3d2>0){_3d3=1-(_3d5-_3d4)/2/Math.PI;for(i=0;i<_3ce.length;++i){if(!_3ce[i].weak){_3ce[i].step=_3d3*_3ce[i].step;}}}for(i=0;i<_3ce.length;++i){_3ce[i].start=i?_3ce[i].end:_3cf;_3ce[i].end=_3ce[i].start+_3ce[i].step;}for(i=_3ce.length-1;i>=0;--i){if(_3ce[i].step!==0){_3ce[i].end=_3cf+2*Math.PI;break;}}}_3cf=_3bd;var o,_3d6;arr.some(_3bf,function(_3d7,i){var _3d8;var v=run[i],_3d9=_3c9[i];if(_3d7>=1){_3d6=this._plotFill(_3d9.series.fill,dim,_3b9);_3d6=this._shapeFill(_3d6,{x:_3cc.cx-_3cc.r,y:_3cc.cy-_3cc.r,width:2*_3cc.r,height:2*_3cc.r});_3d6=this._pseudoRadialFill(_3d6,{x:_3cc.cx,y:_3cc.cy},_3cc.r);_3d8=this._createRing(s,_3cc).setFill(_3d6).setStroke(_3d9.series.stroke);this.dyn.push({fill:_3d6,stroke:_3d9.series.stroke});if(_3c3){o={element:"slice",index:i,run:this.run,shape:_3d8,x:i,y:typeof v=="number"?v:v.y,cx:_3cc.cx,cy:_3cc.cy,cr:r};this._connectEvents(o);_3cd[i]=o;}var k;for(k=i+1;k<_3bf.length;k++){_3d9=_3c9[k];this.dyn.push({fill:_3d9.series.fill,stroke:_3d9.series.stroke});}return true;}if(_3ce[i].step===0){this.dyn.push({fill:_3d9.series.fill,stroke:_3d9.series.stroke});return false;}var step=_3ce[i].step,x1=_3cc.cx+r*Math.cos(_3cf),y1=_3cc.cy+r*Math.sin(_3cf),x2=_3cc.cx+r*Math.cos(_3cf+step),y2=_3cc.cy+r*Math.sin(_3cf+step);var _3da=m._degToRad(this.opt.fanSize),_3db;if(_3d9.series.fill&&_3d9.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&step>_3da){var _3dc=s.createGroup(),_3dd=Math.ceil(step/_3da),_3de=step/_3dd;_3d6=this._shapeFill(_3d9.series.fill,{x:_3cc.cx-_3cc.r,y:_3cc.cy-_3cc.r,width:2*_3cc.r,height:2*_3cc.r});var j,_3df,beta,_3e0,_3e1,_3e2,_3e3;for(j=0;j<_3dd;++j){_3df=_3cf+(j-_3b6)*_3de;beta=_3cf+(j+1+_3b6)*_3de;_3e0=j==0?x1:_3cc.cx+r*Math.cos(_3df);_3e1=j==0?y1:_3cc.cy+r*Math.sin(_3df);_3e2=j==_3dd-1?x2:_3cc.cx+r*Math.cos(beta);_3e3=j==_3dd-1?y2:_3cc.cy+r*Math.sin(beta);this._createSlice(_3dc,_3cc,r,_3e0,_3e1,_3e2,_3e3,_3df,_3de).setFill(this._pseudoRadialFill(_3d6,{x:_3cc.cx,y:_3cc.cy},r,_3cf+(j+0.5)*_3de,_3cf+(j+0.5)*_3de));}_3db=_3d9.series.stroke;this._createSlice(_3dc,_3cc,r,x1,y1,x2,y2,_3cf,step).setStroke(_3db);_3d8=_3dc;}else{_3db=_3d9.series.stroke;_3d8=this._createSlice(s,_3cc,r,x1,y1,x2,y2,_3cf,step).setStroke(_3db);_3d6=_3d9.series.fill;if(_3d6&&_3d6.type==="radial"){_3d6=this._shapeFill(_3d6,{x:_3cc.cx-_3cc.r,y:_3cc.cy-_3cc.r,width:2*_3cc.r,height:2*_3cc.r});if(this.opt.radGrad==="linear"){_3d6=this._pseudoRadialFill(_3d6,{x:_3cc.cx,y:_3cc.cy},r,_3cf,_3cf+step);}}else{if(_3d6&&_3d6.type==="linear"){var bbox=lang.clone(_3d8.getBoundingBox());if(g.renderer==="svg"){var pos={w:0,h:0};try{pos=_3b3.position(_3d8.rawNode);}catch(ignore){}if(pos.h>bbox.height){bbox.height=pos.h;}if(pos.w>bbox.width){bbox.width=pos.w;}}_3d6=this._plotFill(_3d6,dim,_3b9);_3d6=this._shapeFill(_3d6,bbox);}}_3d8.setFill(_3d6);}this.dyn.push({fill:_3d6,stroke:_3d9.series.stroke});if(_3c3){o={element:"slice",index:i,run:this.run,shape:_3d8,x:i,y:typeof v=="number"?v:v.y,cx:_3cc.cx,cy:_3cc.cy,cr:r};this._connectEvents(o);_3cd[i]=o;}_3cf=_3cf+step;return false;},this);if(this.opt.labels){var _3e4=has("dojo-bidi")&&this.chart.isRightToLeft();if(this.opt.labelStyle=="default"){_3bd=_3bc;_3cf=_3bd;arr.some(_3bf,function(_3e5,i){if(_3e5<=0&&!this.opt.minWidth){return false;}var _3e6=_3c9[i];if(_3e5>=1){this.renderLabel(s,_3cc.cx,_3cc.cy+size/2,_3c0[i],_3e6,this.opt.labelOffset>0);return true;}var end=_3bd+_3e5*2*Math.PI;if(i+1==_3bf.length){end=_3bc+2*Math.PI;}if(this.opt.omitLabels&&end-_3bd<0.001){return false;}var _3e7=_3cf+(_3ce[i].step/2),x=_3cc.cx+_3c2*Math.cos(_3e7),y=_3cc.cy+_3c2*Math.sin(_3e7)+size/2;this.renderLabel(s,_3e4?dim.width-x:x,y,_3c0[i],_3e6,this.opt.labelOffset>0);_3cf+=_3ce[i].step;_3bd=end;return false;},this);}else{if(this.opt.labelStyle=="columns"){var _3e8=this.opt.omitLabels;_3bd=_3bc;_3cf=_3bd;var _3e9=[],_3ea=0,k;for(k=_3bf.length-1;k>=0;--k){if(_3bf[k]){++_3ea;}}arr.forEach(_3bf,function(_3eb,i){var end=_3bd+_3eb*2*Math.PI;if(i+1==_3bf.length){end=_3bc+2*Math.PI;}if(this.minWidth!==0||end-_3bd>=0.001){var _3ec=_3cf+(_3ce[i].step/2);if(_3ea===1&&!this.opt.minWidth){_3ec=(_3bd+end)/2;}_3e9.push({angle:_3ec,left:Math.cos(_3ec)<0,theme:_3c9[i],index:i,omit:_3e8?end-_3bd<0.001:false});}_3bd=end;_3cf+=_3ce[i].step;},this);var _3ed=g._base._getTextBox("a",{font:_3ba,whiteSpace:"nowrap"}).h;this._getProperLabelRadius(_3e9,_3ed,_3cc.r*1.1);var _3ee=_3cc.cx-_3cc.r*2,_3ef=_3cc.cx+_3cc.r*2;arr.forEach(_3e9,function(_3f0){if(_3f0.omit){return;}var _3f1=_3c9[_3f0.index],_3f2=0;if(_3f1&&_3f1.axis&&_3f1.axis.tick&&_3f1.axis.tick.labelGap){_3f2=_3f1.axis.tick.labelGap;}var _3f3=g._base._getTextBox(_3c0[_3f0.index],{font:_3f1.series.font,whiteSpace:"nowrap",paddingLeft:_3f2+"px"}).w,x=_3cc.cx+_3f0.labelR*Math.cos(_3f0.angle),y=_3cc.cy+_3f0.labelR*Math.sin(_3f0.angle),_3f4=(_3f0.left)?(_3ee+_3f3):(_3ef-_3f3),_3f5=(_3f0.left)?_3ee:_3f4+_3f2,_3f6=_3cc.r,_3f7=s.createPath().moveTo(_3cc.cx+_3f6*Math.cos(_3f0.angle),_3cc.cy+_3f6*Math.sin(_3f0.angle));if(Math.abs(_3f0.labelR*Math.cos(_3f0.angle))<_3cc.r*2-_3f3){_3f7.lineTo(x,y);}_3f7.lineTo(_3f4,y).setStroke(_3f0.theme.series.labelWiring);_3f7.moveToBack();var mid=_3ed/3+y;var elem=this.renderLabel(s,_3f5,mid||0,_3c0[_3f0.index],_3f1,false,"left");if(_3c3&&!this.opt.htmlLabels){var _3f8=g._base._getTextBox(_3c0[_3f0.index],{font:_3f0.theme.series.font}).w||0,_3f9=g.normalizedLength(g.splitFontString(_3f0.theme.series.font).size);o={element:"labels",index:_3f0.index,run:this.run,shape:elem,x:_3f5,y:y,label:_3c0[_3f0.index]};var shp=elem.getShape(),lt=_3b3.position(this.chart.node,true),_3fa=lang.mixin({type:"rect"},{x:shp.x,y:shp.y-2*_3f9});_3fa.x+=lt.x;_3fa.y+=lt.y;_3fa.x=Math.round(_3fa.x);_3fa.y=Math.round(_3fa.y);_3fa.width=Math.ceil(_3f8);_3fa.height=Math.ceil(_3f9);o.aroundRect=_3fa;this._connectEvents(o);_3cd[_3bf.length+_3f0.index]=o;}},this);}}}var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:_3cd[esi++];});if(has("dojo-bidi")){this._checkOrientation(this.group,dim,_3b9);}return this;},_getProperLabelRadius:function(_3fb,_3fc,_3fd){if(_3fb.length==1){_3fb[0].labelR=_3fd;return;}var _3fe={},_3ff={},_400=2,_401=2,i;var _402;for(i=0;i<_3fb.length;++i){_402=Math.abs(Math.sin(_3fb[i].angle));if(_3fb[i].left){if(_400>_402){_400=_402;_3fe=_3fb[i];}}else{if(_401>_402){_401=_402;_3ff=_3fb[i];}}}_3fe.labelR=_3ff.labelR=_3fd;this._caculateLabelR(_3fe,_3fb,_3fc);this._caculateLabelR(_3ff,_3fb,_3fc);},_caculateLabelR:function(_403,_404,_405){var i,j,k,_406=_404.length,_407=_403.labelR,_408,step=_404[_403.index].left?-_405:_405;for(k=0,i=_403.index,j=(i+1)%_406;k<_406&&_404[i].left===_404[j].left;++k){_408=(Math.sin(_404[i].angle)*_407+step)/Math.sin(_404[j].angle);_407=Math.max(_403.labelR,_408);_404[j].labelR=_407;i=(i+1)%_406;j=(j+1)%_406;}if(k>=_406){_404[0].labelR=_403.labelR;}for(k=0,i=_403.index,j=(i||_406)-1;k<_406&&_404[i].left===_404[j].left;++k){_408=(Math.sin(_404[i].angle)*_407-step)/Math.sin(_404[j].angle);_407=Math.max(_403.labelR,_408);_404[j].labelR=_407;i=(i||_406)-1;j=(j||_406)-1;}},_createRing:function(_409,_40a){var r=this.opt.innerRadius;if(r>0){r=_40a.r*(r/100);}else{if(r<0){r=-r;}}if(r){return _409.createPath({}).setAbsoluteMode(true).moveTo(_40a.cx,_40a.cy-_40a.r).arcTo(_40a.r,_40a.r,0,false,true,_40a.cx+_40a.r,_40a.cy).arcTo(_40a.r,_40a.r,0,true,true,_40a.cx,_40a.cy-_40a.r).closePath().moveTo(_40a.cx,_40a.cy-r).arcTo(r,r,0,false,true,_40a.cx+r,_40a.cy).arcTo(r,r,0,true,true,_40a.cx,_40a.cy-r).closePath();}return _409.createCircle(_40a);},_createSlice:function(_40b,_40c,R,x1,y1,x2,y2,_40d,_40e){var r=this.opt.innerRadius;if(r>0){r=_40c.r*(r/100);}else{if(r<0){r=-r;}}if(r){var _40f=_40c.cx+r*Math.cos(_40d),_410=_40c.cy+r*Math.sin(_40d),_411=_40c.cx+r*Math.cos(_40d+_40e),_412=_40c.cy+r*Math.sin(_40d+_40e);return _40b.createPath({}).setAbsoluteMode(true).moveTo(_40f,_410).lineTo(x1,y1).arcTo(R,R,0,_40e>Math.PI,true,x2,y2).lineTo(_411,_412).arcTo(r,r,0,_40e>Math.PI,false,_40f,_410).closePath();}return _40b.createPath({}).setAbsoluteMode(true).moveTo(_40c.cx,_40c.cy).lineTo(x1,y1).arcTo(R,R,0,_40e>Math.PI,true,x2,y2).lineTo(_40c.cx,_40c.cy).closePath();}});});},"dojox/charting/plot2d/Grid":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/sniff","./CartesianBase","./common","dojox/lang/utils","dojox/gfx/fx"],function(lang,_413,arr,has,_414,dc,du,fx){var _415=function(a,b){return a.value-b.value;};return _413("dojox.charting.plot2d.Grid",_414,{defaultParams:{hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:false,vStripes:false,animate:null,enableCache:false,renderOnAxis:true},optionalParams:{majorHLine:{},minorHLine:{},majorVLine:{},minorVLine:{},hFill:{},vFill:{},hAlternateFill:{},vAlternateFill:{}},constructor:function(_416,_417){this.opt=lang.clone(this.defaultParams);du.updateWithObject(this.opt,_417);du.updateWithPattern(this.opt,_417,this.optionalParams);this.animate=this.opt.animate;if(this.opt.enableCache){this._lineFreePool=[];this._lineUsePool=[];this._rectFreePool=[];this._rectUsePool=[];}},addSeries:function(run){return this;},getSeriesStats:function(){return lang.delegate(dc.defaultStats);},cleanGroup:function(){this.inherited(arguments);if(this.opt.enableCache){this._lineFreePool=this._lineFreePool.concat(this._lineUsePool);this._lineUsePool=[];this._rectFreePool=this._rectFreePool.concat(this._rectUsePool);this._rectUsePool=[];}},createLine:function(_418,_419){var line;if(this.opt.enableCache&&this._lineFreePool.length>0){line=this._lineFreePool.pop();line.setShape(_419);_418.add(line);}else{line=_418.createLine(_419);}if(this.opt.enableCache){this._lineUsePool.push(line);}return line;},createRect:function(_41a,_41b){var rect;if(this.opt.enableCache&&this._rectFreePool.length>0){rect=this._rectFreePool.pop();rect.setShape(_41b);_41a.add(rect);}else{rect=_41a.createRect(_41b);}if(this.opt.enableCache){this._rectUsePool.push(rect);}return rect;},render:function(dim,_41c){if(this.zoom){return this.performZoom(dim,_41c);}this.dirty=this.isDirty();if(!this.dirty){return this;}this.cleanGroup();var s=this.getGroup(),ta=this.chart.theme,_41d,_41e;if((has("ios")&&has("ios")<6)||has("android")||(has("safari")&&!has("ios"))){var w=Math.max(0,dim.width-_41c.l-_41c.r),h=Math.max(0,dim.height-_41c.t-_41c.b);s.createRect({x:_41c.l,y:_41c.t,width:w,height:h});}if(this._vAxis){_41e=this._vAxis.getTicks();var _41f=this._vAxis.getScaler();if(_41e!=null&&_41f!=null){var vt=_41f.scaler.getTransformerFromModel(_41f);if(this.opt.hStripes){this._renderHRect(_41e,ta.grid,dim,_41c,_41f,vt);}if(this.opt.hMinorLines){_41d=this.opt.minorHLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;this._renderHLines(_41e.minor,_41d,dim,_41c,_41f,vt);}if(this.opt.hMajorLines){_41d=this.opt.majorHLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;this._renderHLines(_41e.major,_41d,dim,_41c,_41f,vt);}}}if(this._hAxis){_41e=this._hAxis.getTicks();var _420=this._hAxis.getScaler();if(_41e!=null&&_420!=null){var ht=_420.scaler.getTransformerFromModel(_420);if(this.opt.vStripes){this._renderVRect(_41e,ta.grid,dim,_41c,_420,ht);}if(_41e&&this.opt.vMinorLines){_41d=this.opt.minorVLine||(ta.grid&&ta.grid.minorLine)||ta.axis.minorTick;this._renderVLines(_41e.minor,_41d,dim,_41c,_420,ht);}if(_41e&&this.opt.vMajorLines){_41d=this.opt.majorVLine||(ta.grid&&ta.grid.majorLine)||ta.axis.majorTick;this._renderVLines(_41e.major,_41d,dim,_41c,_420,ht);}}}this.dirty=false;return this;},_renderHLines:function(_421,_422,dim,_423,_424,vt){var s=this.getGroup();arr.forEach(_421,function(tick){if(!this.opt.renderOnAxis&&tick.value==(this._vAxis.opt.leftBottom?_424.bounds.from:_424.bounds.to)){return;}var y=dim.height-_423.b-vt(tick.value);var _425=this.createLine(s,{x1:_423.l,y1:y,x2:dim.width-_423.r,y2:y}).setStroke(_422);if(this.animate){this._animateGrid(_425,"h",_423.l,_423.r+_423.l-dim.width);}},this);},_renderVLines:function(_426,_427,dim,_428,_429,ht){var s=this.getGroup();arr.forEach(_426,function(tick){if(!this.opt.renderOnAxis&&tick.value==(this._hAxis.opt.leftBottom?_429.bounds.from:_429.bounds.to)){return;}var x=_428.l+ht(tick.value);var _42a=this.createLine(s,{x1:x,y1:_428.t,x2:x,y2:dim.height-_428.b}).setStroke(_427);if(this.animate){this._animateGrid(_42a,"v",dim.height-_428.b,dim.height-_428.b-_428.t);}},this);},_renderHRect:function(_42b,_42c,dim,_42d,_42e,vt){var fill,tick,y,y2,_42f;var _430=_42b.major.concat(_42b.minor);_430.sort(_415);if(_430[0].value>_42e.bounds.from){_430.splice(0,0,{value:_42e.bounds.from});}if(_430[_430.length-1].value<_42e.bounds.to){_430.push({value:_42e.bounds.to});}var s=this.getGroup();for(var j=0;j<_430.length-1;j++){tick=_430[j];y=dim.height-_42d.b-vt(tick.value);y2=dim.height-_42d.b-vt(_430[j+1].value);fill=(j%2==0)?(this.opt.hAlternateFill||(_42c&&_42c.alternateFill)):(this.opt.hFill||(_42c&&_42c.fill));if(fill){_42f=this.createRect(s,{x:_42d.l,y:y,width:dim.width-_42d.r,height:y-y2}).setFill(fill);if(this.animate){this._animateGrid(_42f,"h",_42d.l,_42d.r+_42d.l-dim.width);}}}},_renderVRect:function(_431,_432,dim,_433,_434,ht){var fill,tick,x,x2,_435;var _436=_431.major.concat(_431.minor);_436.sort(_415);if(_436[0].value>_434.bounds.from){_436.splice(0,0,{value:_434.bounds.from});}if(_436[_436.length-1].value<_434.bounds.to){_436.push({value:_434.bounds.to});}var s=this.getGroup();for(var j=0;j<_436.length-1;j++){tick=_436[j];x=_433.l+ht(tick.value);x2=_433.l+ht(_436[j+1].value);fill=(j%2==0)?(this.opt.vAlternateFill||(_432&&_432.alternateFill)):(this.opt.vFill||(_432&&_432.fill));if(fill){_435=this.createRect(s,{x:x,y:_433.t,width:x2-x,height:dim.width-_433.r}).setFill(fill);if(this.animate){this._animateGrid(_435,"v",dim.height-_433.b,dim.height-_433.b-_433.t);}}}},_animateGrid:function(_437,type,_438,size){var _439=type=="h"?[_438,0]:[0,_438];var _43a=type=="h"?[1/size,1]:[1,1/size];fx.animateTransform(lang.delegate({shape:_437,duration:1200,transform:[{name:"translate",start:_439,end:[0,0]},{name:"scale",start:_43a,end:[1,1]},{name:"original"}]},this.animate)).play();}});});},"dojox/charting/action2d/Tooltip":function(){define(["dijit/Tooltip","dojo/_base/lang","dojo/_base/declare","dojo/_base/window","dojo/_base/connect","dojo/dom-style","./PlotAction","dojox/gfx/matrix","dojo/has","dojo/has!dojo-bidi?../bidi/action2d/Tooltip","dojox/lang/functional","dojox/lang/functional/scan","dojox/lang/functional/fold"],function(_43b,lang,_43c,win,hub,_43d,_43e,m,has,_43f,df){var _440=function(o,plot){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}if(plot.tooltipFunc){return plot.tooltipFunc(o);}else{return o.y;}};var pi4=Math.PI/4,pi2=Math.PI/2;var _441=_43c(has("dojo-bidi")?"dojox.charting.action2d.NonBidiTooltip":"dojox.charting.action2d.Tooltip",_43e,{defaultParams:{text:_440,mouseOver:true,defaultPosition:["after-centered","before-centered"]},optionalParams:{},constructor:function(_442,plot,_443){this.text=_443&&_443.text?_443.text:_440;this.mouseOver=_443&&_443.mouseOver!=undefined?_443.mouseOver:true;this.defaultPosition=_443&&_443.defaultPosition!=undefined?_443.defaultPosition:["after-centered","before-centered"];this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){_43b.hide(this.aroundRect);this.aroundRect=null;if(o.type==="onplotreset"){delete this.angles;}return;}if(!o.shape||(this.mouseOver&&o.type!=="onmouseover")||(!this.mouseOver&&o.type!=="onclick")){return;}var _444={type:"rect"},_445=this.defaultPosition;switch(o.element){case "marker":_444.x=o.cx;_444.y=o.cy;_444.w=_444.h=1;break;case "circle":_444.x=o.cx-o.cr;_444.y=o.cy-o.cr;_444.w=_444.h=2*o.cr;break;case "spider_circle":_444.x=o.cx;_444.y=o.cy;_444.w=_444.h=1;break;case "spider_plot":return;case "column":_445=["above-centered","below-centered"];case "bar":_444=lang.clone(o.shape.getShape());_444.w=_444.width;_444.h=_444.height;break;case "candlestick":_444.x=o.x;_444.y=o.y;_444.w=o.width;_444.h=o.height;break;default:if(!this.angles){var _446=typeof o.run.data[0]=="number"?df.map(o.run.data,"x ? Math.max(x, 0) : 0"):df.map(o.run.data,"x ? Math.max(x.y, 0) : 0");this.angles=df.map(df.scanl(_446,"+",0),"* 2 * Math.PI / this",df.foldl(_446,"+",0));}var _447=m._degToRad(o.plot.opt.startAngle),_448=(this.angles[o.index]+this.angles[o.index+1])/2+_447;_444.x=o.cx+o.cr*Math.cos(_448);_444.y=o.cy+o.cr*Math.sin(_448);_444.w=_444.h=1;if(_447&&(_448<0||_448>2*Math.PI)){_448=Math.abs(2*Math.PI-Math.abs(_448));}if(_448<pi4){}else{if(_448<pi2+pi4){_445=["below-centered","above-centered"];}else{if(_448<Math.PI+pi4){_445=["before-centered","after-centered"];}else{if(_448<2*Math.PI-pi4){_445=["above-centered","below-centered"];}}}}break;}if(has("dojo-bidi")){this._recheckPosition(o,_444,_445);}var lt=this.chart.getCoords();_444.x+=lt.x;_444.y+=lt.y;_444.x=Math.round(_444.x);_444.y=Math.round(_444.y);_444.w=Math.ceil(_444.w);_444.h=Math.ceil(_444.h);this.aroundRect=_444;var _449=this.text(o,this.plot);if(_449){_43b.show(this._format(_449),this.aroundRect,_445);}if(!this.mouseOver){this._handle=hub.connect(win.doc,"onclick",this,"onClick");}},onClick:function(){this.process({type:"onmouseout"});},_recheckPosition:function(obj,rect,_44a){},_format:function(_44b){return _44b;}});return has("dojo-bidi")?_43c("dojox.charting.action2d.Tooltip",[_441,_43f]):_441;});},"dijit/Tooltip":function(){define(["dojo/_base/array","dojo/_base/declare","dojo/_base/fx","dojo/dom","dojo/dom-class","dojo/dom-geometry","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/on","dojo/sniff","./_base/manager","./place","./_Widget","./_TemplatedMixin","./BackgroundIframe","dojo/text!./templates/Tooltip.html","./main"],function(_44c,_44d,fx,dom,_44e,_44f,_450,lang,_451,on,has,_452,_453,_454,_455,_456,_457,_458){var _459=_44d("dijit._MasterTooltip",[_454,_455],{duration:_452.defaultDuration,templateString:_457,postCreate:function(){this.ownerDocumentBody.appendChild(this.domNode);this.bgIframe=new _456(this.domNode);this.fadeIn=fx.fadeIn({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onShow")});this.fadeOut=fx.fadeOut({node:this.domNode,duration:this.duration,onEnd:lang.hitch(this,"_onHide")});},show:function(_45a,_45b,_45c,rtl,_45d,_45e,_45f){if(this.aroundNode&&this.aroundNode===_45b&&this.containerNode.innerHTML==_45a){return;}if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}this.containerNode.innerHTML=_45a;if(_45d){this.set("textDir",_45d);}this.containerNode.align=rtl?"right":"left";var pos=_453.around(this.domNode,_45b,_45c&&_45c.length?_45c:_460.defaultPosition,!rtl,lang.hitch(this,"orient"));var _461=pos.aroundNodePos;if(pos.corner.charAt(0)=="M"&&pos.aroundCorner.charAt(0)=="M"){this.connectorNode.style.top=_461.y+((_461.h-this.connectorNode.offsetHeight)>>1)-pos.y+"px";this.connectorNode.style.left="";}else{if(pos.corner.charAt(1)=="M"&&pos.aroundCorner.charAt(1)=="M"){this.connectorNode.style.left=_461.x+((_461.w-this.connectorNode.offsetWidth)>>1)-pos.x+"px";}else{this.connectorNode.style.left="";this.connectorNode.style.top="";}}_450.set(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=_45b;this.onMouseEnter=_45e||noop;this.onMouseLeave=_45f||noop;},orient:function(node,_462,_463,_464,_465){this.connectorNode.style.top="";var _466=_464.h,_467=_464.w;node.className="dijitTooltip "+{"MR-ML":"dijitTooltipRight","ML-MR":"dijitTooltipLeft","TM-BM":"dijitTooltipAbove","BM-TM":"dijitTooltipBelow","BL-TL":"dijitTooltipBelow dijitTooltipABLeft","TL-BL":"dijitTooltipAbove dijitTooltipABLeft","BR-TR":"dijitTooltipBelow dijitTooltipABRight","TR-BR":"dijitTooltipAbove dijitTooltipABRight","BR-BL":"dijitTooltipRight","BL-BR":"dijitTooltipLeft"}[_462+"-"+_463];this.domNode.style.width="auto";var size=_44f.position(this.domNode);if(has("ie")||has("trident")){size.w+=2;}var _468=Math.min((Math.max(_467,1)),size.w);_44f.setMarginBox(this.domNode,{w:_468});if(_463.charAt(0)=="B"&&_462.charAt(0)=="B"){var bb=_44f.position(node);var _469=this.connectorNode.offsetHeight;if(bb.h>_466){var _46a=_466-((_465.h+_469)>>1);this.connectorNode.style.top=_46a+"px";this.connectorNode.style.bottom="";}else{this.connectorNode.style.bottom=Math.min(Math.max(_465.h/2-_469/2,0),bb.h-_469)+"px";this.connectorNode.style.top="";}}else{this.connectorNode.style.top="";this.connectorNode.style.bottom="";}return Math.max(0,size.w-_467);},_onShow:function(){if(has("ie")){this.domNode.style.filter="";}},hide:function(_46b){if(this._onDeck&&this._onDeck[1]==_46b){this._onDeck=null;}else{if(this.aroundNode===_46b){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}}this.onMouseEnter=this.onMouseLeave=noop;},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});if(has("dojo-bidi")){_459.extend({_setAutoTextDir:function(node){this.applyTextDir(node);_44c.forEach(node.children,function(_46c){this._setAutoTextDir(_46c);},this);},_setTextDirAttr:function(_46d){this._set("textDir",_46d);if(_46d=="auto"){this._setAutoTextDir(this.containerNode);}else{this.containerNode.dir=this.textDir;}}});}_458.showTooltip=function(_46e,_46f,_470,rtl,_471,_472,_473){if(_470){_470=_44c.map(_470,function(val){return {after:"after-centered",before:"before-centered"}[val]||val;});}if(!_460._masterTT){_458._masterTT=_460._masterTT=new _459();}return _460._masterTT.show(_46e,_46f,_470,rtl,_471,_472,_473);};_458.hideTooltip=function(_474){return _460._masterTT&&_460._masterTT.hide(_474);};var _475="DORMANT",_476="SHOW TIMER",_477="SHOWING",_478="HIDE TIMER";function noop(){};var _460=_44d("dijit.Tooltip",_454,{label:"",showDelay:400,hideDelay:400,connectId:[],position:[],selector:"",_setConnectIdAttr:function(_479){_44c.forEach(this._connections||[],function(_47a){_44c.forEach(_47a,function(_47b){_47b.remove();});},this);this._connectIds=_44c.filter(lang.isArrayLike(_479)?_479:(_479?[_479]:[]),function(id){return dom.byId(id,this.ownerDocument);},this);this._connections=_44c.map(this._connectIds,function(id){var node=dom.byId(id,this.ownerDocument),_47c=this.selector,_47d=_47c?function(_47e){return on.selector(_47c,_47e);}:function(_47f){return _47f;},self=this;return [on(node,_47d(_451.enter),function(){self._onHover(this);}),on(node,_47d("focusin"),function(){self._onHover(this);}),on(node,_47d(_451.leave),lang.hitch(self,"_onUnHover")),on(node,_47d("focusout"),lang.hitch(self,"set","state",_475))];},this);this._set("connectId",_479);},addTarget:function(node){var id=node.id||node;if(_44c.indexOf(this._connectIds,id)==-1){this.set("connectId",this._connectIds.concat(id));}},removeTarget:function(node){var id=node.id||node,idx=_44c.indexOf(this._connectIds,id);if(idx>=0){this._connectIds.splice(idx,1);this.set("connectId",this._connectIds);}},buildRendering:function(){this.inherited(arguments);_44e.add(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;_44c.forEach(lang.isArrayLike(ids)?ids:[ids],this.addTarget,this);},getContent:function(node){return this.label||this.domNode.innerHTML;},state:_475,_setStateAttr:function(val){if(this.state==val||(val==_476&&this.state==_477)||(val==_478&&this.state==_475)){return;}if(this._hideTimer){this._hideTimer.remove();delete this._hideTimer;}if(this._showTimer){this._showTimer.remove();delete this._showTimer;}switch(val){case _475:if(this._connectNode){_460.hide(this._connectNode);delete this._connectNode;this.onHide();}break;case _476:if(this.state!=_477){this._showTimer=this.defer(function(){this.set("state",_477);},this.showDelay);}break;case _477:var _480=this.getContent(this._connectNode);if(!_480){this.set("state",_475);return;}_460.show(_480,this._connectNode,this.position,!this.isLeftToRight(),this.textDir,lang.hitch(this,"set","state",_477),lang.hitch(this,"set","state",_478));this.onShow(this._connectNode,this.position);break;case _478:this._hideTimer=this.defer(function(){this.set("state",_475);},this.hideDelay);break;}this._set("state",val);},_onHover:function(_481){if(this._connectNode&&_481!=this._connectNode){this.set("state",_475);}this._connectNode=_481;this.set("state",_476);},_onUnHover:function(_482){this.set("state",_478);},open:function(_483){this.set("state",_475);this._connectNode=_483;this.set("state",_477);},close:function(){this.set("state",_475);},onShow:function(){},onHide:function(){},destroy:function(){this.set("state",_475);_44c.forEach(this._connections||[],function(_484){_44c.forEach(_484,function(_485){_485.remove();});},this);this.inherited(arguments);}});_460._MasterTooltip=_459;_460.show=_458.showTooltip;_460.hide=_458.hideTooltip;_460.defaultPosition=["after-centered","before-centered"];return _460;});},"dijit/_base/manager":function(){define(["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_486,_487,lang,_488,_489){var _48a={};_486.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){_48a[name]=_488[name];});lang.mixin(_48a,{defaultDuration:_487["defaultDuration"]||200});lang.mixin(_489,_48a);return _489;});},"dijit/registry":function(){define(["dojo/_base/array","dojo/_base/window","./main"],function(_48b,win,_48c){var _48d={},hash={};var _48e={length:0,add:function(_48f){if(hash[_48f.id]){throw new Error("Tried to register widget with id=="+_48f.id+" but that id is already registered");}hash[_48f.id]=_48f;this.length++;},remove:function(id){if(hash[id]){delete hash[id];this.length--;}},byId:function(id){return typeof id=="string"?hash[id]:id;},byNode:function(node){return hash[node.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in hash){ar.push(hash[id]);}return ar;},getUniqueId:function(_490){var id;do{id=_490+"_"+(_490 in _48d?++_48d[_490]:_48d[_490]=0);}while(hash[id]);return _48c._scopeName=="dijit"?id:_48c._scopeName+"_"+id;},findWidgets:function(root,_491){var _492=[];function _493(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var _494=node.getAttribute("widgetId");if(_494){var _495=hash[_494];if(_495){_492.push(_495);}}else{if(node!==_491){_493(node);}}}}};_493(root);return _492;},_destroyAll:function(){_48c._curFocus=null;_48c._prevFocus=null;_48c._activeStack=[];_48b.forEach(_48e.findWidgets(win.body()),function(_496){if(!_496._destroyed){if(_496.destroyRecursive){_496.destroyRecursive();}else{if(_496.destroy){_496.destroy();}}}});},getEnclosingWidget:function(node){while(node){var id=node.nodeType==1&&node.getAttribute("widgetId");if(id){return hash[id];}node=node.parentNode;}return null;},_hash:hash};_48c.registry=_48e;return _48e;});},"dijit/main":function(){define(["dojo/_base/kernel"],function(dojo){return dojo.dijit;});},"dijit/place":function(){define(["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","./Viewport","./main"],function(_497,_498,_499,_49a,win,_49b,_49c){function _49d(node,_49e,_49f,_4a0){var view=_49b.getEffectiveBox(node.ownerDocument);if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){win.body(node.ownerDocument).appendChild(node);}var best=null;_497.some(_49e,function(_4a1){var _4a2=_4a1.corner;var pos=_4a1.pos;var _4a3=0;var _4a4={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_4a2.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_4a2.charAt(0)]};var s=node.style;s.left=s.right="auto";if(_49f){var res=_49f(node,_4a1.aroundCorner,_4a2,_4a4,_4a0);_4a3=typeof res=="undefined"?0:res;}var _4a5=node.style;var _4a6=_4a5.display;var _4a7=_4a5.visibility;if(_4a5.display=="none"){_4a5.visibility="hidden";_4a5.display="";}var bb=_498.position(node);_4a5.display=_4a6;_4a5.visibility=_4a7;var _4a8={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_4a2.charAt(1)],_4a9={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_4a2.charAt(0)],_4aa=Math.max(view.l,_4a8),_4ab=Math.max(view.t,_4a9),endX=Math.min(view.l+view.w,_4a8+bb.w),endY=Math.min(view.t+view.h,_4a9+bb.h),_4ac=endX-_4aa,_4ad=endY-_4ab;_4a3+=(bb.w-_4ac)+(bb.h-_4ad);if(best==null||_4a3<best.overflow){best={corner:_4a2,aroundCorner:_4a1.aroundCorner,x:_4aa,y:_4ab,w:_4ac,h:_4ad,overflow:_4a3,spaceAvailable:_4a4};}return !_4a3;});if(best.overflow&&_49f){_49f(node,best.aroundCorner,best.corner,best.spaceAvailable,_4a0);}var top=best.y,side=best.x,body=win.body(node.ownerDocument);if(/relative|absolute/.test(_499.get(body,"position"))){top-=_499.get(body,"marginTop");side-=_499.get(body,"marginLeft");}var s=node.style;s.top=top+"px";s.left=side+"px";s.right="auto";return best;};var _4ae={"TL":"BR","TR":"BL","BL":"TR","BR":"TL"};var _4af={at:function(node,pos,_4b0,_4b1,_4b2){var _4b3=_497.map(_4b0,function(_4b4){var c={corner:_4b4,aroundCorner:_4ae[_4b4],pos:{x:pos.x,y:pos.y}};if(_4b1){c.pos.x+=_4b4.charAt(1)=="L"?_4b1.x:-_4b1.x;c.pos.y+=_4b4.charAt(0)=="T"?_4b1.y:-_4b1.y;}return c;});return _49d(node,_4b3,_4b2);},around:function(node,_4b5,_4b6,_4b7,_4b8){var _4b9;if(typeof _4b5=="string"||"offsetWidth" in _4b5||"ownerSVGElement" in _4b5){_4b9=_498.position(_4b5,true);if(/^(above|below)/.test(_4b6[0])){var _4ba=_498.getBorderExtents(_4b5),_4bb=_4b5.firstChild?_498.getBorderExtents(_4b5.firstChild):{t:0,l:0,b:0,r:0},_4bc=_498.getBorderExtents(node),_4bd=node.firstChild?_498.getBorderExtents(node.firstChild):{t:0,l:0,b:0,r:0};_4b9.y+=Math.min(_4ba.t+_4bb.t,_4bc.t+_4bd.t);_4b9.h-=Math.min(_4ba.t+_4bb.t,_4bc.t+_4bd.t)+Math.min(_4ba.b+_4bb.b,_4bc.b+_4bd.b);}}else{_4b9=_4b5;}if(_4b5.parentNode){var _4be=_499.getComputedStyle(_4b5).position=="absolute";var _4bf=_4b5.parentNode;while(_4bf&&_4bf.nodeType==1&&_4bf.nodeName!="BODY"){var _4c0=_498.position(_4bf,true),pcs=_499.getComputedStyle(_4bf);if(/relative|absolute/.test(pcs.position)){_4be=false;}if(!_4be&&/hidden|auto|scroll/.test(pcs.overflow)){var _4c1=Math.min(_4b9.y+_4b9.h,_4c0.y+_4c0.h);var _4c2=Math.min(_4b9.x+_4b9.w,_4c0.x+_4c0.w);_4b9.x=Math.max(_4b9.x,_4c0.x);_4b9.y=Math.max(_4b9.y,_4c0.y);_4b9.h=_4c1-_4b9.y;_4b9.w=_4c2-_4b9.x;}if(pcs.position=="absolute"){_4be=true;}_4bf=_4bf.parentNode;}}var x=_4b9.x,y=_4b9.y,_4c3="w" in _4b9?_4b9.w:(_4b9.w=_4b9.width),_4c4="h" in _4b9?_4b9.h:(_49a.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_4b9.height+", width:"+_4c3+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_4b9.height+", w:"+_4c3+" }","","2.0"),_4b9.h=_4b9.height);var _4c5=[];function push(_4c6,_4c7){_4c5.push({aroundCorner:_4c6,corner:_4c7,pos:{x:{"L":x,"R":x+_4c3,"M":x+(_4c3>>1)}[_4c6.charAt(1)],y:{"T":y,"B":y+_4c4,"M":y+(_4c4>>1)}[_4c6.charAt(0)]}});};_497.forEach(_4b6,function(pos){var ltr=_4b7;switch(pos){case "above-centered":push("TM","BM");break;case "below-centered":push("BM","TM");break;case "after-centered":ltr=!ltr;case "before-centered":push(ltr?"ML":"MR",ltr?"MR":"ML");break;case "after":ltr=!ltr;case "before":push(ltr?"TL":"TR",ltr?"TR":"TL");push(ltr?"BL":"BR",ltr?"BR":"BL");break;case "below-alt":ltr=!ltr;case "below":push(ltr?"BL":"BR",ltr?"TL":"TR");push(ltr?"BR":"BL",ltr?"TR":"TL");break;case "above-alt":ltr=!ltr;case "above":push(ltr?"TL":"TR",ltr?"BL":"BR");push(ltr?"TR":"TL",ltr?"BR":"BL");break;default:push(pos.aroundCorner,pos.corner);}});var _4c8=_49d(node,_4c5,_4b8,{w:_4c3,h:_4c4});_4c8.aroundNodePos=_4b9;return _4c8;}};return _49c.place=_4af;});},"dijit/Viewport":function(){define(["dojo/Evented","dojo/on","dojo/domReady","dojo/sniff","dojo/window"],function(_4c9,on,_4ca,has,_4cb){var _4cc=new _4c9();var _4cd;_4ca(function(){var _4ce=_4cb.getBox();_4cc._rlh=on(window,"resize",function(){var _4cf=_4cb.getBox();if(_4ce.h==_4cf.h&&_4ce.w==_4cf.w){return;}_4ce=_4cf;_4cc.emit("resize");});if(has("ie")==8){var _4d0=screen.deviceXDPI;setInterval(function(){if(screen.deviceXDPI!=_4d0){_4d0=screen.deviceXDPI;_4cc.emit("resize");}},500);}if(has("ios")){on(document,"focusin",function(evt){_4cd=evt.target;});on(document,"focusout",function(evt){_4cd=null;});}});_4cc.getEffectiveBox=function(doc){var box=_4cb.getBox(doc);var tag=_4cd&&_4cd.tagName&&_4cd.tagName.toLowerCase();if(has("ios")&&_4cd&&!_4cd.readOnly&&(tag=="textarea"||(tag=="input"&&/^(color|email|number|password|search|tel|text|url)$/.test(_4cd.type)))){box.h*=(orientation==0||orientation==180?0.66:0.4);var rect=_4cd.getBoundingClientRect();box.h=Math.max(box.h,rect.top+rect.height);}return box;};return _4cc;});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(lang,has,_4d1,dom,geom,_4d2,_4d3){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var body=_4d1.body(doc),_4d4=_4d3.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},body,"last"),div=_4d3.create("div",{style:{overflow:"hidden",direction:"ltr"}},_4d4,"last"),ret=geom.position(div).x!=0;_4d4.removeChild(div);body.removeChild(_4d4);return ret;});has.add("position-fixed-support",function(win,doc){var body=_4d1.body(doc),_4d5=_4d3.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},body,"last"),_4d6=_4d3.create("span",{style:{position:"fixed",left:"0",top:"0"}},_4d5,"last"),ret=geom.position(_4d6).x!=geom.position(_4d5).x;_4d5.removeChild(_4d6);body.removeChild(_4d5);return ret;});var _4d7={getBox:function(doc){doc=doc||_4d1.doc;var _4d8=(doc.compatMode=="BackCompat")?_4d1.body(doc):doc.documentElement,_4d9=geom.docScroll(doc),w,h;if(has("touch")){var _4da=_4d7.get(doc);w=_4da.innerWidth||_4d8.clientWidth;h=_4da.innerHeight||_4d8.clientHeight;}else{w=_4d8.clientWidth;h=_4d8.clientHeight;}return {l:_4d9.x,t:_4d9.y,w:w,h:h};},get:function(doc){if(has("ie")&&_4d7!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_4d1.doc,body=_4d1.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie")||has("trident"),isWK=has("webkit");if(node==body||node==html){return;}if(!(has("mozilla")||isIE||isWK||has("opera")||has("trident")||has("edge"))&&("scrollIntoView" in node)){node.scrollIntoView(false);return;}var _4db=doc.compatMode=="BackCompat",_4dc=Math.min(body.clientWidth||html.clientWidth,html.clientWidth||body.clientWidth),_4dd=Math.min(body.clientHeight||html.clientHeight,html.clientHeight||body.clientHeight),_4de=(isWK||_4db)?body:html,_4df=pos||geom.position(node),el=node.parentNode,_4e0=function(el){return (isIE<=6||(isIE==7&&_4db))?false:(has("position-fixed-support")&&(_4d2.get(el,"position").toLowerCase()=="fixed"));},self=this,_4e1=function(el,x,y){if(el.tagName=="BODY"||el.tagName=="HTML"){self.get(el.ownerDocument).scrollBy(x,y);}else{x&&(el.scrollLeft+=x);y&&(el.scrollTop+=y);}};if(_4e0(node)){return;}while(el){if(el==body){el=_4de;}var _4e2=geom.position(el),_4e3=_4e0(el),rtl=_4d2.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_4de){_4e2.w=_4dc;_4e2.h=_4dd;if(_4de==html&&(isIE||has("trident"))&&rtl){_4e2.x+=_4de.offsetWidth-_4e2.w;}_4e2.x=0;_4e2.y=0;}else{var pb=geom.getPadBorderExtents(el);_4e2.w-=pb.w;_4e2.h-=pb.h;_4e2.x+=pb.l;_4e2.y+=pb.t;var _4e4=el.clientWidth,_4e5=_4e2.w-_4e4;if(_4e4>0&&_4e5>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_4e2.x+=_4e5;}_4e2.w=_4e4;}_4e4=el.clientHeight;_4e5=_4e2.h-_4e4;if(_4e4>0&&_4e5>0){_4e2.h=_4e4;}}if(_4e3){if(_4e2.y<0){_4e2.h+=_4e2.y;_4e2.y=0;}if(_4e2.x<0){_4e2.w+=_4e2.x;_4e2.x=0;}if(_4e2.y+_4e2.h>_4dd){_4e2.h=_4dd-_4e2.y;}if(_4e2.x+_4e2.w>_4dc){_4e2.w=_4dc-_4e2.x;}}var l=_4df.x-_4e2.x,t=_4df.y-_4e2.y,r=l+_4df.w-_4e2.w,bot=t+_4df.h-_4e2.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_4de||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_4db)||has("trident")>=5)){s=-s;}old=el.scrollLeft;_4e1(el,s,0);s=el.scrollLeft-old;_4df.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_4de||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;_4e1(el,0,s);s=el.scrollTop-old;_4df.y-=s;}el=(el!=_4de)&&!_4e3&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_4d7);return _4d7;});},"dijit/_Widget":function(){define(["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_4e6,_4e7,_4e8,_4e9,has,_4ea,lang,_4eb,_4ec,_4ed,_4ee,_4ef,_4f0){function _4f1(){};function _4f2(_4f3){return function(obj,_4f4,_4f5,_4f6){if(obj&&typeof _4f4=="string"&&obj[_4f4]==_4f1){return obj.on(_4f4.substring(2).toLowerCase(),lang.hitch(_4f5,_4f6));}return _4f3.apply(_4e8,arguments);};};_4e6.around(_4e8,"connect",_4f2);if(_4ea.connect){_4e6.around(_4ea,"connect",_4f2);}var _4f7=_4e9("dijit._Widget",[_4ee,_4ef,_4f0],{onClick:_4f1,onDblClick:_4f1,onKeyDown:_4f1,onKeyPress:_4f1,onKeyUp:_4f1,onMouseDown:_4f1,onMouseMove:_4f1,onMouseOut:_4f1,onMouseOver:_4f1,onMouseLeave:_4f1,onMouseEnter:_4f1,onMouseUp:_4f1,constructor:function(_4f8){this._toConnect={};for(var name in _4f8){if(this[name]===_4f1){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_4f8[name];delete _4f8[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_4f1){return _4e8.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_4f9){_4ea.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_4f9);},attr:function(name,_4fa){var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_4ea.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_4eb("[widgetId]",this.containerNode).map(_4ed.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_4ec(0,function(){var _4fb=["dijit/_base"];require(_4fb);});}return _4f7;});},"dijit/_WidgetBase":function(){define(["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","dojo/has!dojo-bidi?./_BidiMixin","./registry"],function(_4fc,_4fd,_4fe,_4ff,_500,_501,dom,_502,_503,_504,_505,_506,has,_507,lang,on,_508,_509,_50a,win,_50b,_50c,_50d){has.add("dijit-legacy-requires",!_507.isAsync);has.add("dojo-bidi",false);if(has("dijit-legacy-requires")){_508(0,function(){var _50e=["dijit/_base/manager"];_4fc(_50e);});}var _50f={};function _510(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _511(attr){return function(val){_502[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};function _512(a,b){return a===b||(a!==a&&b!==b);};var _513=_501("dijit._WidgetBase",[_509,_50b],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_511("lang"),dir:"",_setDirAttr:_511("dir"),"class":"",_setClassAttr:{node:"domNode",type:"class"},_setTypeAttr:null,style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_4ff.blankGif||_4fc.toUrl("dojo/resources/blank.gif"),textDir:"",_introspect:function(){var ctor=this.constructor;if(!ctor._setterAttrs){var _514=ctor.prototype,_515=ctor._setterAttrs=[],_516=(ctor._onMap={});for(var name in _514.attributeMap){_515.push(name);}for(name in _514){if(/^on/.test(name)){_516[name.substring(2).toLowerCase()]=name;}if(/^_set[A-Z](.*)Attr$/.test(name)){name=name.charAt(4).toLowerCase()+name.substr(5,name.length-9);if(!_514.attributeMap||!(name in _514.attributeMap)){_515.push(name);}}}}},postscript:function(_517,_518){this.create(_517,_518);},create:function(_519,_51a){this._introspect();this.srcNodeRef=dom.byId(_51a);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&this.srcNodeRef.id&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_519){this.params=_519;lang.mixin(this,_519);}this.postMixInProperties();if(!this.id){this.id=_50d.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:document);this.ownerDocumentBody=win.body(this.ownerDocument);_50d.add(this);this.buildRendering();var _51b;if(this.domNode){this._applyAttributes();var _51c=this.srcNodeRef;if(_51c&&_51c.parentNode&&this.domNode!==_51c){_51c.parentNode.replaceChild(this.domNode,_51c);_51b=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_51b){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var _51d={};for(var key in this.params||{}){_51d[key]=this._get(key);}_4fd.forEach(this.constructor._setterAttrs,function(key){if(!(key in _51d)){var val=this._get(key);if(val){this.set(key,val);}}},this);for(key in _51d){this.set(key,_51d[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _51e=this.baseClass.split(" ");if(!this.isLeftToRight()){_51e=_51e.concat(_4fd.map(_51e,function(name){return name+"Rtl";}));}_503.add(this.domNode,_51e);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_4fd.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_51f){this._beingDestroyed=true;this.destroyDescendants(_51f);this.destroy(_51f);},destroy:function(_520){this._beingDestroyed=true;this.uninitialize();function _521(w){if(w.destroyRecursive){w.destroyRecursive(_520);}else{if(w.destroy){w.destroy(_520);}}};_4fd.forEach(this._connects,lang.hitch(this,"disconnect"));_4fd.forEach(this._supportingWidgets,_521);if(this.domNode){_4fd.forEach(_50d.findWidgets(this.domNode,this.containerNode),_521);}this.destroyRendering(_520);_50d.remove(this.id);this._destroyed=true;},destroyRendering:function(_522){if(this.bgIframe){this.bgIframe.destroy(_522);delete this.bgIframe;}if(this.domNode){if(_522){_502.remove(this.domNode,"widgetId");}else{_504.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_522){_504.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_523){_4fd.forEach(this.getChildren(),function(_524){if(_524.destroyRecursive){_524.destroyRecursive(_523);}});},uninitialize:function(){return false;},_setStyleAttr:function(_525){var _526=this.domNode;if(lang.isObject(_525)){_506.set(_526,_525);}else{if(_526.style.cssText){_526.style.cssText+="; "+_525;}else{_526.style.cssText=_525;}}this._set("style",_525);},_attrToDom:function(attr,_527,_528){_528=arguments.length>=3?_528:this.attributeMap[attr];_4fd.forEach(lang.isArray(_528)?_528:[_528],function(_529){var _52a=this[_529.node||_529||"domNode"];var type=_529.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_527)){_527=lang.hitch(this,_527);}var _52b=_529.attribute?_529.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_52a.tagName){_502.set(_52a,_52b,_527);}else{_52a.set(_52b,_527);}break;case "innerText":_52a.innerHTML="";_52a.appendChild(this.ownerDocument.createTextNode(_527));break;case "textContent":_52a.textContent=_527;break;case "innerHTML":_52a.innerHTML=_527;break;case "class":_503.replace(_52a,_527,this[attr]);break;case "toggleClass":_503.toggle(_52a,_529.className||attr,_527);break;}},this);},get:function(name){var _52c=this._getAttrNames(name);return this[_52c.g]?this[_52c.g]():this._get(name);},set:function(name,_52d){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _52e=this._getAttrNames(name),_52f=this[_52e.s];if(lang.isFunction(_52f)){var _530=_52f.apply(this,Array.prototype.slice.call(arguments,1));}else{var _531=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_531]&&this[_531].tagName,_532=tag&&(_50f[tag]||(_50f[tag]=_510(this[_531]))),map=name in this.attributeMap?this.attributeMap[name]:_52e.s in this?this[_52e.s]:((_532&&_52e.l in _532&&typeof _52d!="function")||/^aria-|^data-|^role$/.test(name))?_531:null;if(map!=null){this._attrToDom(name,_52d,map);}this._set(name,_52d);}return _530||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_533){var _534=this[name];this[name]=_533;if(this._created&&!_512(_534,_533)){if(this._watchCallbacks){this._watchCallbacks(name,_534,_533);}this.emit("attrmodified-"+name,{detail:{prevValue:_534,newValue:_533}});}},_get:function(name){return this[name];},emit:function(type,_535,_536){_535=_535||{};if(_535.bubbles===undefined){_535.bubbles=true;}if(_535.cancelable===undefined){_535.cancelable=true;}if(!_535.detail){_535.detail={};}_535.detail.widget=this;var ret,_537=this["on"+type];if(_537){ret=_537.apply(this,_536?_536:[_535]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_535);}return ret;},on:function(type,func){var _538=this._onMap(type);if(_538){return _4fe.after(this,_538,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_50d.findWidgets(this.containerNode):[];},getParent:function(){return _50d.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_539,_53a){return this.own(_500.connect(obj,_539,this,_53a))[0];},disconnect:function(_53b){_53b.remove();},subscribe:function(t,_53c){return this.own(_50a.subscribe(t,lang.hitch(this,_53c)))[0];},unsubscribe:function(_53d){_53d.remove();},isLeftToRight:function(){return this.dir?(this.dir.toLowerCase()=="ltr"):_505.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_506.get(this.domNode,"display")!="none");},placeAt:function(_53e,_53f){var _540=!_53e.tagName&&_50d.byId(_53e);if(_540&&_540.addChild&&(!_53f||typeof _53f==="number")){_540.addChild(this,_53f);}else{var ref=_540&&("domNode" in _540)?(_540.containerNode&&!/after|before|replace/.test(_53f||"")?_540.containerNode:_540.domNode):dom.byId(_53e,this.ownerDocument);_504.place(this.domNode,ref,_53f);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},defer:function(fcn,_541){var _542=setTimeout(lang.hitch(this,function(){if(!_542){return;}_542=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_541||0);return {remove:function(){if(_542){clearTimeout(_542);_542=null;}return null;}};}});if(has("dojo-bidi")){_513.extend(_50c);}return _513;});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_543,lang,_544,when){return _543("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_545){if(_545){this.set(_545);}},_get:function(name,_546){return typeof this[_546.g]==="function"?this[_546.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_547){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _548=this._getAttrNames(name),_549=this._get(name,_548),_54a=this[_548.s],_54b;if(typeof _54a==="function"){_54b=_54a.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_547;}if(this._watchCallbacks){var self=this;when(_54b,function(){self._watchCallbacks(name,_549,_547);});}return this;},_changeAttrValue:function(name,_54c){var _54d=this.get(name);this[name]=_54c;if(this._watchCallbacks){this._watchCallbacks(name,_54d,_54c);}return this;},watch:function(name,_54e){var _54f=this._watchCallbacks;if(!_54f){var self=this;_54f=this._watchCallbacks=function(name,_550,_551,_552){var _553=function(_554){if(_554){_554=_554.slice();for(var i=0,l=_554.length;i<l;i++){_554[i].call(self,name,_550,_551);}}};_553(_54f["_"+name]);if(!_552){_553(_54f["*"]);}};}if(!_54e&&typeof name==="function"){_54e=name;name="*";}else{name="_"+name;}var _555=_54f[name];if(typeof _555!=="object"){_555=_54f[name]=[];}_555.push(_54e);var _556={};_556.unwatch=_556.remove=function(){var _557=_544.indexOf(_555,_54e);if(_557>-1){_555.splice(_557,1);}};return _556;}});});},"dijit/Destroyable":function(){define(["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_558,_559,_55a){return _55a("dijit.Destroyable",null,{destroy:function(_55b){this._destroyed=true;},own:function(){var _55c=["destroyRecursive","destroy","remove"];_558.forEach(arguments,function(_55d){var _55e;var odh=_559.before(this,"destroy",function(_55f){_55d[_55e](_55f);});var hdhs=[];function _560(){odh.remove();_558.forEach(hdhs,function(hdh){hdh.remove();});};if(_55d.then){_55e="cancel";_55d.then(_560,_560);}else{_558.forEach(_55c,function(_561){if(typeof _55d[_561]==="function"){if(!_55e){_55e=_561;}hdhs.push(_559.after(_55d,_561,_560,true));}});}},this);return arguments;}});});},"dijit/_OnDijitClickMixin":function(){define(["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","./a11yclick"],function(on,_562,keys,_563,has,_564){var ret=_563("dijit._OnDijitClickMixin",null,{connect:function(obj,_565,_566){return this.inherited(arguments,[obj,_565=="ondijitclick"?_564:_565,_566]);}});ret.a11yclick=_564;return ret;});},"dijit/a11yclick":function(){define(["dojo/keys","dojo/mouse","dojo/on","dojo/touch"],function(keys,_567,on,_568){function _569(e){if((e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!/input|button|textarea/i.test(e.target.nodeName)){for(var node=e.target;node;node=node.parentNode){if(node.dojoClick){return true;}}}};var _56a;on(document,"keydown",function(e){if(_569(e)){_56a=e.target;e.preventDefault();}else{_56a=null;}});on(document,"keyup",function(e){if(_569(e)&&e.target==_56a){_56a=null;on.emit(e.target,"click",{cancelable:true,bubbles:true,ctrlKey:e.ctrlKey,shiftKey:e.shiftKey,metaKey:e.metaKey,altKey:e.altKey,_origType:e.type});}});var _56b=function(node,_56c){node.dojoClick=true;return on(node,"click",_56c);};_56b.click=_56b;_56b.press=function(node,_56d){var _56e=on(node,_568.press,function(evt){if(evt.type=="mousedown"&&!_567.isLeft(evt)){return;}_56d(evt);}),_56f=on(node,"keydown",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_56d(evt);}});return {remove:function(){_56e.remove();_56f.remove();}};};_56b.release=function(node,_570){var _571=on(node,_568.release,function(evt){if(evt.type=="mouseup"&&!_567.isLeft(evt)){return;}_570(evt);}),_572=on(node,"keyup",function(evt){if(evt.keyCode===keys.ENTER||evt.keyCode===keys.SPACE){_570(evt);}});return {remove:function(){_571.remove();_572.remove();}};};_56b.move=_568.move;return _56b;});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./dom-class","./_base/lang","./on","./has","./mouse","./domReady","./_base/window"],function(dojo,_573,dom,_574,lang,on,has,_575,_576,win){var ios4=has("ios")<5;var _577=has("pointer-events")||has("MSPointer"),_578=(function(){var _579={};for(var type in {down:1,move:1,up:1,cancel:1,over:1,out:1}){_579[type]=has("MSPointer")?"MSPointer"+type.charAt(0).toUpperCase()+type.slice(1):"pointer"+type;}return _579;})();var _57a=has("touch-events");var _57b,_57c,_57d=false,_57e,_57f,_580,_581,_582,_583;var _584;function _585(_586,_587,_588){if(_577&&_588){return function(node,_589){return on(node,_588,_589);};}else{if(_57a){return function(node,_58a){var _58b=on(node,_587,function(evt){_58a.call(this,evt);_584=(new Date()).getTime();}),_58c=on(node,_586,function(evt){if(!_584||(new Date()).getTime()>_584+1000){_58a.call(this,evt);}});return {remove:function(){_58b.remove();_58c.remove();}};};}else{return function(node,_58d){return on(node,_586,_58d);};}}};function _58e(node){do{if(node.dojoClick!==undefined){return node;}}while(node=node.parentNode);};function _58f(e,_590,_591){if(_575.isRight(e)){return;}var _592=_58e(e.target);_57c=!e.target.disabled&&_592&&_592.dojoClick;if(_57c){_57d=(_57c=="useTarget");_57e=(_57d?_592:e.target);if(_57d){e.preventDefault();}_57f=e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX;_580=e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY;_581=(typeof _57c=="object"?_57c.x:(typeof _57c=="number"?_57c:0))||4;_582=(typeof _57c=="object"?_57c.y:(typeof _57c=="number"?_57c:0))||4;if(!_57b){_57b=true;var _593=function _593(e){if(_57d){_57c=dom.isDescendant(win.doc.elementFromPoint((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX),(e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)),_57e);}else{_57c=_57c&&(e.changedTouches?e.changedTouches[0].target:e.target)==_57e&&Math.abs((e.changedTouches?e.changedTouches[0].pageX-win.global.pageXOffset:e.clientX)-_57f)<=_581&&Math.abs((e.changedTouches?e.changedTouches[0].pageY-win.global.pageYOffset:e.clientY)-_580)<=_582;}};win.doc.addEventListener(_590,function(e){if(_575.isRight(e)){return;}_593(e);if(_57d){e.preventDefault();}},true);win.doc.addEventListener(_591,function(e){if(_575.isRight(e)){return;}_593(e);if(_57c){_583=(new Date()).getTime();var _594=(_57d?_57e:e.target);if(_594.tagName==="LABEL"){_594=dom.byId(_594.getAttribute("for"))||_594;}var src=(e.changedTouches)?e.changedTouches[0]:e;var _595=function _595(type){var evt=document.createEvent("MouseEvents");evt._dojo_click=true;evt.initMouseEvent(type,true,true,e.view,e.detail,src.screenX,src.screenY,src.clientX,src.clientY,e.ctrlKey,e.altKey,e.shiftKey,e.metaKey,0,null);return evt;};var _596=_595("mousedown");var _597=_595("mouseup");var _598=_595("click");setTimeout(function(){on.emit(_594,"mousedown",_596);on.emit(_594,"mouseup",_597);on.emit(_594,"click",_598);_583=(new Date()).getTime();},0);}},true);var _599=function _599(type){win.doc.addEventListener(type,function(e){var _59a=e.target;if(_57c&&!e._dojo_click&&(new Date()).getTime()<=_583+1000&&!(_59a.tagName=="INPUT"&&_574.contains(_59a,"dijitOffScreen"))){e.stopPropagation();e.stopImmediatePropagation&&e.stopImmediatePropagation();if(type=="click"&&(_59a.tagName!="INPUT"||(_59a.type=="radio"&&(_574.contains(_59a,"dijitCheckBoxInput")||_574.contains(_59a,"mblRadioButton")))||(_59a.type=="checkbox"&&(_574.contains(_59a,"dijitCheckBoxInput")||_574.contains(_59a,"mblCheckBox"))))&&_59a.tagName!="TEXTAREA"&&_59a.tagName!="AUDIO"&&_59a.tagName!="VIDEO"){e.preventDefault();}}},true);};_599("click");_599("mousedown");_599("mouseup");}}};var _59b;if(has("touch")){if(_577){_576(function(){win.doc.addEventListener(_578.down,function(evt){_58f(evt,_578.move,_578.up);},true);});}else{_576(function(){_59b=win.body();win.doc.addEventListener("touchstart",function(evt){_584=(new Date()).getTime();var _59c=_59b;_59b=evt.target;on.emit(_59c,"dojotouchout",{relatedTarget:_59b,bubbles:true});on.emit(_59b,"dojotouchover",{relatedTarget:_59c,bubbles:true});_58f(evt,"touchmove","touchend");},true);function _59d(evt){var _59e=lang.delegate(evt,{bubbles:true});if(has("ios")>=6){_59e.touches=evt.touches;_59e.altKey=evt.altKey;_59e.changedTouches=evt.changedTouches;_59e.ctrlKey=evt.ctrlKey;_59e.metaKey=evt.metaKey;_59e.shiftKey=evt.shiftKey;_59e.targetTouches=evt.targetTouches;}return _59e;};on(win.doc,"touchmove",function(evt){_584=(new Date()).getTime();var _59f=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_59f){if(_59b!==_59f){on.emit(_59b,"dojotouchout",{relatedTarget:_59f,bubbles:true});on.emit(_59f,"dojotouchover",{relatedTarget:_59b,bubbles:true});_59b=_59f;}if(!on.emit(_59f,"dojotouchmove",_59d(evt))){evt.preventDefault();}}});on(win.doc,"touchend",function(evt){_584=(new Date()).getTime();var node=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset))||win.body();on.emit(node,"dojotouchend",_59d(evt));});});}}var _5a0={press:_585("mousedown","touchstart",_578.down),move:_585("mousemove","dojotouchmove",_578.move),release:_585("mouseup","dojotouchend",_578.up),cancel:_585(_575.leave,"touchcancel",_577?_578.cancel:null),over:_585("mouseover","dojotouchover",_578.over),out:_585("mouseout","dojotouchout",_578.out),enter:_575._eventHandler(_585("mouseover","dojotouchover",_578.over)),leave:_575._eventHandler(_585("mouseout","dojotouchout",_578.out))};1&&(dojo.touch=_5a0);return _5a0;});},"dijit/_FocusMixin":function(){define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_5a1,_5a2,_5a3,lang){lang.extend(_5a2,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _5a3("dijit._FocusMixin",null,{_focusManager:_5a1});});},"dijit/focus":function(){define(["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/domReady","dojo/sniff","dojo/Stateful","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_5a4,_5a5,dom,_5a6,_5a7,_5a8,_5a9,lang,on,_5aa,has,_5ab,win,_5ac,a11y,_5ad,_5ae){var _5af;var _5b0;var _5b1=_5a5([_5ab,_5a9],{curNode:null,activeStack:[],constructor:function(){var _5b2=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_5a4.before(_5a8,"empty",_5b2);_5a4.before(_5a8,"destroy",_5b2);},registerIframe:function(_5b3){return this.registerWin(_5b3.contentWindow,_5b3);},registerWin:function(_5b4,_5b5){var _5b6=this,body=_5b4.document&&_5b4.document.body;if(body){var _5b7=has("pointer-events")?"pointerdown":has("MSPointer")?"MSPointerDown":has("touch-events")?"mousedown, touchstart":"mousedown";var mdh=on(_5b4.document,_5b7,function(evt){if(evt&&evt.target&&evt.target.parentNode==null){return;}_5b6._onTouchNode(_5b5||evt.target,"mouse");});var fih=on(body,"focusin",function(evt){if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isFocusable(evt.target)){_5b6._onFocusNode(_5b5||evt.target);}else{_5b6._onTouchNode(_5b5||evt.target);}});var foh=on(body,"focusout",function(evt){_5b6._onBlurNode(_5b5||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;body=null;}};}},_onBlurNode:function(node){var now=(new Date()).getTime();if(now<_5af+100){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}if(now<_5b0+100){return;}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){_5b0=(new Date()).getTime();if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}if(_5a7.contains(node,"dijitPopup")){node=node.firstChild;}var _5b8=[];try{while(node){var _5b9=_5a6.get(node,"dijitPopupParent");if(_5b9){node=_5ad.byId(_5b9).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_5ac.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_5ba=id&&_5ad.byId(id);if(_5ba&&!(by=="mouse"&&_5ba.get("disabled"))){_5b8.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_5b8,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}_5af=(new Date()).getTime();if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_5bb,by){var _5bc=this.activeStack,_5bd=_5bc.length-1,_5be=_5bb.length-1;if(_5bb[_5be]==_5bc[_5bd]){return;}this.set("activeStack",_5bb);var _5bf,i;for(i=_5bd;i>=0&&_5bc[i]!=_5bb[i];i--){_5bf=_5ad.byId(_5bc[i]);if(_5bf){_5bf._hasBeenBlurred=true;_5bf.set("focused",false);if(_5bf._focusManager==this){_5bf._onBlur(by);}this.emit("widget-blur",_5bf,by);}}for(i++;i<=_5be;i++){_5bf=_5ad.byId(_5bb[i]);if(_5bf){_5bf.set("focused",true);if(_5bf._focusManager==this){_5bf._onFocus(by);}this.emit("widget-focus",_5bf,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _5c0=new _5b1();_5aa(function(){var _5c1=_5c0.registerWin(_5ac.get(document));if(has("ie")){on(window,"unload",function(){if(_5c1){_5c1.remove();_5c1=null;}});}});_5ae.focus=function(node){_5c0.focus(node);};for(var attr in _5c0){if(!/^_/.test(attr)){_5ae.focus[attr]=typeof _5c0[attr]=="function"?lang.hitch(_5c0,attr):_5c0[attr];}}_5c0.watch(function(attr,_5c2,_5c3){_5ae.focus[attr]=_5c3;});return _5c0;});},"dijit/a11y":function(){define(["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_5c4,dom,_5c5,_5c6,lang,has,_5c7){var _5c8;var a11y={_isElementShown:function(elem){var s=_5c6.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_5c5.get(elem,"type")!="hidden");},hasDefaultTabStop:function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _5c5.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _5c9=elem.contentDocument;if("designMode" in _5c9&&_5c9.designMode=="on"){return true;}body=_5c9.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}},effectiveTabIndex:function(elem){if(_5c5.get(elem,"disabled")){return _5c8;}else{if(_5c5.has(elem,"tabIndex")){return +_5c5.get(elem,"tabIndex");}else{return a11y.hasDefaultTabStop(elem)?0:_5c8;}}},isTabNavigable:function(elem){return a11y.effectiveTabIndex(elem)>=0;},isFocusable:function(elem){return a11y.effectiveTabIndex(elem)>=-1;},_getTabNavigable:function(root){var _5ca,last,_5cb,_5cc,_5cd,_5ce,_5cf={};function _5d0(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _5d1=a11y._isElementShown,_5d2=a11y.effectiveTabIndex;var _5d3=function(_5d4){for(var _5d5=_5d4.firstChild;_5d5;_5d5=_5d5.nextSibling){if(_5d5.nodeType!=1||(has("ie")<=9&&_5d5.scopeName!=="HTML")||!_5d1(_5d5)){continue;}var _5d6=_5d2(_5d5);if(_5d6>=0){if(_5d6==0){if(!_5ca){_5ca=_5d5;}last=_5d5;}else{if(_5d6>0){if(!_5cb||_5d6<_5cc){_5cc=_5d6;_5cb=_5d5;}if(!_5cd||_5d6>=_5ce){_5ce=_5d6;_5cd=_5d5;}}}var rn=_5d0(_5d5);if(_5c5.get(_5d5,"checked")&&rn){_5cf[rn]=_5d5;}}if(_5d5.nodeName.toUpperCase()!="SELECT"){_5d3(_5d5);}}};if(_5d1(root)){_5d3(root);}function rs(node){return _5cf[_5d0(node)]||node;};return {first:rs(_5ca),last:rs(last),lowest:rs(_5cb),highest:rs(_5cd)};},getFirstInTabbingOrder:function(root,doc){var _5d7=a11y._getTabNavigable(dom.byId(root,doc));return _5d7.lowest?_5d7.lowest:_5d7.first;},getLastInTabbingOrder:function(root,doc){var _5d8=a11y._getTabNavigable(dom.byId(root,doc));return _5d8.last?_5d8.last:_5d8.highest;}};1&&lang.mixin(_5c7,a11y);return a11y;});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./domReady","./sniff","./_base/window"],function(_5d9,lang,_5da,has,_5db){var html=_5db.doc.documentElement,ie=has("ie"),_5dc=has("trident"),_5dd=has("opera"),maj=Math.floor,ff=has("ff"),_5de=_5d9.boxModel.replace(/-/,""),_5df={"dj_quirks":has("quirks"),"dj_opera":_5dd,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_edge":has("edge"),"dj_gecko":has("mozilla"),"dj_ios":has("ios"),"dj_android":has("android")};if(ie){_5df["dj_ie"]=true;_5df["dj_ie"+maj(ie)]=true;_5df["dj_iequirks"]=has("quirks");}if(_5dc){_5df["dj_trident"]=true;_5df["dj_trident"+maj(_5dc)]=true;}if(ff){_5df["dj_ff"+maj(ff)]=true;}_5df["dj_"+_5de]=true;var _5e0="";for(var clz in _5df){if(_5df[clz]){_5e0+=clz+" ";}}html.className=lang.trim(html.className+" "+_5e0);_5da(function(){if(!_5d9.isBodyLtr()){var _5e1="dj_rtl dijitRtl "+_5e0.replace(/ /g,"-rtl ");html.className=lang.trim(html.className+" "+_5e1+"dj_rtl dijitRtl "+_5e0.replace(/ /g,"-rtl "));}});return has;});},"dijit/hccss":function(){define(["dojo/dom-class","dojo/hccss","dojo/domReady","dojo/_base/window"],function(_5e2,has,_5e3,win){_5e3(function(){if(has("highcontrast")){_5e2.add(win.body(),"dijit_a11y");}});return has;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./domReady","./_base/window"],function(_5e4,_5e5,_5e6,_5e7,has,_5e8,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");try{div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url(\""+(_5e5.blankGif||_5e4.toUrl("./resources/blank.gif"))+"\");";win.body().appendChild(div);var cs=_5e7.getComputedStyle(div),_5e9=cs.backgroundImage;return cs.borderTopColor==cs.borderRightColor||(_5e9&&(_5e9=="none"||_5e9=="url(invalid-url:)"));}catch(e){console.warn("hccss: exception detecting high-contrast mode, document is likely hidden: "+e.toString());return false;}finally{if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}}});_5e8(function(){if(has("highcontrast")){_5e6.add(win.body(),"dj_a11y");}});return has;});},"dijit/_TemplatedMixin":function(){define(["dojo/cache","dojo/_base/declare","dojo/dom-construct","dojo/_base/lang","dojo/on","dojo/sniff","dojo/string","./_AttachMixin"],function(_5ea,_5eb,_5ec,lang,on,has,_5ed,_5ee){var _5ef=_5eb("dijit._TemplatedMixin",_5ee,{templateString:null,templatePath:null,_skipNodeCache:false,searchContainerNode:true,_stringRepl:function(tmpl){var _5f0=this.declaredClass,_5f1=this;return _5ed.substitute(tmpl,this,function(_5f2,key){if(key.charAt(0)=="!"){_5f2=lang.getObject(key.substr(1),false,_5f1);}if(typeof _5f2=="undefined"){throw new Error(_5f0+" template:"+key);}if(_5f2==null){return "";}return key.charAt(0)=="!"?_5f2:this._escapeValue(""+_5f2);},this);},_escapeValue:function(val){return val.replace(/["'<>&]/g,function(val){return {"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;"}[val];});},buildRendering:function(){if(!this._rendered){if(!this.templateString){this.templateString=_5ea(this.templatePath,{sanitize:true});}var _5f3=_5ef.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_5f3)){node=_5ec.toDom(this._stringRepl(_5f3),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_5f3);}}else{node=_5f3.cloneNode(true);}this.domNode=node;}this.inherited(arguments);if(!this._rendered){this._fillContent(this.srcNodeRef);}this._rendered=true;},_fillContent:function(_5f4){var dest=this.containerNode;if(_5f4&&dest){while(_5f4.hasChildNodes()){dest.appendChild(_5f4.firstChild);}}}});_5ef._templateCache={};_5ef.getCachedTemplate=function(_5f5,_5f6,doc){var _5f7=_5ef._templateCache;var key=_5f5;var _5f8=_5f7[key];if(_5f8){try{if(!_5f8.ownerDocument||_5f8.ownerDocument==(doc||document)){return _5f8;}}catch(e){}_5ec.destroy(_5f8);}_5f5=_5ed.trim(_5f5);if(_5f6||_5f5.match(/\$\{([^\}]+)\}/g)){return (_5f7[key]=_5f5);}else{var node=_5ec.toDom(_5f5,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_5f5);}return (_5f7[key]=node);}};if(has("ie")){on(window,"unload",function(){var _5f9=_5ef._templateCache;for(var key in _5f9){var _5fa=_5f9[key];if(typeof _5fa=="object"){_5ec.destroy(_5fa);}delete _5f9[key];}});}return _5ef;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dojo/text":function(){define(["./_base/kernel","require","./has","./request"],function(dojo,_5fb,has,_5fc){var _5fd;if(1){_5fd=function(url,sync,load){_5fc(url,{sync:!!sync,headers:{"X-Requested-With":null}}).then(load);};}else{if(_5fb.getText){_5fd=_5fb.getText;}else{console.error("dojo/text plugin failed to load because loader does not support getText");}}var _5fe={},_5ff=function(text){if(text){text=text.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");var _600=text.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(_600){text=_600[1];}}else{text="";}return text;},_601={},_602={};dojo.cache=function(_603,url,_604){var key;if(typeof _603=="string"){if(/\//.test(_603)){key=_603;_604=url;}else{key=_5fb.toUrl(_603.replace(/\./g,"/")+(url?("/"+url):""));}}else{key=_603+"";_604=url;}var val=(_604!=undefined&&typeof _604!="string")?_604.value:_604,_605=_604&&_604.sanitize;if(typeof val=="string"){_5fe[key]=val;return _605?_5ff(val):val;}else{if(val===null){delete _5fe[key];return null;}else{if(!(key in _5fe)){_5fd(key,true,function(text){_5fe[key]=text;});}return _605?_5ff(_5fe[key]):_5fe[key];}}};return {dynamic:true,normalize:function(id,_606){var _607=id.split("!"),url=_607[0];return (/^\./.test(url)?_606(url):url)+(_607[1]?"!"+_607[1]:"");},load:function(id,_608,load){var _609=id.split("!"),_60a=_609.length>1,_60b=_609[0],url=_608.toUrl(_609[0]),_60c="url:"+url,text=_601,_60d=function(text){load(_60a?_5ff(text):text);};if(_60b in _5fe){text=_5fe[_60b];}else{if(_608.cache&&_60c in _608.cache){text=_608.cache[_60c];}else{if(url in _5fe){text=_5fe[url];}}}if(text===_601){if(_602[url]){_602[url].push(_60d);}else{var _60e=_602[url]=[_60d];_5fd(url,!_608.async,function(text){_5fe[_60b]=_5fe[url]=text;for(var i=0;i<_60e.length;){_60e[i++](text);}delete _602[url];});}}else{_60d(text);}}};});},"dojo/request":function(){define(["./request/default!"],function(_60f){return _60f;});},"dojo/request/default":function(){define(["exports","require","../has"],function(_610,_611,has){var _612=has("config-requestProvider"),_613;if(1||has("host-webworker")){_613="./xhr";}else{if(0){_613="./node";}}if(!_612){_612=_613;}_610.getPlatformDefaultId=function(){return _613;};_610.load=function(id,_614,_615,_616){_611([id=="platform"?_613:_612],function(_617){_615(_617);});};});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_618,lang){var _619=/[&<>'"\/]/g;var _61a={"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#x27;","/":"&#x2F;"};var _61b={};lang.setObject("dojo.string",_61b);_61b.escape=function(str){if(!str){return "";}return str.replace(_619,function(c){return _61a[c];});};_61b.codePointAt=String.prototype.codePointAt?function(str,_61c){return String.prototype.codePointAt.call(str,_61c);}:function(str,_61d){if(str==null){throw new TypeError("codePointAt called on null or undefined");}var size;var _61e;var _61f;var _620;str=String(str);size=str.length;_620=_61d?Number(_61d):0;if(_620!=_620){_620=0;}if(_620<0||_620>=size){return undefined;}_61e=str.charCodeAt(_620);if(_61e>=55296&&_61e<=56319&&size>_620+1){_61f=str.charCodeAt(_620+1);if(_61f>=56320&&_61f<=57343){return (_61e-55296)*1024+_61f-56320+65536;}}return _61e;};_61b.fromCodePoint=String.fromCodePoint||function(){var _621=[];var _622=0;var _623="";var _624;var _625;for(_625=0,len=arguments.length;_625!==len;++_625){_624=+arguments[_625];if(!(_624<1114111&&(_624>>>0)===_624)){throw RangeError("Invalid code point: "+_624);}if(_624<=65535){_622=_621.push(_624);}else{_624-=65536;_622=_621.push((_624>>10)+55296,(_624%1024)+56320);}if(_622>=16383){_623+=String.fromCharCode.apply(null,_621);_621.length=0;}}return _623+String.fromCharCode.apply(null,_621);};_61b.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_61b.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_61b.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_61b.substitute=function(_626,map,_627,_628){_628=_628||_618.global;_627=_627?lang.hitch(_628,_627):function(v){return v;};return _626.replace(/\$\{([^\s\:\}]*)(?:\:([^\s\:\}]+))?\}/g,function(_629,key,_62a){if(key==""){return "$";}var _62b=lang.getObject(key,false,map);if(_62a){_62b=lang.getObject(_62a,false,_628).call(_628,_62b,key);}var _62c=_627(_62b,key);if(typeof _62c==="undefined"){throw new Error("string.substitute could not find key \""+key+"\" in template");}return _62c.toString();});};_61b.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _61b;});},"dijit/_AttachMixin":function(){define(["require","dojo/_base/array","dojo/_base/connect","dojo/_base/declare","dojo/_base/lang","dojo/mouse","dojo/on","dojo/touch","./_WidgetBase"],function(_62d,_62e,_62f,_630,lang,_631,on,_632,_633){var _634=lang.delegate(_632,{"mouseenter":_631.enter,"mouseleave":_631.leave,"keypress":_62f._keypress});var _635;var _636=_630("dijit._AttachMixin",null,{constructor:function(){this._attachPoints=[];this._attachEvents=[];},buildRendering:function(){this.inherited(arguments);this._attachTemplateNodes(this.domNode);this._beforeFillContent();},_beforeFillContent:function(){},_attachTemplateNodes:function(_637){var node=_637;while(true){if(node.nodeType==1&&(this._processTemplateNode(node,function(n,p){return n.getAttribute(p);},this._attach)||this.searchContainerNode)&&node.firstChild){node=node.firstChild;}else{if(node==_637){return;}while(!node.nextSibling){node=node.parentNode;if(node==_637){return;}}node=node.nextSibling;}}},_processTemplateNode:function(_638,_639,_63a){var ret=true;var _63b=this.attachScope||this,_63c=_639(_638,"dojoAttachPoint")||_639(_638,"data-dojo-attach-point");if(_63c){var _63d,_63e=_63c.split(/\s*,\s*/);while((_63d=_63e.shift())){if(lang.isArray(_63b[_63d])){_63b[_63d].push(_638);}else{_63b[_63d]=_638;}ret=(_63d!="containerNode");this._attachPoints.push(_63d);}}var _63f=_639(_638,"dojoAttachEvent")||_639(_638,"data-dojo-attach-event");if(_63f){var _640,_641=_63f.split(/\s*,\s*/);var trim=lang.trim;while((_640=_641.shift())){if(_640){var _642=null;if(_640.indexOf(":")!=-1){var _643=_640.split(":");_640=trim(_643[0]);_642=trim(_643[1]);}else{_640=trim(_640);}if(!_642){_642=_640;}this._attachEvents.push(_63a(_638,_640,lang.hitch(_63b,_642)));}}}return ret;},_attach:function(node,type,func){type=type.replace(/^on/,"").toLowerCase();if(type=="dijitclick"){type=_635||(_635=_62d("./a11yclick"));}else{type=_634[type]||type;}return on(node,type,func);},_detachTemplateNodes:function(){var _644=this.attachScope||this;_62e.forEach(this._attachPoints,function(_645){delete _644[_645];});this._attachPoints=[];_62e.forEach(this._attachEvents,function(_646){_646.remove();});this._attachEvents=[];},destroyRendering:function(){this._detachTemplateNodes();this.inherited(arguments);}});lang.extend(_633,{dojoAttachEvent:"",dojoAttachPoint:""});return _636;});},"dijit/BackgroundIframe":function(){define(["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff"],function(_647,_648,_649,_64a,_64b,lang,on,has){has.add("config-bgIframe",(has("ie")||has("trident"))&&!/IEMobile\/10\.0/.test(navigator.userAgent));var _64c=new function(){var _64d=[];this.pop=function(){var _64e;if(_64d.length){_64e=_64d.pop();_64e.style.display="";}else{if(has("ie")<9){var burl=_649["dojoBlankHtmlUrl"]||_647.toUrl("dojo/resources/blank.html")||"javascript:\"\"";var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";_64e=document.createElement(html);}else{_64e=_64a.create("iframe");_64e.src="javascript:\"\"";_64e.className="dijitBackgroundIframe";_64e.setAttribute("role","presentation");_64b.set(_64e,"opacity",0.1);}_64e.tabIndex=-1;}return _64e;};this.push=function(_64f){_64f.style.display="none";_64d.push(_64f);};}();_648.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}if(has("config-bgIframe")){var _650=(this.iframe=_64c.pop());node.appendChild(_650);if(has("ie")<7||has("quirks")){this.resize(node);this._conn=on(node,"resize",lang.hitch(this,"resize",node));}else{_64b.set(_650,{width:"100%",height:"100%"});}}};lang.extend(_648.BackgroundIframe,{resize:function(node){if(this.iframe){_64b.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});}},destroy:function(){if(this._conn){this._conn.remove();this._conn=null;}if(this.iframe){this.iframe.parentNode.removeChild(this.iframe);_64c.push(this.iframe);delete this.iframe;}}});return _648.BackgroundIframe;});},"dojox/lang/functional/scan":function(){define(["dojo/_base/kernel","dojo/_base/lang","./lambda"],function(_651,lang,df){var _652={};lang.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_651.global;f=df.lambda(f);var t,n,i;if(lang.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}else{t=[z];for(i in a){if(!(i in _652)){t.push(z=f.call(o,z,a[i],i,a));}}}}return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_651.global;f=df.lambda(f);var t,n,z,_653=true;if(lang.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i){}}else{if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a))){}}}else{for(i in a){if(!(i in _652)){if(_653){t=[z=a[i]];_653=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}}return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}o=o||_651.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}o=o||_651.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z){}return t;}});});},"dojox/charting/action2d/Highlight":function(){define(["dojo/_base/lang","dojo/_base/declare","dojo/_base/Color","dojo/_base/connect","dojox/color/_base","./PlotAction","dojo/fx/easing","dojox/gfx/fx"],function(lang,_654,_655,hub,c,_656,dfe,dgf){var _657=100,_658=75,_659=50,cc=function(_65a){return function(){return _65a;};},hl=function(_65b){var a=new c.Color(_65b),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=_657;if(x.l<_659){x.l=_658;}else{if(x.l>_658){x.l=_659;}else{x.l=x.l-_659>_658-x.l?_659:_658;}}}var _65c=c.fromHsl(x);_65c.a=a.a;return _65c;},_65d=function(_65e){var r=hl(_65e);r.a=0.7;return r;};return _654("dojox.charting.action2d.Highlight",_656,{defaultParams:{duration:400,easing:dfe.backOut},optionalParams:{highlight:"red"},constructor:function(_65f,plot,_660){var a=_660&&_660.highlight;this.colorFunc=a?(lang.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}if(o.element=="spider_circle"||o.element=="spider_plot"){return;}else{if(o.element=="spider_poly"&&this.colorFunc==hl){this.colorFunc=_65d;}}var _661=o.run.name,_662=o.index,anim;if(_661 in this.anim){anim=this.anim[_661][_662];}else{this.anim[_661]={};}if(anim){anim.action.stop(true);}else{var _663=o.shape.getFill();if(!_663||!(_663 instanceof _655)){return;}this.anim[_661][_662]=anim={start:_663,end:this.colorFunc(_663)};}var _664=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=_664;_664=end;end=t;}anim.action=dgf.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:_664,end:end}});if(o.type=="onmouseout"){hub.connect(anim.action,"onEnd",this,function(){if(this.anim[_661]){delete this.anim[_661][_662];}});}anim.action.play();}});});},"url:dijit/templates/Tooltip.html":"<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\" data-dojo-attach-event=\"mouseenter:onMouseEnter,mouseleave:onMouseLeave\"\n\t><div class=\"dijitTooltipConnector\" data-dojo-attach-point=\"connectorNode\"></div\n\t><div class=\"dijitTooltipContainer dijitTooltipContents\" data-dojo-attach-point=\"containerNode\" role='alert'></div\n></div>\n"}});var setStyle;require(["dojo/_base/declare","dojo/dom-style","dojo/ready","dojox/charting/Chart","dojo/store/Memory","dojox/charting/StoreSeries","dojox/charting/Theme","dojox/charting/action2d/PlotAction","dojox/charting/axis2d/Default","dojox/charting/plot2d/Columns","dojox/charting/plot2d/Lines","dojox/charting/plot2d/Pie","dojox/charting/plot2d/Grid","dojox/charting/action2d/Tooltip","dojox/charting/action2d/Highlight"],function(_665,_666,_667,_668,_669,_66a,_66b,_66c,_66d,_66e,_66f,Pie,Grid,_670,_671){setStyle=_666.set;var _672=[{month:"Jan",revenues:12435,profit:53,America:40,Europe:35,Asia:25},{month:"Feb",revenues:11425,profit:67,America:35,Europe:35,Asia:30},{month:"Mar",revenues:13534,profit:130,America:45,Europe:25,Asia:30},{month:"Apr",revenues:12001,profit:54,America:60,Europe:20,Asia:20},{month:"May",revenues:14334,profit:140,America:40,Europe:30,Asia:30},{month:"Jun",revenues:12400,profit:121,America:60,Europe:20,Asia:20},{month:"Jul",revenues:12212,profit:50,America:40,Europe:30,Asia:30},{month:"Aug",revenues:14424,profit:101,America:40,Europe:35,Asia:25},{month:"Nov",revenues:14134,profit:72,America:35,Europe:35,Asia:30},{month:"Oct",revenues:13242,profit:85,America:45,Europe:25,Asia:30},{month:"Nov",revenues:16312,profit:264,America:60,Europe:20,Asia:20},{month:"Dec",revenues:19132,profit:124,America:50,Europe:25,Asia:25}];var _673=_665(_66c,{constructor:function(_674,plot,_675){this.callback=_675;this.connect();},process:function(o){if(o.shape&&o.type=="onclick"||o.type=="onmouseover"){this.callback(o.index,o.type=="onclick");}}});_667(function(){var _676=new _669({data:_672});var _677=function(_678){if(_678>12||_678<1){return "";}return _672[_678-1].month;};var _679=new _66b({chart:{fill:{type:"linear",x1:0,y1:0,x2:0,y2:240,colors:[{offset:0,color:"#ececec"},{offset:0.5,color:"#cecece"},{offset:1,color:"#ececec"}]}},plotarea:{fill:{type:"linear",x1:0,y1:0,x2:0,y2:240,colors:[{offset:0,color:"#ececec"},{offset:0.5,color:"#cecece"},{offset:1,color:"#ececec"}]}},marker:{symbol:_66b.defaultMarkers.CIRCLE}});var _67a=new _668("chart1").setTheme(_679).addAxis("x",{majorTickStep:1,minorTicks:false,labelFunc:_677,minorLabels:false}).addAxis("ry",{vertical:true,fixLower:"major",fixUpper:"major",includeZero:true,majorTickStep:10000,max:30000,title:"Revenues"}).addAxis("py",{vertical:true,fixLower:"major",fixUpper:"major",includeZero:true,leftBottom:false,majorTickStep:100,max:300,title:"Profit"}).addPlot("profit",{type:"Default",vAxis:"py",tension:"X",markers:true,stroke:{color:"yellow"},fill:"yellow",animate:true}).addPlot("revenues",{type:"Columns",gap:5,vAxis:"ry",stroke:{color:"white"},fill:"#2a6ead",animate:true}).addPlot("grid",{type:"Grid",vMajorLines:false,vAxis:"ry"}).addSeries("data1",new _66a(_676,{},function(item){return item.revenues;}),{plot:"revenues"}).addSeries("data2",new _66a(_676,{},function(item){return item.profit;}),{plot:"profit"});var _67b=new _66b({plotarea:{fill:null},colors:["#57808f","#506885","#4f7878","#558f7f","#508567"]});var _67c=new _668("chart2",{fill:null,margins:{t:0,l:0,b:0,r:0}}).setTheme(_67b).addPlot("regions",{type:"Pie",radius:112,stroke:"white"}).addSeries("data",[],{plot:"regions"});new _670(_67a,"revenues");new _671(_67a,"revenues");new _673(_67a,"revenues",function(_67d,_67e){_67c.updateSeries("data",[{y:_672[_67d].America,text:"America"},{y:_672[_67d].Europe,text:"Europe"},{y:_672[_67d].Asia,text:"Asia"}]);if(_67e){_666.set("overlay","visibility","visible");}_67c.render();});_67a.render();});});